/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.AccountEditorDialog;
import IPMIView20.L;
import IPMIView20.UsersAccountView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class AccountComponent
extends JPanel {
    public static final int COMPONENT_TYPE_TITLE = -1;
    public static final int COMPONENT_TYPE_ANONYMOUS = 0;
    public static final int COMPONENT_TYPE_ADMIN = 1;
    private JLabel userStatus = new JLabel();
    private JLabel userID = new JLabel();
    private JLabel userName = new JLabel();
    private JLabel networkPrivileges = new JLabel();
    private JLabel solPrivileges = new JLabel();
    private JPanel buttonsPanel = new JPanel();
    private JPanel contentPanel = new JPanel();
    private JPanel splitorPanel = new JPanel();
    private CustomizedColorButton modifyButton = new CustomizedColorButton();
    private CustomizedColorButton deleteButton = new CustomizedColorButton();
    private Icon greenStatusIcon = new ImageIcon(this.getClass().getResource("/images/status_green.png"));
    private Icon redStatusIcon = new ImageIcon(this.getClass().getResource("/images/status_red.png"));
    private Icon greyStatusIcon = new ImageIcon(this.getClass().getResource("/images/status_grey.png"));
    private Icon accountEditIcon = new ImageIcon(this.getClass().getResource("/images/account_edit.png"));
    private Icon accountDelIcon = new ImageIcon(this.getClass().getResource("/images/account_delete.png"));
    private UsersAccountView usersAccountView;
    private AccountEditorDialog.LooseMouseListener modifyButtonListener;
    private AccountEditorDialog.LooseMouseListener deleteButtonListener;
    private AccountComponent instance = this;
    private int componentIndex;

    public AccountComponent(int idx) {
        this(null, idx);
    }

    public AccountComponent(UsersAccountView view, int idx) {
        this.usersAccountView = view;
        this.componentIndex = idx;
        this.setComponentsLayout();
        this.setComponentMisc();
        this.setComponentsColor(idx);
        this.setComponentsSize();
        this.setComponentsTextAndFont(idx);
        this.setComponentsIcon(idx);
        this.setComponentsListenser(idx);
    }

    public void setEnabledModifyButton() {
        this.modifyButton.addMouseListener(this.modifyButtonListener);
        this.modifyButton.setIcon(this.accountEditIcon);
    }

    public void setEnabledDeleteButton() {
        this.deleteButton.addMouseListener(this.deleteButtonListener);
        this.deleteButton.setIcon(this.accountDelIcon);
    }

    public boolean isReservedComponent() {
        return this.componentIndex <= 0;
    }

    public boolean isDeletableAccount() {
        return this.componentIndex > 2;
    }

    public boolean isEnabledSOLPrivileges() {
        return this.solPrivileges.getIcon().equals(this.greenStatusIcon);
    }

    public byte getUserIDByte() {
        return (byte)Integer.valueOf(this.userID.getText()).intValue();
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public String getNetworkPrivileges() {
        return this.networkPrivileges.getText();
    }

    public void setUserStatus(boolean enabled) {
        this.userStatus.setIcon(enabled ? this.greenStatusIcon : this.redStatusIcon);
    }

    public void setUserID(String usrID) {
        this.userID.setText(usrID);
    }

    public void setUserName(String userName) {
        this.userName.setText(userName);
    }

    public void setNetworkPrivileges(String privileges) {
        this.networkPrivileges.setText(privileges);
    }

    public void setSolPrivileges(boolean enabled) {
        this.solPrivileges.setIcon(enabled ? this.greenStatusIcon : this.redStatusIcon);
    }

    private void setComponentsLayout() {
        this.setLayout(new BoxLayout(this, 1));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.splitorPanel.setLayout(new BoxLayout(this.splitorPanel, 0));
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.add(this.modifyButton);
        this.buttonsPanel.add(this.deleteButton);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.contentPanel.add(Box.createHorizontalStrut(10));
        this.contentPanel.add(this.userStatus);
        this.contentPanel.add(Box.createHorizontalGlue());
        this.contentPanel.add(this.userID);
        this.contentPanel.add(Box.createHorizontalGlue());
        this.contentPanel.add(this.userName);
        this.contentPanel.add(Box.createHorizontalGlue());
        this.contentPanel.add(this.networkPrivileges);
        this.contentPanel.add(Box.createHorizontalGlue());
        this.contentPanel.add(this.solPrivileges);
        this.contentPanel.add(Box.createHorizontalGlue());
        this.contentPanel.add(this.buttonsPanel);
        this.contentPanel.add(Box.createHorizontalStrut(10));
        JSeparator separator = new JSeparator(0);
        separator.setForeground(Color.LIGHT_GRAY);
        this.splitorPanel.add(Box.createHorizontalStrut(10));
        this.splitorPanel.add(separator);
        this.splitorPanel.add(Box.createHorizontalStrut(10));
        this.add(this.contentPanel);
        this.add(this.splitorPanel);
    }

    private void setComponentMisc() {
        this.userName.putClientProperty("html.disable", Boolean.TRUE);
        this.modifyButton.setOpaque(false);
        this.modifyButton.setContentAreaFilled(false);
        this.modifyButton.setBorderPainted(false);
        this.modifyButton.setFocusPainted(false);
        this.deleteButton.setOpaque(false);
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setBorderPainted(false);
        this.deleteButton.setFocusPainted(false);
    }

    private void setComponentsColor(int index) {
        if (index == -1) {
            Color color = new Color(112, 112, 112);
            this.userStatus.setForeground(color);
            this.userID.setForeground(color);
            this.userName.setForeground(color);
            this.networkPrivileges.setForeground(color);
            this.solPrivileges.setForeground(color);
        }
        this.buttonsPanel.setBackground(Color.WHITE);
        this.modifyButton.setBackground(Color.WHITE);
        this.deleteButton.setBackground(Color.WHITE);
        this.contentPanel.setBackground(Color.WHITE);
        this.splitorPanel.setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
    }

    private void setComponentsSize() {
        this.splitorPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 3));
        this.splitorPanel.setMinimumSize(new Dimension(100, 3));
        int minW = 120;
        int minH = 30;
        int minWBtn = 40;
        int minHBtn = 30;
        this.userStatus.setMinimumSize(new Dimension(minW - 20, minH));
        this.userID.setMinimumSize(new Dimension(minW - 20, minH));
        this.userName.setMinimumSize(new Dimension(minW, minH));
        this.networkPrivileges.setMinimumSize(new Dimension(minW, minH));
        this.solPrivileges.setMinimumSize(new Dimension(minW, minH));
        this.modifyButton.setMinimumSize(new Dimension(minWBtn, minHBtn));
        this.deleteButton.setMinimumSize(new Dimension(minWBtn, minHBtn));
        this.userStatus.setMaximumSize(new Dimension(minW - 20, minH));
        this.userID.setMaximumSize(new Dimension(minW - 20, minH));
        this.userName.setMaximumSize(new Dimension(minW, minH));
        this.networkPrivileges.setMaximumSize(new Dimension(minW, minH));
        this.solPrivileges.setMaximumSize(new Dimension(minW, minH));
        this.modifyButton.setMaximumSize(new Dimension(minWBtn, minHBtn));
        this.deleteButton.setMaximumSize(new Dimension(minWBtn, minHBtn));
        this.userStatus.setPreferredSize(new Dimension(minW - 20, minH));
        this.userID.setPreferredSize(new Dimension(minW - 20, minH));
        this.userName.setPreferredSize(new Dimension(minW, minH));
        this.networkPrivileges.setPreferredSize(new Dimension(minW, minH));
        this.solPrivileges.setPreferredSize(new Dimension(minW, minH));
        this.modifyButton.setPreferredSize(new Dimension(minWBtn, minHBtn));
        this.deleteButton.setPreferredSize(new Dimension(minWBtn, minHBtn));
        int minWContent = Integer.MAX_VALUE;
        int minHContent = 38;
        this.contentPanel.setMinimumSize(new Dimension(minWContent, minHContent));
        this.contentPanel.setMaximumSize(new Dimension(minWContent, minHContent));
        this.contentPanel.setPreferredSize(new Dimension(320, minHContent));
    }

    private void setComponentsTextAndFont(int index) {
        switch (index) {
            case -1: {
                Font font = this.userStatus.getFont();
                font = font.deriveFont(font.getStyle() | 1);
                font = font.deriveFont(12.0f);
                this.userStatus.setFont(font);
                this.userID.setFont(font);
                this.userName.setFont(font);
                this.networkPrivileges.setFont(font);
                this.solPrivileges.setFont(font);
                this.userStatus.setText(L.t("user.User_Status"));
                this.userID.setText(L.t("user.User_ID"));
                this.userName.setText(L.t("user.User_Name"));
                this.networkPrivileges.setText(L.t("user.Network_Privileges"));
                this.solPrivileges.setText(L.t("user.SOL_Privileges"));
                break;
            }
            case 0: {
                this.userID.setText(String.valueOf(index + 1));
                this.userName.setText("Anonymous");
                this.networkPrivileges.setText("Reserved");
                break;
            }
            case 1: {
                this.userID.setText(String.valueOf(index + 1));
                this.userName.setText("ADMIN");
                this.networkPrivileges.setText("Administrator");
                break;
            }
            default: {
                this.userID.setText(String.valueOf(index + 1));
                this.userName.setText("");
                this.networkPrivileges.setText("");
            }
        }
    }

    private void setComponentsIcon(int index) {
        switch (index) {
            case -1: {
                break;
            }
            case 0: {
                this.userStatus.setIcon(this.greyStatusIcon);
                this.solPrivileges.setIcon(null);
                this.modifyButton.setIcon(null);
                this.deleteButton.setIcon(null);
                break;
            }
            default: {
                this.userStatus.setIcon(null);
                this.solPrivileges.setIcon(null);
                this.modifyButton.setIcon(null);
                this.deleteButton.setIcon(null);
            }
        }
    }

    private void setComponentsListenser(int index) {
        this.modifyButtonListener = new AccountEditorDialog.LooseMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AccountComponent.this.usersAccountView.getAccountEditor().setLocationRelativeTo(AccountComponent.this.usersAccountView);
                AccountComponent.this.usersAccountView.getAccountEditor().setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
                AccountComponent.this.usersAccountView.getAccountEditor().modifyUser(AccountComponent.this.instance);
                AccountComponent.this.usersAccountView.getAccountEditor().setVisible(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AccountComponent.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AccountComponent.this.setCursor(new Cursor(0));
            }
        };
        this.deleteButtonListener = new AccountEditorDialog.LooseMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int result = JOptionPane.showOptionDialog(AccountComponent.this.modifyButton.getParent(), L.t("user.Delete_Confirm") + " (" + AccountComponent.this.instance.userName.getText() + ")", "", 2, 2, null, null, null);
                if (result == 0) {
                    AccountComponent.this.usersAccountView.getUsersAccountControl().deleteAccount(Integer.valueOf(AccountComponent.this.userID.getText()));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AccountComponent.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AccountComponent.this.setCursor(new Cursor(0));
            }
        };
    }

    public class CustomizedColorButton
    extends JButton {
        @Override
        protected void paintComponent(Graphics g) {
            if (!this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
        }
    }
}

