/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.AccountComponent;
import IPMIView20.ErrorStatusTextField;
import IPMIView20.L;
import IPMIView20.RoundPasswordTextField;
import IPMIView20.RoundTextField;
import IPMIView20.ToggleSwitch;
import IPMIView20.UsersAccountControl;
import com.supermicro.ipmi.text.UserAccountProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class AccountEditorDialog
extends JDialog
implements RoundPasswordTextField.PasswordDisplayInterface {
    public static final int OPERATION_CREATE = 0;
    public static final int OPERATION_MODIFY = 1;
    private JPanel titlePanel = new JPanel();
    private JPanel contentPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private JPanel usernameRowPanel = new JPanel();
    private JPanel passwordRowPanel = new JPanel();
    private JPanel passwordConfirmRowPanel = new JPanel();
    private JPanel networkPrivilegeRowPanel = new JPanel();
    private JPanel solPrivilegeRowPanel = new JPanel();
    private JPanel descriptionRowPanel = new JPanel();
    private Icon lightBulbIcon = new ImageIcon(this.getClass().getResource("/images/lightBulb.png"));
    private JLabel titleLabel = new JLabel();
    private JLabel usernameLabel = new JLabel();
    private JLabel passwordLabel = new JLabel();
    private JLabel passwordConfirmLabel = new JLabel();
    private JLabel networkPrivilegesLabel = new JLabel();
    private JLabel solPrivilegesLabel = new JLabel();
    private ErrorStatusTextField usernameStatusLabel = new ErrorStatusTextField();
    private ErrorStatusTextField passwordStatusLabel = new ErrorStatusTextField();
    private ErrorStatusTextField passwordConfirmStatusLabel = new ErrorStatusTextField();
    private RoundTextField usernameTextField = new RoundTextField();
    private RoundPasswordTextField passwordTextField = new RoundPasswordTextField(this);
    private RoundPasswordTextField passwordConfirmTextField = new RoundPasswordTextField();
    private JRadioButton adminRadioButton = new JRadioButton();
    private JRadioButton operatorRadioButton = new JRadioButton();
    private JRadioButton userRadioButton = new JRadioButton();
    private ButtonGroup networkPrivilegesButtonGroup = new ButtonGroup();
    private ToggleSwitch solToggleSwitch = new ToggleSwitch();
    private JButton closeButton = new JButton();
    private JButton saveButton = new JButton();
    private JDialog dialogInst;
    private UsersAccountControl userAccountControl;
    private byte userIndex;
    private int pendingOperation;
    private boolean isLegacyDevice;
    private boolean isPasswordRequired;
    private String passwordRequiredText;
    private String passwordConfirmRequiredText;
    private String passwordNotRequiredText;
    private String passwordConfirmNotRequiredText;
    private JTextArea descTextField = new JTextArea(){

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            AccountEditorDialog.this.lightBulbIcon.paintIcon(this, g, 20, 15);
        }
    };

    public AccountEditorDialog() {
        this.dialogInst = this;
        this.setComponentsLayout();
        this.setComponentMisc();
        this.setComponentsColor();
        this.setComponentsSize();
        this.setComponentsFontAndText();
        this.setComponentsListenser();
    }

    public void setController(UsersAccountControl controller) {
        this.userAccountControl = controller;
        this.isLegacyDevice = this.userAccountControl.isLegacyDevices();
    }

    public void createUser() {
        this.titleLabel.setText(L.t("user.ADD_User"));
        this.passwordLabel.setText(this.passwordRequiredText);
        this.passwordConfirmLabel.setText(this.passwordConfirmRequiredText);
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        this.passwordConfirmTextField.setText("");
        this.usernameStatusLabel.setTextField("");
        this.passwordStatusLabel.setTextField("");
        this.passwordConfirmStatusLabel.setTextField("");
        this.passwordTextField.setPasswordVisible(false);
        this.passwordConfirmTextField.setPasswordVisible(false);
        this.usernameTextField.setValid(true);
        SwingUtilities.invokeLater(() -> this.passwordTextField.setValid(true));
        this.passwordConfirmTextField.setValid(true);
        this.adminRadioButton.setSelected(true);
        this.solToggleSwitch.setActivated(false);
        this.pendingOperation = 0;
        this.isPasswordRequired = true;
    }

    public void modifyUser(AccountComponent comp) {
        this.userIndex = comp.getUserIDByte();
        this.titleLabel.setText(L.t("user.Modify_User"));
        this.passwordLabel.setText(this.passwordNotRequiredText);
        this.passwordConfirmLabel.setText(this.passwordConfirmNotRequiredText);
        this.usernameTextField.setText(comp.getUserName());
        this.passwordTextField.setText("");
        this.passwordConfirmTextField.setText("");
        this.usernameStatusLabel.setTextField("");
        this.passwordStatusLabel.setTextField("");
        this.passwordConfirmStatusLabel.setTextField("");
        this.passwordTextField.setPasswordVisible(false);
        this.passwordConfirmTextField.setPasswordVisible(false);
        this.usernameTextField.setValid(true);
        SwingUtilities.invokeLater(() -> this.passwordTextField.setValid(true));
        this.passwordConfirmTextField.setValid(true);
        String networkPrivileges = comp.getNetworkPrivileges();
        if (networkPrivileges.equals("Administrator")) {
            this.adminRadioButton.setSelected(true);
        } else if (networkPrivileges.equals("Operator")) {
            this.operatorRadioButton.setSelected(true);
        } else if (networkPrivileges.equals("User")) {
            this.userRadioButton.setSelected(true);
        }
        this.solToggleSwitch.setActivated(comp.isEnabledSOLPrivileges());
        this.pendingOperation = 1;
        this.isPasswordRequired = false;
    }

    private void verifyInputEvent(ComponentEvent e) {
        JTextField textField = (JTextField)e.getSource();
        if (textField.equals(this.usernameTextField)) {
            this.verifyInputTextField(this.usernameTextField);
        } else if (textField.equals(this.passwordTextField)) {
            this.verifyInputTextField(this.passwordTextField);
        } else if (textField.equals(this.passwordConfirmTextField)) {
            this.verifyInputTextField(this.passwordConfirmTextField);
        }
    }

    private void verifyInputTextField(JTextField fields) {
        if (fields.equals(this.usernameTextField)) {
            boolean isValid = this.userAccountControl.isValidUsername(fields.getText());
            this.setUsernameStatus(isValid);
        } else if (fields.equals(this.passwordTextField)) {
            String username = this.usernameTextField.getText();
            int result = 0;
            if (this.isPasswordRequired || !fields.getText().isEmpty()) {
                result = this.userAccountControl.isValidPassword(username, fields.getText(), this.isLegacyDevice);
            }
            this.setPasswordStatus(result);
        } else if (fields.equals(this.passwordConfirmTextField)) {
            boolean isValid = fields.getText().equals(((JTextComponent)this.passwordTextField).getText());
            if (this.isPasswordRequired && fields.getText().isEmpty()) {
                isValid = false;
            }
            this.setConfirmPasswordStatus(isValid);
        }
    }

    private void setUsernameStatus(boolean isValid) {
        this.usernameStatusLabel.setTextField(isValid ? "" : "      " + L.t("user.Change_user_name_wrong_length"));
        this.usernameTextField.setValid(isValid);
        this.usernameRowPanel.updateUI();
    }

    private void setPasswordStatus(int status) {
        if (status == 0) {
            this.passwordTextField.setValid(true);
            this.descTextField.setVisible(false);
            this.passwordStatusLabel.setVisible(false);
            this.passwordStatusLabel.setTextField("");
            if (((JTextComponent)this.passwordTextField).getText().isEmpty() && ((JTextComponent)this.passwordConfirmTextField).getText().isEmpty()) {
                this.verifyInputTextField(this.passwordConfirmTextField);
            }
        } else {
            this.passwordStatusLabel.setVisible(true);
            this.passwordTextField.setValid(false);
            if (status == 1) {
                this.descTextField.setVisible(false);
                this.passwordStatusLabel.setTextField("      " + L.t("user.Change_user_password_wrong_length"));
            } else if (status == 2) {
                this.descTextField.setVisible(false);
                this.passwordStatusLabel.setTextField("      " + L.t("user.Change_user_password_identical_failed"));
            } else if (status == 3) {
                this.descTextField.setVisible(false);
                this.passwordStatusLabel.setTextField("      " + L.t("user.Change_user_password_reversed_identical_failed"));
            } else if (status == 4) {
                this.descTextField.setVisible(true);
                this.passwordStatusLabel.setTextField("      " + L.t("user.Change_user_password_rules_invalid"));
            }
        }
        this.passwordRowPanel.updateUI();
        this.passwordConfirmRowPanel.updateUI();
    }

    private void setConfirmPasswordStatus(boolean isValid) {
        this.passwordConfirmTextField.setValid(isValid);
        SwingUtilities.invokeLater(() -> {
            this.passwordConfirmTextField.setValid(isValid);
            this.passwordConfirmStatusLabel.setVisible(!isValid);
            this.passwordConfirmStatusLabel.setTextField(isValid ? "" : "      " + L.t("user.Change_user_password_confirm_mismatch"));
            this.passwordConfirmStatusLabel.invalidate();
            this.passwordConfirmStatusLabel.repaint();
            this.passwordConfirmRowPanel.updateUI();
        });
    }

    private UserAccountProperty snapshot() {
        UserAccountProperty prop = new UserAccountProperty();
        prop.setUserID(this.userIndex);
        prop.setAccountState(1);
        prop.setUsername(this.usernameTextField.getText());
        prop.setPassword(((JTextComponent)this.passwordTextField).getText());
        prop.setEnabledSOL(this.solToggleSwitch.isActivated());
        prop.setNetworkPrivilege(this.getNetworkPrivilege());
        return prop;
    }

    private byte getNetworkPrivilege() {
        if (this.adminRadioButton.isSelected()) {
            return 4;
        }
        if (this.operatorRadioButton.isSelected()) {
            return 3;
        }
        if (this.userRadioButton.isSelected()) {
            return 2;
        }
        return 4;
    }

    private void setComponentsLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.usernameRowPanel.setLayout(new BoxLayout(this.usernameRowPanel, 0));
        this.passwordRowPanel.setLayout(new BoxLayout(this.passwordRowPanel, 0));
        this.passwordConfirmRowPanel.setLayout(new BoxLayout(this.passwordConfirmRowPanel, 0));
        this.networkPrivilegeRowPanel.setLayout(new BoxLayout(this.networkPrivilegeRowPanel, 0));
        this.solPrivilegeRowPanel.setLayout(new BoxLayout(this.solPrivilegeRowPanel, 0));
        this.descriptionRowPanel.setLayout(new BoxLayout(this.descriptionRowPanel, 0));
        this.usernameRowPanel.add(Box.createHorizontalStrut(30));
        this.usernameRowPanel.add(this.usernameLabel);
        this.usernameRowPanel.add(Box.createHorizontalStrut(50));
        this.usernameRowPanel.add(this.usernameTextField);
        this.usernameRowPanel.add(Box.createHorizontalStrut(20));
        this.usernameRowPanel.add(this.usernameStatusLabel);
        this.usernameRowPanel.add(Box.createHorizontalStrut(20));
        this.usernameRowPanel.add(Box.createHorizontalGlue());
        this.passwordRowPanel.add(Box.createHorizontalStrut(30));
        this.passwordRowPanel.add(this.passwordLabel);
        this.passwordRowPanel.add(Box.createHorizontalStrut(50));
        this.passwordRowPanel.add(this.passwordTextField);
        this.passwordRowPanel.add(Box.createHorizontalStrut(20));
        this.passwordRowPanel.add(this.passwordStatusLabel);
        this.passwordRowPanel.add(Box.createHorizontalStrut(20));
        this.passwordRowPanel.add(Box.createHorizontalGlue());
        this.passwordConfirmRowPanel.add(Box.createHorizontalStrut(30));
        this.passwordConfirmRowPanel.add(this.passwordConfirmLabel);
        this.passwordConfirmRowPanel.add(Box.createHorizontalStrut(50));
        this.passwordConfirmRowPanel.add(this.passwordConfirmTextField);
        this.passwordConfirmRowPanel.add(Box.createHorizontalStrut(20));
        this.passwordConfirmRowPanel.add(this.passwordConfirmStatusLabel);
        this.passwordConfirmRowPanel.add(Box.createHorizontalStrut(20));
        this.passwordConfirmRowPanel.add(Box.createHorizontalGlue());
        this.networkPrivilegeRowPanel.add(Box.createHorizontalStrut(30));
        this.networkPrivilegeRowPanel.add(this.networkPrivilegesLabel);
        this.networkPrivilegeRowPanel.add(Box.createHorizontalStrut(50));
        this.networkPrivilegeRowPanel.add(this.adminRadioButton);
        this.networkPrivilegeRowPanel.add(this.operatorRadioButton);
        this.networkPrivilegeRowPanel.add(this.userRadioButton);
        this.networkPrivilegeRowPanel.add(Box.createHorizontalGlue());
        this.solPrivilegeRowPanel.add(Box.createHorizontalStrut(30));
        this.solPrivilegeRowPanel.add(this.solPrivilegesLabel);
        this.solPrivilegeRowPanel.add(Box.createHorizontalStrut(52));
        this.solPrivilegeRowPanel.add(this.solToggleSwitch);
        this.solPrivilegeRowPanel.add(Box.createHorizontalGlue());
        this.descriptionRowPanel.add(Box.createHorizontalStrut(30));
        this.descriptionRowPanel.add(Box.createHorizontalGlue());
        this.descriptionRowPanel.add(this.descTextField);
        this.descriptionRowPanel.add(Box.createHorizontalStrut(20));
        this.titlePanel.add(Box.createHorizontalStrut(30));
        this.titlePanel.add(this.titleLabel);
        this.contentPanel.add(Box.createVerticalStrut(20));
        this.contentPanel.add(this.usernameRowPanel);
        this.contentPanel.add(this.passwordRowPanel);
        this.contentPanel.add(this.passwordConfirmRowPanel);
        this.contentPanel.add(this.networkPrivilegeRowPanel);
        this.contentPanel.add(this.solPrivilegeRowPanel);
        this.contentPanel.add(this.descriptionRowPanel);
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.add(this.saveButton);
        this.bottomPanel.add(Box.createHorizontalStrut(10));
        this.bottomPanel.add(this.closeButton);
        this.bottomPanel.add(Box.createHorizontalStrut(20));
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.getContentPane().add((Component)this.bottomPanel, "South");
    }

    private void setComponentMisc() {
        this.descTextField.setVisible(false);
        this.usernameStatusLabel.setEditable(false);
        this.passwordStatusLabel.setEditable(false);
        this.passwordConfirmStatusLabel.setEditable(false);
        this.networkPrivilegesButtonGroup.add(this.adminRadioButton);
        this.networkPrivilegesButtonGroup.add(this.operatorRadioButton);
        this.networkPrivilegesButtonGroup.add(this.userRadioButton);
        Border descBorder = BorderFactory.createLineBorder(new Color(38, 123, 204), 2);
        this.descTextField.setBorder(BorderFactory.createCompoundBorder(descBorder, BorderFactory.createEmptyBorder(10, 45, 10, 25)));
        this.descTextField.setMargin(new Insets(2, 20, 2, 2));
    }

    private void setComponentsColor() {
        this.titleLabel.setForeground(Color.WHITE);
        this.titlePanel.setBackground(Color.DARK_GRAY);
        this.contentPanel.setBackground(Color.WHITE);
        this.bottomPanel.setBackground(Color.LIGHT_GRAY);
        this.usernameRowPanel.setBackground(Color.WHITE);
        this.passwordRowPanel.setBackground(Color.WHITE);
        this.passwordConfirmRowPanel.setBackground(Color.WHITE);
        this.networkPrivilegeRowPanel.setBackground(Color.WHITE);
        this.solPrivilegeRowPanel.setBackground(Color.WHITE);
        this.descriptionRowPanel.setBackground(Color.WHITE);
        this.adminRadioButton.setBackground(Color.WHITE);
        this.operatorRadioButton.setBackground(Color.WHITE);
        this.userRadioButton.setBackground(Color.WHITE);
        this.networkPrivilegesLabel.setForeground(new Color(96, 96, 96));
        this.solPrivilegesLabel.setForeground(new Color(96, 96, 96));
        this.adminRadioButton.setForeground(new Color(96, 96, 96));
        this.operatorRadioButton.setForeground(new Color(96, 96, 96));
        this.userRadioButton.setForeground(new Color(96, 96, 96));
        this.descTextField.setBackground(new Color(239, 247, 255));
        this.descTextField.setForeground(new Color(38, 123, 204));
    }

    private void setComponentsSize() {
        int rowPanelW = 300;
        int rowPanelH = 35;
        int labelW = 120;
        int labelH = 20;
        int intputW = 320;
        int inputH = 20;
        int radioBtnW = 80;
        int radioBtnH = 35;
        int bottomBtnW = 70;
        int bottomBtnH = 22;
        this.setMinimumSize(new Dimension(850, 400));
        this.setMaximumSize(new Dimension(850, 400));
        this.setPreferredSize(new Dimension(850, 400));
        this.titlePanel.setMinimumSize(new Dimension(300, 30));
        this.titlePanel.setMaximumSize(new Dimension(300, 30));
        this.titlePanel.setPreferredSize(new Dimension(300, 30));
        this.contentPanel.setMinimumSize(new Dimension(300, 400));
        this.contentPanel.setMaximumSize(new Dimension(300, 400));
        this.contentPanel.setPreferredSize(new Dimension(300, 400));
        this.bottomPanel.setMinimumSize(new Dimension(300, 40));
        this.bottomPanel.setMaximumSize(new Dimension(300, 40));
        this.bottomPanel.setPreferredSize(new Dimension(300, 40));
        this.usernameRowPanel.setMinimumSize(new Dimension(rowPanelW, rowPanelH));
        this.usernameRowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.usernameRowPanel.setPreferredSize(new Dimension(rowPanelW, rowPanelH));
        this.passwordRowPanel.setMinimumSize(new Dimension(rowPanelW, rowPanelH));
        this.passwordRowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.passwordRowPanel.setPreferredSize(new Dimension(rowPanelW, rowPanelH));
        this.passwordConfirmRowPanel.setMinimumSize(new Dimension(rowPanelW, rowPanelH));
        this.passwordConfirmRowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.passwordConfirmRowPanel.setPreferredSize(new Dimension(rowPanelW, rowPanelH));
        this.networkPrivilegeRowPanel.setMinimumSize(new Dimension(rowPanelW, rowPanelH));
        this.networkPrivilegeRowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.networkPrivilegeRowPanel.setPreferredSize(new Dimension(rowPanelW, rowPanelH));
        this.solPrivilegeRowPanel.setMinimumSize(new Dimension(rowPanelW, rowPanelH));
        this.solPrivilegeRowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.solPrivilegeRowPanel.setPreferredSize(new Dimension(rowPanelW, rowPanelH));
        this.descriptionRowPanel.setMinimumSize(new Dimension(rowPanelW, 100));
        this.descriptionRowPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.descriptionRowPanel.setPreferredSize(new Dimension(rowPanelW, 100));
        this.usernameLabel.setMinimumSize(new Dimension(labelW, labelH));
        this.usernameLabel.setMaximumSize(new Dimension(labelW, labelH));
        this.usernameLabel.setPreferredSize(new Dimension(labelW, labelH));
        this.passwordLabel.setMinimumSize(new Dimension(labelW, labelH));
        this.passwordLabel.setMaximumSize(new Dimension(labelW, labelH));
        this.passwordLabel.setPreferredSize(new Dimension(labelW, labelH));
        this.passwordConfirmLabel.setMinimumSize(new Dimension(labelW, labelH));
        this.passwordConfirmLabel.setMaximumSize(new Dimension(labelW, labelH));
        this.passwordConfirmLabel.setPreferredSize(new Dimension(labelW, labelH));
        this.networkPrivilegesLabel.setMinimumSize(new Dimension(labelW, labelH));
        this.networkPrivilegesLabel.setMaximumSize(new Dimension(labelW, labelH));
        this.networkPrivilegesLabel.setPreferredSize(new Dimension(labelW, labelH));
        this.solPrivilegesLabel.setMinimumSize(new Dimension(labelW, labelH));
        this.solPrivilegesLabel.setMaximumSize(new Dimension(labelW, labelH));
        this.solPrivilegesLabel.setPreferredSize(new Dimension(labelW, labelH));
        this.usernameTextField.setMinimumSize(new Dimension(intputW, inputH));
        this.usernameTextField.setMaximumSize(new Dimension(intputW, inputH));
        this.usernameTextField.setPreferredSize(new Dimension(intputW, inputH));
        this.descTextField.setLineWrap(true);
        this.descTextField.setMinimumSize(new Dimension(400, 80));
        this.descTextField.setMaximumSize(new Dimension(400, 80));
        this.descTextField.setPreferredSize(new Dimension(400, 80));
        this.usernameStatusLabel.setMinimumSize(new Dimension(290, inputH));
        this.usernameStatusLabel.setMaximumSize(new Dimension(290, inputH));
        this.usernameStatusLabel.setPreferredSize(new Dimension(290, inputH));
        this.passwordStatusLabel.setMinimumSize(new Dimension(290, inputH));
        this.passwordStatusLabel.setMaximumSize(new Dimension(290, inputH));
        this.passwordStatusLabel.setPreferredSize(new Dimension(290, inputH));
        this.passwordConfirmStatusLabel.setMinimumSize(new Dimension(290, inputH));
        this.passwordConfirmStatusLabel.setMaximumSize(new Dimension(290, inputH));
        this.passwordConfirmStatusLabel.setPreferredSize(new Dimension(290, inputH));
        this.passwordTextField.setMinimumSize(new Dimension(intputW, inputH));
        this.passwordTextField.setMaximumSize(new Dimension(intputW, inputH));
        this.passwordTextField.setPreferredSize(new Dimension(intputW, inputH));
        this.passwordConfirmTextField.setMinimumSize(new Dimension(intputW, inputH));
        this.passwordConfirmTextField.setMaximumSize(new Dimension(intputW, inputH));
        this.passwordConfirmTextField.setPreferredSize(new Dimension(intputW, inputH));
        this.adminRadioButton.setMinimumSize(new Dimension(radioBtnW, radioBtnH));
        this.adminRadioButton.setMaximumSize(new Dimension(radioBtnW, radioBtnH));
        this.adminRadioButton.setPreferredSize(new Dimension(radioBtnW, radioBtnH));
        this.operatorRadioButton.setMinimumSize(new Dimension(radioBtnW, radioBtnH));
        this.operatorRadioButton.setMaximumSize(new Dimension(radioBtnW, radioBtnH));
        this.operatorRadioButton.setPreferredSize(new Dimension(radioBtnW, radioBtnH));
        this.userRadioButton.setMinimumSize(new Dimension(radioBtnW, radioBtnH));
        this.userRadioButton.setMaximumSize(new Dimension(radioBtnW, radioBtnH));
        this.userRadioButton.setPreferredSize(new Dimension(radioBtnW, radioBtnH));
        this.closeButton.setMinimumSize(new Dimension(bottomBtnW, bottomBtnH));
        this.closeButton.setMaximumSize(new Dimension(bottomBtnW, bottomBtnH));
        this.closeButton.setPreferredSize(new Dimension(bottomBtnW, bottomBtnH));
        this.saveButton.setMinimumSize(new Dimension(bottomBtnW, bottomBtnH));
        this.saveButton.setMaximumSize(new Dimension(bottomBtnW, bottomBtnH));
        this.saveButton.setPreferredSize(new Dimension(bottomBtnW, bottomBtnH));
        this.solToggleSwitch.setMinimumSize(new Dimension(57, 20));
        this.solToggleSwitch.setMaximumSize(new Dimension(57, 20));
        this.solToggleSwitch.setPreferredSize(new Dimension(57, 20));
    }

    private void setComponentsFontAndText() {
        Font titleFont = this.titleLabel.getFont();
        titleFont = titleFont.deriveFont(titleFont.getStyle() | 1);
        titleFont = titleFont.deriveFont(12.0f);
        this.titleLabel.setFont(titleFont);
        this.passwordRequiredText = "<html><font color=\"rgb(96, 96, 96)\">" + L.t("user.Password") + "</font><font color=RED> *</font></html>";
        this.passwordConfirmRequiredText = "<html><font color=\"rgb(96, 96, 96)\">" + L.t("user.Confirm_Password") + "</font><font color=RED> *</font></html>";
        this.passwordNotRequiredText = "<html><font color=\"rgb(96, 96, 96)\">" + L.t("user.Password") + "</font></html>";
        this.passwordConfirmNotRequiredText = "<html><font color=\"rgb(96, 96, 96)\">" + L.t("user.Confirm_Password") + "</font></html>";
        this.titleLabel.setText(L.t("user.Modify_User"));
        this.usernameLabel.setText("<html><font color=\"rgb(96, 96, 96)\">" + L.t("user.User_Name") + "</font><font color=RED> *</font></html>");
        this.passwordLabel.setText(this.passwordRequiredText);
        this.passwordConfirmLabel.setText(this.passwordConfirmRequiredText);
        this.networkPrivilegesLabel.setText(L.t("user.Network_Privileges"));
        this.solPrivilegesLabel.setText(L.t("user.SOL_Privileges"));
        this.descTextField.setText(L.t("user.Change_user_password_rules_mismatch"));
        this.adminRadioButton.setText("Admin");
        this.operatorRadioButton.setText("Operator");
        this.userRadioButton.setText("User");
        this.closeButton.setText(L.t("user.Close"));
        this.saveButton.setText(L.t("user.Save"));
    }

    private void setComponentsListenser() {
        FocusListener textFieldFocusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AccountEditorDialog.this.verifyInputEvent(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.usernameTextField.addFocusListener(textFieldFocusListener);
        this.passwordTextField.addFocusListener(textFieldFocusListener);
        this.passwordConfirmTextField.addFocusListener(textFieldFocusListener);
        this.saveButton.addMouseListener(new LooseMouseListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                block9: {
                    block11: {
                        block10: {
                            block8: {
                                AccountEditorDialog.access$300(AccountEditorDialog.this, AccountEditorDialog.access$200(AccountEditorDialog.this));
                                AccountEditorDialog.access$300(AccountEditorDialog.this, AccountEditorDialog.access$400(AccountEditorDialog.this));
                                AccountEditorDialog.access$300(AccountEditorDialog.this, AccountEditorDialog.access$500(AccountEditorDialog.this));
                                if (AccountEditorDialog.access$600(AccountEditorDialog.this) != 0) break block8;
                                if (!AccountEditorDialog.access$200(AccountEditorDialog.this).getText().isEmpty() && !AccountEditorDialog.access$400(AccountEditorDialog.this).getText().isEmpty() && !AccountEditorDialog.access$500(AccountEditorDialog.this).getText().isEmpty() && AccountEditorDialog.access$200(AccountEditorDialog.this).isValid() && AccountEditorDialog.access$400(AccountEditorDialog.this).isValid() && AccountEditorDialog.access$500(AccountEditorDialog.this).isValid()) {
                                    AccountEditorDialog.access$800(AccountEditorDialog.this).createAccount(AccountEditorDialog.access$700(AccountEditorDialog.this));
                                    AccountEditorDialog.access$900(AccountEditorDialog.this).setVisible(false);
                                } else {
                                    msg = null;
                                    msg = AccountEditorDialog.access$200(AccountEditorDialog.this).getText().isEmpty() != false ? L.t("user.Change_user_name_empty") : (AccountEditorDialog.access$400(AccountEditorDialog.this).getText().isEmpty() != false ? L.t("user.Change_user_password_empty") : L.t("user.Please_Check_Invalid_Field"));
                                    options = new String[]{"OK"};
                                    if (msg != null) {
                                        JOptionPane.showOptionDialog(((JButton)e.getSource()).getParent(), msg, L.t("user.Confirm"), -1, 2, null, options, options[0]);
                                    }
                                }
                                break block9;
                            }
                            if (AccountEditorDialog.access$600(AccountEditorDialog.this) != 1) break block9;
                            msg = null;
                            if (!AccountEditorDialog.access$200(AccountEditorDialog.this).getText().isEmpty()) break block10;
                            msg = L.t("user.Change_user_name_empty");
                            break block11;
                        }
                        if (AccountEditorDialog.access$400(AccountEditorDialog.this).getText().isEmpty() && AccountEditorDialog.access$500(AccountEditorDialog.this).getText().isEmpty()) ** GOTO lbl-1000
                        if (AccountEditorDialog.access$400(AccountEditorDialog.this).getText().isEmpty() || AccountEditorDialog.access$500(AccountEditorDialog.this).getText().isEmpty()) {
                            msg = L.t("user.Change_user_password_empty");
                        } else if (!AccountEditorDialog.access$400(AccountEditorDialog.this).isValid() || !AccountEditorDialog.access$500(AccountEditorDialog.this).isValid()) {
                            msg = L.t("user.Please_Check_Invalid_Field");
                        } else lbl-1000:
                        // 2 sources

                        {
                            AccountEditorDialog.access$800(AccountEditorDialog.this).modifyAccount(AccountEditorDialog.access$700(AccountEditorDialog.this));
                            AccountEditorDialog.access$900(AccountEditorDialog.this).setVisible(false);
                        }
                    }
                    options = new String[]{"OK"};
                    if (msg != null) {
                        JOptionPane.showOptionDialog(((JButton)e.getSource()).getParent(), msg, L.t("user.Confirm"), -1, 2, null, options, options[0]);
                    }
                }
            }
        });
        this.closeButton.addMouseListener(new LooseMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AccountEditorDialog.this.dialogInst.setVisible(false);
            }
        });
    }

    @Override
    public void showPlainPassword(boolean isPlain) {
        this.passwordConfirmTextField.setPasswordVisible(isPlain);
    }

    public static void main(String[] args) {
        AccountEditorDialog accountEditorDialog = new AccountEditorDialog();
        SwingUtilities.invokeLater(() -> {
            accountEditorDialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
            accountEditorDialog.createUser();
            accountEditorDialog.setVisible(true);
        });
    }

    static /* synthetic */ RoundTextField access$200(AccountEditorDialog x0) {
        return x0.usernameTextField;
    }

    static /* synthetic */ void access$300(AccountEditorDialog x0, JTextField x1) {
        x0.verifyInputTextField(x1);
    }

    static /* synthetic */ RoundPasswordTextField access$400(AccountEditorDialog x0) {
        return x0.passwordTextField;
    }

    static /* synthetic */ RoundPasswordTextField access$500(AccountEditorDialog x0) {
        return x0.passwordConfirmTextField;
    }

    static /* synthetic */ int access$600(AccountEditorDialog x0) {
        return x0.pendingOperation;
    }

    static /* synthetic */ UserAccountProperty access$700(AccountEditorDialog x0) {
        return x0.snapshot();
    }

    static /* synthetic */ UsersAccountControl access$800(AccountEditorDialog x0) {
        return x0.userAccountControl;
    }

    public static interface LooseMouseListener
    extends MouseListener {
        @Override
        default public void mouseClicked(MouseEvent e) {
        }

        @Override
        default public void mousePressed(MouseEvent e) {
        }

        @Override
        default public void mouseReleased(MouseEvent e) {
        }

        @Override
        default public void mouseEntered(MouseEvent e) {
        }

        @Override
        default public void mouseExited(MouseEvent e) {
        }
    }
}

