/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ComboTabListener;
import IPMIView20.IPMIView20;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class ComboTab
extends JPanel
implements ComboTabListener {
    private static final long serialVersionUID = 1L;
    public static final int TOOLBAR_RESET = 0;
    public static final int TOOLBAR_LOADING = 1;
    public static final int TOOLBAR_LOCKED = 2;
    public static final int TOOLBAR_PART_LOCKED = 3;
    public static final int BUTTON_GET = 0;
    public static final int BUTTON_SAVE = 1;
    public static final int BUTTON_ADD_USER = 2;
    public static final int BUTTON_DEL = 3;
    public static final int BUTTON_REFRESH = 4;
    public static final int TAB_CHANGE = 5;
    public static final int TAB_LEAVE = 6;
    private static final String ICON_PATH_GET = "/images/toolbar_list.png";
    private static final String ICON_PATH_SAVE = "/images/toolbar_save.png";
    private static final String ICON_PATH_ADD = "/images/toolbar_new_user.png";
    private static final String ICON_PATH_DEL = "/images/toolbar_delete.png";
    private static final String ICON_PATH_REFRESH = "/images/toolbar_refresh.png";
    private static final String ICON_PATH_LOADING = "/images/loading.gif";
    private static final Dimension COMBOBOX_DIMENSION = new Dimension(150, 27);
    private Icon getIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_list.png"));
    private Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.png"));
    private Icon addIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_new_user.png"));
    private Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_delete.png"));
    private Icon refreshIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_refresh.png"));
    private Icon loadingIcon = new ImageIcon(this.getClass().getResource("/images/loading.gif"));
    private List<JPanel> subTabList = new ArrayList<JPanel>();
    private List<JToolBar> toolbarList = new ArrayList<JToolBar>();
    private JComboBox<String> tabsCombobox = new JComboBox();
    private JPanel toolbarPanel = new JPanel();
    private JSeparator separator = new JSeparator(1);
    private JPanel comboboxGroupPanel = new JPanel();
    private JLabel loadingLabel = new JLabel();
    private JScrollPane scrollPane = new JScrollPane();
    private int currentSubTabIndex = 0;

    public ComboTab() {
        this.setLayout(new BorderLayout());
        this.toolbarPanel.setLayout(new BorderLayout());
        this.tabsCombobox.setMaximumSize(COMBOBOX_DIMENSION);
        this.tabsCombobox.setPreferredSize(COMBOBOX_DIMENSION);
        this.tabsCombobox.setMinimumSize(COMBOBOX_DIMENSION);
        this.tabsCombobox.setFont(new Font(IPMIView20.IPMI_DEFAULT_FONT, 1, 12));
        this.tabsCombobox.setForeground(Color.BLUE);
        this.separator.setMaximumSize(new Dimension(3, 22));
        this.loadingLabel.setIcon(this.loadingIcon);
        this.loadingLabel.setVisible(false);
        this.comboboxGroupPanel.setLayout(new BoxLayout(this.comboboxGroupPanel, 0));
        this.tabsCombobox.addActionListener(e -> {
            int index = this.tabsCombobox.getSelectedIndex();
            if (index < this.subTabList.size()) {
                if (this.subTabList.size() > 1 && this.toolbarList.get(this.currentSubTabIndex) != null) {
                    this.toolbarPanel.remove(this.toolbarList.get(this.currentSubTabIndex));
                }
                this.toolbarPanel.add((Component)this.toolbarList.get(index), "West");
                this.toolbarPanel.revalidate();
                this.toolbarPanel.repaint();
                this.scrollPane.setViewportView(this.subTabList.get(index));
                if (this.subTabList.get(index) instanceof ComboTabListener) {
                    ((ComboTabListener)((Object)this.subTabList.get(this.currentSubTabIndex))).toolbarAction(6);
                    ((ComboTabListener)((Object)this.subTabList.get(index))).toolbarAction(5);
                }
                this.currentSubTabIndex = index;
            }
            this.comboboxGroupPanel.requestFocusInWindow();
        });
    }

    public int getCurrentTabIndex() {
        return this.tabsCombobox.getSelectedIndex();
    }

    public void resetDefaultTab() {
        this.tabsCombobox.setSelectedIndex(0);
    }

    public boolean isEmpty() {
        return this.tabsCombobox == null || this.tabsCombobox.getItemCount() == 0;
    }

    public void addSubTab(JPanel subPanel, String subTabName) {
        this.addSubTab(subPanel, subTabName, null);
    }

    public void addSubTab(JPanel subPanel, String subTabName, int ... buttonType) {
        JToolBar toolbar = new JToolBar();
        Insets toolBtnMargin = new Insets(0, 0, 0, 10);
        if (null != buttonType) {
            for (int btnType : buttonType) {
                ToolbarButton button = new ToolbarButton();
                button.setButtonType(btnType);
                switch (btnType) {
                    case 0: {
                        button.setText("Get");
                        button.setIcon(this.getIcon);
                        break;
                    }
                    case 1: {
                        button.setText("Save");
                        button.setIcon(this.saveIcon);
                        break;
                    }
                    case 2: {
                        button.setText("Add User");
                        button.setIcon(this.addIcon);
                        break;
                    }
                    case 3: {
                        button.setText("Delete");
                        button.setIcon(this.deleteIcon);
                        break;
                    }
                    case 4: {
                        button.setText("Refresh");
                        button.setIcon(this.refreshIcon);
                        break;
                    }
                }
                button.setMargin(toolBtnMargin);
                button.addActionListener(e -> ((ComboTabListener)((Object)subPanel)).toolbarAction(btnType));
                toolbar.add(button);
            }
        }
        toolbar.setFloatable(false);
        this.toolbarList.add(toolbar);
        this.tabsCombobox.addItem(subTabName);
        this.subTabList.add(subPanel);
        this.currentSubTabIndex = this.tabsCombobox.getItemCount() - 1;
        this.toolbarPanel.add((Component)toolbar, "West");
        this.comboboxGroupPanel.add(this.loadingLabel);
        this.comboboxGroupPanel.add(Box.createHorizontalStrut(7));
        this.comboboxGroupPanel.add(this.separator);
        this.comboboxGroupPanel.add(Box.createHorizontalStrut(7));
        this.comboboxGroupPanel.add(this.tabsCombobox);
        this.toolbarPanel.add((Component)this.comboboxGroupPanel, "East");
        this.add((Component)this.toolbarPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setViewportView(subPanel);
        this.scrollPane.getViewport().addChangeListener(e -> subPanel.repaint());
    }

    private void setLoadingIconVisible(boolean visible) {
        this.loadingLabel.setVisible(visible);
    }

    private void setToolbarButtonEnable(boolean enable, int[] buttonArray) {
        int index = this.tabsCombobox.getSelectedIndex();
        if (index >= 0) {
            for (Component comp : this.toolbarList.get(index).getComponents()) {
                if (buttonArray != null && buttonArray.length > 0) {
                    ToolbarButton toolbarButton = (ToolbarButton)comp;
                    for (int btn : buttonArray) {
                        if (toolbarButton.getButtonType() != btn) continue;
                        comp.setEnabled(enable);
                    }
                    continue;
                }
                comp.setEnabled(enable);
            }
        }
    }

    @Override
    public void toolbarStatus(int status, int ... buttons) {
        switch (status) {
            case 0: {
                this.tabsCombobox.setEnabled(true);
                this.setLoadingIconVisible(false);
                this.setToolbarButtonEnable(true, buttons);
                break;
            }
            case 1: {
                this.tabsCombobox.setEnabled(false);
                this.setLoadingIconVisible(true);
                break;
            }
            case 2: {
                this.tabsCombobox.setEnabled(false);
                this.setToolbarButtonEnable(false, buttons);
                break;
            }
            case 3: {
                this.setToolbarButtonEnable(false, buttons);
                break;
            }
        }
    }

    private class ToolbarButton
    extends JButton {
        private int buttonType = -1;

        private ToolbarButton() {
        }

        public int getButtonType() {
            return this.buttonType;
        }

        public void setButtonType(int type) {
            this.buttonType = type;
        }
    }
}

