/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import dyorgio.runtime.out.process.CallableSerializable;
import dyorgio.runtime.run.as.root.NotAuthorizedException;
import dyorgio.runtime.run.as.root.RootExecutor;
import dyorgio.runtime.run.as.root.UserCanceledException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeviceFile
implements Serializable {
    private Vector GroupName;
    private Vector[][] GroupMember;
    private Vector TextFromFile = new Vector(20);
    private TreeMap hostnameToIP = new TreeMap();
    public static final int ECHO_LENGTH_LIMITATION = 4096;

    public void LoadFromFile(String Filename) {
        File f = new File(Filename + ".properties");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException ie) {
                System.err.println();
                System.err.println("Can't create the properties file that contains the IPMI devices information.");
                System.err.println("Please check your file access rights.");
                System.err.println();
                System.exit(1);
            }
        }
        try {
            String tempString;
            this.TextFromFile.removeAllElements();
            FileReader fin = new FileReader(Filename + ".properties");
            BufferedReader br = new BufferedReader(fin);
            boolean i = false;
            while ((tempString = br.readLine()) != null) {
                this.TextFromFile.addElement(tempString);
            }
            fin.close();
        }
        catch (IOException e) {
            System.err.println();
            System.err.println("Can't find the properties file that contains the IPMI devices information.");
            System.err.println("Its name should be IPMIView.properties");
            System.err.println();
            System.exit(1);
        }
    }

    public boolean SaveToFile(String Filename) {
        return this.SaveToFile(Filename, true);
    }

    public boolean SaveToFile(String Filename, boolean tryPrivilegeElevation) {
        try {
            FileWriter fout = new FileWriter(Filename + ".properties");
            PrintWriter pw = new PrintWriter(fout);
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                pw.println(this.TextFromFile.get(i).toString());
            }
            fout.close();
            IPMIView20.configurationChanged = false;
            return true;
        }
        catch (IOException ex) {
            if (DeviceFile.isPermissionDeniedOnWindows(ex.getMessage())) {
                boolean result = false;
                result = this.isContentOverSizeLimitation() ? DeviceFile.saveFileAsWindowsAdmin(Filename + ".properties", this.TextFromFile) : DeviceFile.saveFileAsWindowsAdmin(Filename + ".properties", this.getContentWithEchoPackage());
                if (result) {
                    IPMIView20.configurationChanged = false;
                }
                return result;
            }
            System.err.println();
            System.err.println("Can't save to file!");
            System.err.println();
            return false;
        }
    }

    public static boolean saveFileAsWindowsAdmin(String filename, String content) {
        Boolean result;
        block6: {
            result = false;
            try {
                RootExecutor rootExecutor = new RootExecutor(new String[0]);
                result = (Boolean)rootExecutor.call((CallableSerializable & Serializable)() -> {
                    block3: {
                        try {
                            String filePath = "\"" + filename + "\"";
                            String[] command = new String[]{"cmd", "/c", content + " > " + filePath};
                            Process process = Runtime.getRuntime().exec(command);
                            int code = process.waitFor();
                            if (code == 0) {
                                return true;
                            }
                        }
                        catch (IOException | InterruptedException e) {
                            if (!IPMIView20.instance.DEBUG) break block3;
                            e.printStackTrace();
                        }
                    }
                    return false;
                });
            }
            catch (UserCanceledException e) {
                if (IPMIView20.instance.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (NotAuthorizedException e) {
                if (IPMIView20.instance.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!IPMIView20.instance.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean saveFileAsWindowsAdmin(String filename, Vector<String> content) {
        Boolean result;
        block6: {
            result = false;
            try {
                RootExecutor rootExecutor = new RootExecutor(new String[0]);
                result = (Boolean)rootExecutor.call((CallableSerializable & Serializable)() -> {
                    try {
                        String ACTION_REPLACE = " > ";
                        String ACTION_APPEND = " >> ";
                        String filePath = "\"" + filename + "\"";
                        int count = 0;
                        StringBuilder builder = new StringBuilder();
                        for (String prop : content) {
                            prop = DeviceFile.getEchoEscapedChars(prop).trim();
                            builder.append(builder.length() == 0 ? "echo " : "& echo ");
                            builder.append(prop);
                            if (builder.length() <= 4096) continue;
                            String action = count == 0 ? " > " : " >> ";
                            String parameters = "(" + builder.toString() + ")" + action + filePath;
                            if (DeviceFile.runCommandProcess(parameters) != 0) {
                                return false;
                            }
                            builder.setLength(0);
                            ++count;
                        }
                        if (builder.length() != 0) {
                            String action = count == 0 ? " > " : " >> ";
                            String parameters = "(" + builder.toString() + ")" + action + filePath;
                            if (DeviceFile.runCommandProcess(parameters) != 0) {
                                return false;
                            }
                        }
                        return true;
                    }
                    catch (IOException | InterruptedException e) {
                        if (IPMIView20.instance.DEBUG) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                });
            }
            catch (UserCanceledException e) {
                if (IPMIView20.instance.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (NotAuthorizedException e) {
                if (IPMIView20.instance.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!IPMIView20.instance.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return result;
    }

    public void SaveLayoutToFile(String Filename, String hostname, String Layposition) {
        String tempString = null;
        Object xString = null;
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(hostname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            if (y > x) {
                int z = tempString.indexOf(58, y + 1);
                if (z > y) {
                    this.TextFromFile.set(i, tempString.substring(0, z + 1) + Layposition);
                } else {
                    this.TextFromFile.set(i, tempString.substring(0) + ":" + Layposition);
                }
            } else {
                this.TextFromFile.set(i, tempString.substring(0) + "::" + Layposition);
            }
            this.SaveToFile(Filename);
            return;
        }
    }

    public String hostnameToIP(String hostname) {
        if (this.hostnameToIP.containsKey(hostname)) {
            return (String)this.hostnameToIP.get(hostname);
        }
        String tempString = null;
        String xString = null;
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(hostname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.lastIndexOf(58);
            if (tempString.contains("|")) {
                String tempsubString = tempString.substring(0, y);
                y = tempsubString.lastIndexOf(58);
            }
            xString = tempString.substring(x + 1, y);
            this.hostnameToIP.put(hostname, xString);
            return xString;
        }
        return xString;
    }

    protected static Vector parseList(String theStringList) {
        Vector<String> v = new Vector<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(theStringList, ";");
        while (tokenizer.hasMoreTokens()) {
            String Id2 = tokenizer.nextToken();
            v.addElement(Id2);
        }
        return v;
    }

    public Vector getDevice(String devicename) {
        Vector<String> deviceentry = new Vector<String>(20);
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(devicename + "=")) continue;
            int x = tempString.indexOf(61);
            if (tempString.contains("|")) {
                int z = tempString.lastIndexOf(58);
                String tempsubString = tempString.substring(0, z);
                int y = tempsubString.lastIndexOf(58);
                deviceentry.addElement(tempString.substring(0, x));
                deviceentry.addElement(tempString.substring(x + 1, y));
                deviceentry.addElement(tempString.substring(y + 1, z));
                deviceentry.addElement(tempString.substring(z + 1, tempString.length()));
            } else {
                int y = tempString.lastIndexOf(58);
                deviceentry.addElement(tempString.substring(0, x));
                deviceentry.addElement(tempString.substring(x + 1, y));
                deviceentry.addElement(tempString.substring(y + 1, tempString.length()));
                deviceentry.addElement("");
            }
            return deviceentry;
        }
        return deviceentry;
    }

    public Vector getDeviceVector(String groupname) {
        Vector devices = new Vector(20);
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String xString;
            int x;
            String tempString = this.TextFromFile.get(i).toString();
            if (groupname == null || groupname == GlobalDefine.IPMI_DOMAIN) {
                if (tempString.startsWith("!")) continue;
                x = tempString.indexOf(61);
                xString = tempString.substring(0, x);
                devices.addElement(xString);
                continue;
            }
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            xString = y > x ? tempString.substring(x + 1, y) : tempString.substring(x + 1);
            devices = DeviceFile.parseList(xString);
            return devices;
        }
        return devices;
    }

    public Vector getGroupVector(String groupname) {
        Vector<String> groupentry = new Vector<String>(20);
        if (groupname == null || groupname.equals(GlobalDefine.IPMI_DOMAIN)) {
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                String tempString = this.TextFromFile.get(i).toString();
                if (!tempString.startsWith("!")) continue;
                int x = tempString.indexOf(61);
                int y = tempString.indexOf(58, x + 1);
                if (y > x) {
                    groupentry.addElement(tempString.substring(1, x));
                    groupentry.addElement(tempString.substring(y + 1, tempString.length()));
                    continue;
                }
                groupentry.addElement(tempString.substring(1, x));
                groupentry.addElement("");
            }
            return groupentry;
        }
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            if (y > x) {
                groupentry.addElement(tempString.substring(1, x));
                groupentry.addElement(tempString.substring(y + 1, tempString.length()));
            } else {
                groupentry.addElement(tempString.substring(1, x));
                groupentry.addElement("");
            }
            return groupentry;
        }
        return groupentry;
    }

    public void addGroup(String groupname, String description) {
        this.TextFromFile.addElement("!" + groupname + "=:" + description);
        IPMIView20.getInstance().setConfigurationUpdated();
    }

    public void addDevice(String devicename, String IP, String description) {
        this.TextFromFile.addElement(devicename + "=" + IP + ":" + description);
        IPMIView20.getInstance().setConfigurationUpdated();
    }

    public void deleteGroup(String groupname) {
        if (groupname == null || groupname.equals(GlobalDefine.IPMI_DOMAIN)) {
            return;
        }
        if (groupname != null) {
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                String tempString = this.TextFromFile.get(i).toString();
                if (!tempString.startsWith("!" + groupname + "=")) continue;
                this.TextFromFile.remove(i);
                IPMIView20.getInstance().setConfigurationUpdated();
                return;
            }
        }
    }

    public void dump() {
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            System.out.println(i + " " + this.TextFromFile.get(i).toString());
        }
    }

    public void joinGroup(String groupname, String devicename) {
        if (groupname == null || groupname.compareTo(GlobalDefine.IPMI_DOMAIN) == 0) {
            return;
        }
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            tempString = y > x ? (tempString.charAt(y - 1) == '=' ? tempString.substring(0, y) + devicename + tempString.substring(y) : tempString.substring(0, y) + ";" + devicename + tempString.substring(y)) : (tempString.charAt(tempString.length() - 1) == '=' ? tempString + devicename + ":" : tempString + ";" + devicename + ":");
            this.TextFromFile.set(i, tempString);
            IPMIView20.getInstance().setConfigurationUpdated();
            return;
        }
    }

    public void disjoinGroup(String groupname, String devicename) {
        if (groupname == null || groupname.compareTo(GlobalDefine.IPMI_DOMAIN) == 0) {
            return;
        }
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            int j = tempString.indexOf(devicename);
            if (j >= 0) {
                int k = tempString.indexOf(";", j + 1);
                if (k > 0) {
                    this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k + 1));
                } else {
                    k = tempString.indexOf(":", j + 1);
                    if (k > 0) {
                        if (tempString.charAt(j - 1) == '=') {
                            this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k));
                        } else {
                            this.TextFromFile.set(i, tempString.substring(0, j - 1) + tempString.substring(k));
                        }
                    } else if (tempString.charAt(j - 1) == '=') {
                        this.TextFromFile.set(i, tempString.substring(0, j));
                    } else {
                        this.TextFromFile.set(i, tempString.substring(0, j - 1));
                    }
                }
            }
            IPMIView20.getInstance().setConfigurationUpdated();
            return;
        }
    }

    public void deleteDevice(String devicename, String IP, String description) {
        String tempString;
        int i;
        if (this.hostnameToIP.containsKey(devicename)) {
            this.hostnameToIP.remove(devicename);
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (tempString.compareTo(devicename + "=" + IP) != 0 && !tempString.startsWith(devicename + "=" + IP + ":")) continue;
            this.TextFromFile.remove(i);
            IPMIView20.getInstance().setConfigurationUpdated();
            break;
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!")) continue;
            int j = tempString.indexOf(devicename);
            if (j >= 0) {
                int k = tempString.indexOf(";", j + 1);
                if (k > 0) {
                    this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k + 1));
                } else {
                    k = tempString.indexOf(":", j + 1);
                    if (k > 0) {
                        if (tempString.charAt(j - 1) == '=') {
                            this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k));
                        } else {
                            this.TextFromFile.set(i, tempString.substring(0, j - 1) + tempString.substring(k));
                        }
                    } else if (tempString.charAt(j - 1) == '=') {
                        this.TextFromFile.set(i, tempString.substring(0, j));
                    } else {
                        this.TextFromFile.set(i, tempString.substring(0, j - 1));
                    }
                }
            }
            IPMIView20.getInstance().setConfigurationUpdated();
        }
    }

    public void modifyDevice(String devicename, String IP, String description, String old_devicename, String old_IP, String old_description) {
        String tempString;
        int i;
        if (this.hostnameToIP.containsKey(devicename)) {
            this.hostnameToIP.put(devicename, IP);
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(old_devicename + "=" + old_IP + ":" + old_description)) continue;
            int x = tempString.indexOf(58);
            int y = tempString.lastIndexOf(58);
            if (tempString.contains("|")) {
                String pos = tempString.substring(y + 1, tempString.length());
                this.TextFromFile.set(i, devicename + "=" + IP + ":" + description + ":" + pos);
            } else {
                this.TextFromFile.set(i, devicename + "=" + IP + ":" + description);
            }
            IPMIView20.getInstance().setConfigurationUpdated();
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!")) continue;
            int equalSign = tempString.indexOf("=");
            int j = tempString.indexOf(old_devicename);
            if (j >= 0 & j > equalSign) {
                int k = tempString.indexOf(";", j + 1);
                if (k > 0) {
                    this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k + 1));
                } else {
                    k = tempString.indexOf(":", j + 1);
                    if (k > 0) {
                        if (tempString.charAt(j - 1) == '=') {
                            this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k));
                        } else {
                            this.TextFromFile.set(i, tempString.substring(0, j - 1) + tempString.substring(k));
                        }
                    } else if (tempString.charAt(j - 1) == '=') {
                        this.TextFromFile.set(i, tempString.substring(0, j));
                    } else {
                        this.TextFromFile.set(i, tempString.substring(0, j - 1));
                    }
                }
                int eqIndex = tempString.indexOf("=");
                String groupName = tempString.substring(1, eqIndex);
                this.joinGroup(groupName, devicename);
            }
            IPMIView20.getInstance().setConfigurationUpdated();
        }
    }

    public void modifyGroup(String groupname, String description, String old_groupname, String old_description) {
        if (groupname == null || groupname.equals(GlobalDefine.IPMI_DOMAIN)) {
            return;
        }
        if (groupname != null) {
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                String tempString = this.TextFromFile.get(i).toString();
                if (!tempString.startsWith("!" + old_groupname + "=")) continue;
                int x = tempString.indexOf(61);
                int y = tempString.indexOf(58, x + 1);
                tempString = y > x ? "!" + groupname + "=" + tempString.substring(x + 1, y) + ":" + description : "!" + groupname + "=" + tempString.substring(x + 1, tempString.length()) + ":" + description;
                this.TextFromFile.set(i, tempString);
                IPMIView20.getInstance().setConfigurationUpdated();
                return;
            }
        }
    }

    public static void clearRootExecutorTempFiles() {
        block2: {
            String fullPath = System.getProperty("user.home") + "\\AppData\\Local\\Temp\\";
            try {
                Set<String> fileSet1 = DeviceFile.listFilesUsingFilesList(fullPath, "out-process");
                fileSet1.iterator().forEachRemaining(e -> {
                    File file = new File(fullPath + e);
                    boolean isFileDeleted = file.delete();
                    if (IPMIView20.instance.DEBUG) {
                        if (isFileDeleted) {
                            System.out.println(e + " is deleted successfully.");
                        } else {
                            System.out.println(e + " is not deleted...");
                        }
                    }
                });
                Set<String> fileSet2 = DeviceFile.listFilesUsingFilesList(fullPath, "run-as-root");
                fileSet2.iterator().forEachRemaining(e -> {
                    File file = new File(fullPath + e);
                    boolean isFileDeleted = file.delete();
                    if (IPMIView20.instance.DEBUG) {
                        if (isFileDeleted) {
                            System.out.println(e + " is deleted successfully.");
                        } else {
                            System.out.println(e + " is not deleted...");
                        }
                    }
                });
            }
            catch (IOException e2) {
                if (!IPMIView20.instance.DEBUG) break block2;
                e2.printStackTrace();
            }
        }
    }

    public static boolean isPermissionDeniedOnWindows(String message) {
        String[] keywords;
        String platform = System.getProperty("os.name");
        if (platform == null || !platform.toLowerCase().contains("windows")) {
            return false;
        }
        for (String key : keywords = new String[]{"denied", "\u5b58\u53d6\u88ab\u62d2", "\u62d2\u7edd\u8bbf\u95ee"}) {
            if (!message.contains(key)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> listFilesUsingFilesList(String dir, String prefix) throws IOException {
        try (Stream<Path> stream = Files.list(Paths.get(dir, new String[0]));){
            Set<String> set = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().startsWith(prefix)).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
            return set;
        }
    }

    private boolean isContentOverSizeLimitation() {
        int limitation = 4096;
        int size = 2;
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            if ((size += this.TextFromFile.get(i).toString().length() + "& echo ".length()) <= 4096) continue;
            return true;
        }
        return false;
    }

    private String getContentWithEchoPackage() {
        StringBuilder builder = new StringBuilder();
        builder.append("echo ");
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String property = this.TextFromFile.get(i).toString();
            property = DeviceFile.getEchoEscapedChars(property);
            if (i != 0) {
                builder.append(" & echo ");
            }
            builder.append(property);
        }
        String content = "(" + builder.toString() + ")";
        return content;
    }

    private static String getEchoEscapedChars(String singleLineProperty) {
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        lists.add(Arrays.asList("^", "\\^", "^^"));
        lists.add(Arrays.asList("&", "&", "^&"));
        lists.add(Arrays.asList("<", "<", "^<"));
        lists.add(Arrays.asList(">", ">", "^>"));
        lists.add(Arrays.asList("|", "\\|", "^|"));
        lists.add(Arrays.asList("'", "'", "^'"));
        lists.add(Arrays.asList("`", "`", "^`"));
        lists.add(Arrays.asList(";", ";", "^;"));
        lists.add(Arrays.asList("(", "\\(", "^("));
        lists.add(Arrays.asList(")", "\\)", "^)"));
        lists.add(Arrays.asList("\"", "\"", "^\""));
        lists.add(Arrays.asList("\\", "\\\\", "\\\\"));
        for (List list : lists) {
            if (!singleLineProperty.contains((String)list.get(0))) continue;
            singleLineProperty = singleLineProperty.replaceAll((String)list.get(1), (String)list.get(2));
        }
        return singleLineProperty;
    }

    private static int runCommandProcess(String parameter) throws IOException, InterruptedException {
        String[] command = new String[]{"cmd", "/c", parameter};
        Process process = Runtime.getRuntime().exec(command);
        int code = process.waitFor();
        return code;
    }

    public static String getHostnameByIP(String aIP) {
        if (aIP == null) {
            return null;
        }
        DeviceFile deviceFile = new DeviceFile();
        deviceFile.LoadFromFile("IPMIView");
        Vector v = deviceFile.getDeviceVector(null);
        for (int i = 0; i < v.size(); ++i) {
            String ip = deviceFile.hostnameToIP(v.get(i).toString());
            if (!ip.equals(aIP)) continue;
            return v.get(i).toString();
        }
        return null;
    }

    public static void main(String[] args) {
        String hostname = DeviceFile.getHostnameByIP("192.168.12.125");
        System.out.println("hostname = " + hostname);
        hostname = DeviceFile.getHostnameByIP("192.168.12.173");
        System.out.println("hostname = " + hostname);
        hostname = DeviceFile.getHostnameByIP("192.168.12.126");
        System.out.println("hostname = " + hostname);
        hostname = DeviceFile.getHostnameByIP("192.168.12.125");
        System.out.println("hostname = " + hostname);
        hostname = DeviceFile.getHostnameByIP("192.168.12.124");
        System.out.println("hostname = " + hostname);
        hostname = DeviceFile.getHostnameByIP("192.168.23.95");
        System.out.println("hostname = " + hostname);
    }
}

