/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;

public class ErrorStatusTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final int ICON_POSITION_OFFSET_X = 2;
    private static final int ICON_POSITION_OFFSET_Y = 1;
    private static final int ARC = 5;
    private static final String ICON_STATUS_WARNING = "/images/status_warning.png";
    private static final Color COLOR_FAILURE = new Color(255, 148, 148);
    private static final Color COLOR_SUCCESS = Color.WHITE;
    private Color showColor = COLOR_FAILURE;
    private Color hideColor = COLOR_SUCCESS;
    private boolean visible;
    private Color currentColor;
    private Icon statusIcon = new ImageIcon(this.getClass().getResource("/images/status_warning.png"));

    public ErrorStatusTextField() {
        this.setOpaque(false);
        this.setForeground(Color.WHITE);
        this.visible = true;
    }

    public void setShowColor(Color color) {
        this.showColor = color;
    }

    public void setHidColor(Color color) {
        this.hideColor = color;
    }

    public void setTextField(String text) {
        if (text.isEmpty()) {
            this.visible = false;
            this.currentColor = this.hideColor;
        } else {
            this.visible = true;
            this.currentColor = this.showColor;
        }
        super.setText(text);
        super.invalidate();
        super.repaint();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.currentColor);
        g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
        if (this.visible) {
            this.statusIcon.paintIcon(this, g, 2, 1);
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        g.setColor(this.currentColor);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
    }
}

