/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.FanModePanel_jUpdateButton_actionAdapter;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.SystemLockdownCommand;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class FanModePanel
extends JPanel {
    private String ip;
    private String id;
    private String password;
    private byte privilege;
    boolean isLoaded;
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    private JLabel message;
    TitledBorder titledBorder1 = new TitledBorder("");
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JRadioButton jOptimalRadioButton = new JRadioButton();
    JRadioButton jFullRadioButton = new JRadioButton();
    JRadioButton jStandardRadioButton = new JRadioButton();
    JRadioButton jPUEOptimalRadioButton = new JRadioButton();
    JRadioButton jHeavyIORadioButton = new JRadioButton();
    JRadioButton jPUE3OptimalRadioButton = new JRadioButton();
    JRadioButton jLiquidCoolingRadioButton = new JRadioButton();
    JRadioButton jSmartSpeedRadioButton = new JRadioButton();
    JButton jUpdateButton = new JButton();
    TitledBorder titledBorder2 = new TitledBorder("");
    byte orgLANMode;

    public FanModePanel(String ip, String id, String password, byte privilege, JLabel message) {
        try {
            this.ip = ip;
            this.id = id;
            this.password = password;
            this.privilege = privilege;
            this.message = message;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.buttonGroup1.add(this.jOptimalRadioButton);
        this.buttonGroup1.add(this.jStandardRadioButton);
        this.buttonGroup1.add(this.jFullRadioButton);
        this.buttonGroup1.add(this.jPUEOptimalRadioButton);
        this.buttonGroup1.add(this.jHeavyIORadioButton);
        this.buttonGroup1.add(this.jPUE3OptimalRadioButton);
        this.buttonGroup1.add(this.jLiquidCoolingRadioButton);
        this.buttonGroup1.add(this.jSmartSpeedRadioButton);
    }

    private void jbInit() throws Exception {
        this.titledBorder2 = new TitledBorder(L.t("device.Fan.Speed_Mode"));
        this.titledBorder1 = new TitledBorder(L.t("device.Fan.Speed_Mode"));
        this.setLayout(null);
        this.jOptimalRadioButton.setToolTipText("Optimal");
        this.jOptimalRadioButton.setText("Optimal");
        this.jOptimalRadioButton.setBounds(new Rectangle(83, 21, 63, 23));
        this.jFullRadioButton.setToolTipText("Full");
        this.jFullRadioButton.setText("Full");
        this.jFullRadioButton.setBounds(new Rectangle(8, 40, 43, 23));
        this.jStandardRadioButton.setToolTipText("Standard");
        this.jStandardRadioButton.setText("Standard");
        this.jStandardRadioButton.setBounds(new Rectangle(8, 21, 67, 23));
        this.jPUEOptimalRadioButton.setToolTipText("PUE2 Optimal");
        this.jPUEOptimalRadioButton.setText("PUE2 Opt");
        this.jPUEOptimalRadioButton.setBounds(new Rectangle(83, 40, 75, 23));
        this.jHeavyIORadioButton.setToolTipText("Heavy IO");
        this.jHeavyIORadioButton.setText("Heavy IO");
        this.jHeavyIORadioButton.setBounds(new Rectangle(8, 59, 75, 23));
        this.jPUE3OptimalRadioButton.setToolTipText("PUE3 Optimal");
        this.jPUE3OptimalRadioButton.setText("PUE3 Opt");
        this.jPUE3OptimalRadioButton.setBounds(new Rectangle(83, 59, 75, 23));
        this.jLiquidCoolingRadioButton.setToolTipText("Liquid Cooling");
        this.jLiquidCoolingRadioButton.setText("Liquid");
        this.jLiquidCoolingRadioButton.setBounds(new Rectangle(8, 78, 60, 23));
        this.jSmartSpeedRadioButton.setToolTipText("Smart Speed");
        this.jSmartSpeedRadioButton.setText("Smart");
        this.jSmartSpeedRadioButton.setBounds(new Rectangle(83, 78, 60, 23));
        this.jUpdateButton.setBounds(new Rectangle(12, 106, 80, 23));
        this.jUpdateButton.setPreferredSize(new Dimension(80, 23));
        this.jUpdateButton.setToolTipText(L.t("device.Fan.Update"));
        this.jUpdateButton.setHorizontalTextPosition(0);
        this.jUpdateButton.setText(L.t("device.Fan.Update"));
        this.jUpdateButton.addActionListener(new FanModePanel_jUpdateButton_actionAdapter(this));
        this.setBorder(this.titledBorder2);
        this.add(this.jStandardRadioButton);
        this.add(this.jOptimalRadioButton);
        this.add(this.jFullRadioButton);
        this.add(this.jPUEOptimalRadioButton);
        this.add(this.jHeavyIORadioButton);
        this.add(this.jPUE3OptimalRadioButton);
        this.add(this.jLiquidCoolingRadioButton);
        this.add(this.jSmartSpeedRadioButton);
        this.add(this.jUpdateButton);
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivilege(byte privilege) {
        this.privilege = privilege;
    }

    public String getIp() {
        return this.ip;
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getPrivilege() {
        return this.privilege;
    }

    public boolean getIsLoaded() {
        return this.isLoaded;
    }

    public void load() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        this.isLoaded = false;
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte fanMode = ipmiOEMCommand.getFANSpeedMode();
        this.setFanModeRadioButton(fanMode);
        int fanModeCapability = -1;
        try {
            fanModeCapability = ipmiOEMCommand.getFANSpeedModeCapability();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((byte)(fanModeCapability & 1) == 1) {
            this.jStandardRadioButton.setEnabled(true);
        } else {
            this.jStandardRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 2) == 2) {
            this.jFullRadioButton.setEnabled(true);
        } else {
            this.jFullRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 4) == 4) {
            this.jOptimalRadioButton.setEnabled(true);
        } else {
            this.jOptimalRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 8) == 8) {
            this.jPUEOptimalRadioButton.setEnabled(true);
        } else {
            this.jPUEOptimalRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 0x10) == 16) {
            this.jHeavyIORadioButton.setEnabled(true);
        } else {
            this.jHeavyIORadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 0x20) == 32) {
            this.jPUE3OptimalRadioButton.setEnabled(true);
        } else {
            this.jPUE3OptimalRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 0x40) == 64) {
            this.jLiquidCoolingRadioButton.setEnabled(true);
        } else {
            this.jLiquidCoolingRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 0x80) == -128) {
            this.jSmartSpeedRadioButton.setEnabled(true);
        } else {
            this.jSmartSpeedRadioButton.setEnabled(false);
        }
        this.isLoaded = true;
        sessionController.closeSession();
    }

    private void setFanModeRadioButton(byte fanMode) {
        switch (fanMode) {
            case 0: {
                this.jStandardRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.jFullRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.jOptimalRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.jPUEOptimalRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.jHeavyIORadioButton.setSelected(true);
                break;
            }
            case 5: {
                this.jPUE3OptimalRadioButton.setSelected(true);
                break;
            }
            case 6: {
                this.jLiquidCoolingRadioButton.setSelected(true);
                break;
            }
            case 7: {
                this.jSmartSpeedRadioButton.setSelected(true);
                break;
            }
        }
    }

    public void update() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        int fanMode = 0;
        this.orgLANMode = ipmiOEMCommand.getFANSpeedMode();
        if (this.jHeavyIORadioButton.isSelected()) {
            fanMode = 4;
        } else if (this.jPUEOptimalRadioButton.isSelected()) {
            fanMode = 3;
        } else if (this.jOptimalRadioButton.isSelected()) {
            fanMode = 2;
        } else if (this.jStandardRadioButton.isSelected()) {
            fanMode = 0;
        } else if (this.jFullRadioButton.isSelected()) {
            fanMode = 1;
        } else if (this.jPUE3OptimalRadioButton.isSelected()) {
            fanMode = 5;
        } else if (this.jLiquidCoolingRadioButton.isSelected()) {
            fanMode = 6;
        } else if (this.jSmartSpeedRadioButton.isSelected()) {
            fanMode = 7;
        }
        if (fanMode != this.orgLANMode) {
            ipmiOEMCommand.setFANSpeedMode((byte)fanMode);
        }
        sessionController.closeSession();
    }

    public void jUpdateButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (FanModePanel.this.isSystemLockdown()) {
                    return;
                }
                FanModePanel.this.setCursor(new Cursor(3));
                try {
                    FanModePanel.this.update();
                }
                catch (IPMIException ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Not a supported fan mode");
                    FanModePanel.this.setFanModeRadioButton(FanModePanel.this.orgLANMode);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), ex.toString());
                    FanModePanel.this.setFanModeRadioButton(FanModePanel.this.orgLANMode);
                }
                FanModePanel.this.setCursor(new Cursor(0));
            }
        };
        thread.start();
    }

    private boolean isSystemLockdown() {
        this.ipmiInterfaceConfig = new IPMIInterfaceConfig();
        this.ipmiInterfaceConfig.setIp(this.ip);
        this.ipmiInterfaceConfig.setUserName(this.id);
        this.ipmiInterfaceConfig.setPassword(new String(this.password));
        this.ipmiInterfaceConfig.setPrivilege((byte)4);
        SystemLockdownCommand systemLockdownCommand = new SystemLockdownCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, systemLockdownCommand);
        if (sessionController == null) {
            this.message.setText("createSessionController failed");
        }
        if (systemLockdownCommand != null && systemLockdownCommand.isSystemLocked()) {
            this.message.setText(L.t("device.Fan.InSystemLockdownMode"));
            JOptionPane.showMessageDialog(this, L.t("device.Fan.InSystemLockdownMode"), L.t("user.Forbidden"), 0);
            sessionController.closeSession();
            return true;
        }
        sessionController.closeSession();
        return false;
    }
}

