/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.FlashRedFishBaseControl;
import IPMIView20.FlashRedFishInterface;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.redfish.RedfishHttpUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class FlashBIOSRedFishControl
extends FlashRedFishBaseControl {
    public FlashBIOSRedFishControl(FlashRedFishInterface redfishInterface) {
        super(redfishInterface);
    }

    @Override
    protected void setConfiguration(boolean preserveME, boolean preserveNVRAM, boolean preserveSMBIOS, boolean backupImage) {
        this.requestBody = "{\"Targets\": [\"/redfish/v1/Systems/1/Bios\"],\r\n\"@Redfish.OperationApplyTime\": \"Immediate\",\r\n\"Oem\": {\"Supermicro\": {\"BIOS\":{\"PreserveME\": " + (preserveME ? "true" : "false") + ",\"PreserveNVRAM\": " + (preserveNVRAM ? "true" : "false") + ",\"PreserveSMBIOS\": " + (preserveSMBIOS ? "true" : "false") + ",\"BackupBIOS\": " + (backupImage ? "true" : "false") + "}}}}";
    }

    protected void setConfiguration(boolean preserveME, boolean preserveNVRAM, boolean preserveSMBIOS, boolean backupImage, boolean preserveOA, boolean preserveSetupConfig, boolean preserveSetupPWD, boolean preserveSecBootKey, boolean preserveBootConfig) {
        this.requestBody = "{\"Targets\":[\"/redfish/v1/Systems/1/Bios\"],\r\n\"@Redfish.OperationApplyTime\":\"Immediate\",\r\n\"Oem\":{\"Supermicro\":{\"BIOS\":{\"PreserveME\":" + preserveME + ",\r\n\"PreserveNVRAM\":" + preserveNVRAM + ",\r\n\"PreserveSMBIOS\":" + preserveSMBIOS + ",\r\n\"PreserveOA\":" + preserveOA + ",\r\n\"PreserveSETUPCONF\":" + preserveSetupConfig + ",\r\n\"PreserveSETUPPWD\":" + preserveSetupPWD + ",\r\n\"PreserveSECBOOTKEY\":" + preserveSecBootKey + ",\r\n\"PreserveBOOTCONF\":" + preserveBootConfig + ",\r\n\"BackupBIOS\":" + backupImage + "}}}}";
    }

    @Override
    protected String getTargetVersion(String ip, String username, String password) {
        if (!this.checkStringNotEmpty(ip)) {
            this.listenser.updateMessage("IP cannot be empty");
            return null;
        }
        if (!this.checkStringNotEmpty(username)) {
            this.listenser.updateMessage("Username cannot be empty");
            return null;
        }
        if (!this.checkStringNotEmpty(password)) {
            this.listenser.updateMessage("Password cannot be empty");
            return null;
        }
        this.loginIP = ip;
        this.loginID = username;
        this.loginPWD = password;
        this.interfaceConfig.setIp(ip);
        this.interfaceConfig.setUserName(username);
        this.interfaceConfig.setPassword(password);
        this.interfaceConfig.setPrivilege((byte)4);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiOEMCommand);
        if (null != sessionController) {
            String targetBuildDate = null;
            String targetVersion = null;
            try {
                byte[] dateBytes = ipmiOEMCommand.getBiosDate();
                byte[] verBytes = ipmiOEMCommand.getBiosVer();
                if (null != dateBytes) {
                    targetBuildDate = new String(dateBytes);
                }
                if (null != verBytes) {
                    targetVersion = new String(verBytes);
                }
            }
            catch (IPMIException e) {
                this.listenser.updateMessage(e.getMessage());
            }
            sessionController.closeSession();
            return targetBuildDate + (targetVersion == null ? "" : " Rev " + targetVersion.trim());
        }
        return null;
    }

    @Override
    protected String getImageVersion(String ip, String filename) throws Exception {
        if (!this.checkLogin()) {
            this.listenser.updateState(2);
        }
        if (!this.checkStringNotEmpty(filename)) {
            this.listenser.updateMessage("filename cannot be empty");
            return null;
        }
        IPMIX9BIOSOEMCommand.BIOSInfo biosInfo = this.getBiosInfo(filename);
        if (this.checkBoardID(biosInfo, this.getTargetBoardID())) {
            return biosInfo.date + (biosInfo.ver == null ? "" : " Rev " + biosInfo.ver);
        }
        return null;
    }

    protected String getHIIVersion() {
        String url = "https://" + this.interfaceConfig.getIp() + "/restapi/smci/BmcInfo/";
        RedfishHttpUtils utils = new RedfishHttpUtils();
        try {
            utils.sendRedfishGet(this.interfaceConfig, url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> entryMap = null;
        try {
            entryMap = utils.getEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String version = null;
        if (entryMap != null) {
            version = entryMap.get("InternalFwVersion/NewHII");
        }
        if (version == null) {
            return "00.00";
        }
        return version;
    }

    @Override
    protected void doFlashing() {
        this.listenser.updateState(1);
        if (!this.checkStringNotEmpty(this.requestBody)) {
            this.listenser.updateState(0);
            return;
        }
        if (!this.checkLogin()) {
            this.listenser.updateState(2);
            return;
        }
        if (!this.checkFileExists()) {
            this.listenser.updateState(4);
            return;
        }
        new Thread(() -> {
            if (this.checkRoTModel() && !this.setPowerOff()) {
                this.listenser.updateState(3);
                return;
            }
            try {
                this.redfishFlash.flashWorker(this.interfaceConfig, this.imageFile, this.requestBody, false);
                this.listenser.updateState(7);
            }
            catch (Exception e) {
                this.listenser.updateMessage("<html><p style=\"color:red\">" + e.getLocalizedMessage() + "</p></html>");
                this.listenser.updateState(8);
            }
        }).start();
    }

    private IPMIX9BIOSOEMCommand.BIOSInfo getBiosInfo(String filename) {
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiX9BIOSOEMCommand);
        if (null != sessionController) {
            IPMIX9BIOSOEMCommand.BIOSInfo biosFileInfo = null;
            try {
                biosFileInfo = ipmiX9BIOSOEMCommand.checkBIOSImage(filename, false, 8192);
                if (biosFileInfo == null) {
                    biosFileInfo = ipmiX9BIOSOEMCommand.checkBIOSImage(filename, false, 10240);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sessionController.closeSession();
            return biosFileInfo;
        }
        return null;
    }

    private byte[] getTargetBoardID() {
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiOEMCommand);
        if (null != sessionController) {
            byte[] boardID = ipmiOEMCommand.getProductID();
            sessionController.closeSession();
            return boardID;
        }
        return null;
    }

    private int getTargetOFID() {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiBMCFileCommand);
        int deviceOFID = -1;
        if (sessionController != null) {
            try {
                byte[] ofid = new byte[2];
                byte[] ofidArray = ipmiBMCFileCommand.generalFileDownloadbyArray((byte)21, false, false);
                System.arraycopy(ofidArray, 8, ofid, 0, 2);
                deviceOFID = ByteUtility.twoBytesToIntLSB(ofid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sessionController.closeSession();
        }
        return deviceOFID;
    }

    private int getImageOFID(String filename) throws Exception {
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
        return ipmiX9BIOSOEMCommand.checkBIOSImageOFID(filename);
    }

    private boolean checkOFID(int imageOFID, int targetOFID) {
        return targetOFID <= 0 || targetOFID <= imageOFID;
    }

    private boolean checkBoardID(IPMIX9BIOSOEMCommand.BIOSInfo biosInfo, byte[] targetInfo) {
        if (null == biosInfo) {
            this.listenser.updateMessage("BIOS File is invalid");
            return false;
        }
        if (null == targetInfo) {
            this.listenser.updateMessage("Cannot get BIOS board ID");
            return false;
        }
        if (targetInfo[0] != biosInfo.boardID[0] || targetInfo[1] != biosInfo.boardID[1]) {
            String fileBIOSID = ByteUtility.bytesToHex(biosInfo.boardID);
            String bmcBIOSID = ByteUtility.bytesToHex(targetInfo);
            this.listenser.updateMessage("BIOS File invalid (Board ID mismatch. (" + fileBIOSID + ")(" + bmcBIOSID + "))");
            return false;
        }
        return true;
    }

    private boolean checkRoTModel() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiMessagingCommand);
        boolean isRoT = false;
        if (sessionController != null) {
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            isRoT = !IPMIMessagingCommand.isNonROT(guid);
            sessionController.closeSession();
        }
        return isRoT;
    }

    private boolean setPowerOff() {
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiChassisCommand);
        boolean isPowerOff = false;
        if (sessionController != null) {
            block10: {
                try {
                    if (ipmiChassisCommand.isPowerOn()) {
                        if (ipmiChassisCommand.powerDown()) {
                            SwingUtilities.invokeAndWait(() -> this.listenser.updateMessage("Update BIOS image requries system power off"));
                            Thread.sleep(2000L);
                            SwingUtilities.invokeAndWait(() -> this.listenser.updateMessage("Going to force shutdown the system"));
                            Thread.sleep(2000L);
                            SwingUtilities.invokeAndWait(() -> this.listenser.updateMessage("Detecting system power status"));
                            Thread.sleep(2000L);
                            SwingUtilities.invokeAndWait(() -> this.listenser.updateMessage("Wait for Power off ..."));
                            Thread.sleep(2000L);
                            for (int detectedCnt = 0; detectedCnt < 30; ++detectedCnt) {
                                Thread.sleep(1000L);
                                if (ipmiChassisCommand.isPowerOn()) continue;
                                isPowerOff = true;
                                break block10;
                            }
                            break block10;
                        }
                        isPowerOff = false;
                        break block10;
                    }
                    isPowerOff = true;
                }
                catch (IPMIException | InterruptedException | InvocationTargetException e) {
                    isPowerOff = false;
                }
            }
            sessionController.closeSession();
        }
        try {
            if (isPowerOff) {
                SwingUtilities.invokeAndWait(() -> this.listenser.updateMessage("System power status: off"));
            } else {
                SwingUtilities.invokeAndWait(() -> this.listenser.updateMessage("Can not shut down this system"));
            }
            Thread.sleep(2000L);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.listenser.updateMessage(e.getMessage());
        }
        return isPowerOff;
    }
}

