/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ByteUtility;
import IPMIView20.ExampleFileFilter;
import IPMIView20.FlashFirmware_jOpenButton_actionAdapter;
import IPMIView20.FlashFirmware_jStartButton_actionAdapter;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FlashFirmware
extends JDialog {
    String ip;
    String username;
    String password;
    boolean isFlashing = false;
    static JFileChooser openFileChooser;
    byte lanType = (byte)99;
    byte lanDrvier = 0;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    JLabel jLabel1 = new JLabel();
    JTextField jFirmwareFileTextField = new JTextField();
    JButton jOpenButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JProgressBar jProgressBar = new JProgressBar();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JLabel jStatusLabel = new JLabel();
    JPanel jPanel3 = new JPanel();
    JButton jStartButton = new JButton();
    JPanel jPanel5 = new JPanel();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    JLabel jLabel3 = new JLabel();
    JTextArea jTextArea = new JTextArea();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel4 = new JPanel();
    VerticalFlowLayout verticalFlowLayout3 = new VerticalFlowLayout();
    JLabel jLabel2 = new JLabel();
    public JPanel jCenterPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JTextField jIDTextField = new JTextField();
    JPanel jPanel6 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();

    public FlashFirmware(String ip) {
        super((Frame)IPMIView20.getInstance(), true);
        this.ip = ip;
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() {
        this.jProgressBar.setVisible(false);
        this.jStatusLabel.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.titledBorder2 = new TitledBorder("");
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setBorder(null);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jLabel1.setText(L.t("flash.Firmware_File") + ": ");
        this.jOpenButton.setText(L.t("flash.Open"));
        this.jOpenButton.addActionListener(new FlashFirmware_jOpenButton_actionAdapter(this));
        this.jPanel2.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jProgressBar.setMinimumSize(new Dimension(10, 20));
        this.jProgressBar.setPreferredSize(new Dimension(80, 20));
        this.jProgressBar.setToolTipText("");
        this.jStatusLabel.setText(L.t("flash.Status"));
        this.jStartButton.setHorizontalAlignment(11);
        this.jStartButton.setText(L.t("flash.Start"));
        this.jStartButton.addActionListener(new FlashFirmware_jStartButton_actionAdapter(this));
        this.jFirmwareFileTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.jFirmwareFileTextField.setToolTipText("");
        this.jFirmwareFileTextField.setEditable(false);
        this.jPanel3.setLayout((LayoutManager)this.verticalFlowLayout2);
        this.jLabel3.setText(L.t("flash.Message") + ":");
        this.jTextArea.setBorder(null);
        this.jTextArea.setMinimumSize(new Dimension(62, 120));
        this.jTextArea.setEditable(false);
        this.jPanel4.setLayout((LayoutManager)this.verticalFlowLayout3);
        this.jLabel2.setFont(new Font(IPMIView20.IPMI_DEFAULT_FONT, 1, 18));
        this.jLabel2.setForeground(Color.blue);
        this.jLabel2.setToolTipText("");
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(L.t("flash.IP") + ": " + this.ip);
        this.setTitle(L.t("flash.Update_Firmware"));
        this.jCenterPanel.setLayout(this.borderLayout3);
        this.jCenterPanel.setBorder(this.titledBorder2);
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jPanel6.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.jPanel4.add(this.jPanel6);
        this.jPanel6.add(this.jStartButton);
        this.jPanel6.add(this.jOpenButton);
        this.jScrollPane1.getViewport().add(this.jTextArea);
        this.jPanel1.add((Component)this.jLabel1, "West");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jFirmwareFileTextField, null);
        this.jPanel1.add((Component)this.jPanel5, "East");
        this.jPanel2.add(this.jStatusLabel);
        this.jPanel2.add((Component)this.jProgressBar, null);
        this.jPanel2.add(this.jLabel3);
        this.jPanel4.add(this.jLabel2);
        this.jPanel4.add(this.jPanel1);
        this.jPanel4.add(this.jPanel2);
        this.jCenterPanel.add((Component)this.jPanel4, "North");
        this.jCenterPanel.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jCenterPanel, "Center");
        this.setSize(436, 360);
    }

    public void jOpenButton_actionPerformed(ActionEvent e) {
        int returnVal;
        if (openFileChooser == null) {
            openFileChooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("bin");
            filter.setDescription("Firmware file");
            openFileChooser.setFileFilter(filter);
        }
        if ((returnVal = openFileChooser.showOpenDialog(this)) == 0) {
            this.jFirmwareFileTextField.setText(openFileChooser.getSelectedFile().getPath());
        }
    }

    public void noShowIP() {
        this.jLabel2.setText("");
    }

    public void setFlash() {
        this.jOpenButton.setEnabled(false);
        this.jStartButton.setEnabled(false);
        this.isFlashing = true;
    }

    public void resetFlash() {
        this.jOpenButton.setEnabled(true);
        this.jStartButton.setEnabled(true);
        this.isFlashing = false;
    }

    public void jStartButton_actionPerformed(ActionEvent e) {
        String firmwareVerisonFromFile;
        String firmwareVerisonFromBMC;
        if (this.jFirmwareFileTextField.getText() == null || this.jFirmwareFileTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("flash.Please_select_firmware"));
            return;
        }
        try {
            if (!IPMIRaritanOEMCommand.checkFirmwareFile(this.jFirmwareFileTextField.getText())) {
                JOptionPane.showMessageDialog(this, L.t("flash.Firmware_format_error"));
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString());
            return;
        }
        int result = this.showIDAndPWDialog();
        if (result != 0) {
            return;
        }
        try {
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp(this.ip);
            config.setUserName(this.username);
            config.setPassword(this.password);
            config.setRetry(0);
            config.setTimeout(3);
            config.setPrivilege((byte)4);
            ISessionController sessionController = IPMIVersion.getSessionController(config);
            if (sessionController == null) {
                JOptionPane.showMessageDialog(this, L.t("flash.Login_failed"));
                return;
            }
            IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
            IPMINetworkInterface rmcp = sessionController.startup(config);
            if (rmcp == null) {
                JOptionPane.showMessageDialog(this, L.t("flash.Login_failed"));
                return;
            }
            ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
            firmwareVerisonFromBMC = ipmiRaritanOEMCommand.getFirmwareVersionFromIPMI();
            firmwareVerisonFromFile = IPMIRaritanOEMCommand.getFirmwareVersionFromFile(this.jFirmwareFileTextField.getText());
            sessionController.closeSession();
            if (firmwareVerisonFromBMC == null) {
                throw new Exception(L.t("flash.Can_not_get_firmware_version_from_BMC_This_device_do_not_support_firmware_update"));
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            JOptionPane.showMessageDialog(this, ex1.getMessage(), L.t("flash.Error"), 0);
            return;
        }
        String info = L.t("flash.Current_firmware") + ":\n" + firmwareVerisonFromBMC + "\n\n" + L.t("flash.New_firmware") + ":\n" + firmwareVerisonFromFile + "\n\n" + L.t("flash.Would_you_like_to_continue");
        result = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), info, L.t("flash.Request_Confirmation"), 0);
        if (result != 0) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                boolean isDone = false;
                int retry = 0;
                do {
                    try {
                        FlashFirmware.this.flashFirmware(FlashFirmware.this.jFirmwareFileTextField.getText());
                        isDone = true;
                    }
                    catch (Exception ex1) {
                        FlashFirmware.this.resetFlash();
                        if (retry++ < 10) continue;
                        JOptionPane.showMessageDialog(FlashFirmware.this.getThis(), L.t("flash.Exception_occurd_please_retry_again") + "\n" + ex1.toString(), "Error", 0);
                        return;
                    }
                } while (!isDone);
            }
        };
        thread.start();
    }

    public JDialog getThis() {
        return this;
    }

    public void flashFirmware(String filename) throws Exception {
        byte[] data;
        File firmware = new File(filename);
        int chunkSize = 0;
        byte[] reservationID = new byte[2];
        int totalRead = 0;
        int readCount = 0;
        this.setFlash();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.username);
        config.setPassword(this.password);
        config.setRetry(0);
        config.setTimeout(3);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            JOptionPane.showMessageDialog(this, L.t("flash.Cannot_connect_to_BMC"));
            this.resetFlash();
            return;
        }
        this.jTextArea.setText("");
        this.jTextArea.append(L.t("flash.Login_to") + " " + this.ip + "\n");
        ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
        ipmiOEMCommand.setIPMIInterface(rmcp);
        ipmiGlobalCommand.setIPMIInterface(rmcp);
        this.jStatusLabel.setText(L.t("flash.Start_firmware_upgarde"));
        long fileSize = firmware.length();
        IPMIMessage ipmiMessage = ipmiRaritanOEMCommand.startFirmwareUpgradeCommand((int)fileSize);
        if (ipmiMessage.completionCode != 0) {
            ipmiRaritanOEMCommand.cancelFirmwareUpgradeCommand(reservationID);
            this.resetFlash();
            throw new Exception(L.t("flash.Calling_start_firmware_upgrade_error"));
        }
        reservationID[0] = ipmiMessage.data[0];
        reservationID[1] = ipmiMessage.data[1];
        byte[] bytes = new byte[4];
        System.arraycopy(ipmiMessage.data, 2, bytes, 0, 4);
        chunkSize = (int)com.supermicro.ipmi.ByteUtility.fourBytesToLongByLSBFirst(bytes);
        chunkSize = 900;
        byte[] chunk = new byte[chunkSize];
        this.jTextArea.append(L.t("flash.Start_firmware_upgarde_slash_n"));
        byte[] productID = ipmiOEMCommand.getProductID();
        if (productID == null) {
            ipmiRaritanOEMCommand.cancelFirmwareUpgradeCommand(reservationID);
            this.resetFlash();
            throw new Exception(L.t("flash.Get_product_ID_failed"));
        }
        if (productID[0] == 19 && productID[1] == 17) {
            this.jTextArea.append(L.t("flash.Set_chunk_size_to_80_The_upload_will_take_long_time"));
            chunkSize = 80;
            chunk = new byte[chunkSize];
        }
        if ((data = ipmiOEMCommand.getSIMxxLanDriver()) != null) {
            this.lanType = data[0];
            this.lanDrvier = data[1];
            if (this.lanType == 1 && this.lanDrvier == 5) {
                this.jTextArea.append(L.t("flash.Set_chunk_size_to_80_The_upload_will_take_long_time"));
                chunkSize = 80;
                chunk = new byte[chunkSize];
            }
        }
        this.jStatusLabel.setText(L.t("flash.Uploading_firmware"));
        this.jStatusLabel.setVisible(true);
        this.jProgressBar.setVisible(true);
        this.jProgressBar.setValue(0);
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        this.jTextArea.append(L.t("flash.Uploading_firmware_dot"));
        long imageSize = firmware.length();
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            ipmiMessage = ipmiRaritanOEMCommand.uploadFirmwareCommand(reservationID, currentChunk, chunk);
            if (ipmiMessage.completionCode != 0) {
                ipmiRaritanOEMCommand.cancelFirmwareUpgradeCommand(reservationID);
                this.resetFlash();
                throw new Exception(L.t("flash.Upload_firmware_error_location") + " : " + totalRead + " (" + ByteUtility.byteToHex(ipmiMessage.completionCode) + "h)");
            }
            this.jProgressBar.setValue(imageSize != 0L ? (int)((long)((totalRead += readCount) * 100) / imageSize) : 0);
            this.jStatusLabel.setText(L.t("flash.Uploading_firmware ...") + " ( " + totalRead + " bytes, " + (imageSize != 0L ? (long)(totalRead * 100) / imageSize : 0L) + "% )");
        }
        this.jTextArea.append(L.t("flash.Done") + " \n");
        this.jStatusLabel.setText(L.t("flash.Upload_firmware_completed"));
        raf.close();
        byte flashFlag = 0;
        ipmiMessage = ipmiRaritanOEMCommand.flashFirmwareCommand(reservationID, flashFlag);
        if (ipmiMessage.completionCode != 0) {
            String errorMessage = "";
            switch (ipmiMessage.completionCode) {
                case -128: {
                    errorMessage = L.t("flash.upload_incomplete");
                    break;
                }
                case -127: {
                    errorMessage = L.t("flash.bad_CRC");
                    break;
                }
                case -126: {
                    errorMessage = L.t("flash.firmware_invalid");
                    break;
                }
                case -125: {
                    errorMessage = L.t("flash.upgrade_failed");
                }
            }
            ipmiRaritanOEMCommand.cancelFirmwareUpgradeCommand(reservationID);
            this.resetFlash();
            throw new Exception(errorMessage);
        }
        this.jTextArea.append(L.t("flash.BMC_is_flashing_firmware_now_please_wait_for_1_minute"));
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        ipmiGlobalCommand.getDeviceIDCommand();
        Thread.currentThread();
        Thread.sleep(10000L);
        this.jTextArea.append(L.t("flash.Done") + " \n");
        IPMIMessage resMessage = null;
        resMessage = ipmiGlobalCommand.getDeviceIDCommand();
        if (resMessage == null) {
            int count = 0;
            do {
                sessionController = IPMIVersion.getSessionController(config);
                System.out.println("retry ping BMC [In flash step]");
                Thread.currentThread();
                Thread.sleep(5000L);
            } while (count++ != 10 && sessionController == null);
            if (sessionController != null) {
                rmcp = sessionController.startup(config);
                if (rmcp != null) {
                    System.out.println("reconnect successful for sending flash finalize command");
                    ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
                } else {
                    throw new Exception(L.t("flash.upgrade_failed"));
                }
            }
        }
        this.jStatusLabel.setText(L.t("flash.Checking_FW_update_status_and_reboot_device"));
        this.jTextArea.append(L.t("flash.Checking_FW_update_status_and_reboot_device"));
        ipmiMessage = ipmiRaritanOEMCommand.finalizeFirmwareUpgradeCommand(reservationID);
        if (ipmiMessage != null) {
            switch (ipmiMessage.completionCode) {
                case 0: {
                    this.jStatusLabel.setText(L.t("flash.Done"));
                    this.jTextArea.append(L.t("flash.Done") + " \n");
                    this.jTextArea.append(L.t("flash.Update_firmware_completed") + "\n");
                    JOptionPane.showMessageDialog(this, L.t("flash.Update_firmware_completed") + ". \n " + L.t("flash.Please_close_this_dialog_and_try_to_connect_this_system_after_2_minutes"));
                    break;
                }
                case -128: {
                    this.jStatusLabel.setText(L.t("flash.FW_flash_failed"));
                    this.jTextArea.append(L.t("flash.FW_flash_failed") + " \n");
                }
            }
        } else {
            this.jStatusLabel.setText(L.t("flash.FW_flash_failed"));
            this.jTextArea.append(L.t("flash.FW_flash_failed") + " \n");
        }
        this.resetFlash();
    }

    public int showIDAndPWDialog() {
        Object[] message = new Object[3];
        String id = L.t("flash.Login_ID");
        JPasswordField jPasswordTextField = new JPasswordField();
        String password = L.t("flash.Password");
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        p1.add(new JLabel(id));
        p1.add(this.jIDTextField);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        p2.add(new JLabel(password));
        p2.add(jPasswordTextField);
        JLabel l3 = new JLabel("* " + L.t("main.Administrator_level_is_required"));
        message[0] = p1;
        message[1] = p2;
        message[2] = l3;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FlashFirmware.this.jIDTextField.requestFocus();
            }
        };
        Thread th = new Thread(r);
        th.start();
        int result = JOptionPane.showOptionDialog(IPMIView20.getInstance(), message, L.t("flash.Please_input_ID_and_Password"), 2, 3, null, null, null);
        if (result == 0) {
            this.username = this.jIDTextField.getText();
            this.password = new String(jPasswordTextField.getPassword());
        }
        return result;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.isFlashing) {
                int result = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("flash.The_firmware_is_updating_now_Are_you_sure_to_quit"), L.t("flash.Request_Confirmation"), 0);
                if (result == 1) {
                    return;
                }
                this.dispose();
            } else {
                this.dispose();
            }
        }
        super.processWindowEvent(e);
    }

    @Override
    public void setVisible(boolean isEnable) {
        super.setVisible(isEnable);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (FlashFirmware.this.isVisible()) {
                    FlashFirmware.this.setVisible(false);
                }
            }
        };
        thread.start();
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }
}

