/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ExampleFileFilter;
import IPMIView20.FlashFirmwareAMIX9_jBrowseButton_actionAdapter;
import IPMIView20.FlashFirmwareAMIX9_jCheckFWVerButton_actionAdapter;
import IPMIView20.FlashFirmwareAMIX9_jFlashButton_actionAdapter;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import com.supermicro.ipmi.IPMIAMIYAFUCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class FlashFirmwareAMIX9
extends JDialog
implements IPMIAMIYAFUCommand.Progress {
    int minorVersion = 0;
    String ip;
    String username;
    String password;
    boolean isFlashing = false;
    static JFileChooser openFileChooser;
    IPMIAMIYAFUCommand.FirmwareFile firmwareFile;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel4 = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    JCheckBox jPreserveBootLoaderCheckBox = new JCheckBox();
    JCheckBox jPreserveConfigCheckBox = new JCheckBox();
    GridLayout gridLayout1 = new GridLayout();
    JCheckBox jPreserveBootVariableCheckBox = new JCheckBox();
    JLabel jIPStringLabel = new JLabel();
    JLabel jFileStringLabel = new JLabel();
    JTextField jFileTextField = new JTextField();
    JButton jBrowseButton = new JButton();
    JTextField jIPTextField = new JTextField();
    JProgressBar jProgressBar1 = new JProgressBar();
    JLabel jStatusStringLabel = new JLabel();
    JLabel jStatusLabel = new JLabel();
    JLabel jLabel5 = new JLabel();
    TitledBorder titledBorder2 = new TitledBorder("");
    JLabel jVerLabel = new JLabel();
    JButton jFlashButton = new JButton();
    TitledBorder titledBorder3 = new TitledBorder("");
    TitledBorder titledBorder4 = new TitledBorder("");
    JLabel jFileStatusLabel = new JLabel();
    JLabel jFirmwareStatusLabel = new JLabel();
    JButton jCheckFWVerButton = new JButton();
    JTextField jIDTextField = new JTextField();
    JTextField jPasswordTextField = new JPasswordField();
    int progressValue;
    String statusMessage;
    JLabel jTimeLeftLabel = new JLabel();

    public FlashFirmwareAMIX9(String ip) {
        super((Frame)IPMIView20.getInstance(), true);
        try {
            JLabel jFileStatusLabel = new JLabel();
            JLabel jFirmwareStatusLabel = new JLabel();
            JButton jCheckFWVerButton = new JButton();
            this.ip = ip;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.setResizable(false);
        this.jIPTextField.setText(this.ip);
        Dimension d = new Dimension(380, 296);
        this.setSize(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.jPreserveBootVariableCheckBox.setVisible(false);
        this.jVerLabel.setText(IPMIAMIYAFUCommand.YAFU_FLASH_VERSION + "." + this.minorVersion);
        this.jProgressBar1.setEnabled(false);
        this.jStatusStringLabel.setEnabled(false);
        this.jPanel4.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setTitle("YAFUFlash");
        this.titledBorder1 = new TitledBorder("Options");
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(null);
        this.jPanel4.setBorder(this.titledBorder1);
        this.jPanel4.setBounds(new Rectangle(324, 44, 161, 111));
        this.jPanel4.setLayout(this.gridLayout1);
        this.jPreserveBootLoaderCheckBox.setText("Preserve BootLoader");
        this.jPreserveConfigCheckBox.setText("Preserve Config Module");
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.jPreserveBootVariableCheckBox.setSelected(true);
        this.jPreserveBootVariableCheckBox.setText("Preserve Boot variable");
        this.jIPStringLabel.setText("IP:");
        this.jIPStringLabel.setBounds(new Rectangle(30, 49, 35, 15));
        this.jFileStringLabel.setText("File:");
        this.jFileStringLabel.setBounds(new Rectangle(29, 84, 35, 15));
        this.jFileTextField.setEditable(false);
        this.jFileTextField.setBounds(new Rectangle(63, 80, 160, 22));
        this.jBrowseButton.setBounds(new Rectangle(235, 79, 78, 23));
        this.jBrowseButton.setText("Browse...");
        this.jBrowseButton.addActionListener(new FlashFirmwareAMIX9_jBrowseButton_actionAdapter(this));
        this.jIPTextField.setEditable(false);
        this.jIPTextField.setBounds(new Rectangle(63, 49, 160, 22));
        this.jProgressBar1.setBounds(new Rectangle(30, 186, 314, 20));
        this.jStatusStringLabel.setText("Status:");
        this.jStatusStringLabel.setBounds(new Rectangle(30, 160, 35, 15));
        this.jStatusLabel.setBounds(new Rectangle(65, 160, 418, 15));
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(null);
        this.jPanel1.setBounds(new Rectangle(1, 0, 388, 32));
        this.jPanel1.setLayout(null);
        this.jLabel5.setFont(new Font("Arial", 1, 12));
        this.jLabel5.setText("Remote Flash Tool for Renesas /AMI FW");
        this.jLabel5.setBounds(new Rectangle(8, 7, 248, 19));
        this.jVerLabel.setText("V1.0");
        this.jVerLabel.setBounds(new Rectangle(285, 9, 43, 15));
        this.jFlashButton.setBounds(new Rectangle(265, 215, 79, 23));
        this.jFlashButton.setEnabled(false);
        this.jFlashButton.setText("Flash");
        this.jFlashButton.addActionListener(new FlashFirmwareAMIX9_jFlashButton_actionAdapter(this));
        this.jPanel2.setBorder(this.titledBorder3);
        this.jFileStatusLabel.setForeground(Color.blue);
        this.jFileStatusLabel.setBounds(new Rectangle(29, 108, 277, 18));
        this.jFirmwareStatusLabel.setForeground(Color.blue);
        this.jFirmwareStatusLabel.setBounds(new Rectangle(29, 134, 194, 15));
        this.jCheckFWVerButton.setBounds(new Rectangle(235, 127, 78, 23));
        this.jCheckFWVerButton.setMargin(new Insets(2, 2, 2, 2));
        this.jCheckFWVerButton.setText("FW Version");
        this.jCheckFWVerButton.addActionListener(new FlashFirmwareAMIX9_jCheckFWVerButton_actionAdapter(this));
        this.jTimeLeftLabel.setForeground(Color.blue);
        this.jTimeLeftLabel.setBounds(new Rectangle(30, 213, 318, 15));
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add(this.jIPStringLabel);
        this.jPanel2.add(this.jPanel4);
        this.jPanel4.add(this.jPreserveBootLoaderCheckBox);
        this.jPanel4.add(this.jPreserveConfigCheckBox);
        this.jPanel4.add(this.jPreserveBootVariableCheckBox);
        this.jPanel2.add(this.jIPTextField);
        this.jPanel2.add(this.jFileStringLabel);
        this.jPanel2.add(this.jFileTextField);
        this.jPanel2.add(this.jPanel1);
        this.jPanel1.add(this.jLabel5);
        this.jPanel1.add(this.jVerLabel);
        this.jPanel2.add(this.jStatusLabel);
        this.jPanel2.add(this.jStatusStringLabel);
        this.jPanel2.add(this.jProgressBar1);
        this.jPanel2.add(this.jBrowseButton);
        this.jPanel2.add(this.jFileStatusLabel);
        this.jPanel2.add(this.jFirmwareStatusLabel);
        this.jPanel2.add(this.jCheckFWVerButton);
        this.jPanel2.add(this.jTimeLeftLabel);
        this.jPanel2.add(this.jFlashButton);
    }

    public int showIDAndPWDialog() {
        Object[] message = new Object[3];
        String id = L.t("flash.Login_ID");
        JPasswordField jPasswordTextField = new JPasswordField();
        String password = L.t("flash.Password");
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        p1.add(new JLabel(id));
        p1.add(this.jIDTextField);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        p2.add(new JLabel(password));
        p2.add(jPasswordTextField);
        JLabel l3 = new JLabel("* " + L.t("main.Administrator_level_is_required"));
        message[0] = p1;
        message[1] = p2;
        message[2] = l3;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FlashFirmwareAMIX9.this.jIDTextField.requestFocus();
            }
        };
        Thread th = new Thread(r);
        th.start();
        int result = JOptionPane.showOptionDialog(this, message, L.t("flash.Please_input_ID_and_Password"), 2, 3, null, null, null);
        if (result == 0) {
            this.username = this.jIDTextField.getText();
            this.password = new String(jPasswordTextField.getPassword());
        }
        return result;
    }

    public void jBrowseButton_actionPerformed(ActionEvent e) {
        int returnVal;
        if (openFileChooser == null) {
            openFileChooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("ima");
            filter.setDescription("Firmware file");
            openFileChooser.setFileFilter(filter);
        }
        if ((returnVal = openFileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        this.jFileTextField.setText(openFileChooser.getSelectedFile().getPath());
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FlashFirmwareAMIX9.this.getThis().setCursor(new Cursor(3));
                IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
                try {
                    FlashFirmwareAMIX9.this.jFileStatusLabel.setText("Analysing firmware file ... ");
                    FlashFirmwareAMIX9.this.firmwareFile = ipmiAMIYAFUCommand.createFirmwareFile(openFileChooser.getSelectedFile().getPath());
                    IPMIAMIYAFUCommand.FMHInfo fmhInfo = FlashFirmwareAMIX9.this.firmwareFile.getRainerFMH();
                    if (fmhInfo != null) {
                        String ver = FlashFirmwareAMIX9.this.firmwareFile.getFirmwareVersionString();
                        if (ver == null) {
                            ver = "" + fmhInfo.moduleVersion[0] + "." + fmhInfo.moduleVersion[1];
                        }
                        FlashFirmwareAMIX9.this.jFileStatusLabel.setText("New firmware version : " + ver);
                        FlashFirmwareAMIX9.this.jFlashButton.setEnabled(true);
                    } else {
                        FlashFirmwareAMIX9.this.jFileStatusLabel.setText("Invalid file");
                        FlashFirmwareAMIX9.this.jFlashButton.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    FlashFirmwareAMIX9.this.jFileStatusLabel.setText("Invalid file");
                    FlashFirmwareAMIX9.this.jFlashButton.setEnabled(false);
                }
                finally {
                    FlashFirmwareAMIX9.this.getThis().setCursor(new Cursor(0));
                }
            }
        };
        thread.start();
    }

    public void jFlashButton_actionPerformed(ActionEvent e) {
        int result;
        if (this.jFlashButton.getText().equalsIgnoreCase("Finish")) {
            this.dispose();
            return;
        }
        if (this.jFileTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("flash.Please_select_firmware"));
            return;
        }
        if ((this.username == null || this.password == null) && (result = this.showIDAndPWDialog()) != 0) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                FlashFirmwareAMIX9.this.jProgressBar1.setEnabled(true);
                FlashFirmwareAMIX9.this.jStatusStringLabel.setEnabled(true);
                FlashFirmwareAMIX9.this.jFlashButton.setEnabled(false);
                FlashFirmwareAMIX9.this.jBrowseButton.setEnabled(false);
                FlashFirmwareAMIX9.this.jCheckFWVerButton.setEnabled(false);
                FlashFirmwareAMIX9.this.jPreserveBootLoaderCheckBox.setEnabled(false);
                FlashFirmwareAMIX9.this.jPreserveConfigCheckBox.setEnabled(false);
                FlashFirmwareAMIX9.this.isFlashing = true;
                int retry = 0;
                boolean isDone = false;
                do {
                    try {
                        FlashFirmwareAMIX9.this.doFlash();
                        isDone = true;
                    }
                    catch (Exception ex) {
                        if (++retry <= 2) continue;
                        int retVal = JOptionPane.showConfirmDialog(FlashFirmwareAMIX9.this.getThis(), ex.getMessage() + "\nFlash Failed. Would you like to retry ?", "Failed", 0);
                        if (retVal == 0) {
                            FlashFirmwareAMIX9.this.jProgressBar1.setValue(0);
                            FlashFirmwareAMIX9.this.jStatusLabel.setText("");
                            FlashFirmwareAMIX9.this.jTimeLeftLabel.setText("");
                            continue;
                        }
                        if (retVal != 1) continue;
                        isDone = true;
                    }
                } while (!isDone);
                FlashFirmwareAMIX9.this.jFlashButton.setEnabled(true);
                FlashFirmwareAMIX9.this.jBrowseButton.setEnabled(false);
                FlashFirmwareAMIX9.this.jCheckFWVerButton.setEnabled(false);
                FlashFirmwareAMIX9.this.jFlashButton.setText("Finish");
                FlashFirmwareAMIX9.this.isFlashing = false;
            }
        };
        thread.start();
    }

    private void oneMinuteCheck() {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(FlashFirmwareAMIX9.this.ip);
                    if (guid != null) {
                        FlashFirmwareAMIX9.this.jStatusLabel.setText("Finished. Device ready ( version: " + FlashFirmwareAMIX9.this.getCurrentFWVersion() + " )");
                        FlashFirmwareAMIX9.this.jCheckFWVerButton.setEnabled(true);
                        FlashFirmwareAMIX9.this.jFirmwareStatusLabel.setForeground(Color.GRAY);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(FlashFirmwareAMIX9.this.getThis(), "Error " + ex.toString());
                }
            }
        }, 180000L);
    }

    private String getCurrentFWVersion() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.username);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ipmiAMIYAFUCommand.setProgress(this);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            throw new Exception("Connect failed");
        }
        IPMIAMIYAFUCommand.FirmwareInfo firmwareInfo = ipmiAMIYAFUCommand.getFirmwareInfo();
        return "" + firmwareInfo.getVersionString();
    }

    private void doFlash() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.username);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        config.setTimeout(15);
        config.setRetry(10);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ipmiAMIYAFUCommand.setProgress(this);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            throw new Exception("Connect failed");
        }
        IPMIAMIYAFUCommand.FirmwareInfo firmwareInfo = ipmiAMIYAFUCommand.getFirmwareInfo();
        this.jFirmwareStatusLabel.setForeground(Color.BLUE);
        this.jFirmwareStatusLabel.setText("Current firmware version: " + firmwareInfo.getVersionString());
        ipmiAMIYAFUCommand.setPreLoadFirmwareFile(this.firmwareFile);
        ipmiAMIYAFUCommand.flashFlow90(this.jFileTextField.getText(), true);
    }

    public void jCheckFWVerButton_actionPerformed(ActionEvent e) {
        int result;
        if ((this.username == null || this.password == null) && (result = this.showIDAndPWDialog()) != 0) {
            return;
        }
        this.jFirmwareStatusLabel.setForeground(Color.BLUE);
        this.jFirmwareStatusLabel.setText("Getting FW version ...");
        try {
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp(this.ip);
            config.setUserName(this.username);
            config.setPassword(this.password);
            config.setPrivilege((byte)4);
            IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
            ipmiAMIYAFUCommand.setProgress(this);
            ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
            if (sessionController == null) {
                throw new Exception("Connect failed");
            }
            IPMIAMIYAFUCommand.FirmwareInfo firmwareInfo = ipmiAMIYAFUCommand.getFirmwareInfo();
            this.jFirmwareStatusLabel.setForeground(Color.BLUE);
            this.jFirmwareStatusLabel.setText("Current firmware version: " + firmwareInfo.getVersionString());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error " + ex.toString());
        }
    }

    @Override
    public void setValue(int value) {
        this.progressValue = value;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlashFirmwareAMIX9.this.jProgressBar1.setValue(FlashFirmwareAMIX9.this.progressValue);
            }
        });
    }

    @Override
    public void message(String message) {
        this.statusMessage = message;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlashFirmwareAMIX9.this.jStatusLabel.setText(FlashFirmwareAMIX9.this.statusMessage);
            }
        });
    }

    @Override
    public void left(long diffMillis) {
        if (diffMillis == 0L) {
            this.jTimeLeftLabel.setText("");
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.jTimeLeftLabel.setText("Remaining Time: " + leftMins + " min(s) " + leftSecs + " sec(s)");
    }

    public FlashFirmwareAMIX9 getThis() {
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isIsFlashing() {
        return this.isFlashing;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIsFlashing(boolean isFlashing) {
        this.isFlashing = isFlashing;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.isFlashing) {
                int result = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), "The firmware is updating now. Are you sure to quit ? ( If quit, it may damage your FW! )", L.t("flash.Request_Confirmation"), 0);
                if (result == 1) {
                    return;
                }
                this.dispose();
            } else {
                this.dispose();
            }
        }
        super.processWindowEvent(e);
    }

    @Override
    public void setVisible(boolean isEnable) {
        super.setVisible(isEnable);
        if (this.isVisible()) {
            super.setVisible(false);
        }
    }
}

