/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.FlashRedFishInterface;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.redfish.RedfishFlash;
import java.io.File;

public abstract class FlashRedFishBaseControl
implements IPMIDCMOEMCommand.Progress {
    static final int RETRY_LINK_UP = -1;
    static final int RETRY_LINK_DOWN = 60;
    protected String loginIP;
    protected String loginID;
    protected String loginPWD;
    protected String imageFile;
    protected String requestBody;
    protected IPMIInterfaceConfig interfaceConfig;
    protected FlashRedFishInterface listenser;
    protected RedfishFlash redfishFlash;

    public FlashRedFishBaseControl(FlashRedFishInterface redfishInterface) {
        this.listenser = redfishInterface;
        this.init();
    }

    public void setLoginIP(String ip) {
        this.loginIP = ip;
    }

    public void setLoginUsername(String username) {
        this.loginID = username;
    }

    public void setLoginPassword(String password) {
        this.loginPWD = password;
    }

    public void setFirmwareFile(String file) {
        this.imageFile = file;
    }

    @Override
    public void setValue(int value) {
        this.listenser.updateProgress(value);
    }

    @Override
    public void message(String message) {
        this.listenser.updateMessage(message);
    }

    @Override
    public void left(long value) {
    }

    protected abstract String getTargetVersion(String var1, String var2, String var3);

    protected abstract String getImageVersion(String var1, String var2) throws Exception;

    protected abstract void setConfiguration(boolean var1, boolean var2, boolean var3, boolean var4);

    protected abstract void doFlashing();

    protected boolean checkConnectionRecovery(String ip, int msg, boolean checkLinkUp, boolean checkLinkDown) {
        boolean recovery = false;
        this.asyncNotifyMessage(msg);
        if (!(checkLinkDown && !this.checkConnectionState(false, ip, 60) || checkLinkUp && !this.checkConnectionState(true, ip, -1))) {
            recovery = true;
        }
        if (recovery) {
            this.listenser.updateMessage("Device is ready now.");
        } else {
            this.listenser.updateMessage("Device connection recover failed.");
        }
        return recovery;
    }

    protected boolean checkConnectionState(boolean checkLinkUp, String ip, int checkTimes) {
        int count = 0;
        boolean stateChanged = false;
        if (checkLinkUp) {
            this.listenser.updateMessage("Wait for Link up ...");
        } else {
            this.listenser.updateMessage("Wait for Link down ...");
        }
        do {
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
            if (!checkLinkUp && guid == null) {
                stateChanged = true;
                break;
            }
            if (checkLinkUp && guid != null) {
                stateChanged = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (count++ < checkTimes || checkTimes < 0);
        return stateChanged;
    }

    protected boolean checkLogin() {
        boolean isLogin = false;
        IPMINetworkInterface rmcp = null;
        ISessionController sessionController = null;
        if (this.checkStringNotEmpty(this.loginIP) && this.checkStringNotEmpty(this.loginID) && this.checkStringNotEmpty(this.loginPWD) && (sessionController = IPMIVersion.getSessionController(this.interfaceConfig)) != null && (rmcp = sessionController.startup(this.interfaceConfig)) != null) {
            isLogin = true;
        }
        if (sessionController != null) {
            sessionController.closeSession();
        }
        return isLogin;
    }

    protected boolean checkFileExists() {
        File tempFile;
        return this.checkStringNotEmpty(this.imageFile) && (tempFile = new File(this.imageFile)) != null && tempFile.exists();
    }

    protected boolean checkStringNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    private void init() {
        this.loginIP = null;
        this.loginID = null;
        this.loginPWD = null;
        this.imageFile = null;
        this.requestBody = null;
        this.interfaceConfig = new IPMIInterfaceConfig();
        this.redfishFlash = new RedfishFlash();
        this.redfishFlash.setProgress(this);
    }

    private void asyncNotifyMessage(int msg) {
        Runnable runnable = () -> this.listenser.updateState(msg);
        new Thread(runnable).start();
    }
}

