/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.FlashRedFishInterface;
import IPMIView20.L;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class FlashRedFishBaseView
extends JDialog
implements FlashRedFishInterface {
    protected JPanel optionsPanel;
    protected JPanel optionsFirstPanel;
    protected JPanel optionsSecondPanel;
    protected JPanel optionsThirdPanel;
    protected JPanel optionsFourPanel;
    protected JButton browserButton;
    protected JLabel currentLabel;
    protected JLabel newLabel;
    protected String filePath;
    protected String loginIP;
    protected String loginID;
    protected String loginPWD;
    private JPanel northPanel;
    private JPanel centerPanel;
    private JPanel southPanel;
    private JPanel infoPanel;
    private JPanel infoFirstPanel;
    private JPanel infoSecondPanel;
    private JPanel infoThirdPanel;
    private JPanel infoFourthPanel;
    private JPanel progressPanel;
    private JLabel titleLabel;
    private JLabel versionLabel;
    private JLabel ipLabel;
    private JLabel ipValueLabel;
    private JLabel currentValueLabel;
    private JLabel newValueLabel;
    private JLabel fileLabel;
    private FadeLabel flashMessageLabel;
    private JButton queryVerButton;
    private JButton flashFwButton;
    private JButton cancelButton;
    private JTextField filePathEditText;
    private JTextField usernameTextField;
    private JPasswordField passwordTextField;
    private JProgressBar progressBar;
    private JFileChooser fileChooser;
    private Timer breatheTimer;
    private FutureTask<JFileChooser> futureFileChooser;
    private float alphaDirection;
    private boolean freezeComponents;

    public FlashRedFishBaseView() {
        this.init();
        this.initComponents();
    }

    protected void init() {
        this.fileChooser = null;
        this.filePath = null;
        this.loginIP = null;
        this.loginID = null;
        this.loginPWD = null;
        this.freezeComponents = false;
        this.alphaDirection = -0.025f;
        this.futureFileChooser = new FutureTask<JFileChooser>(JFileChooser::new);
        Executors.newSingleThreadExecutor().execute(this.futureFileChooser);
    }

    protected void initComponents() {
        this.newComponents();
        this.setComponetsMisc();
        this.setComponentsText();
        this.setComponentsSize();
        this.setComponentsLayout();
        this.setComponentsListenser();
    }

    protected void newComponents() {
        this.northPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.southPanel = new JPanel();
        this.infoPanel = new JPanel();
        this.infoFirstPanel = new JPanel();
        this.infoSecondPanel = new JPanel();
        this.infoThirdPanel = new JPanel();
        this.infoFourthPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.optionsFirstPanel = new JPanel();
        this.optionsSecondPanel = new JPanel();
        this.optionsThirdPanel = new JPanel();
        this.optionsFourPanel = new JPanel();
        this.progressPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.ipLabel = new JLabel();
        this.ipValueLabel = new JLabel();
        this.currentLabel = new JLabel();
        this.currentValueLabel = new JLabel();
        this.newLabel = new JLabel();
        this.newValueLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.flashMessageLabel = new FadeLabel();
        this.browserButton = new JButton();
        this.queryVerButton = new JButton();
        this.flashFwButton = new JButton();
        this.cancelButton = new JButton();
        this.filePathEditText = new JTextField();
        this.usernameTextField = new JTextField();
        this.passwordTextField = new JPasswordField();
        this.progressBar = new JProgressBar();
    }

    protected void setComponetsMisc() {
        this.queryVerButton.setIcon(new ImageIcon(this.getClass().getResource("/images/toolbar_discover.gif")));
        this.queryVerButton.setMargin(new Insets(0, 0, 0, 0));
        this.flashMessageLabel.setBorder(new EmptyBorder(5, 15, 0, 10));
        this.titleLabel.setForeground(Color.WHITE);
        this.versionLabel.setForeground(Color.WHITE);
        this.northPanel.setBackground(Color.DARK_GRAY);
        this.southPanel.setBackground(Color.LIGHT_GRAY);
        this.breatheTimer = new Timer(50, e -> {
            float alpha = this.flashMessageLabel.getAlpha();
            if ((alpha += this.alphaDirection) < 0.0f) {
                alpha = 0.0f;
                this.alphaDirection = 0.05f;
            } else if (alpha > 1.0f) {
                alpha = 0.999999f;
                this.alphaDirection = -0.05f;
            }
            this.flashMessageLabel.setAlpha(alpha);
        });
        this.breatheTimer.setRepeats(true);
        this.breatheTimer.setCoalesce(true);
    }

    protected void setComponentsText() {
        this.titleLabel.setText("Remote RedFish Flash Tool");
        this.versionLabel.setText("V2.0.1");
        this.cancelButton.setText("Cancel");
        this.flashFwButton.setText("Flash");
        this.browserButton.setText("Browse");
        this.ipLabel.setText("IP:");
        this.fileLabel.setText("File:");
        this.flashMessageLabel.setText("Ready");
        this.infoPanel.setBorder(new TitledBorder("Information"));
        this.optionsPanel.setBorder(new TitledBorder("Options"));
    }

    protected void setComponentsSize() {
        this.setMinimumSize(new Dimension(500, 450));
        this.northPanel.setMinimumSize(new Dimension(100, 30));
        this.northPanel.setPreferredSize(new Dimension(100, 30));
        this.southPanel.setMinimumSize(new Dimension(100, 40));
        this.southPanel.setPreferredSize(new Dimension(100, 40));
        this.cancelButton.setMaximumSize(new Dimension(70, 22));
        this.cancelButton.setPreferredSize(new Dimension(70, 22));
        this.flashFwButton.setMaximumSize(new Dimension(70, 22));
        this.flashFwButton.setPreferredSize(new Dimension(70, 22));
        this.browserButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.browserButton.setMaximumSize(new Dimension(70, 22));
        this.browserButton.setMinimumSize(new Dimension(70, 22));
        this.browserButton.setPreferredSize(new Dimension(70, 22));
        this.infoPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.infoPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 80));
        this.optionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.optionsPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 100));
        int infoSubPanelW = 400;
        int infoSubPanelH = 15;
        this.infoFirstPanel.setPreferredSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoFirstPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.infoFirstPanel.setMinimumSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoSecondPanel.setPreferredSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoSecondPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.infoSecondPanel.setMinimumSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoThirdPanel.setPreferredSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoThirdPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.infoThirdPanel.setMinimumSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoFourthPanel.setPreferredSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoFourthPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.infoFourthPanel.setMinimumSize(new Dimension(infoSubPanelW, infoSubPanelH));
        int infoSubPanelComW = 150;
        int infoSubPanelComH = 20;
        this.ipLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.ipLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.ipLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.ipValueLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.ipValueLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.ipValueLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentValueLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentValueLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentValueLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.newValueLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.newValueLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.newValueLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.newLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.newLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.newLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.fileLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.fileLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.fileLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.filePathEditText.setMaximumSize(new Dimension(Integer.MAX_VALUE, infoSubPanelComH));
        this.progressPanel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.progressPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 25));
        this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.progressBar.setPreferredSize(new Dimension(1280, 20));
    }

    protected void setComponentsLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.northPanel.setLayout(new BoxLayout(this.northPanel, 0));
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.southPanel.setLayout(new BoxLayout(this.southPanel, 0));
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoFirstPanel.setLayout(new BoxLayout(this.infoFirstPanel, 0));
        this.infoSecondPanel.setLayout(new BoxLayout(this.infoSecondPanel, 0));
        this.infoThirdPanel.setLayout(new BoxLayout(this.infoThirdPanel, 0));
        this.infoFourthPanel.setLayout(new BoxLayout(this.infoFourthPanel, 0));
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        this.optionsFirstPanel.setLayout(new BoxLayout(this.optionsFirstPanel, 0));
        this.optionsSecondPanel.setLayout(new BoxLayout(this.optionsSecondPanel, 0));
        this.optionsThirdPanel.setLayout(new BoxLayout(this.optionsThirdPanel, 0));
        this.optionsFourPanel.setLayout(new BoxLayout(this.optionsFourPanel, 0));
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 0));
        this.infoFirstPanel.add(Box.createHorizontalStrut(20));
        this.infoFirstPanel.add(this.ipLabel);
        this.infoFirstPanel.add(this.ipValueLabel);
        this.infoSecondPanel.add(Box.createHorizontalStrut(20));
        this.infoSecondPanel.add(this.currentLabel);
        this.infoSecondPanel.add(this.currentValueLabel);
        this.infoSecondPanel.add(Box.createHorizontalGlue());
        this.infoSecondPanel.add(this.queryVerButton);
        this.infoSecondPanel.add(Box.createHorizontalStrut(50));
        this.infoThirdPanel.add(Box.createHorizontalStrut(20));
        this.infoThirdPanel.add(this.newLabel);
        this.infoThirdPanel.add(this.newValueLabel);
        this.infoFourthPanel.add(Box.createHorizontalStrut(20));
        this.infoFourthPanel.add(this.fileLabel);
        this.infoFourthPanel.add(this.filePathEditText);
        this.infoFourthPanel.add(Box.createHorizontalStrut(10));
        this.infoFourthPanel.add(this.browserButton);
        this.infoFourthPanel.add(Box.createHorizontalStrut(10));
        this.infoPanel.add(this.infoFirstPanel);
        this.infoPanel.add(this.infoSecondPanel);
        this.infoPanel.add(this.infoThirdPanel);
        this.infoPanel.add(this.infoFourthPanel);
        this.progressPanel.add(Box.createHorizontalStrut(10));
        this.progressPanel.add(this.progressBar);
        this.progressPanel.add(Box.createHorizontalStrut(10));
        this.northPanel.add(Box.createHorizontalStrut(10));
        this.northPanel.add(this.titleLabel);
        this.northPanel.add(Box.createHorizontalGlue());
        this.northPanel.add(this.versionLabel);
        this.northPanel.add(Box.createHorizontalStrut(10));
        this.southPanel.add(Box.createHorizontalGlue());
        this.southPanel.add(this.flashFwButton);
        this.southPanel.add(Box.createHorizontalStrut(10));
        this.southPanel.add(this.cancelButton);
        this.southPanel.add(Box.createHorizontalStrut(20));
        this.centerPanel.add(Box.createVerticalStrut(10));
        this.centerPanel.add(this.infoPanel);
        this.centerPanel.add(Box.createVerticalStrut(10));
        this.centerPanel.add(this.optionsPanel);
        this.centerPanel.add(this.flashMessageLabel);
        this.centerPanel.add(this.progressPanel);
        this.optionsFirstPanel.add(Box.createHorizontalStrut(20));
        this.optionsSecondPanel.add(Box.createHorizontalStrut(20));
        this.optionsThirdPanel.add(Box.createHorizontalStrut(20));
        this.optionsFourPanel.add(Box.createHorizontalStrut(20));
        this.optionsPanel.add(this.optionsFirstPanel);
        this.optionsPanel.add(this.optionsSecondPanel);
        this.optionsPanel.add(this.optionsThirdPanel);
        this.optionsPanel.add(this.optionsFourPanel);
        this.getContentPane().add((Component)this.northPanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.infoFirstPanel.setAlignmentX(0.0f);
        this.infoSecondPanel.setAlignmentX(0.0f);
        this.infoThirdPanel.setAlignmentX(0.0f);
        this.infoFourthPanel.setAlignmentX(0.0f);
        this.optionsFirstPanel.setAlignmentX(0.0f);
        this.optionsSecondPanel.setAlignmentX(0.0f);
        this.optionsThirdPanel.setAlignmentX(0.0f);
        this.optionsFourPanel.setAlignmentX(0.0f);
        this.progressPanel.setAlignmentX(0.0f);
    }

    protected void setComponentsListenser() {
        this.queryVerButton.addActionListener(e -> this.queryVerButtonActionEvent(e));
        this.flashFwButton.addActionListener(e -> this.flashButtonActionEvent(e));
        this.cancelButton.addActionListener(e -> this.cancelButtonActionEvent(e));
    }

    protected void setEnableComponents(boolean enable, boolean enableFlash, boolean enableCancel) {
        this.browserButton.setEnabled(enable);
        this.queryVerButton.setEnabled(enable);
        this.flashFwButton.setEnabled(enableFlash);
        this.cancelButton.setEnabled(enableCancel);
        this.filePathEditText.setEnabled(enable);
        this.freezeComponents = !enable;
    }

    protected void broswerButtonActionEvent(ActionEvent e, boolean setDefaultType) {
        this.setCursor(new Cursor(3));
        if (this.fileChooser == null) {
            try {
                this.fileChooser = this.futureFileChooser.get();
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.resetChoosableFileFilters();
                this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("(*.bin or *.BIN)", "bin"));
                this.fileChooser.setFileFilter(this.fileChooser.getChoosableFileFilters()[setDefaultType ? 1 : 0]);
            }
            catch (InterruptedException | ExecutionException exc) {
                exc.printStackTrace();
            }
        }
        if (this.fileChooser != null) {
            this.filePath = this.fileChooser.showOpenDialog(null) == 0 ? this.fileChooser.getSelectedFile().getAbsolutePath() : "";
        }
        this.setCursor(new Cursor(0));
        this.resetFlashStatus();
        Runnable runnable = () -> {
            this.setCursor(new Cursor(3));
            try {
                if (this.loginIP != null && this.filePath != null && !this.loginIP.isEmpty() && !this.filePath.isEmpty()) {
                    this.setFlashStatus("Check file...");
                    String fwFileVer = this.getImageVersion(this.loginIP, this.filePath);
                    if (fwFileVer == null) {
                        this.filePath = null;
                        this.filePathEditText.setText("");
                        this.newValueLabel.setText("");
                    } else {
                        this.newValueLabel.setText(fwFileVer);
                        this.filePathEditText.setText(this.filePath);
                        this.setFlashStatus("Check file ... Done");
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.setCursor(new Cursor(0));
        };
        new Thread(runnable).start();
    }

    protected abstract String getImageVersion(String var1, String var2) throws Exception;

    protected abstract String getTargetVersion(String var1, String var2, String var3);

    protected abstract void flashButtonActionEvent(ActionEvent var1);

    protected void queryVerButtonActionEvent(ActionEvent e) {
        if (this.popupLoginDialog()) {
            this.setCursor(new Cursor(3));
            this.setFlashStatus("Login ...");
            String ver = this.getTargetVersion(this.loginIP, this.loginID, this.loginPWD);
            this.currentValueLabel.setText(ver);
            if (ver == null) {
                this.setFlashStatus("Login failed");
            } else {
                this.setFlashStatus("Login successfully");
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void cancelButtonActionEvent(ActionEvent e) {
        this.dispose();
    }

    private boolean popupLoginDialog() {
        Object[] message = new Object[3];
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        p1.add(new JLabel(L.t("flash.Login_ID")));
        p1.add(this.usernameTextField);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        p2.add(new JLabel(L.t("flash.Password")));
        p2.add(this.passwordTextField);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(1, 1));
        p3.setMinimumSize(new Dimension(150, 30));
        p3.setPreferredSize(new Dimension(150, 30));
        p3.add(new JLabel("* " + L.t("main.Administrator_level_is_required")));
        message[0] = p1;
        message[1] = p2;
        message[2] = p3;
        JOptionPane pane = new JOptionPane(message, 3, 2){

            @Override
            public void selectInitialValue() {
                FlashRedFishBaseView.this.usernameTextField.requestFocusInWindow();
            }
        };
        JDialog dialog = pane.createDialog(null, L.t("flash.Please_input_ID_and_Password"));
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue != null && (Integer)selectedValue == 0) {
            this.loginID = this.usernameTextField == null ? null : this.usernameTextField.getText();
            this.loginPWD = new String(this.passwordTextField.getPassword());
            return true;
        }
        this.loginID = null;
        this.loginPWD = null;
        return false;
    }

    private void setEnableComponents(boolean enable) {
        this.setEnableComponents(enable, enable, enable);
    }

    private void setFlashStatus(String status) {
        this.flashMessageLabel.setText(status);
    }

    private void resetFlashStatus() {
        this.flashMessageLabel.setText("");
    }

    private void setFlashStatusBreathe(boolean start) {
        if (!start && this.breatheTimer.isRunning()) {
            this.breatheTimer.stop();
            this.flashMessageLabel.resetAlpha();
        } else if (start && !this.breatheTimer.isRunning()) {
            this.breatheTimer.start();
        }
    }

    private void animationHandler(String msg) {
        if (msg.equals("Uploading file ") || msg.contains("Resetting BMC") || msg.equals("Wait for Link up ...") || msg.equals("Wait for Link down ...")) {
            this.setFlashStatusBreathe(true);
        } else {
            this.setFlashStatusBreathe(false);
        }
    }

    public void setLoginIP(String ip) {
        this.loginIP = ip;
        this.ipValueLabel.setText(ip);
    }

    @Override
    public void updateState(int st) {
        switch (st) {
            case 0: {
                this.setEnableComponents(true);
                this.setCursor(new Cursor(0));
                break;
            }
            case 1: {
                this.setEnableComponents(false);
                this.setCursor(new Cursor(3));
                break;
            }
            case 2: {
                this.queryVerButtonActionEvent(null);
                this.setEnableComponents(true);
                this.setCursor(new Cursor(0));
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this, "Update image requries system power off");
                this.setEnableComponents(true);
                this.setCursor(new Cursor(0));
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this, L.t("flash.Please_select_file"));
                this.setEnableComponents(true);
                this.setCursor(new Cursor(0));
                break;
            }
            case 5: {
                JOptionPane.showMessageDialog(this, "BMC IP is unavailable currently. Please check after 2 minutes later");
                this.setEnableComponents(true, false, true);
                this.setCursor(new Cursor(0));
                break;
            }
            case 6: {
                JOptionPane.showMessageDialog(this, "BMC IP is unavailable currently. Please check after 2 minutes later\nRoT devices will perform system backup, may need up to 8 minutes to recover.");
                this.setEnableComponents(true, false, true);
                this.setCursor(new Cursor(0));
                break;
            }
            case 7: 
            case 8: {
                if (st == 8) {
                    this.updateProgress(0);
                }
                this.cancelButton.setText("Close");
                this.setEnableComponents(true, false, true);
                this.setCursor(new Cursor(0));
                break;
            }
        }
    }

    @Override
    public void updateMessage(String msg) {
        this.flashMessageLabel.setText(msg);
        this.animationHandler(msg);
    }

    @Override
    public void updateProgress(int progress) {
        boolean isEnabledNew;
        boolean isEnabled = this.progressBar.isEnabled();
        boolean bl = isEnabledNew = progress > 0;
        if (isEnabled != isEnabledNew) {
            this.progressBar.setEnabled(isEnabledNew);
            this.progressBar.setStringPainted(isEnabledNew);
        }
        this.progressBar.setValue(progress);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (!this.freezeComponents) {
                super.processWindowEvent(e);
                this.setVisible(false);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    private class FadeLabel
    extends JLabel {
        private float alpha;
        private BufferedImage background;

        public FadeLabel() {
            try {
                this.background = new BufferedImage(100, 30, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setAlpha(1.0f);
        }

        public void setAlpha(float value) {
            if (this.alpha != value) {
                float old = this.alpha;
                this.alpha = value;
                this.firePropertyChange("alpha", old, this.alpha);
                this.repaint();
            }
        }

        public void resetAlpha() {
            this.setAlpha(1.0f);
        }

        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.background == null ? super.getPreferredSize() : new Dimension(this.background.getWidth(), this.background.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
            super.paint(g2d);
            g2d.dispose();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.background != null) {
                int x = (this.getWidth() - this.background.getWidth()) / 2;
                int y = (this.getHeight() - this.background.getHeight()) / 2;
                g.drawImage(this.background, x, y, this);
            }
            super.paintComponent(g);
        }
    }
}

