/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.DateTimeInterface;
import IPMIView20.IPMIView20;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.redfish.text.NTPConfigurationHelper;
import com.supermicro.redfish.text.NTPRedfishService;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class IPMIDateTimeControl
implements NTPRedfishService {
    public static final byte NTP_SETTINGS = 0;
    public static final byte NTP_DNS_PRIMARY = 1;
    public static final byte NTP_DNS_SECONDARY = 2;
    public static final String CURRENT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss EEE";
    private final int THREAD_POOL_MAXIMUN = 1;
    private boolean forceUseOEMCommand;
    private DateTimeInterface listenser = null;
    private ThreadPoolExecutor excutor = null;
    private IPMIInterfaceConfig ipmiCfg = null;
    private NTPConfigurationHelper helper = null;

    public IPMIDateTimeControl(DateTimeInterface callback) {
        this.listenser = callback;
        this.excutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    public void setConfig(IPMIInterfaceConfig config) {
        this.ipmiCfg = config;
        this.helper = new NTPConfigurationHelper(config);
        this.forceUseOEMCommand = true;
    }

    public NTPConfigurationHelper getConfigurationHelper() {
        return this.helper;
    }

    public void getNTPSettings() {
        this.excutor.submit(() -> {
            if (!this.forceUseOEMCommand && this.helper.isMethodSupported()) {
                this.getNTPSettingsWithRedfish();
            } else {
                this.getNTPSettingsWithOEM();
            }
        });
    }

    public void setNTPSettings(NTPConfigurationHelper.NTPAttributes attributes) {
        this.excutor.submit(() -> {
            if (!this.forceUseOEMCommand && this.helper.isMethodSupported()) {
                this.setNTPSettingsWithRedfish(attributes);
            } else {
                this.setNTPSettingsWithOEM(attributes);
            }
        });
    }

    private void getNTPSettingsWithOEM() {
        ISessionController controller = null;
        NTPConfigurationHelper.NTPAttributes attributes = null;
        if (this.ipmiCfg == null) {
            this.listenser.updateStatus(2, null);
        } else if (this.ipmiCfg.getPrivilege() != 4) {
            this.listenser.updateStatus(7, null);
        } else {
            this.listenser.updateStatus(1, null);
            Instant beginTimestamp = this.getTimerRecord();
            IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(null);
            controller = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiCfg, command, 10);
            if (controller == null) {
                this.listenser.updateStatus(2, null);
            } else {
                IPMISELCommand ipmiSELCommand = new IPMISELCommand(command.getIPMIInterface());
                String currentDateTime = ipmiSELCommand.getSELTimeWithSpecificFormat(CURRENT_DATE_TIME_FORMAT);
                attributes = this.getAttributes(command, this.ipmiCfg);
                if (attributes == null) {
                    this.listenser.updateStatus(2, attributes);
                } else {
                    attributes.setDateTime(currentDateTime);
                    this.setTimerWaiting(beginTimestamp, 1000L);
                    this.listenser.updateStatus(0, attributes);
                }
            }
        }
        if (controller != null) {
            controller.closeSession();
        }
    }

    private void getNTPSettingsWithRedfish() {
        this.listenser.updateStatus(1, null);
        Instant beginTimestamp = this.getTimerRecord();
        NTPConfigurationHelper.NTPAttributes attributes = this.helper.getConfiguration();
        if (attributes != null) {
            this.setTimerWaiting(beginTimestamp, 1000L);
            this.listenser.updateStatus(0, attributes);
        } else {
            this.listenser.updateStatus(2, null);
        }
    }

    private void setNTPSettingsWithOEM(NTPConfigurationHelper.NTPAttributes attributes) {
        boolean result;
        ISessionController controller;
        block27: {
            controller = null;
            result = false;
            this.listenser.updateStatus(4, null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.ipmiCfg == null) {
                this.listenser.updateStatus(6, null);
            } else {
                IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(null);
                controller = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiCfg, command, 10);
                if (controller == null) {
                    if (IPMIView20.showException) {
                        System.out.println("createSessionControlle fail in RAKP panel");
                    }
                    this.listenser.updateStatus(6, null);
                } else {
                    NTPConfigurationHelper.NTPAttributes currentAttributes = this.getAttributes(command, this.ipmiCfg);
                    if (currentAttributes != null) {
                        block28: {
                            try {
                                boolean setTimezoneInRedfish = false;
                                if (currentAttributes.isNTPEnable() != attributes.isNTPEnable() || currentAttributes.isDaylightSavingTimeEnable() != attributes.isDaylightSavingTimeEnable() || !currentAttributes.getTimezone().equalsIgnoreCase(attributes.getTimezone())) {
                                    byte[] ntpData = command.getNTPDateTime((byte)0);
                                    if (IPMIOEMWebSettingCommand.isNTPLegacyResponse(ntpData)) {
                                        ntpData[0] = attributes.isNTPEnable() ? (byte)1 : 0;
                                        byte by = ntpData[6] = attributes.isDaylightSavingTimeEnable() ? (byte)1 : 0;
                                        if (attributes.isTimezoneCountrySupported()) {
                                            byte[] zeroArray = new byte[]{43, 48, 48, 48, 48};
                                            System.arraycopy(zeroArray, 0, ntpData, 1, 5);
                                            setTimezoneInRedfish = true;
                                        } else {
                                            String timezoneStr = attributes.getTimezone();
                                            System.arraycopy(timezoneStr.getBytes(), 0, ntpData, 1, 5);
                                        }
                                        command.setNTPDateTime((byte)0, ntpData);
                                    } else {
                                        int index = attributes.getTimezoneIndex();
                                        ntpData[0] = attributes.isNTPEnable() ? (byte)1 : 0;
                                        ntpData[1] = (byte)index;
                                        ntpData[3] = attributes.isDaylightSavingTimeEnable() ? (byte)1 : 0;
                                        command.setNewNTPSettings(ntpData);
                                    }
                                }
                                if (!currentAttributes.getPrimaryNTPServer().equalsIgnoreCase(attributes.getPrimaryNTPServer())) {
                                    String primaryServerStr = attributes.getPrimaryNTPServer();
                                    if (primaryServerStr == null) {
                                        this.listenser.updateStatus(6, null);
                                        break block27;
                                    }
                                    byte[] primaryData = new byte[primaryServerStr.length() + 1];
                                    System.arraycopy(primaryServerStr.getBytes(), 0, primaryData, 0, primaryServerStr.length());
                                    command.setNTPDateTime((byte)1, primaryData);
                                }
                                if (!currentAttributes.getSecondaryNTPServer().equalsIgnoreCase(attributes.getSecondaryNTPServer())) {
                                    String secondaryServerStr = attributes.getSecondaryNTPServer();
                                    if (secondaryServerStr == null) {
                                        this.listenser.updateStatus(6, null);
                                        break block27;
                                    }
                                    byte[] secondaryData = new byte[secondaryServerStr.length() + 1];
                                    System.arraycopy(secondaryServerStr.getBytes(), 0, secondaryData, 0, secondaryServerStr.length());
                                    command.setNTPDateTime((byte)2, secondaryData);
                                }
                                if (!setTimezoneInRedfish) break block28;
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                String timeZoneName = attributes.getTimezone();
                                this.setNTPRedfishTimezone(this.ipmiCfg, timeZoneName);
                            }
                            catch (IPMIException e) {
                                if (IPMIView20.showException) {
                                    e.printStackTrace();
                                }
                                result = false;
                                break block27;
                            }
                        }
                        result = true;
                    }
                }
            }
        }
        if (controller != null) {
            controller.closeSession();
        }
        if (result && this.isAttributesChanged(attributes)) {
            this.listenser.updateStatus(5, null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.listenser.updateStatus(3, null);
        } else {
            this.listenser.updateStatus(6, null);
        }
    }

    private void setNTPSettingsWithRedfish(NTPConfigurationHelper.NTPAttributes attributes) {
        if (attributes != null) {
            this.listenser.updateStatus(4, null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Instant beginTimestamp = this.getTimerRecord();
            this.helper.setConfiguration(attributes);
            this.setTimerWaiting(beginTimestamp, 1000L);
            this.listenser.updateStatus(3, null);
        } else {
            this.listenser.updateStatus(6, null);
        }
    }

    private NTPConfigurationHelper.NTPAttributes getAttributes(IPMIOEMWebSettingCommand command, IPMIInterfaceConfig config) {
        NTPConfigurationHelper.NTPAttributes attributes = this.helper.getConfigurationInstance();
        if (command != null) {
            try {
                byte[] ntpData = command.getNTPDateTime((byte)0);
                byte[] primaryData = command.getNTPDateTime((byte)1);
                byte[] secondaryData = command.getNTPDateTime((byte)2);
                byte[] guid = IPMIMessagingCommand.getSystemGUIDbyConfig(config);
                boolean isNTPEnabled = ntpData != null && ntpData.length > 0 ? ntpData[0] == 1 : false;
                boolean isBeforeX12 = IPMIMessagingCommand.isBeforeX12(guid);
                boolean isRedfishTimezoneCountrySupported = isBeforeX12 ? false : this.isNTPRedfishTimezoneSupported(config);
                boolean isRedfishAutoDSTSupported = isBeforeX12 ? false : this.isNTPRedfishAutoDSTSupported(config);
                boolean isTimezoneCountrySupported = isRedfishTimezoneCountrySupported;
                boolean isAutoDSTSupported = isRedfishAutoDSTSupported;
                boolean isAutoDSTEnabled = false;
                boolean isDSTEnabled = false;
                String timezone = null;
                if (isRedfishTimezoneCountrySupported) {
                    timezone = this.getNTPRedfishTimezone(this.ipmiCfg);
                } else if (IPMIOEMWebSettingCommand.isNTPLegacyResponse(ntpData)) {
                    timezone = new String(ntpData).substring(1, 6);
                } else {
                    timezone = IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList().get((ntpData[1] & 0xFF) - 1);
                    isTimezoneCountrySupported = true;
                }
                if (isRedfishAutoDSTSupported) {
                    isAutoDSTEnabled = this.isNTPRedfishAutoDSTEnabled(this.ipmiCfg);
                } else if (IPMIOEMWebSettingCommand.isNTPLegacyResponse(ntpData)) {
                    isDSTEnabled = ntpData[6] == 1;
                } else {
                    isAutoDSTEnabled = ntpData[3] == 1;
                    isAutoDSTSupported = true;
                }
                String primaryServer = primaryData != null ? new String(primaryData) : null;
                String secondaryServer = secondaryData != null ? new String(secondaryData) : null;
                attributes.setTimezone(timezone);
                attributes.setPrimaryNTPServer(primaryServer);
                attributes.setSecondaryNTPServer(secondaryServer);
                attributes.setDaylightSavingTimeEnable(isAutoDSTEnabled || isDSTEnabled);
                attributes.setNTPEnable(isNTPEnabled);
                attributes.setAutoDstSupported(isAutoDSTSupported);
                attributes.setTimezoneCountrySupported(isTimezoneCountrySupported);
            }
            catch (IPMIException e) {
                if (IPMIView20.showException) {
                    e.printStackTrace();
                }
                if (e.getIPMIMessage().completionCode == -44) {
                    attributes.setInsufficientPrivilege(true);
                }
                return null;
            }
        }
        return attributes;
    }

    private boolean isAttributesChanged(NTPConfigurationHelper.NTPAttributes attributes) {
        int count = 40;
        boolean result = false;
        if (this.ipmiCfg == null) {
            return false;
        }
        IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(null);
        ISessionController controller = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiCfg, command, 10);
        if (controller == null) {
            return false;
        }
        do {
            this.listenser.updateStatus(4, count);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            NTPConfigurationHelper.NTPAttributes current = this.getAttributes(command, this.ipmiCfg);
            if (current == null) break;
            if (attributes.isNTPEnable() && !current.getTimezone().equalsIgnoreCase(attributes.getTimezone())) {
                System.out.println("(" + count + ")Timezone: " + current.getTimezone() + " is not changed to " + attributes.getTimezone());
                continue;
            }
            if (attributes.isNTPEnable() && !current.getPrimaryNTPServer().equalsIgnoreCase(attributes.getPrimaryNTPServer())) {
                System.out.println("(" + count + ")PrimaryServer: " + current.getPrimaryNTPServer() + " is not changed to " + attributes.getPrimaryNTPServer());
                continue;
            }
            if (attributes.isNTPEnable() && !current.getSecondaryNTPServer().equalsIgnoreCase(attributes.getSecondaryNTPServer())) {
                System.out.println("(" + count + ")Secondary Server: " + current.getSecondaryNTPServer() + " is not changed to " + attributes.getSecondaryNTPServer());
                continue;
            }
            if (current.isNTPEnable() != attributes.isNTPEnable()) {
                System.out.println("(" + count + ")NTP status: " + current.isNTPEnable() + " is not changed to " + attributes.isNTPEnable());
                continue;
            }
            if (attributes.isNTPEnable() && current.isDaylightSavingTimeEnable() != attributes.isDaylightSavingTimeEnable()) {
                System.out.println("(" + count + ")DayLight saving status: " + current.isDaylightSavingTimeEnable() + " is not changed to " + attributes.isDaylightSavingTimeEnable());
                continue;
            }
            result = true;
        } while (count-- > 0 && !result);
        if (controller != null) {
            controller.closeSession();
        }
        return result;
    }

    private Instant getTimerRecord() {
        return Instant.now();
    }

    private void setTimerWaiting(Instant beginTimeStamp, long expectedWaitingTime) {
        Instant endTimeStamp = Instant.now();
        long timeElapsed = Duration.between(beginTimeStamp, endTimeStamp).toMillis();
        if (timeElapsed < expectedWaitingTime) {
            try {
                Thread.sleep(expectedWaitingTime - timeElapsed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

