/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ExpandableComponent;
import IPMIView20.IPMIDeviceControlInterface;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IPMIDeviceFanPanel
extends ExpandableComponent {
    private JPanel bodyPanel = new JPanel();
    private JPanel bodyInsideLeftPanel = new JPanel();
    private JPanel bodyInsideRightPanel = new JPanel();
    private JRadioButton standardModeBtn = new JRadioButton();
    private JRadioButton fullModeBtn = new JRadioButton();
    private JRadioButton heavyIOModeBtn = new JRadioButton();
    private JRadioButton liquidModeBtn = new JRadioButton();
    private JRadioButton optimalModeBtn = new JRadioButton();
    private JRadioButton pUE2OptModeBtn = new JRadioButton();
    private JRadioButton pUE3OptModeBtn = new JRadioButton();
    private JRadioButton smartModeBtn = new JRadioButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private final int RADIO_BUTTON_WIDTH = 220;
    private final int RADIO_BUTTON_HEIGHT = 25;
    private IPMIDeviceControlInterface deviceStateListener;

    public IPMIDeviceFanPanel(IPMIDeviceControlInterface listener) {
        this.init();
        this.deviceStateListener = listener;
    }

    public void init() {
        this.setHeaderText("FAN Control");
        this.standardModeBtn.setText("Standard");
        this.fullModeBtn.setText("Full");
        this.heavyIOModeBtn.setText("Heavy IO");
        this.liquidModeBtn.setText("Liquid");
        this.optimalModeBtn.setText("Optimal");
        this.pUE2OptModeBtn.setText("PUE2 Opt");
        this.pUE3OptModeBtn.setText("PUE3 Opt");
        this.smartModeBtn.setText("Smart");
        this.buttonGroup.add(this.standardModeBtn);
        this.buttonGroup.add(this.fullModeBtn);
        this.buttonGroup.add(this.heavyIOModeBtn);
        this.buttonGroup.add(this.liquidModeBtn);
        this.buttonGroup.add(this.optimalModeBtn);
        this.buttonGroup.add(this.pUE2OptModeBtn);
        this.buttonGroup.add(this.pUE3OptModeBtn);
        this.buttonGroup.add(this.smartModeBtn);
        this.fixedButtonDimension(this.standardModeBtn, 220, 25);
        this.fixedButtonDimension(this.fullModeBtn, 220, 25);
        this.fixedButtonDimension(this.heavyIOModeBtn, 220, 25);
        this.fixedButtonDimension(this.liquidModeBtn, 220, 25);
        this.fixedButtonDimension(this.optimalModeBtn, 220, 25);
        this.fixedButtonDimension(this.pUE2OptModeBtn, 220, 25);
        this.fixedButtonDimension(this.pUE3OptModeBtn, 220, 25);
        this.fixedButtonDimension(this.smartModeBtn, 220, 25);
        this.bodyPanel.setLayout(new BoxLayout(this.bodyPanel, 0));
        this.bodyInsideLeftPanel.setLayout(new BoxLayout(this.bodyInsideLeftPanel, 1));
        this.bodyInsideRightPanel.setLayout(new BoxLayout(this.bodyInsideRightPanel, 1));
        this.bodyPanel.add(Box.createHorizontalStrut(40));
        this.bodyPanel.add(this.bodyInsideLeftPanel);
        this.bodyPanel.add(Box.createHorizontalStrut(40));
        this.bodyPanel.add(this.bodyInsideRightPanel);
        this.bodyPanel.add(Box.createHorizontalGlue());
        this.bodyInsideLeftPanel.add(Box.createVerticalStrut(10));
        this.bodyInsideLeftPanel.add(this.standardModeBtn);
        this.bodyInsideLeftPanel.add(this.fullModeBtn);
        this.bodyInsideLeftPanel.add(this.heavyIOModeBtn);
        this.bodyInsideLeftPanel.add(this.liquidModeBtn);
        this.bodyInsideLeftPanel.add(Box.createVerticalGlue());
        this.bodyInsideRightPanel.add(Box.createVerticalStrut(10));
        this.bodyInsideRightPanel.add(this.optimalModeBtn);
        this.bodyInsideRightPanel.add(this.pUE2OptModeBtn);
        this.bodyInsideRightPanel.add(this.pUE3OptModeBtn);
        this.bodyInsideRightPanel.add(this.smartModeBtn);
        this.bodyInsideRightPanel.add(Box.createVerticalGlue());
        super.setBodyComponet(this.bodyPanel, 140);
        this.standardModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.fullModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.heavyIOModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.liquidModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.optimalModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.pUE2OptModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.pUE3OptModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
        this.smartModeBtn.addActionListener(e -> this.setRadioButtonAction(e));
    }

    private void fixedButtonDimension(JRadioButton button, int width, int height) {
        button.setMaximumSize(new Dimension(width, height));
        button.setMinimumSize(new Dimension(width, height));
        button.setPreferredSize(new Dimension(width, height));
    }

    private void setRadioButtonAction(ActionEvent e) {
        JRadioButton target = (JRadioButton)e.getSource();
        this.setComponetLocked(true);
        int mode = -1;
        if (target == this.standardModeBtn) {
            mode = 0;
        } else if (target == this.fullModeBtn) {
            mode = 1;
        } else if (target == this.optimalModeBtn) {
            mode = 2;
        } else if (target == this.pUE2OptModeBtn) {
            mode = 3;
        } else if (target == this.heavyIOModeBtn) {
            mode = 4;
        } else if (target == this.pUE3OptModeBtn) {
            mode = 5;
        } else if (target == this.liquidModeBtn) {
            mode = 6;
        } else if (target == this.smartModeBtn) {
            mode = 7;
        }
        this.deviceStateListener.updateState(12, mode);
    }

    public void setFanModeCapability(byte cap) {
        this.standardModeBtn.setEnabled((cap >> 0 & 1) != 0);
        this.fullModeBtn.setEnabled((cap >> 1 & 1) != 0);
        this.optimalModeBtn.setEnabled((cap >> 2 & 1) != 0);
        this.pUE2OptModeBtn.setEnabled((cap >> 3 & 1) != 0);
        this.heavyIOModeBtn.setEnabled((cap >> 4 & 1) != 0);
        this.pUE3OptModeBtn.setEnabled((cap >> 5 & 1) != 0);
        this.liquidModeBtn.setEnabled((cap >> 6 & 1) != 0);
        this.smartModeBtn.setEnabled((cap >> 7 & 1) != 0);
    }

    public void setFanMode(int mode) {
        switch (mode) {
            case 0: {
                this.standardModeBtn.setSelected(true);
                break;
            }
            case 1: {
                this.fullModeBtn.setSelected(true);
                break;
            }
            case 2: {
                this.optimalModeBtn.setSelected(true);
                break;
            }
            case 3: {
                this.pUE2OptModeBtn.setSelected(true);
                break;
            }
            case 4: {
                this.heavyIOModeBtn.setSelected(true);
                break;
            }
            case 5: {
                this.pUE3OptModeBtn.setSelected(true);
                break;
            }
            case 6: {
                this.liquidModeBtn.setSelected(true);
                break;
            }
            case 7: {
                this.smartModeBtn.setSelected(true);
            }
        }
    }

    @Override
    protected void setComponetLocked(boolean locked) {
        super.setComponetLocked(locked);
        if (locked) {
            this.standardModeBtn.setEnabled(!locked);
            this.fullModeBtn.setEnabled(!locked);
            this.optimalModeBtn.setEnabled(!locked);
            this.pUE2OptModeBtn.setEnabled(!locked);
            this.heavyIOModeBtn.setEnabled(!locked);
            this.pUE3OptModeBtn.setEnabled(!locked);
            this.liquidModeBtn.setEnabled(!locked);
            this.smartModeBtn.setEnabled(!locked);
        }
    }
}

