/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.ComboTabListener;
import IPMIView20.IPMIDeviceBootPanel;
import IPMIView20.IPMIDeviceControl;
import IPMIView20.IPMIDeviceControlInterface;
import IPMIView20.IPMIDeviceFanPanel;
import IPMIView20.IPMIDeviceInfoPanel;
import IPMIView20.IPMIDevicePowerPanel;
import IPMIView20.IPMIDeviceUidPanel;
import IPMIView20.L;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IPMIDeviceView
extends JPanel
implements IPMIDeviceControlInterface,
ComboTabListener {
    private JPanel controlPanel = new JPanel();
    private JLabel mainWindowToolbarBottomMessage;
    private IPMIDeviceFanPanel fanControlPanel = new IPMIDeviceFanPanel(this);
    private IPMIDeviceUidPanel uidControlPanel = new IPMIDeviceUidPanel(this);
    private IPMIDevicePowerPanel powerControlPanel = new IPMIDevicePowerPanel(this);
    private IPMIDeviceBootPanel bootControlPanel = new IPMIDeviceBootPanel(this);
    private IPMIDeviceInfoPanel infoPanel = new IPMIDeviceInfoPanel();
    private IPMIInterfaceConfig interfaceConfig = new IPMIInterfaceConfig();
    private IPMIDeviceControl controller;
    private ComboTabListener comboTabListener;
    private Timer pollingTimer;
    private boolean isOperatorEnable;
    private boolean isAdministratorEnable;

    public IPMIDeviceView(ComboTabListener listener) {
        this.setLayout(new BorderLayout());
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        this.controlPanel.add(this.uidControlPanel);
        this.controlPanel.add(this.fanControlPanel);
        this.controlPanel.add(this.bootControlPanel);
        this.controlPanel.add(this.powerControlPanel);
        this.powerControlPanel.setExpanded(false);
        this.comboTabListener = listener;
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.infoPanel, "Center");
    }

    public void init(CSession cSession, JLabel xMessage) {
        this.interfaceConfig.setIp(cSession.SIP);
        this.interfaceConfig.setUserName(cSession.userID);
        this.interfaceConfig.setPassword(cSession.getPasswordStr());
        this.interfaceConfig.setPrivilege(cSession.MaxLevel[0]);
        this.interfaceConfig.setSmcRAKP(cSession.isSMCRAKP);
        this.mainWindowToolbarBottomMessage = xMessage;
        this.controller = new IPMIDeviceControl(this.interfaceConfig, this);
        this.powerControlPanel.setAccountPermission(this.interfaceConfig.getPrivilege());
        this.isOperatorEnable = this.interfaceConfig.getPrivilege() == 4 || this.interfaceConfig.getPrivilege() == 3;
        this.isAdministratorEnable = this.interfaceConfig.getPrivilege() == 4;
    }

    public void startTimer() {
        if (this.pollingTimer == null) {
            this.pollingTimer = new Timer();
            this.pollingTimer.schedule((TimerTask)new PollingTask(), 0L, 5000L);
        }
    }

    public void stopTimer() {
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
            this.pollingTimer = null;
        }
    }

    public synchronized void reload(boolean locked) {
        this.comboTabListener.toolbarStatus(1, new int[0]);
        this.comboTabListener.toolbarStatus(2, new int[0]);
        if (locked) {
            this.setSubPanelEnable(false);
        }
        this.controller.getSystemInformation();
        if (this.isAdministratorEnable) {
            this.controller.getFanCapability();
            this.controller.getFanSpeed();
            this.controller.getUidMode();
        }
        if (this.isOperatorEnable) {
            this.controller.getBootOption();
        }
    }

    private void setSubPanelEnable(boolean enable) {
        this.fanControlPanel.setComponetLocked(this.isAdministratorEnable ? !enable : true);
        this.uidControlPanel.setComponetLocked(this.isAdministratorEnable ? !enable : true);
        this.powerControlPanel.setComponetLocked(!enable);
        this.bootControlPanel.setComponetLocked(this.isOperatorEnable ? !enable : true);
    }

    public static void main(String[] args) {
    }

    @Override
    public void updateState(int state, Integer ... subArgs) {
        if (state == 1) {
            this.mainWindowToolbarBottomMessage.setText("running");
        } else if (state == 0) {
            this.mainWindowToolbarBottomMessage.setText("done");
            this.infoPanel.updateInfo(this.controller.getDeviceProfile());
            this.powerControlPanel.setCurrentPowerOn(this.controller.getDeviceProfile().isPowerState());
            this.powerControlPanel.setCurrentEnable(this.controller.getDeviceProfile().isPowerState());
            this.setSubPanelEnable(true);
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IPMIDeviceView iPMIDeviceView = this;
                synchronized (iPMIDeviceView) {
                    this.comboTabListener.toolbarStatus(0, new int[0]);
                }
            }).start();
        } else if (state == 2) {
            this.mainWindowToolbarBottomMessage.setText("error");
            this.setSubPanelEnable(true);
        } else if (state == 3) {
            if (subArgs != null && subArgs[0] != null) {
                if (subArgs[0] == 1) {
                    this.startTimer();
                    this.setSubPanelEnable(true);
                } else {
                    this.stopTimer();
                    this.setSubPanelEnable(false);
                }
            }
        } else if (state == 4) {
            if (subArgs != null && subArgs[0] != null) {
                this.controller.setChassisPowerState(subArgs[0]);
            }
        } else if (state == 5) {
            if (subArgs != null && subArgs[0] != null) {
                String msg = "";
                switch (subArgs[0]) {
                    case 0: {
                        msg = L.t("device.power-up_command_was_sent");
                        break;
                    }
                    case 1: {
                        msg = L.t("device.sending_the_power-down_command");
                        break;
                    }
                    case 2: {
                        msg = L.t("device.graceful_shutdown_command_was_sent");
                        break;
                    }
                    case 3: {
                        msg = L.t("device.power-cycle_command_was_sent");
                        break;
                    }
                    case 4: {
                        msg = L.t("device.reset_command_was_sent");
                        break;
                    }
                    case 6: {
                        msg = L.t("device.reset_command_was_sent");
                    }
                }
                this.mainWindowToolbarBottomMessage.setText(msg);
                this.powerControlPanel.setComponentEnable(false);
                this.startTimer();
            }
        } else if (state == 8) {
            if (subArgs != null && subArgs[0] != null) {
                this.controller.setUidMode(subArgs[0] == 1);
            }
        } else if (state == 6) {
            if (subArgs != null && subArgs[0] != null) {
                this.uidControlPanel.setUidState(subArgs[0] == 1);
                this.uidControlPanel.setComponetLocked(!this.isAdministratorEnable);
            }
        } else if (state == 9) {
            if (subArgs != null && subArgs[0] != null) {
                this.fanControlPanel.setFanModeCapability((byte)subArgs[0].intValue());
            }
        } else if (state == 10) {
            if (subArgs != null && subArgs[0] != null) {
                this.fanControlPanel.setFanMode(subArgs[0]);
            }
        } else if (state == 12) {
            if (subArgs != null && subArgs[0] != null) {
                this.controller.setFanSpeed(subArgs[0]);
            }
        } else if (state == 11) {
            if (subArgs != null && subArgs[0] != null) {
                this.mainWindowToolbarBottomMessage.setText("Set FAN speed " + (subArgs[0] == 1 ? "done" : "fail"));
                this.fanControlPanel.setFanModeCapability(this.controller.getDeviceProfile().getFanSpeedCapability());
            }
        } else if (state == 7) {
            if (subArgs != null && subArgs[0] != null) {
                this.mainWindowToolbarBottomMessage.setText((subArgs[0] == 1 ? "Enable" : "Disable") + " UID " + (subArgs[1] == 1 ? "done" : "fail"));
                this.uidControlPanel.setComponetLocked(!this.isAdministratorEnable);
            }
        } else if (state == 13) {
            if (subArgs != null && subArgs[0] != null) {
                this.bootControlPanel.setBootoption(subArgs[0]);
                this.bootControlPanel.setComponetLocked(!this.isOperatorEnable);
            }
        } else if (state == 15) {
            if (subArgs != null && subArgs[0] != null) {
                this.mainWindowToolbarBottomMessage.setText("Set BootOption ...");
                this.controller.setBootOption(subArgs[0]);
            }
        } else if (state == 14 && subArgs != null && subArgs[0] != null) {
            this.bootControlPanel.setComponetLocked(!this.isOperatorEnable);
            String message = this.bootControlPanel.getCurrentBootoption() == null ? "Clear next Bootoption" : "Set BootOption to " + this.bootControlPanel.getCurrentBootoption();
            this.mainWindowToolbarBottomMessage.setText(message + " " + (subArgs[0] == 1 ? "done" : "fail"));
        }
    }

    @Override
    public void toolbarAction(int actionType) {
        if (actionType == 4) {
            this.stopTimer();
            this.reload(true);
            this.startTimer();
        }
    }

    private class PollingTask
    extends TimerTask {
        private PollingTask() {
        }

        @Override
        public void run() {
            IPMIDeviceView.this.reload(false);
        }
    }
}

