/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class IconTextField
extends JTextField {
    private IconTextComponentHelper mHelper = new IconTextComponentHelper(this);

    public IconTextField() {
    }

    public IconTextField(int cols) {
        super(cols);
    }

    private IconTextComponentHelper getHelper() {
        if (this.mHelper == null) {
            this.mHelper = new IconTextComponentHelper(this);
        }
        return this.mHelper;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.getHelper().onPaintComponent(graphics);
    }

    public void setIcon(Icon icon) {
        this.getHelper().onSetIcon(icon);
    }

    public void setIconSpacing(int spacing) {
        this.getHelper().onSetIconSpacing(spacing);
    }

    @Override
    public void setBorder(Border border) {
        this.getHelper().onSetBorder(border);
        super.setBorder(this.getHelper().getBorder());
    }

    class IconTextComponentHelper {
        private static final int ICON_SPACING = 4;
        private int mIconSpacing;
        private Border mBorder;
        private Icon mIcon;
        private Border mOrigBorder;
        private JTextComponent mTextComponent;

        IconTextComponentHelper(JTextComponent component) {
            this.mTextComponent = component;
            this.mBorder = this.mOrigBorder = component.getBorder();
            this.mIconSpacing = 4;
        }

        Border getBorder() {
            return this.mBorder;
        }

        void onPaintComponent(Graphics g) {
            if (this.mIcon != null) {
                Insets iconInsets = this.mOrigBorder.getBorderInsets(this.mTextComponent);
                this.mIcon.paintIcon(this.mTextComponent, g, this.mTextComponent.getWidth() - this.mIcon.getIconWidth() - iconInsets.left, this.mIconSpacing / 2);
            }
        }

        void onSetBorder(Border border) {
            this.mOrigBorder = border;
            if (this.mIcon == null) {
                this.mBorder = border;
            } else {
                Border margin = BorderFactory.createEmptyBorder(0, this.mIconSpacing, 0, 0);
                this.mBorder = BorderFactory.createCompoundBorder(border, margin);
            }
        }

        void onSetIcon(Icon icon) {
            this.mIcon = icon;
            this.resetBorder();
        }

        void onSetIconSpacing(int space) {
            this.mIconSpacing = space;
        }

        private void resetBorder() {
            this.mTextComponent.setBorder(this.mOrigBorder);
        }
    }
}

