/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.util.ArrayList;

public class NTPTimeZoneItems {
    private ArrayList<String> timezoneItems = new ArrayList();
    private ArrayList<Boolean> timezoneSupportList = new ArrayList();
    private final String PREFIX = "UTC";
    private boolean isAutoDstSupported = false;
    private boolean isAutoDstEnabled = false;
    private boolean isTimezoneCountrySupported = false;
    private int seletectedIndex;

    public void setSupportList(ArrayList<Boolean> list) {
        this.timezoneSupportList = list;
    }

    public void setItems(ArrayList<String> items) {
        this.timezoneItems.clear();
        this.timezoneItems.addAll(items);
    }

    public void setAutoDstSupported(boolean supported) {
        this.isAutoDstSupported = supported;
    }

    public void setCurrentItemAutoDstEnabled(boolean enable) {
        this.isAutoDstEnabled = enable;
    }

    public void setTimezoneCountrySupported(boolean supported) {
        this.isTimezoneCountrySupported = supported;
    }

    public void setCurrentTimezoneIndex(int index) {
        this.seletectedIndex = index;
    }

    public ArrayList<Boolean> getSupportList() {
        return this.timezoneSupportList;
    }

    public ArrayList<String> getItems() {
        return this.timezoneItems;
    }

    public int getItemIndex(String item) {
        if (item != null && item.length() > 0) {
            String value = item;
            if (this.isTimezoneCountrySupported) {
                int index = 0;
                try {
                    index = Integer.parseInt(item) - 1;
                }
                catch (NumberFormatException ex) {
                    index = this.timezoneItems.indexOf(item);
                }
                return index;
            }
            value = value.replaceFirst(":", "");
            return this.timezoneItems.indexOf(value);
        }
        return -1;
    }

    public String getItemValue(int index, boolean withMiddle) {
        if (index >= 0 && index < this.timezoneItems.size()) {
            if (withMiddle) {
                String value = this.timezoneItems.get(index);
                return value.substring(0, 3) + ":" + value.substring(3, 5);
            }
            return this.timezoneItems.get(index);
        }
        return null;
    }

    public String getDispalyFormat(String value) {
        if (!this.isTimezoneCountrySupported) {
            return value != null ? "UTC" + value.substring(0, 3) + ":" + value.substring(3, 5) : "";
        }
        return value;
    }

    public int getCurrentTimezoneIndex() {
        return this.seletectedIndex;
    }

    public boolean isTimezoneCountrySupported() {
        return this.isTimezoneCountrySupported;
    }

    public boolean isAutoDstSupported() {
        return this.isAutoDstSupported;
    }

    public boolean isCurrentItemAutoDstEnabled() {
        return this.isAutoDstEnabled;
    }

    public boolean isTimezoneSetup() {
        return this.timezoneItems.size() > 0;
    }
}

