/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NetworkSettingUtility {
    static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public static byte[] hexStringToBytes(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hexString.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static List<String> bytesToHexStringList(byte[] bytes) {
        byte[] hexChars = new byte[1];
        ArrayList<String> hexStrList = new ArrayList<String>();
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[0] = HEX_ARRAY[v >>> 4];
            String firstStr = new String(hexChars, StandardCharsets.UTF_8);
            hexChars[0] = HEX_ARRAY[v & 0xF];
            String secondStr = new String(hexChars, StandardCharsets.UTF_8);
            hexStrList.add(firstStr + secondStr);
        }
        return hexStrList;
    }

    public static byte[] ipv6IPStrToBytes(String address) {
        String ipAddr = address.split("/")[0];
        String netMaskStr = address.split("/")[1];
        int netMask = Integer.valueOf(netMaskStr);
        String ipAddrFull = ipAddr;
        while (ipAddrFull.contains(":0:")) {
            ipAddrFull = ipAddrFull.replaceAll(":0:", ":0000:");
        }
        String ipAddrPure = ipAddrFull.replace(":", "");
        byte[] addrBytes = new byte[17];
        byte[] result = NetworkSettingUtility.hexStringToBytes(ipAddrPure);
        System.arraycopy(result, 0, addrBytes, 0, 16);
        addrBytes[16] = (byte)netMask;
        return addrBytes;
    }

    public static String fillColonToAddress(String addr) {
        int colonCount;
        String result = addr;
        if (null != result && result.contains("::") && (colonCount = result.length() - result.replaceAll(":", "").length()) != 7) {
            int lackColon = 7 - colonCount;
            String tmp = "::";
            for (int idx = 0; idx < lackColon; ++idx) {
                tmp = tmp + ":";
            }
            result = result.replace("::", tmp);
        }
        return result;
    }

    public static String fillZeroToAddress(String addr) {
        int subAddrLength = 8;
        if (null == addr) {
            return addr;
        }
        String[] subAddr = addr.split(":", 8);
        String result = "";
        for (int index = 0; index < 8; ++index) {
            if (subAddr[index].length() != 4) {
                String tmp = "";
                for (int subIdx = subAddr[index].length(); subIdx < 4; ++subIdx) {
                    tmp = tmp + "0";
                }
                subAddr[index] = tmp + subAddr[index];
            }
            result = result + subAddr[index];
            if (index == 7) continue;
            result = result + ":";
        }
        return result;
    }

    public static String standardizeAddress(String address, boolean hasSubmask) {
        return NetworkSettingUtility.shortenAddress(NetworkSettingUtility.extendedAddress(address, hasSubmask), hasSubmask);
    }

    public static String extendedAddress(String address, boolean hasSubmask) {
        String addr;
        String result = null;
        String string = addr = hasSubmask ? address.split("/")[0] : address;
        String mask = hasSubmask ? (address.split("/").length > 1 ? address.split("/")[1] : null) : null;
        result = NetworkSettingUtility.fillColonToAddress(addr);
        result = NetworkSettingUtility.fillZeroToAddress(result);
        return hasSubmask ? result + "/" + mask : result;
    }

    public static String shortenAddress(String address, boolean hasSubmask) {
        if (null == address) {
            return address;
        }
        String addr = hasSubmask ? address.split("/")[0] : address;
        String mask = hasSubmask ? address.split("/")[1] : null;
        addr = addr.replaceAll("^0{1,3}", "");
        if ((addr = addr.replaceAll(":0{1,3}", ":")).contains("::")) {
            return hasSubmask ? addr + "/" + mask : addr;
        }
        int subAddrLength = 8;
        String[] subAddr = addr.split(":");
        Boolean[] zeroArr = new Boolean[8];
        if (subAddr.length != 8) {
            return "";
        }
        for (int index = 0; index < 8; ++index) {
            zeroArr[index] = subAddr[index].equals("0") || subAddr[index].equals("00") || subAddr[index].equals("000") || subAddr[index].equals("0000") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        int curLeft = 0;
        int curRight = 0;
        int curLen = 0;
        int backupLeft = 0;
        int backupRight = 0;
        int backupLen = 0;
        boolean counting = false;
        for (int index = 0; index < subAddr.length; ++index) {
            if (index != 7) {
                if (counting && !zeroArr[index].booleanValue()) {
                    curRight = index - 1;
                    curLen = curRight - curLeft + 1;
                    if (curLen > backupLen) {
                        backupLeft = curLeft;
                        backupRight = curRight;
                        backupLen = curLen;
                    }
                    counting = false;
                    continue;
                }
                if (counting || !zeroArr[index].booleanValue()) continue;
                counting = true;
                curLeft = index;
                continue;
            }
            if (!counting || (curLen = (curRight = zeroArr[index] != false ? index : index - 1) - curLeft + 1) <= backupLen) continue;
            backupLeft = curLeft;
            backupRight = curRight;
            backupLen = curLen;
        }
        if (backupLeft == 0 && backupRight == 0) {
            return address;
        }
        String result = "";
        for (int index = 0; index < 8; ++index) {
            if (backupLeft > index || index > backupRight) {
                result = result + subAddr[index];
                if (index != 7) {
                    result = result + ":";
                }
            }
            if (index == backupLeft && 0 == backupLeft) {
                result = result + ":";
            }
            if (index != backupRight) continue;
            result = result + ":";
        }
        return hasSubmask ? result + "/" + mask : result;
    }

    public static boolean isValidIPv4(String ip) {
        String chunkIPv4 = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
        Pattern IPV4_STD_REGEX = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$");
        return ip != null && IPV4_STD_REGEX.matcher(ip).matches();
    }

    public static boolean isValidIPv6(String ip, boolean hasPrefix) {
        if (hasPrefix == ip.contains("/")) {
            if (hasPrefix) {
                ip = ip.split("/")[0];
            }
        } else {
            return false;
        }
        String chunkIPv6 = "[0-9a-fA-F]{1,4}";
        Pattern IPV6_STD_REGEX = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Pattern IPV6_COMPRESS_REGEX = Pattern.compile("^((?:[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)::((?:([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?)$");
        Pattern IPV6_COMPRESS_REGEX_BORDER = Pattern.compile("^(::(?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5})|((?:[0-9a-fA-F]{1,4})(?::[0-9a-fA-F]{1,4}){5}::)$");
        return IPV6_STD_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX.matcher(ip).matches() || IPV6_COMPRESS_REGEX_BORDER.matcher(ip).matches();
    }

    public static boolean isValidIPv6Prefix(String address) {
        if (address.contains("/")) {
            Integer prefix = 0;
            String[] token = address.split("/");
            if (token.length < 2) {
                return false;
            }
            try {
                prefix = Integer.valueOf(token[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return 1 <= prefix && prefix <= 128;
        }
        return false;
    }

    public static boolean isValidVLANID(String vlanID) {
        try {
            int id = Integer.valueOf(vlanID);
            if (0 <= id && id <= 4095) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isValidDomainName(String domainName) {
        Pattern special = Pattern.compile("[,;&'\"<>\\\\=$|^?*~`()\\[\\]\\{\\}#%!]");
        if (special.matcher(domainName).matches()) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,24}$");
        return pattern.matcher(domainName).matches();
    }
}

