/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.NewVersionUpdateInterface;
import com.supermicro.redfish.AuthClient;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.PatternSyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class NewVersionUpdateControl {
    private NewVersionUpdateInterface listener;
    private boolean isDownloadTaskCancel;
    private boolean isSkipDownloadForDebug = false;
    private String fileURL;
    private String filePath;
    private String fileVersion;

    public NewVersionUpdateControl(NewVersionUpdateInterface callback) {
        this.listener = callback;
    }

    public void download(boolean isWindows) {
        this.listener.updateState(1, "0");
        this.isDownloadTaskCancel = false;
        this.filePath = null;
        new Thread(() -> {
            block7: {
                try {
                    if (this.isDownloadTaskCancel) {
                        this.listener.updateState(5, new String[0]);
                    } else {
                        this.listener.updateState(1, "1");
                        if (this.isSkipDownloadForDebug) {
                            this.filePath = this.getFileDownloadPath(this.fileURL);
                            this.listener.updateState(0, this.filePath);
                        } else {
                            boolean result = this.downloadFile(this.fileURL);
                            if (!result) {
                                this.listener.updateState(2, new String[0]);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!IPMIView20.instance.DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public boolean open(String path) {
        try {
            if (!Desktop.isDesktopSupported()) {
                return false;
            }
            Desktop.getDesktop().open(new File(path));
        }
        catch (IOException e) {
            if (IPMIView20.instance.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName != null ? osName.toLowerCase().contains("windows") : false;
    }

    public void setDownloadTaskCancel() {
        this.isDownloadTaskCancel = true;
    }

    public void cleanDownloadFile() {
        block3: {
            if (this.filePath != null) {
                try {
                    File file = new File(this.filePath);
                    boolean result = file.delete();
                    System.out.println("delete " + this.filePath + " : " + result);
                }
                catch (SecurityException ex) {
                    if (!IPMIView20.instance.DEBUG) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean isNewVersionExists(boolean isWindows) throws Exception {
        int currentVersionInt;
        this.fileURL = this.getFileURL(isWindows);
        String latestVersion = this.getLatestVersion(this.fileURL);
        int lastVersionInt = Integer.valueOf(latestVersion);
        return lastVersionInt > (currentVersionInt = Integer.valueOf(IPMIView20.BuildSeq).intValue());
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    private String getLatestVersion(String location) {
        block6: {
            if (location != null && !location.isEmpty()) {
                String prefix = "IPMIView_";
                String suffixWin = "_Window";
                String suffixLinux = "_bundleJRE";
                int beginIdx = location.indexOf("IPMIView_");
                int endIdx = location.indexOf("_Window");
                if (endIdx < 0) {
                    endIdx = location.indexOf("_bundleJRE");
                }
                try {
                    String fullVersion = location.substring(beginIdx, endIdx);
                    String[] fragment1 = fullVersion.split("_");
                    if (fragment1.length >= 2) {
                        this.fileVersion = fragment1[1];
                        String[] fragment2 = fullVersion.split("\\.");
                        if (fragment2.length > 0) {
                            return fragment2[fragment2.length - 1];
                        }
                    }
                }
                catch (IndexOutOfBoundsException | PatternSyntaxException ex) {
                    if (!IPMIView20.instance.DEBUG) break block6;
                    ex.printStackTrace();
                }
            }
        }
        return "";
    }

    private String getSoftwareItemIDByParser1(String body, String targetPlatform) {
        String versionTokenBegin = "_IPMIView";
        String versionTokenEnd = "</label>";
        String valueTokenBegin = "value=\"";
        String valueTokenEnd = "\"";
        int versionStartLocation = 0;
        int versionEndLocation = 0;
        int valueStartLocation = 0;
        int valueEndLocation = 0;
        String versionToken = "";
        String versionID = "";
        String softwareItemId = "";
        int tryCount = 0;
        int tryCountLimit = 2;
        while (tryCount++ < 2 && softwareItemId.isEmpty()) {
            versionStartLocation = body.indexOf("_IPMIView", versionEndLocation);
            if (versionStartLocation < 0 || (versionEndLocation = body.indexOf("</label>", versionStartLocation)) < 0) continue;
            try {
                versionToken = body.substring(versionStartLocation, versionEndLocation);
            }
            catch (IndexOutOfBoundsException ex) {
                continue;
            }
            valueStartLocation = versionToken.indexOf("value=\"");
            if (valueStartLocation < 0 || (valueEndLocation = versionToken.indexOf("\"", valueStartLocation + "value=\"".length())) < 0) continue;
            try {
                versionID = versionToken.substring(valueStartLocation + "value=\"".length(), valueEndLocation);
                Integer.valueOf(versionID);
                if (!versionToken.toLowerCase().contains(targetPlatform.toLowerCase())) continue;
                softwareItemId = versionID;
                break;
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            }
        }
        return softwareItemId;
    }

    private String getSoftwareItemIDByParser2(String body, String targetPlatform) {
        String softwareItemId = "";
        int offset = 0;
        int nextOffset = 0;
        String application = "IPMIView";
        String fieldName = "id=\"";
        while (offset >= 0 && softwareItemId.isEmpty() && (offset = body.indexOf(targetPlatform, offset)) >= 0 && (nextOffset = body.indexOf(">", offset)) >= 0) {
            block6: {
                try {
                    String[] fieldValueToken;
                    int fieldOffsetEnd;
                    int fieldOffsetStart;
                    String currentToken = body.substring(offset, nextOffset);
                    if (currentToken == null || !currentToken.contains("IPMIView") || !currentToken.contains("id=\"") || (fieldOffsetStart = currentToken.indexOf("id=\"")) < 0 || (fieldOffsetEnd = currentToken.indexOf("\"", fieldOffsetStart + "id=\"".length())) < 0) break block6;
                    String fieldValue = currentToken.substring(fieldOffsetStart + "id=\"".length(), fieldOffsetEnd);
                    for (String token : fieldValueToken = fieldValue.split("_")) {
                        try {
                            softwareItemId = Integer.valueOf(token).toString();
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            offset = nextOffset;
        }
        return softwareItemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileURLByID(String softwareItemID) throws Exception {
        AuthClient client = new AuthClient();
        String url = "https://www.supermicro.com/support/resources/getfile.php?SoftwareItemID=" + softwareItemID + "&type=serversoftwarefile";
        CloseableHttpClient httpClient = client.prepareHttpClient();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = httpClient.execute(httpPost);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 302) {
                Header[] responseHeaders;
                for (Header hdr2 : responseHeaders = response.getAllHeaders()) {
                    if (!hdr2.getName().equalsIgnoreCase("Location")) continue;
                    String string = hdr2.getValue();
                    return string;
                }
            }
            Header[] headerArray = null;
            return headerArray;
        }
        finally {
            response.close();
            httpClient.close();
        }
    }

    private String getFileURL(boolean isWindows) throws Exception {
        String targetURL;
        block6: {
            String body;
            String platformKeyword;
            block5: {
                platformKeyword = isWindows ? "Windows" : "Linux";
                String currentURL = "https://www.supermicro.com/en/support/resources/downloadcenter/smsdownload";
                targetURL = null;
                body = null;
                AuthClient client = new AuthClient();
                CloseableHttpClient httpClient = null;
                try {
                    httpClient = client.prepareHttpClient();
                    CloseableHttpResponse response = null;
                    HttpPost httpPost = new HttpPost(currentURL);
                    response = httpClient.execute(httpPost);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (200 <= statusCode && statusCode <= 210) {
                        body = EntityUtils.toString(response.getEntity());
                    }
                    response.close();
                    httpClient.close();
                }
                catch (Exception e) {
                    if (!IPMIView20.instance.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
            if (body == null) break block6;
            String softwareItemID = null;
            softwareItemID = this.getSoftwareItemIDByParser1(body, platformKeyword);
            if (softwareItemID == null || softwareItemID.isEmpty()) {
                softwareItemID = this.getSoftwareItemIDByParser2(body, platformKeyword);
            }
            if (softwareItemID != null && !softwareItemID.isEmpty()) {
                targetURL = this.getFileURLByID(softwareItemID);
            }
        }
        return targetURL;
    }

    private String getFileDownloadPath(String url) {
        String filename;
        block3: {
            filename = "IPMIView20.zip";
            try {
                String[] token = url.split("/");
                if (token != null && token.length > 0) {
                    filename = token[token.length - 1];
                }
            }
            catch (PatternSyntaxException ex) {
                if (!IPMIView20.instance.DEBUG) break block3;
                ex.printStackTrace();
            }
        }
        String fileSeparator = System.getProperty("file.separator");
        String home = System.getProperty("user.home");
        String path = home + fileSeparator + "Downloads" + fileSeparator + filename;
        return path;
    }

    private boolean downloadFile(String url) throws Exception {
        AuthClient client = new AuthClient();
        CloseableHttpClient httpClient = client.prepareHttpClient();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Content-type", "application/json");
        this.filePath = this.getFileDownloadPath(url);
        CloseableHttpResponse response = httpClient.execute(httpGet);
        long fileSize = 0L;
        if (this.isDownloadTaskCancel) {
            block44: {
                block43: {
                    this.listener.updateState(5, new String[0]);
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        if (!IPMIView20.instance.DEBUG) break block43;
                        e.printStackTrace();
                    }
                }
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    if (!IPMIView20.instance.DEBUG) break block44;
                    e.printStackTrace();
                }
            }
            return true;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        Header[] responseHeaders = response.getAllHeaders();
        HttpEntity entity = response.getEntity();
        for (Header hdr2 : responseHeaders) {
            if (!hdr2.getName().equalsIgnoreCase("Content-Length")) continue;
            fileSize = Integer.valueOf(hdr2.getValue()).intValue();
        }
        if (statusCode < 200 || statusCode > 210) {
            block46: {
                block45: {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        if (!IPMIView20.instance.DEBUG) break block45;
                        e.printStackTrace();
                    }
                }
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    if (!IPMIView20.instance.DEBUG) break block46;
                    e.printStackTrace();
                }
            }
            return false;
        }
        this.listener.updateState(1, "2");
        InputStream inputStream = entity.getContent();
        File file = new File(this.filePath);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            int read = 0;
            byte[] bytes = new byte[8192];
            long current = 0L;
            int lastPercent = 0;
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
                float percent = (float)(current += (long)read) / (float)fileSize * 100.0f;
                if ((int)percent - lastPercent >= 1) {
                    lastPercent = (int)percent;
                    this.listener.updateProgress((int)percent);
                }
                if (!this.isDownloadTaskCancel) continue;
                this.listener.updateState(5, new String[0]);
                new Thread(() -> {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException e) {
                                            if (!IPMIView20.instance.DEBUG) break block10;
                                            e.printStackTrace();
                                        }
                                    }
                                    try {
                                        file.delete();
                                    }
                                    catch (SecurityException e) {
                                        if (!IPMIView20.instance.DEBUG) break block11;
                                        e.printStackTrace();
                                    }
                                }
                                try {
                                    response.close();
                                }
                                catch (IOException e) {
                                    if (!IPMIView20.instance.DEBUG) break block12;
                                    e.printStackTrace();
                                }
                            }
                            try {
                                httpClient.close();
                            }
                            catch (IOException e) {
                                if (!IPMIView20.instance.DEBUG) break block13;
                                e.printStackTrace();
                            }
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            if (!IPMIView20.instance.DEBUG) break block14;
                            e.printStackTrace();
                        }
                    }
                }).start();
                boolean bl = true;
                return bl;
            }
            this.listener.updateState(0, this.filePath);
        }
        catch (IOException ex) {
            throw new RuntimeException("error writing zip file, error message : " + ex.getMessage(), ex);
        }
        finally {
            block51: {
                block50: {
                    block49: {
                        block48: {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                if (!IPMIView20.instance.DEBUG) break block48;
                                e.printStackTrace();
                            }
                        }
                        try {
                            response.close();
                        }
                        catch (IOException e) {
                            if (!IPMIView20.instance.DEBUG) break block49;
                            e.printStackTrace();
                        }
                    }
                    try {
                        httpClient.close();
                    }
                    catch (IOException e) {
                        if (!IPMIView20.instance.DEBUG) break block50;
                        e.printStackTrace();
                    }
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!IPMIView20.instance.DEBUG) break block51;
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

