/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ComboTabListener;
import IPMIView20.ExpandableComponent;
import IPMIView20.IPMIView20;
import IPMIView20.ToggleSwitch;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.Dimension;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RAKPPanel
extends ExpandableComponent {
    private ToggleSwitch rakpToggleSwitch = new ToggleSwitch();
    private JLabel rakpLable = new JLabel();
    private JPanel bodyPanel = new JPanel();
    private JLabel externalBottomMessage = null;
    private final int THREAD_POOL_MAXIMUN = 1;
    private ThreadPoolExecutor excutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private IPMIInterfaceConfig interfaceConfig = null;
    private ComboTabListener comboTabListener = null;

    public RAKPPanel() {
        this.init();
    }

    public void init() {
        this.setHeaderText("SMC RAKP");
        this.rakpLable.setText("Current RAKP Status");
        this.bodyPanel.setLayout(new BoxLayout(this.bodyPanel, 0));
        this.bodyPanel.add(Box.createHorizontalStrut(40));
        this.bodyPanel.add(this.rakpLable);
        this.bodyPanel.add(Box.createHorizontalStrut(10));
        this.bodyPanel.add(this.rakpToggleSwitch);
        this.bodyPanel.add(Box.createHorizontalGlue());
        this.rakpToggleSwitch.setMinimumSize(new Dimension(57, 20));
        this.rakpToggleSwitch.setMaximumSize(new Dimension(57, 20));
        this.rakpToggleSwitch.setPreferredSize(new Dimension(57, 20));
        super.setBodyComponet(this.bodyPanel, 60);
        this.rakpToggleSwitch.addActionListenser(e -> new Thread(() -> SwingUtilities.invokeLater(() -> {
            Object[] confirms = new Object[]{"Yes", "No"};
            String confirmationMessage = "Are you sure you want to change RAKP mode?\r\n\r\nIf RAKP mode is changed, session will be disconnected.\r\nYou have to reconnect with new RAKP mode later.";
            int result = JOptionPane.showOptionDialog(IPMIView20.getInstance(), confirmationMessage, "", 2, 2, null, confirms, confirms[1]);
            if (result == 0) {
                this.setRakpMode(e, true);
            } else {
                this.reload();
            }
        })).start());
    }

    public void setIPMIConfig(IPMIInterfaceConfig config) {
        this.interfaceConfig = config;
    }

    public void setTabListener(ComboTabListener listener) {
        this.comboTabListener = listener;
    }

    public void setBottomMessage(JLabel label) {
        this.externalBottomMessage = label;
    }

    public void reload() {
        this.setComponetLocked(true);
        this.getRakpMode();
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        super.setExpanded(isExpanded);
    }

    @Override
    protected void setComponetLocked(boolean locked) {
        super.setComponetLocked(locked);
        this.rakpToggleSwitch.setEnabled(!locked);
    }

    private void getRakpMode() {
        this.excutor.submit(() -> {
            ISessionController sessionController;
            block11: {
                sessionController = null;
                if (this.interfaceConfig == null) {
                    this.comboTabListener.toolbarStatus(0, new int[0]);
                } else if (this.interfaceConfig.getPrivilege() != 4) {
                    this.comboTabListener.toolbarStatus(0, new int[0]);
                    this.comboTabListener.toolbarStatus(3, 4);
                    this.externalBottomMessage.setText("Insufficient privilege to access RAKP mode");
                    this.rakpToggleSwitch.setActivated(false);
                    this.rakpToggleSwitch.setEnabled(false);
                } else {
                    IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
                    sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, ipmiOEMCommand, 10);
                    if (sessionController == null) {
                        if (IPMIView20.showException) {
                            System.out.println("createSessionControlle fail in RAKP panel");
                        }
                        this.comboTabListener.toolbarStatus(0, new int[0]);
                    } else {
                        boolean isEnabled;
                        try {
                            isEnabled = ipmiOEMCommand.isSMCRakpEnabled();
                        }
                        catch (IPMIException e) {
                            if (IPMIView20.showException) {
                                e.printStackTrace();
                            }
                            this.comboTabListener.toolbarStatus(0, new int[0]);
                            break block11;
                        }
                        this.externalBottomMessage.setText("Get RAKP mode done");
                        this.rakpToggleSwitch.setActivated(isEnabled);
                        this.setComponetLocked(false);
                        this.comboTabListener.toolbarStatus(0, new int[0]);
                        sessionController.closeSession();
                    }
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    private void setRakpMode(boolean enable, boolean disconnect) {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            if (this.interfaceConfig != null) {
                IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
                sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, ipmiOEMCommand, 10);
                if (sessionController == null) {
                    if (IPMIView20.showException) {
                        System.out.println("createSessionControlle fail in RAKP panel");
                    }
                } else {
                    block8: {
                        try {
                            boolean result = ipmiOEMCommand.setSMCRakpMode(enable);
                            this.externalBottomMessage.setText((enable ? "Enable" : "Disable") + " RAKP " + (result ? "successful" : "failed"));
                        }
                        catch (Exception e) {
                            if (!IPMIView20.showException) break block8;
                            System.out.println("RAKP mode has changed, original session is losed.");
                        }
                    }
                    sessionController.closeSession();
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
            if (disconnect) {
                SwingUtilities.invokeLater(() -> {
                    if (IPMIView20.getInstance().smcRAKPConfigAccessor != null) {
                        if (enable) {
                            IPMIView20.getInstance().smcRAKPConfigAccessor.setProperty(this.interfaceConfig.getIp(), "on");
                        } else {
                            IPMIView20.getInstance().smcRAKPConfigAccessor.removeProperty(this.interfaceConfig.getIp());
                        }
                    }
                    IPMIView20.getInstance().closeInactivatelySession();
                });
            }
        });
    }
}

