/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class RMCP {
    RMCPHeader Header = new RMCPHeader();
    SessionHeader HSession = new SessionHeader();
    IPMIMessage IMessage = new IPMIMessage();
    SOLMessage solMessage = new SOLMessage();
    ASFMessage ASFMsg = new ASFMessage();
    byte compeletecode;
    CSession Session;
    Vector retValue = new Vector(1);
    GlobalDefine gd = new GlobalDefine();

    public void RMCPSetup(byte ClassMsg, byte NetFn, byte CmdFn, byte RqSa, Vector pPara, CSession iSession, byte[] rawData, int[] length) {
        this.retValue.removeAllElements();
        this.Header.init(ClassMsg);
        this.Session = iSession;
        if (ClassMsg == 7) {
            this.HSession.init(pPara);
            this.IMessage.MessageCmd(NetFn, CmdFn, RqSa);
            this.IMessage.MessageData(pPara);
            this.IMessage.Data[this.IMessage.DataPointer] = this.IMessage.checksum2();
            switch (this.HSession.AuthType) {
                case 5: {
                    this.EncryptOEM();
                    System.arraycopy(this.Session.ChallengeStringData, 0, this.HSession.AuthCode, 0, 16);
                    break;
                }
                case 2: {
                    this.EncryptMD5();
                    System.arraycopy(this.Session.ChallengeStringData, 0, this.HSession.AuthCode, 0, 16);
                }
            }
        } else {
            this.ASFMsg.MessageData();
        }
        length[0] = this.Encode(rawData);
    }

    public void RMCPSOLSetup(Vector pPara, Vector solPara, CSession iSession, byte[] rawData, int[] length) {
        this.retValue.removeAllElements();
        this.Session = iSession;
        this.HSession.init(pPara);
        this.solMessage.init(solPara);
        this.EncryptSOLMD5();
        System.arraycopy(this.Session.ChallengeStringData, 0, this.HSession.AuthCode, 0, 16);
        length[0] = this.SOLEncode(rawData);
    }

    public int Encode(byte[] rawData) {
        int xPoint = 0;
        rawData[xPoint++] = this.Header.Version;
        rawData[xPoint++] = this.Header.Reserved;
        rawData[xPoint++] = this.Header.RMCPSeqNum;
        rawData[xPoint++] = this.Header.ClassOfMesg;
        if (this.Header.ClassOfMesg == 7) {
            rawData[xPoint++] = this.HSession.AuthType;
            System.arraycopy(this.HSession.SessionSeq, 0, rawData, xPoint, 4);
            System.arraycopy(this.HSession.SessionID, 0, rawData, xPoint += 4, 4);
            xPoint += 4;
            if (this.HSession.AuthType != 0) {
                System.arraycopy(this.HSession.AuthCode, 0, rawData, xPoint, 16);
                xPoint += 16;
            }
            rawData[xPoint] = (byte)this.IMessage.size();
            rawData[xPoint + 1] = this.IMessage.rsSA;
            rawData[xPoint + 2] = this.IMessage.NetFnLun;
            rawData[xPoint + 3] = this.IMessage.checksum1;
            rawData[xPoint + 4] = this.IMessage.rqSA;
            rawData[xPoint + 5] = this.IMessage.rqSeqLun;
            rawData[xPoint + 6] = this.IMessage.cmd;
            rawData[xPoint + 7 + this.IMessage.DataPointer] = this.IMessage.checksum2();
            System.arraycopy(this.IMessage.Data, 0, rawData, xPoint + 7, this.IMessage.DataPointer);
            if (this.HSession.AuthType != 0) {
                return this.IMessage.size() + 14 + 16;
            }
            return this.IMessage.size() + 14;
        }
        System.arraycopy(this.ASFMsg.IANAnum, 0, rawData, xPoint, 4);
        xPoint += 4;
        rawData[xPoint++] = this.ASFMsg.messagetype;
        rawData[xPoint++] = this.ASFMsg.messagetag;
        rawData[xPoint++] = this.ASFMsg.reserved;
        rawData[xPoint++] = this.ASFMsg.datalength;
        return this.ASFMsg.size() + this.Header.size();
    }

    public int SOLEncode(byte[] rawData) {
        int xPoint = 0;
        rawData[xPoint++] = this.Header.Version;
        rawData[xPoint++] = this.Header.Reserved;
        rawData[xPoint++] = this.Header.RMCPSeqNum;
        rawData[xPoint++] = this.Header.ClassOfMesg;
        rawData[xPoint++] = this.HSession.AuthType;
        System.arraycopy(this.HSession.SessionSeq, 0, rawData, xPoint, 4);
        System.arraycopy(this.HSession.SessionID, 0, rawData, xPoint += 4, 4);
        xPoint += 4;
        if (this.HSession.AuthType != 0) {
            System.arraycopy(this.HSession.AuthCode, 0, rawData, xPoint, 16);
            xPoint += 16;
        }
        rawData[xPoint] = (byte)this.solMessage.size();
        System.arraycopy(this.solMessage.getContent(), 0, rawData, ++xPoint, this.solMessage.size());
        return 30 + this.solMessage.size();
    }

    public void ResolvePacket(byte[] recvBuf, int authcodeflag, int recvLength) {
        byte Cmd;
        byte NetFn;
        int length;
        int DataOffset;
        if (recvBuf == null) {
            return;
        }
        byte[] Byte2 = new byte[1];
        byte[] Byte3 = new byte[1];
        byte[] Byte32 = new byte[2];
        byte[] Byte4 = new byte[1];
        byte[] Byte5 = new byte[1];
        byte[] Byte6 = new byte[1];
        byte[] Byte7 = new byte[1];
        byte[] Byte8 = new byte[3];
        byte[] Byte11 = new byte[2];
        byte[] Byte13 = new byte[4];
        byte[] Byte16 = new byte[16];
        byte[] Byte41 = new byte[4];
        byte[] Byte42 = new byte[4];
        if (authcodeflag == 1) {
            DataOffset = 35;
            this.compeletecode = recvBuf[DataOffset + 1];
            length = recvBuf[29] & 0xFF;
            NetFn = recvBuf[31];
            Cmd = recvBuf[35];
        } else {
            DataOffset = 19;
            this.compeletecode = recvBuf[DataOffset + 1];
            length = recvBuf[13] & 0xFF;
            NetFn = recvBuf[15];
            Cmd = recvBuf[19];
        }
        if (NetFn == 36) {
            if (Cmd == 48) {
                if (this.compeletecode == 0 && length - 9 > 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    if (length - 9 - 2 > 0) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        out.write(recvBuf, DataOffset + 4, length - 9 - 2);
                        String xString = out.toString();
                        this.retValue.addElement(new String(xString));
                    }
                }
            } else if (Cmd == 49 && this.compeletecode == 0) {
                String xString;
                if (length - 9 > 0) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    out.write(recvBuf, DataOffset + 2, length - 9);
                    xString = out.toString();
                } else {
                    xString = "<undefined>";
                }
                this.retValue.addElement(new String(xString));
            }
        } else if (NetFn == 28) {
            if (Cmd == 57) {
                byte[] tempSession = new byte[4];
                byte[] ChallengeStringData = new byte[16];
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, tempSession, 0, 4);
                    this.retValue.addElement(tempSession);
                    System.arraycopy(recvBuf, DataOffset + 6, ChallengeStringData, 0, 16);
                    this.retValue.addElement(ChallengeStringData);
                }
            } else if (Cmd == 55) {
                byte[] bytes = new byte[16];
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, bytes, 0, 16);
                    this.retValue.addElement(bytes);
                }
            } else if (Cmd == 56) {
                byte[] channelNumber = new byte[1];
                byte[] AuthenticationTypeSupport = new byte[1];
                byte[] byte4 = new byte[1];
                byte[] byte5 = new byte[1];
                byte[] byte68 = new byte[3];
                byte[] byte9 = new byte[1];
                System.arraycopy(recvBuf, DataOffset + 2, channelNumber, 0, 1);
                this.retValue.addElement(channelNumber);
                System.arraycopy(recvBuf, DataOffset + 3, AuthenticationTypeSupport, 0, 1);
                this.retValue.addElement(AuthenticationTypeSupport);
                System.arraycopy(recvBuf, DataOffset + 4, byte4, 0, 1);
                this.retValue.addElement(byte4);
                System.arraycopy(recvBuf, DataOffset + 5, byte5, 0, 1);
                this.retValue.addElement(byte5);
                System.arraycopy(recvBuf, DataOffset + 6, byte68, 0, 3);
                this.retValue.addElement(byte68);
                System.arraycopy(recvBuf, DataOffset + 9, byte9, 0, 1);
                this.retValue.addElement(byte9);
            } else if (Cmd == 58) {
                byte[] AuthType = new byte[1];
                byte[] SessionID = new byte[4];
                byte[] SessionSeq = new byte[4];
                byte[] OutboundSessionSeq = new byte[4];
                byte[] MaxLevel = new byte[1];
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, AuthType, 0, 1);
                    this.retValue.addElement(AuthType);
                    System.arraycopy(recvBuf, DataOffset + 3, SessionID, 0, 4);
                    this.retValue.addElement(SessionID);
                    System.arraycopy(recvBuf, DataOffset + 7, SessionSeq, 0, 4);
                    this.retValue.addElement(SessionSeq);
                    System.arraycopy(recvBuf, DataOffset + 11, MaxLevel, 0, 1);
                    this.retValue.addElement(MaxLevel);
                    System.arraycopy(recvBuf, 1, OutboundSessionSeq, 0, 4);
                    this.retValue.addElement(SessionSeq);
                }
            } else if (Cmd == 61) {
                byte[] data = new byte[6];
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, data, 0, 6);
                    this.retValue.addElement(data);
                }
            } else if (Cmd == 59) {
                byte[] MaxLevel = new byte[1];
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, MaxLevel, 0, 1);
                    this.retValue.addElement(MaxLevel);
                }
            } else if (Cmd == 1) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    this.retValue.addElement(Byte2);
                    System.arraycopy(recvBuf, DataOffset + 3, Byte3, 0, 1);
                    this.retValue.addElement(Byte3);
                    System.arraycopy(recvBuf, DataOffset + 4, Byte4, 0, 1);
                    this.retValue.addElement(Byte4);
                    System.arraycopy(recvBuf, DataOffset + 5, Byte5, 0, 1);
                    this.retValue.addElement(Byte5);
                    System.arraycopy(recvBuf, DataOffset + 6, Byte6, 0, 1);
                    this.retValue.addElement(Byte6);
                    System.arraycopy(recvBuf, DataOffset + 7, Byte7, 0, 1);
                    this.retValue.addElement(Byte7);
                    System.arraycopy(recvBuf, DataOffset + 8, Byte8, 0, 3);
                    this.retValue.addElement(Byte8);
                    System.arraycopy(recvBuf, DataOffset + 11, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    System.arraycopy(recvBuf, DataOffset + 13, Byte13, 0, 4);
                    this.retValue.addElement(Byte13);
                }
            } else if (Cmd != 2) {
                if (Cmd != 3) {
                    if (Cmd == 4) {
                        if (this.compeletecode == 0) {
                            System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                            this.retValue.addElement(Byte2);
                            System.arraycopy(recvBuf, DataOffset + 3, Byte3, 0, 1);
                            this.retValue.addElement(Byte3);
                        }
                    } else if (Cmd == 7) {
                        if (this.compeletecode == 0) {
                            System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                            this.retValue.addElement(Byte2);
                            System.arraycopy(recvBuf, DataOffset + 3, Byte3, 0, 1);
                            this.retValue.addElement(Byte3);
                        }
                    } else if (Cmd == 8) {
                        if (this.compeletecode == 0) {
                            System.arraycopy(recvBuf, DataOffset + 2, Byte16, 0, 16);
                            this.retValue.addElement(Byte16);
                        }
                    } else if (Cmd == 68) {
                        if (this.compeletecode == 0) {
                            System.arraycopy(recvBuf, DataOffset + 2, Byte41, 0, 4);
                            this.retValue.addElement(Byte41);
                        }
                    } else if (Cmd == 70) {
                        if (this.compeletecode == 0) {
                            System.arraycopy(recvBuf, DataOffset + 2, Byte16, 0, 16);
                            this.retValue.addElement(Byte16);
                        }
                    } else if (Cmd == 84) {
                        byte[] channelNumber = new byte[1];
                        byte[] cipherSuiteRecord = new byte[16];
                        System.arraycopy(recvBuf, DataOffset + 2, channelNumber, 0, 1);
                        System.arraycopy(recvBuf, DataOffset + 3, cipherSuiteRecord, 0, 16);
                        this.retValue.addElement(channelNumber);
                        this.retValue.addElement(cipherSuiteRecord);
                    } else if (Cmd == 77) {
                        System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                        System.arraycopy(recvBuf, DataOffset + 3, Byte3, 0, 1);
                        System.arraycopy(recvBuf, DataOffset + 4, Byte4, 0, 1);
                        System.arraycopy(recvBuf, DataOffset + 5, Byte5, 0, 1);
                        this.retValue.addElement(Byte2);
                        this.retValue.addElement(Byte3);
                        this.retValue.addElement(Byte4);
                        this.retValue.addElement(Byte5);
                    }
                }
            }
        } else if (NetFn == 44) {
            if (Cmd == 64) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    this.retValue.addElement(Byte2);
                    System.arraycopy(recvBuf, DataOffset + 3, Byte32, 0, 2);
                    this.retValue.addElement(Byte32);
                    System.arraycopy(recvBuf, DataOffset + 5, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    System.arraycopy(recvBuf, DataOffset + 7, Byte41, 0, 4);
                    this.retValue.addElement(Byte41);
                    System.arraycopy(recvBuf, DataOffset + 11, Byte42, 0, 4);
                    this.retValue.addElement(Byte42);
                    System.arraycopy(recvBuf, DataOffset + 15, Byte3, 0, 1);
                    this.retValue.addElement(Byte3);
                }
            } else if (Cmd == 67) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    System.arraycopy(recvBuf, DataOffset + 4, Byte16, 0, 16);
                    this.retValue.addElement(Byte16);
                }
            } else if (Cmd == 72) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte41, 0, 4);
                    this.retValue.addElement(Byte41);
                }
            } else if (Cmd == 32) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    this.retValue.addElement(Byte2);
                    System.arraycopy(recvBuf, DataOffset + 3, Byte32, 0, 2);
                    this.retValue.addElement(Byte32);
                    System.arraycopy(recvBuf, DataOffset + 5, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    System.arraycopy(recvBuf, DataOffset + 7, Byte41, 0, 4);
                    this.retValue.addElement(Byte41);
                    System.arraycopy(recvBuf, DataOffset + 11, Byte42, 0, 4);
                    this.retValue.addElement(Byte42);
                    System.arraycopy(recvBuf, DataOffset + 15, Byte3, 0, 1);
                    this.retValue.addElement(Byte3);
                }
            } else if (Cmd == 40) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte41, 0, 4);
                    this.retValue.addElement(Byte41);
                }
            } else if (Cmd == 35) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    byte[] ByteN = new byte[length - 6 - 4];
                    System.arraycopy(recvBuf, DataOffset + 4, ByteN, 0, length - 6 - 4);
                    this.retValue.addElement(ByteN);
                }
            } else if (Cmd == 34) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                }
            } else if (Cmd == 66) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                }
            } else if (Cmd == 70) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                }
            } else if (Cmd == 71) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    this.retValue.addElement(Byte2);
                }
            } else if (Cmd == 16) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    System.arraycopy(recvBuf, DataOffset + 3, Byte3, 0, 1);
                    System.arraycopy(recvBuf, DataOffset + 4, Byte4, 0, 1);
                    this.retValue.addElement(Byte2);
                    this.retValue.addElement(Byte3);
                    this.retValue.addElement(Byte4);
                }
            } else if (Cmd == 17 && this.compeletecode == 0) {
                System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                byte dataLength = Byte2[0];
                byte[] requestData = new byte[dataLength];
                System.arraycopy(recvBuf, DataOffset + 3, requestData, 0, dataLength);
                this.retValue.addElement(Byte2);
                this.retValue.addElement(requestData);
            }
        } else if (NetFn == 20) {
            if (Cmd == 33) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte11, 0, 2);
                    this.retValue.addElement(Byte11);
                    byte[] ByteN = new byte[length - 6 - 4];
                    System.arraycopy(recvBuf, DataOffset + 4, ByteN, 0, length - 6 - 4);
                    this.retValue.addElement(ByteN);
                }
            } else if (Cmd == 45) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte41, 0, 4);
                    this.retValue.addElement(Byte41);
                    byte[] ByteN = new byte[length - 6 - 2];
                    System.arraycopy(recvBuf, DataOffset + 4, ByteN, 0, length - 6 - 2);
                    this.retValue.addElement(ByteN);
                }
            } else if (Cmd == 40) {
                // empty if block
            }
        } else if (NetFn == 52) {
            if (Cmd == 2) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    this.retValue.addElement(Byte2);
                    byte[] ByteN = new byte[length - 6 - 3];
                    System.arraycopy(recvBuf, DataOffset + 3, ByteN, 0, length - 6 - 3);
                    this.retValue.addElement(ByteN);
                }
            } else if (Cmd == 4) {
                if (this.compeletecode == 0) {
                    byte[] ByteN1 = new byte[18];
                    System.arraycopy(recvBuf, DataOffset + 2, ByteN1, 0, 18);
                    this.retValue.addElement(ByteN1);
                }
            } else if (Cmd == 34 && this.compeletecode == 0) {
                byte[] twoByte = new byte[2];
                System.arraycopy(recvBuf, DataOffset + 2, twoByte, 0, 2);
                this.retValue.addElement(twoByte);
            }
        } else if (NetFn == -60) {
            if (Cmd == 12) {
                if (this.compeletecode == 0) {
                    System.arraycopy(recvBuf, DataOffset + 2, Byte2, 0, 1);
                    this.retValue.addElement(Byte2);
                    System.arraycopy(recvBuf, DataOffset + 3, Byte3, 0, 1);
                    this.retValue.addElement(Byte3);
                }
            } else if (Cmd == 33) {
                if (this.compeletecode == 0) {
                    byte[] byte10 = new byte[8];
                    System.arraycopy(recvBuf, DataOffset + 2, byte10, 0, 8);
                    this.retValue.addElement(byte10);
                }
            } else if (Cmd == 16) {
                if (this.compeletecode == 0) {
                    byte[] byte1 = new byte[1];
                    System.arraycopy(recvBuf, DataOffset + 2, byte1, 0, 1);
                    this.retValue.addElement(byte1);
                }
            } else if (Cmd == -120) {
                if (this.compeletecode == 0) {
                    byte[] byte1 = new byte[1];
                    System.arraycopy(recvBuf, DataOffset + 2, byte1, 0, 1);
                    this.retValue.addElement(byte1);
                }
            } else if (Cmd == 20) {
                if (this.compeletecode == 0) {
                    byte[] byte1 = new byte[4];
                    System.arraycopy(recvBuf, DataOffset + 2, byte1, 0, 4);
                    this.retValue.addElement(byte1);
                }
            } else if (Cmd == -121) {
                if (this.compeletecode == 0) {
                    byte[] byte1 = new byte[1];
                    System.arraycopy(recvBuf, DataOffset + 2, byte1, 0, 1);
                    this.retValue.addElement(byte1);
                }
            } else if (Cmd == 39) {
                if (this.compeletecode == 0) {
                    byte[] byte1 = new byte[1];
                    System.arraycopy(recvBuf, DataOffset + 2, byte1, 0, 1);
                    this.retValue.addElement(byte1);
                }
            } else if (Cmd == 41 && this.compeletecode == 0) {
                byte[] byte1 = new byte[1];
                System.arraycopy(recvBuf, DataOffset + 2, byte1, 0, 1);
                this.retValue.addElement(byte1);
            }
        }
    }

    public void RMCPPong(byte[] recvBuf) {
        int DataOffset = 20;
        this.compeletecode = recvBuf[DataOffset];
    }

    private void EncryptOEM() {
        byte[] h = new byte[16];
        byte[] pppwd = new byte[this.Session.PasswordLength];
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            System.arraycopy(this.Session.UserPassword, 0, pppwd, 0, this.Session.PasswordLength);
            algorithm.update(pppwd);
            byte[] digest = algorithm.digest();
            for (int i = 0; i < 16; ++i) {
                h[i] = (byte)(this.Session.ChallengeStringData[i] ^ digest[i]);
            }
            algorithm.reset();
            algorithm.update(h);
            digest = algorithm.digest();
            System.arraycopy(digest, 0, this.Session.ChallengeStringData, 0, 16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void EncryptMD5() {
        byte[] tmpBuff = new byte[20 + this.IMessage.size() + 4 + 16];
        int tmpInx = 0;
        System.arraycopy(this.Session.UserPassword, 0, tmpBuff, tmpInx, this.Session.PasswordLength);
        System.arraycopy(this.Session.SessionID, 0, tmpBuff, tmpInx += 16, 4);
        tmpInx += 4;
        tmpBuff[tmpInx++] = this.IMessage.rsSA;
        tmpBuff[tmpInx++] = this.IMessage.NetFnLun;
        tmpBuff[tmpInx++] = this.IMessage.checksum1;
        tmpBuff[tmpInx++] = this.IMessage.rqSA;
        tmpBuff[tmpInx++] = this.IMessage.rqSeqLun;
        tmpBuff[tmpInx++] = this.IMessage.cmd;
        System.arraycopy(this.IMessage.Data, 0, tmpBuff, tmpInx, this.IMessage.size() - 6);
        System.arraycopy(this.Session.SessionSeq, 0, tmpBuff, tmpInx += this.IMessage.size() - 6, 4);
        System.arraycopy(this.Session.UserPassword, 0, tmpBuff, tmpInx += 4, this.Session.PasswordLength);
        tmpInx += 16;
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(tmpBuff);
            byte[] digest = algorithm.digest();
            System.arraycopy(digest, 0, this.Session.ChallengeStringData, 0, 16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void EncryptSOLMD5() {
        byte[] tmpBuff = new byte[20 + this.solMessage.size() + 4 + 16];
        int tmpInx = 0;
        System.arraycopy(this.Session.UserPassword, 0, tmpBuff, tmpInx, this.Session.PasswordLength);
        System.arraycopy(this.Session.SessionID, 0, tmpBuff, tmpInx += 16, 4);
        System.arraycopy(this.solMessage.getContent(), 0, tmpBuff, tmpInx += 4, this.solMessage.size());
        System.arraycopy(this.Session.SessionSeq, 0, tmpBuff, tmpInx += this.solMessage.size(), 4);
        System.arraycopy(this.Session.UserPassword, 0, tmpBuff, tmpInx += 4, this.Session.PasswordLength);
        tmpInx += 16;
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(tmpBuff);
            byte[] digest = algorithm.digest();
            System.arraycopy(digest, 0, this.Session.ChallengeStringData, 0, 16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static void main1(String[] argv) {
        String password = "admin";
        byte[] sessionID = new byte[]{0, 44, 0, 2};
        byte[] sessionSeq = new byte[]{-17, 0, 0, 0};
        byte[] content = new byte[]{5, 0, 0, 0, 104};
        byte[] tmpBuff = new byte[45];
        int tmpInx = 0;
        System.arraycopy(password.getBytes(), 0, tmpBuff, tmpInx, password.length());
        System.arraycopy(sessionID, 0, tmpBuff, tmpInx += 16, 4);
        System.arraycopy(content, 0, tmpBuff, tmpInx += 4, 5);
        System.arraycopy(sessionSeq, 0, tmpBuff, tmpInx += 5, 4);
        System.arraycopy(password.getBytes(), 0, tmpBuff, tmpInx += 4, password.length());
        tmpInx += 16;
        for (int i = 0; i < tmpBuff.length; ++i) {
            System.out.println(Integer.toHexString(tmpBuff[i]));
        }
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(tmpBuff);
            byte[] digest = algorithm.digest();
            for (int i = 0; i < digest.length; ++i) {
                System.out.println(Integer.toHexString(digest[i]));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        String password = "admin";
        byte[] sessionID = new byte[]{1, -68, 0, 2};
        byte[] sessionSeq = new byte[]{4, 0, 0, 0};
        byte[] content = new byte[]{0, 1, 1, 0};
        byte[] tmpBuff = new byte[44];
        int tmpInx = 0;
        System.arraycopy(password.getBytes(), 0, tmpBuff, tmpInx, password.length());
        System.arraycopy(sessionID, 0, tmpBuff, tmpInx += 16, 4);
        System.arraycopy(content, 0, tmpBuff, tmpInx += 4, 4);
        System.arraycopy(sessionSeq, 0, tmpBuff, tmpInx += 4, 4);
        System.arraycopy(password.getBytes(), 0, tmpBuff, tmpInx += 4, password.length());
        tmpInx += 16;
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(tmpBuff);
            byte[] digest = algorithm.digest();
            for (int i = 0; i < digest.length; ++i) {
                System.out.println(Integer.toHexString(digest[i]));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public class ASFMessage {
        byte[] IANAnum = new byte[4];
        byte messagetype;
        byte messagetag;
        byte reserved;
        byte datalength;

        public void MessageData() {
            this.IANAnum[0] = 0;
            this.IANAnum[1] = 0;
            this.IANAnum[2] = 17;
            this.IANAnum[3] = -66;
            this.messagetype = (byte)-128;
            this.messagetag = 0;
            this.reserved = 0;
            this.datalength = 0;
        }

        public int size() {
            return 8;
        }
    }

    public class IPMIMessage {
        byte rsSA;
        byte NetFnLun;
        byte checksum1;
        byte rqSA;
        byte rqSeqLun;
        byte cmd;
        byte[] Data = new byte[256];
        int DataPointer = 0;

        public void MessageCmd(byte NetFn, byte CmdFN, byte RqSa) {
            this.rsSA = (byte)32;
            this.NetFnLun = NetFn;
            this.checksum1 = (byte)(256 - (32 + NetFn));
            this.rqSA = RqSa;
            this.rqSeqLun = 0;
            this.cmd = CmdFN;
        }

        public void MessageData(Vector pPara) {
            int i;
            this.DataPointer = 0;
            for (i = 0; i < 256; ++i) {
                this.Data[i] = 0;
            }
            for (i = 3; i < pPara.size(); ++i) {
                String classname = pPara.get(i).getClass().getName();
                if (classname.compareTo("java.lang.String") == 0) {
                    int len = ((String)pPara.get(i)).length();
                    byte[] bytes = ((String)pPara.get(i)).getBytes();
                    System.arraycopy(bytes, 0, this.Data, this.DataPointer, len);
                    this.DataPointer += len;
                    this.Data[this.DataPointer++] = 0;
                    continue;
                }
                if (classname.compareTo("java.lang.Integer") == 0) {
                    Integer bytes = (Integer)pPara.get(i);
                    this.Data[this.DataPointer] = bytes.byteValue();
                    ++this.DataPointer;
                    this.Data[this.DataPointer++] = 0;
                    continue;
                }
                if (classname.compareTo("[B") != 0) continue;
                byte[] bytes = (byte[])pPara.get(i);
                int len = bytes.length;
                System.arraycopy(bytes, 0, this.Data, this.DataPointer, len);
                this.DataPointer += len;
            }
        }

        public byte checksum2() {
            byte csum = (byte)(this.rqSA + this.rqSeqLun + this.cmd);
            for (int i = 0; i < this.DataPointer; ++i) {
                csum = (byte)(csum + this.Data[i]);
            }
            return -csum;
        }

        public int size() {
            return 7 + this.DataPointer;
        }
    }

    public class SOLMessage {
        byte seq;
        byte ackSeq;
        byte acceptedCharCount;
        byte operation;
        byte[] data;

        public int size() {
            return 4 + this.data.length;
        }

        public byte[] getContent() {
            byte[] retData = new byte[this.size()];
            retData[0] = this.seq;
            retData[1] = this.ackSeq;
            retData[2] = this.acceptedCharCount;
            retData[3] = this.operation;
            if (this.data.length > 0) {
                System.arraycopy(this.data, 0, retData, 4, this.data.length);
            }
            return retData;
        }

        public void init(Vector pPara) {
            this.seq = ((byte[])pPara.get(0))[0];
            this.ackSeq = ((byte[])pPara.get(1))[0];
            this.acceptedCharCount = ((byte[])pPara.get(2))[0];
            this.operation = ((byte[])pPara.get(3))[0];
            this.data = (byte[])pPara.get(4);
        }
    }

    public class SessionHeader {
        byte AuthType = 0;
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] AuthCode = new byte[16];

        public void init(Vector pPara) {
            byte[] bytes = (byte[])pPara.get(0);
            this.AuthType = bytes[0];
            bytes = (byte[])pPara.get(1);
            System.arraycopy(bytes, 0, this.SessionSeq, 0, 4);
            bytes = (byte[])pPara.get(2);
            System.arraycopy(bytes, 0, this.SessionID, 0, 4);
        }
    }

    public class RMCPHeader {
        byte Version = (byte)6;
        byte Reserved = 0;
        byte RMCPSeqNum = (byte)-1;
        byte ClassOfMesg;

        public void init(byte ClassMsg) {
            this.Version = (byte)6;
            this.Reserved = 0;
            this.RMCPSeqNum = (byte)-1;
            this.ClassOfMesg = ClassMsg;
        }

        public void init() {
            this.init((byte)7);
        }

        public int size() {
            return 4;
        }

        public byte[] rawData() {
            byte[] raw = new byte[]{this.Version, this.Reserved, this.RMCPSeqNum, this.ClassOfMesg};
            return raw;
        }
    }
}

