/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CMMSessionMessageBarPanel;
import IPMIView20.CMMSessionPanel;
import IPMIView20.L;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeEntity;
import javax.swing.JOptionPane;

class ReducePowerProblem
implements CMMSessionMessageBarPanel.ProblemSolve {
    CMMSessionPanel sessionPanel;
    String helpContent = L.t("cmm.session.ReducePowerProblem");

    public ReducePowerProblem(CMMSessionPanel sessionPanel) {
        this.sessionPanel = sessionPanel;
    }

    public boolean check() {
        boolean checkResult = false;
        for (int i = 0; i < this.sessionPanel.bladeSystemEntity.getBlades().length; ++i) {
            BladeEntity blade = this.sessionPanel.bladeSystemEntity.getBlades()[i];
            if (blade.getPresent() == 0 || !blade.isReducedPower() || blade.getI2cError() != 0) continue;
            checkResult = true;
            break;
        }
        if (checkResult) {
            this.sessionPanel.sessionMessageBarPanel.setOnlyMessage(false);
            this.sessionPanel.sessionMessageBarPanel.setMessage(L.t("cmm.session.reduced_mode"));
            this.sessionPanel.sessionMessageBarPanel.setHelpContent(this.helpContent);
            this.sessionPanel.sessionMessageBarPanel.setLinkText(L.t("cmm.session.reduced_restore"));
            this.sessionPanel.sessionMessageBarPanel.setProblemSolve(this);
            this.sessionPanel.sessionMessageBarPanel.setIcon(1);
            return true;
        }
        return false;
    }

    @Override
    public void solve() {
        String msg = L.t("cmm.session.reduced_solve");
        int result = JOptionPane.showConfirmDialog(this.sessionPanel.cmmLoginPanel.findParentFrame(), msg, L.t("cmm.session.reduced_restore"), 2);
        if (result == 0) {
            boolean bool = this.sendRestoreToFullCPUPowerCommand();
            if (bool) {
                this.sessionPanel.xMessage.setText(L.t("cmm.session.reduced_sent"));
            } else {
                this.sessionPanel.xMessage.setText(L.t("cmm.session.reduced_sent_failed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRestoreToFullCPUPowerCommand() {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.sessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean result = false;
            try {
                result = ipmiCMMOEMCommand.setBladeReduceOrFullPower((byte)0);
            }
            catch (IPMIException iPMIException) {
            }
            finally {
                sessionController.closeSession();
            }
            return result;
        }
        return false;
    }
}

