/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;

public class RoundPasswordTextField
extends JPasswordField {
    private static final Color COLOR_GAINED = new Color(138, 210, 234);
    private static final Color COLOR_LOST = new Color(228, 231, 234);
    private static final Color COLOR_FAILURE = new Color(255, 148, 148);
    private Icon closeEyeIcon = new ImageIcon(this.getClass().getResource("/images/closeEye.png"));
    private Icon openEyeIcon = new ImageIcon(this.getClass().getResource("/images/openEye.png"));
    private static final long serialVersionUID = 1L;
    private static final int ARC = 5;
    private char defaultCharacter;
    private Color currentColor;
    private JLabel passwordEyeLabel;
    private boolean isValid;
    private boolean isFocusGained;
    private boolean isPasswordEyeRequired;
    private PasswordDisplayInterface displayListener;

    public RoundPasswordTextField() {
        this((PasswordDisplayInterface)null);
    }

    public RoundPasswordTextField(PasswordDisplayInterface listener) {
        this.displayListener = listener;
        this.isPasswordEyeRequired = listener != null;
        this.defaultCharacter = this.getEchoChar();
        this.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RoundPasswordTextField.this.isFocusGained = true;
                ((JTextField)e.getSource()).invalidate();
                ((JTextField)e.getSource()).repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                RoundPasswordTextField.this.isFocusGained = false;
                ((JTextField)e.getSource()).invalidate();
                ((JTextField)e.getSource()).repaint();
            }
        });
        if (this.isPasswordEyeRequired) {
            this.passwordEyeLabel = new JLabel(this.openEyeIcon);
            this.passwordEyeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (RoundPasswordTextField.this.getEchoChar() == '\u0000') {
                        RoundPasswordTextField.this.displayListener.showPlainPassword(false);
                        RoundPasswordTextField.this.setPasswordVisible(false);
                    } else {
                        RoundPasswordTextField.this.displayListener.showPlainPassword(true);
                        RoundPasswordTextField.this.setPasswordVisible(true);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    RoundPasswordTextField.this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    RoundPasswordTextField.this.setCursor(new Cursor(0));
                }
            });
            this.setLayout(new OverlayLayout(this));
            this.add(this.passwordEyeLabel);
        }
    }

    public void setPasswordVisible(boolean visible) {
        this.setEchoChar(visible ? (char)'\u0000' : this.defaultCharacter);
        if (this.isPasswordEyeRequired) {
            this.passwordEyeLabel.setIcon(visible ? this.closeEyeIcon : this.openEyeIcon);
        }
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
        super.invalidate();
        super.repaint();
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
        if (this.isPasswordEyeRequired) {
            Dimension offset = new Dimension(this.getWidth() - this.passwordEyeLabel.getWidth() - 5, (this.getHeight() - this.passwordEyeLabel.getHeight()) / 2);
            this.passwordEyeLabel.setLocation(offset.width, offset.height);
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.isFocusGained) {
            this.currentColor = COLOR_GAINED;
        } else if (!this.isFocusGained && this.isValid) {
            this.currentColor = COLOR_LOST;
        } else if (!this.isFocusGained && !this.isValid) {
            this.currentColor = COLOR_FAILURE;
        }
        g.setColor(this.currentColor);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
    }

    public static interface PasswordDisplayInterface {
        public void showPlainPassword(boolean var1);
    }
}

