/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.IPMIView20;
import IPMIView20.Logger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class SOLUDPSocket20 {
    DatagramSocket socket;
    InetAddress saddress = null;
    InetAddress tempaddress = null;
    DatagramPacket s_packet;
    DatagramPacket r_packet;
    byte[] recvBuf = new byte[256];
    int InSeqNum = 0;
    boolean bClosed = false;
    CSession session;
    int receiveByteLength = 0;

    public SOLUDPSocket20() {
        try {
            this.socket = new DatagramSocket();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initSession(CSession session) {
        this.session = session;
    }

    public synchronized boolean SendPacket(String SIP, int port, byte[] InboundSeqNum, byte[] Payload2, int datalength) {
        boolean gotback = false;
        int loop = 1;
        int SIPint = 0;
        try {
            this.saddress = IPMIView20.getInstance().isProxyEnabled ? InetAddress.getByName(IPMIView20.getInstance().proxyIP) : InetAddress.getByName(SIP);
            SIPint = this.saddress.hashCode();
            try {
                this.tempaddress = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                boolean isIPv4 = true;
                try {
                    this.tempaddress = this.getFirstNonLoopbackAddress(isIPv4, !isIPv4);
                }
                catch (Exception e1) {
                    this.tempaddress = InetAddress.getByName("127.0.0.1");
                }
            }
            if (SIPint == 0) {
                return false;
            }
        }
        catch (Exception ue) {
            return false;
        }
        int slength = datalength;
        int rlength = 256;
        this.s_packet = IPMIView20.getInstance().isProxyEnabled ? new DatagramPacket(Payload2, slength, this.saddress, IPMIView20.getInstance().proxyPort) : new DatagramPacket(Payload2, slength, this.saddress, port);
        this.r_packet = new DatagramPacket(this.recvBuf, rlength, this.tempaddress, port);
        while (true) {
            if (this.bClosed) {
                return false;
            }
            try {
                this.socket.send(this.s_packet);
            }
            catch (SecurityException e) {
                return false;
            }
            catch (IOException ie) {
                return false;
            }
            gotback = false;
            try {
                this.socket.receive(this.r_packet);
                gotback = true;
                this.receiveByteLength = this.r_packet.getLength();
            }
            catch (SecurityException e) {
                Logger.writeLog(SIP + " Receive Security violation.\n");
                e.printStackTrace();
                return false;
            }
            catch (IOException ie) {
                Logger.writeLog("[SOLUDPSocket20] IOException Happened");
                ie.printStackTrace();
                if (--loop > 0) continue;
            }
            break;
        }
        return gotback;
    }

    public synchronized boolean SendPacketNoWait(String SIP, int port, byte[] InboundSeqNum, byte[] Payload2, int datalength) {
        boolean gotback = false;
        int loop = 1;
        int SIPint = 0;
        try {
            this.saddress = IPMIView20.getInstance().isProxyEnabled ? InetAddress.getByName(IPMIView20.getInstance().proxyIP) : InetAddress.getByName(SIP);
            SIPint = this.saddress.hashCode();
            try {
                this.tempaddress = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                boolean isIPv4 = true;
                try {
                    this.tempaddress = this.getFirstNonLoopbackAddress(isIPv4, !isIPv4);
                }
                catch (Exception e1) {
                    this.tempaddress = InetAddress.getByName("127.0.0.1");
                }
            }
            if (SIPint == 0) {
                return false;
            }
        }
        catch (UnknownHostException ue) {
            return false;
        }
        int slength = datalength;
        int rlength = 256;
        this.s_packet = IPMIView20.getInstance().isProxyEnabled ? new DatagramPacket(Payload2, slength, this.saddress, IPMIView20.getInstance().proxyPort) : new DatagramPacket(Payload2, slength, this.saddress, port);
        do {
            if (this.bClosed) {
                return false;
            }
            try {
                this.socket.send(this.s_packet);
            }
            catch (SecurityException e) {
                return false;
            }
            catch (IOException ie) {
                return false;
            }
        } while (--loop > 0);
        return true;
    }

    public synchronized byte[] sendData(String ip, int port, byte[] data) {
        int retry = 3;
        byte[] buffer = new byte[2048];
        InetAddress remoteAddress = null;
        InetAddress localAddress = null;
        try {
            remoteAddress = InetAddress.getByName(ip);
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex3) {
            return null;
        }
        DatagramPacket sendPacket = new DatagramPacket(data, data.length, remoteAddress, port);
        DatagramPacket receivePacket = new DatagramPacket(buffer, 256, localAddress, port);
        do {
            try {
                this.socket.send(sendPacket);
            }
            catch (IOException ex) {
                return null;
            }
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException ex2) {
                return null;
            }
            try {
                this.socket.receive(receivePacket);
            }
            catch (SocketTimeoutException ste) {
                continue;
            }
            catch (IOException ex1) {
                return null;
            }
            byte[] result = new byte[receivePacket.getLength()];
            System.arraycopy(buffer, 0, result, 0, receivePacket.getLength());
            return result;
        } while (--retry > 0);
        return null;
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws Exception {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return InetAddress.getByName("127.0.0.1");
    }
}

