/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.ComboTabListener;
import IPMIView20.DeviceFile;
import IPMIView20.IPMIView20;
import IPMIView20.JFanPanel;
import IPMIView20.JPSUPanel;
import IPMIView20.JPowerConsumptionPanel;
import IPMIView20.JSensorPanel;
import IPMIView20.JTempPanel;
import IPMIView20.JTextTempPanel;
import IPMIView20.JVolPanel;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;

public class Sensors20
extends JPanel
implements ComboTabListener {
    boolean bLoaded = false;
    boolean refreshFlag = false;
    boolean priorDone = true;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    String hostname;
    JLabel Message;
    CSession Session;
    DeviceFile Devicefile;
    int TabId;
    UDPSocket udpSocket;
    int TotalEntries = 0;
    Timer timer;
    Vector sRecords = new Vector(10);
    int FanPanelSize = 0;
    int VolPanelSize = 0;
    int TempPanelSize = 0;
    int SensorPanelSize = 0;
    int textTempPanelSize = 0;
    int powerConsumptionPanelSize = 0;
    JFanPanel[] FanPanel;
    JVolPanel[] VolPanel;
    JTempPanel[] TempPanel;
    JSensorPanel[] SensorPanel;
    JTextTempPanel[] textTempPanel;
    JPowerConsumptionPanel[] powerConsumptionPanel;
    JTable table = new JTable();
    DefaultTableModel tablemodel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };
    LinkedList<SensorRecord> discreteSensorlist = new LinkedList();
    private JPSUPanel PSUPanel;
    private JInternalFrame PSUFrame;
    private JDesktopPane jDesktopPane1;
    private JInternalFrame FANFrame;
    private JPanel FANGroup;
    private JInternalFrame VOLFrame;
    private JPanel VOLGroup;
    private JInternalFrame SENSORFrame;
    private JPanel SENSORGroup;
    private JInternalFrame TEMPFrame;
    private JPanel TEMPGroup;
    private JInternalFrame PowerConFrame;
    private JPanel PowerConGroup;
    private JInternalFrame DiscreteFrame;
    private JPanel DiscreteGroup;
    private JPanel jPanel8;
    private JPanel jPanel1;
    private JLabel jRefreshLabel;
    private JComboBox jAutoTimer;
    private JLabel jTimerLabel;
    private JButton jManuRefresh;
    private JButton jSaveLayout;
    private JCheckBox jHideItem;
    private JCheckBox jHistoryItem;

    public Sensors20() {
        this.initComponents();
        this.timer = new Timer();
        this.FANFrame.setVisible(false);
        this.VOLFrame.setVisible(false);
        this.TEMPFrame.setVisible(false);
        this.SENSORFrame.setVisible(false);
        this.PSUFrame.setVisible(false);
        this.PowerConFrame.setVisible(false);
        this.DiscreteFrame.setVisible(false);
        this.FANFrame.setFrameIcon(null);
        this.VOLFrame.setFrameIcon(null);
        this.TEMPFrame.setFrameIcon(null);
        this.SENSORFrame.setFrameIcon(null);
        this.PSUFrame.setFrameIcon(null);
        this.PowerConFrame.setFrameIcon(null);
        this.DiscreteFrame.setFrameIcon(null);
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        Sensors20.this.RefreshSensors();
                    }
                };
                th.start();
            }
        };
        this.timer = new Timer();
        this.timer.schedule(t, 60000L, 60000L);
        this.jAutoTimer.addItem("10");
        this.jAutoTimer.addItem("20");
        this.jAutoTimer.addItem("30");
        this.jAutoTimer.addItem("45");
        this.jAutoTimer.addItem("60");
        this.jAutoTimer.addItem("90");
        this.jAutoTimer.addItem("120");
        this.jAutoTimer.setSelectedIndex(4);
        this.validate();
    }

    public void preset(String Hostname, UDPSocket xSocket, CSession iSession, JLabel xMessage, DeviceFile xDevicefile) {
        this.hostname = Hostname;
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.Devicefile = xDevicefile;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        this.PSUPanel.setLANConfig(this.Session);
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    public void setRefreshFlag(boolean xFlag) {
        this.refreshFlag = xFlag;
    }

    public void showFrame() {
        Rectangle rPos = new Rectangle();
        String layposition = "";
        boolean isSupportDiscrete = true;
        try {
            layposition = (String)this.Devicefile.getDevice(this.hostname).get(3);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.out.println("Load Layout Error");
        }
        if (layposition.length() > 0) {
            int x = layposition.indexOf(44);
            rPos.x = Integer.parseInt(layposition.substring(0, x));
            int y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.FANFrame.setBounds(rPos);
            String xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.FANFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.FANFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.FANFrame.setMaximum(false);
                    this.FANFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.VOLFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.VOLFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.VOLFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.VOLFrame.setMaximum(false);
                    this.VOLFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.TEMPFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.TEMPFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.TEMPFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.TEMPFrame.setMaximum(false);
                    this.TEMPFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.SENSORFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.SENSORFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.SENSORFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.SENSORFrame.setMaximum(false);
                    this.SENSORFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.PSUFrame.setBounds(rPos);
            if (y < 0) {
                isSupportDiscrete = false;
            }
            if ((xtmp = isSupportDiscrete ? layposition.substring(x + 1, y) : layposition.substring(x + 1, layposition.length())).compareTo("1") == 0) {
                try {
                    this.PSUFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.PSUFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.PSUFrame.setMaximum(false);
                    this.PSUFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (isSupportDiscrete) {
                x = y;
                y = layposition.indexOf(44, x + 1);
                rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
                x = y;
                y = layposition.indexOf(44, x + 1);
                rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
                x = y;
                y = layposition.indexOf(44, x + 1);
                rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
                x = y;
                y = layposition.indexOf(44, x + 1);
                rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
                x = y;
                this.DiscreteFrame.setBounds(rPos);
                xtmp = layposition.substring(x + 1, layposition.length());
                if (xtmp.compareTo("1") == 0) {
                    try {
                        this.DiscreteFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (xtmp.compareTo("2") == 0) {
                    try {
                        this.DiscreteFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        this.DiscreteFrame.setMaximum(false);
                        this.DiscreteFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
        this.repaint();
    }

    private boolean GetSDRRepoInfo(IPMISDRCommand command) {
        SDRInfo sdrInfo = command.getSDRRepositoryInfoModal();
        if (null != sdrInfo) {
            this.TotalEntries = sdrInfo.getRecordCount();
            this.Message.setText(L.t("sensor.Get_SDR_Repository_Info_succeeded"));
            return true;
        }
        this.Message.setText(L.t("sensor.Get_SDR_Repository_Info_failed"));
        return false;
    }

    public void GetSensors() {
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = this.Session.Loading;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.getIPMIConfig(), ipmiSDRCommand);
        if (null == sessionController) {
            this.Session.Loading = -1;
            this.Message.setText(L.t("sensor.Get_SDR_Repository_Info_failed"));
            return;
        }
        this.GetSDRRepoInfo(ipmiSDRCommand);
        if (this.TotalEntries > 0) {
            SensorRecord Sensor2;
            int i;
            this.sRecords.removeAllElements();
            if (!this.GetSDRRecords(ipmiSDRCommand)) {
                sessionController.closeSession();
                return;
            }
            int VolIndex = 0;
            int FanIndex = 0;
            int TempIndex = 0;
            int textTempIndex = 0;
            int powerConIndex = 0;
            int SensorIndex = 0;
            boolean hasFanSensor = false;
            boolean hasVolSensor = false;
            boolean hasTempSensor = false;
            boolean hasOtherSensor = false;
            boolean hasPSUSensor = true;
            boolean hasOtherPWSensor = false;
            boolean hasDiscreteSensor = false;
            this.TEMPGroup.removeAll();
            this.VOLGroup.removeAll();
            this.FANGroup.removeAll();
            this.SENSORGroup.removeAll();
            Object[] columnNames = new Object[]{"Status", "Name", "Value"};
            this.tablemodel.setColumnIdentifiers(columnNames);
            this.table.setModel(this.tablemodel);
            byte[] guid = null;
            guid = this.Session.guid == null ? IPMIMessagingCommand.getSystemGUIDByIP(this.Session.SIP) : this.Session.guid;
            for (i = 0; i < this.sRecords.size(); ++i) {
                Sensor2 = (SensorRecord)this.sRecords.get(i);
                if (Sensor2.SensorType == 1) {
                    ++this.TempPanelSize;
                }
                if (Sensor2.SensorType == 192) {
                    ++this.textTempPanelSize;
                }
                if (Sensor2.SensorType == 2) {
                    ++this.VolPanelSize;
                }
                if (Sensor2.SensorType == 4) {
                    ++this.FanPanelSize;
                }
                if (Sensor2.SensorType == 5 || Sensor2.SensorType == 8) {
                    ++this.SensorPanelSize;
                }
                if (Sensor2.SensorType != 11) continue;
                ++this.powerConsumptionPanelSize;
            }
            this.FanPanel = new JFanPanel[this.FanPanelSize];
            this.VolPanel = new JVolPanel[this.VolPanelSize];
            this.TempPanel = new JTempPanel[this.TempPanelSize];
            this.SensorPanel = new JSensorPanel[this.SensorPanelSize];
            this.textTempPanel = new JTextTempPanel[this.textTempPanelSize];
            this.powerConsumptionPanel = new JPowerConsumptionPanel[this.powerConsumptionPanelSize];
            for (i = 0; i < this.sRecords.size(); ++i) {
                Sensor2 = (SensorRecord)this.sRecords.get(i);
                if (Sensor2.SensorType == 1) {
                    hasTempSensor = true;
                    if (Sensor2.Reading == 0 || Sensor2.Reading == -1) {
                        Sensor2.valueString = new String("N/A");
                    }
                    if ((Sensor2.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask[0] & 2) != 2) {
                        Sensor2.MinString = "N/A";
                    }
                    if ((Sensor2.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask[0] & 0x10) != 16) {
                        Sensor2.MaxString = "N/A";
                    }
                    this.TempPanel[TempIndex] = new JTempPanel(Sensor2.SensorNumber, Sensor2.M, Sensor2.B, Sensor2.RExp, Sensor2.BExp);
                    this.TempPanel[TempIndex].init(Sensor2.SensorName, Sensor2.Reading, Sensor2.Maximum, Sensor2.valueString, Sensor2.MaxString);
                    this.TEMPGroup.add(this.TempPanel[TempIndex]);
                    ++TempIndex;
                }
                if (Sensor2.SensorType == 192) {
                    this.textTempPanel[textTempIndex] = new JTextTempPanel(Sensor2.SensorName, Sensor2.SensorNumber);
                    this.textTempPanel[textTempIndex].reading = Sensor2.Reading;
                    this.TEMPGroup.add(this.textTempPanel[textTempIndex]);
                    ++textTempIndex;
                }
                if (Sensor2.SensorType == 11) {
                    hasOtherPWSensor = true;
                    this.powerConsumptionPanel[powerConIndex] = new JPowerConsumptionPanel(Sensor2.SensorName, Sensor2.Reading, Sensor2.SensorNumber, Sensor2.M, Sensor2.B, Sensor2.RExp, Sensor2.BExp);
                    this.PowerConGroup.add(this.powerConsumptionPanel[powerConIndex]);
                    ++powerConIndex;
                }
                if (Sensor2.SensorType == 2) {
                    hasVolSensor = true;
                    this.VolPanel[VolIndex] = new JVolPanel(Sensor2.SensorNumber, Sensor2.M, Sensor2.B, Sensor2.RExp, Sensor2.BExp);
                    if (Sensor2.Reading == 0 || Sensor2.Reading == -1) {
                        Sensor2.valueString = new String("N/A");
                    }
                    if (IPMIMessagingCommand.isMicroBladeNodeGUID(guid) && Sensor2.SensorName.contains("VBAT")) {
                        Sensor2.MaxString = new String("N/A");
                    }
                    if ((Sensor2.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask[0] & 2) != 2) {
                        Sensor2.MinString = "N/A";
                    }
                    if ((Sensor2.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask[0] & 0x10) != 16) {
                        Sensor2.MaxString = "N/A";
                    }
                    if (this.Session.isPeppercon && Sensor2.SensorName.equalsIgnoreCase("-12")) {
                        this.VolPanel[VolIndex].init(Sensor2.SensorName, Sensor2.Reading, Sensor2.Minimum, Sensor2.Maximum, Sensor2.valueString, Sensor2.MaxString, Sensor2.MinString);
                    } else {
                        this.VolPanel[VolIndex].init(Sensor2.SensorName, Sensor2.Reading, Sensor2.Maximum, Sensor2.Minimum, Sensor2.valueString, Sensor2.MaxString, Sensor2.MinString);
                    }
                    this.VOLGroup.add(this.VolPanel[VolIndex]);
                    ++VolIndex;
                }
                if (Sensor2.SensorType == 4) {
                    hasFanSensor = true;
                    this.FanPanel[FanIndex] = new JFanPanel(Sensor2.SensorNumber, Sensor2.M, Sensor2.B, Sensor2.RExp, Sensor2.BExp, Sensor2.Linearization, this.Session);
                    if (Sensor2.Reading == 0) {
                        Sensor2.Reading = (byte)-1;
                    }
                    if (Sensor2.Reading == -1) {
                        Sensor2.valueString = new String("N/A");
                    }
                    if ((Sensor2.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask[0] & 2) != 2) {
                        Sensor2.MinString = "N/A";
                    }
                    if ((Sensor2.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask[0] & 0x10) != 16) {
                        Sensor2.MaxString = "N/A";
                    }
                    this.FanPanel[FanIndex].init(Sensor2.SensorName, Sensor2.Reading, Sensor2.Minimum, Sensor2.valueString, Sensor2.MinString, Sensor2.MaxString);
                    this.FANGroup.add(this.FanPanel[FanIndex]);
                    this.FanPanel[FanIndex].animation();
                    ++FanIndex;
                }
                if (Sensor2.SensorType == 5 || Sensor2.SensorType == 8) {
                    hasOtherSensor = true;
                    this.SensorPanel[SensorIndex] = new JSensorPanel(Sensor2.SensorNumber, Sensor2.SensorType);
                    this.SensorPanel[SensorIndex].init(this.udpSocket, this.Session, this.Message, Sensor2.Reading);
                    this.SENSORGroup.add(this.SensorPanel[SensorIndex]);
                    ++SensorIndex;
                }
                if (Sensor2.SensorType == 35) {
                    hasDiscreteSensor = true;
                    this.discreteSensorlist.add(Sensor2);
                    String reading = "";
                    switch (this.getSensorReadingFromSensorNumber(ipmiSDRCommand, Sensor2.SensorNumber)) {
                        case 1: {
                            reading = "Tr. to Idle";
                            break;
                        }
                        case 2: {
                            reading = "Tr. to Active";
                            break;
                        }
                        case 4: {
                            reading = "Tr. to Busy";
                            break;
                        }
                        default: {
                            reading = "N/A";
                        }
                    }
                    if (reading.equalsIgnoreCase("N/A")) {
                        this.setTableData(this.tablemodel, "N/A", Sensor2.SensorName, reading);
                    } else {
                        this.setTableData(this.tablemodel, "OK", Sensor2.SensorName, reading);
                    }
                }
                if (Sensor2.eventReadingTypeCode != 3 && Sensor2.eventReadingTypeCode != 6 && Sensor2.eventReadingTypeCode != 9 && (Sensor2.eventReadingTypeCode != 111 || Sensor2.SensorType == 5 || Sensor2.SensorType == 8)) continue;
                hasDiscreteSensor = true;
                this.discreteSensorlist.add(Sensor2);
                String status = "N/A";
                int discreteReading = this.getDiscreteReading(ipmiSDRCommand, Sensor2.SensorNumber);
                int offset = -1;
                for (int j = 0; j < 8; ++j) {
                    if ((discreteReading >> j & 1) != 1) continue;
                    offset = (byte)j;
                }
                String value = offset == -1 ? "N/A" : GlobalDefine.getDiscreteSensorReading(Sensor2.eventReadingTypeCode, (byte)Sensor2.SensorType, (byte)offset);
                if (Sensor2.eventReadingTypeCode != 111) {
                    if (offset == 0) {
                        switch (Sensor2.eventReadingTypeCode) {
                            case 3: 
                            case 6: {
                                status = "OK";
                            }
                        }
                    } else if (offset == 1) {
                        switch (Sensor2.eventReadingTypeCode) {
                            case 3: 
                            case 9: {
                                status = "OK";
                                break;
                            }
                            case 6: {
                                status = "Fail";
                            }
                        }
                    } else if (offset == 5) {
                        switch (Sensor2.eventReadingTypeCode) {
                            case 9: {
                                status = "Fail";
                            }
                        }
                    }
                } else if (Sensor2.SensorType == 5) {
                    if (offset == -1) {
                        value = "OK";
                        status = "OK";
                    } else {
                        status = "Fail";
                    }
                } else if (Sensor2.SensorType == 7) {
                    if (offset == 7) {
                        status = "OK";
                    } else if (offset != -1) {
                        status = "Fail";
                    }
                } else if (Sensor2.SensorType == 8) {
                    status = offset == 0 ? "OK" : "Fail";
                } else if (Sensor2.SensorType == 12) {
                    if (offset == 6) {
                        status = "OK";
                    } else if (offset != -1) {
                        status = "Fail";
                    }
                } else if (Sensor2.SensorType == 13) {
                    if (offset == 0 || offset == 4) {
                        status = "OK";
                    } else if (offset != -1) {
                        status = "Fail";
                    }
                } else if (Sensor2.SensorType == 195) {
                    value = Integer.toString(discreteReading);
                }
                if (value == "N/A") {
                    status = "N/A";
                }
                this.setTableData(this.tablemodel, status, Sensor2.SensorName, value);
            }
            sessionController.closeSession();
            this.repaint();
            this.grabFocus();
            if (this.jHideItem.isSelected()) {
                for (i = 0; i < this.TempPanelSize && this.TempPanel[i] != null; ++i) {
                    if (this.TempPanel[i].tempMeter.m_ShowString.compareTo("0.0") != 0 && !"N/A".equals(this.TempPanel[i].tempMeter.m_ShowString)) continue;
                    this.TempPanel[i].setVisible(false);
                }
                for (i = 0; i < this.textTempPanelSize && this.textTempPanel[i] != null; ++i) {
                    if (this.textTempPanel[i].reading != 7) continue;
                    this.textTempPanel[i].setVisible(false);
                }
                for (i = 0; i < this.FanPanelSize && this.FanPanel[i] != null; ++i) {
                    if (this.FanPanel[i].fanMeter.m_ShowString.compareTo("N/A") != 0) continue;
                    this.FanPanel[i].setVisible(false);
                }
                for (i = 0; i < this.VolPanelSize && this.VolPanel[i] != null; ++i) {
                    if (this.VolPanel[i].volMeter.m_ShowString.compareTo("N/A") != 0) continue;
                    this.VolPanel[i].setVisible(false);
                }
            } else {
                for (i = 0; i < this.TempPanelSize && this.TempPanel[i] != null; ++i) {
                    this.TempPanel[i].setVisible(true);
                }
                for (i = 0; i < this.textTempPanelSize && this.textTempPanel[i] != null; ++i) {
                    this.textTempPanel[i].setVisible(true);
                }
                for (i = 0; i < this.FanPanelSize && this.FanPanel[i] != null; ++i) {
                    this.FanPanel[i].setVisible(true);
                }
                for (i = 0; i < this.VolPanelSize && this.VolPanel[i] != null; ++i) {
                    this.VolPanel[i].setVisible(true);
                }
            }
            if (hasFanSensor) {
                this.FANFrame.setVisible(true);
            }
            if (hasVolSensor) {
                this.VOLFrame.setVisible(true);
            }
            if (hasTempSensor) {
                this.TEMPFrame.setVisible(true);
            }
            if (hasOtherSensor) {
                if (SensorIndex > 0) {
                    this.SENSORFrame.setVisible(true);
                } else {
                    this.SENSORFrame.setVisible(false);
                }
            }
            if (hasPSUSensor) {
                this.PSUFrame.setVisible(true);
            }
            if (hasOtherPWSensor) {
                this.PowerConFrame.setVisible(true);
            }
            if (hasDiscreteSensor) {
                this.DiscreteFrame.setVisible(true);
                this.table.setPreferredScrollableViewportSize(new Dimension(300, 100));
                this.DiscreteGroup.add(new JScrollPane(this.table));
            }
            this.jRefreshLabel.setEnabled(true);
            this.jTimerLabel.setEnabled(true);
            this.jAutoTimer.setEnabled(true);
            this.jManuRefresh.setEnabled(true);
            this.jSaveLayout.setEnabled(true);
        }
        this.TEMPFrame.pack();
        this.SENSORFrame.pack();
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void RefreshSensors() {
        byte[] bytey = new byte[256];
        if (!this.refreshFlag) {
            return;
        }
        if (!this.getPriorDone()) {
            return;
        }
        if (this.Session == null) {
            return;
        }
        this.Session.Loading = this.TabId;
        this.setPriorDone(false);
        this.jManuRefresh.setEnabled(false);
        this.Message.setText(L.t("sensor.Refreshing_sensors_status"));
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.getIPMIConfig(), ipmiSDRCommand);
        if (sessionController == null) {
            this.Message.setText("Refreshing sensors failed");
            this.setPriorDone(true);
            this.Session.Loading = -1;
        } else {
            String valueString;
            int Value;
            int X;
            int BExp;
            int RExp;
            int B;
            int M;
            boolean result;
            int i;
            for (i = 0; i < this.FanPanelSize && this.FanPanel[i] != null; ++i) {
                result = this.GetSensor(ipmiSDRCommand, this.FanPanel[i].SensorNumber, bytey);
                if (!result) {
                    bytey[0] = -1;
                }
                M = this.FanPanel[i].M;
                B = this.FanPanel[i].B;
                RExp = this.FanPanel[i].RExp;
                BExp = this.FanPanel[i].BExp;
                X = this.ByteToInt(bytey, 0, 1);
                double rawx = ((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                Value = this.FanPanel[i].Linearization == 7 ? (int)(1.0 / rawx) : (this.FanPanel[i].Linearization == 8 ? (int)(rawx * rawx) : (int)rawx);
                valueString = new String(Value + "");
                if (bytey[0] == 0) {
                    bytey[0] = -1;
                }
                if (bytey[0] == -1) {
                    valueString = "N/A";
                }
                this.FanPanel[i].updateValue(bytey[0], valueString);
            }
            for (i = 0; i < this.VolPanelSize && this.VolPanel[i] != null; ++i) {
                result = this.GetSensor(ipmiSDRCommand, this.VolPanel[i].SensorNumber, bytey);
                M = this.VolPanel[i].M;
                B = this.VolPanel[i].B;
                RExp = this.VolPanel[i].RExp;
                BExp = this.VolPanel[i].BExp;
                X = this.ByteToInt(bytey, 0, 1);
                Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                if (X == 0 || X == 255) {
                    valueString = new String("N/A");
                    bytey[0] = 0;
                } else {
                    valueString = new String((double)Value / 100.0 + "");
                }
                this.VolPanel[i].updateValue(bytey[0], valueString);
            }
            for (i = 0; i < this.TempPanelSize && this.TempPanel[i] != null; ++i) {
                result = this.GetSensor(ipmiSDRCommand, this.TempPanel[i].SensorNumber, bytey);
                M = this.TempPanel[i].M;
                B = this.TempPanel[i].B;
                RExp = this.TempPanel[i].RExp;
                BExp = this.TempPanel[i].BExp;
                X = this.ByteToInt(bytey, 0, 1);
                Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                if (X == 0 || X == 255) {
                    valueString = new String("N/A");
                } else {
                    if (Value > 12700) {
                        Value -= 25600;
                    }
                    valueString = new String((double)Value / 100.0 + "");
                }
                this.TempPanel[i].updateValue(bytey[0], valueString);
            }
            for (i = 0; i < this.textTempPanelSize && this.textTempPanel[i] != null; ++i) {
                result = this.GetSensor(ipmiSDRCommand, this.textTempPanel[i].sensorNumber, bytey);
                byte reading = -1;
                reading = (bytey[1] & 0x20) > 0 ? (byte)7 : bytey[2];
                this.textTempPanel[i].updateStatus(reading);
            }
            for (i = 0; i < this.SensorPanelSize && this.SensorPanel[i] != null; ++i) {
                result = this.GetSensor(ipmiSDRCommand, this.SensorPanel[i].SensorNumber, bytey);
                this.SensorPanel[i].updateValue(bytey[2]);
            }
            for (i = 0; i < this.powerConsumptionPanelSize && this.powerConsumptionPanel[i] != null; ++i) {
                result = this.GetSensor(ipmiSDRCommand, this.powerConsumptionPanel[i].SensorNumber, bytey);
                M = this.powerConsumptionPanel[i].M;
                B = this.powerConsumptionPanel[i].B;
                RExp = this.powerConsumptionPanel[i].RExp;
                BExp = this.powerConsumptionPanel[i].BExp;
                X = this.ByteToInt(bytey, 0, 1);
                Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                valueString = X == 0 || X == 255 ? new String("N/A") : new String((double)Value / 100.0 + "");
                this.powerConsumptionPanel[i].updateStatus(valueString);
            }
            this.removeTableData(this.tablemodel);
            for (i = 0; i < this.discreteSensorlist.size(); ++i) {
                SensorRecord dSensor = this.discreteSensorlist.get(i);
                if (dSensor.SensorType == 35) {
                    String reading = "";
                    switch (this.getSensorReadingFromSensorNumber(ipmiSDRCommand, dSensor.SensorNumber)) {
                        case 1: {
                            reading = "Tr. to Idle";
                            break;
                        }
                        case 2: {
                            reading = "Tr. to Active";
                            break;
                        }
                        case 4: {
                            reading = "Tr. to Busy";
                            break;
                        }
                        default: {
                            reading = "N/A";
                        }
                    }
                    if (reading.equalsIgnoreCase("N/A")) {
                        this.setTableData(this.tablemodel, "N/A", dSensor.SensorName, reading);
                        continue;
                    }
                    this.setTableData(this.tablemodel, "Normal", dSensor.SensorName, reading);
                    continue;
                }
                String status = "N/A";
                int discreteReading = this.getDiscreteReading(ipmiSDRCommand, dSensor.SensorNumber);
                int offset = -1;
                for (int j = 0; j < 8; ++j) {
                    if ((discreteReading >> j & 1) != 1) continue;
                    offset = (byte)j;
                }
                String value = offset == -1 ? "N/A" : GlobalDefine.getDiscreteSensorReading(dSensor.eventReadingTypeCode, (byte)dSensor.SensorType, (byte)offset);
                if (dSensor.eventReadingTypeCode != 111) {
                    if (offset == 0) {
                        switch (dSensor.eventReadingTypeCode) {
                            case 3: 
                            case 6: {
                                status = "OK";
                            }
                        }
                    } else if (offset == 1) {
                        switch (dSensor.eventReadingTypeCode) {
                            case 3: 
                            case 9: {
                                status = "OK";
                                break;
                            }
                            case 6: {
                                status = "Fail";
                            }
                        }
                    } else if (offset == 5) {
                        switch (dSensor.eventReadingTypeCode) {
                            case 9: {
                                status = "Fail";
                            }
                        }
                    }
                } else if (dSensor.SensorType == 5) {
                    if (offset == -1) {
                        value = "OK";
                        status = "OK";
                    } else {
                        status = "Fail";
                    }
                } else if (dSensor.SensorType == 7) {
                    if (offset == 7) {
                        status = "OK";
                    } else if (offset != -1) {
                        status = "Fail";
                    }
                } else if (dSensor.SensorType == 8) {
                    status = offset == 0 ? "OK" : "Fail";
                } else if (dSensor.SensorType == 12) {
                    if (offset == 6) {
                        status = "OK";
                    } else if (offset != -1) {
                        status = "Fail";
                    }
                } else if (dSensor.SensorType == 13) {
                    if (offset == 0 || offset == 4) {
                        status = "OK";
                    } else if (offset != -1) {
                        status = "Fail";
                    }
                } else if (dSensor.SensorType == 195) {
                    value = Integer.toString(discreteReading);
                }
                if (value == "N/A") {
                    status = "N/A";
                }
                this.setTableData(this.tablemodel, status, dSensor.SensorName, value);
            }
            sessionController.closeSession();
            this.tablemodel.fireTableDataChanged();
            this.Message.setText(L.t("sensor.Getting_PSU_PMBus_FRU_data"));
            this.helpRefreshPSU();
            this.Message.setText(L.t("sensor.Refreshing_sensors_status_completed"));
            this.jManuRefresh.setEnabled(true);
            this.setPriorDone(true);
            this.Session.Loading = -1;
            this.repaint();
        }
    }

    public void helpRefreshPSU() {
        this.PSUPanel.load(this.Session);
    }

    private boolean GetSensor(IPMISDRCommand command, int SensorNum, byte[] byteResult) {
        IPMIMessage resMessage = null;
        this.Message.setText(L.t("Getting_status_of_sensor_number_colon") + SensorNum);
        if (null != command && (resMessage = command.getSensorReadingCommand((byte)SensorNum)) != null && resMessage.completionCode == 0) {
            System.arraycopy(resMessage.data, 0, byteResult, 0, resMessage.data.length);
            return true;
        }
        byteResult[0] = -1;
        MessageCenter.getInstance().put(this, (Object)"Can't execute GetSensor");
        return false;
    }

    private boolean GetSDRRecord(IPMISDRCommand command, byte[] ReserveID, byte[] RecordID, byte[] NextRecordID, byte[] Offset, byte[] byteResult, int[] retlength, byte pByteToRead) {
        IPMIMessage resMessage = command.getSDRCommand(ReserveID, RecordID, Offset[0], pByteToRead);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                System.arraycopy(resMessage.data, 0, NextRecordID, 0, 2);
                System.arraycopy(resMessage.data, 2, byteResult, 0, pByteToRead);
                retlength[0] = pByteToRead;
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)("ccode =" + ByteUtility.byteToHex(resMessage.completionCode)));
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        } else {
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get SDR");
        }
        return false;
    }

    private boolean ReserveSDR(IPMISDRCommand command, byte[] ReserveID) {
        if (command != null) {
            byte[] reserveID = command.getSDRReservationID();
            if (reserveID != null) {
                System.arraycopy(reserveID, 0, ReserveID, 0, 2);
                return true;
            }
        } else {
            this.Message.setText(L.t("sensor.ReserveSDR_error"));
        }
        return false;
    }

    private boolean GetSDRRecords(IPMISDRCommand command) {
        byte[] RecordID = new byte[]{0, 0};
        byte[] NextRecordID = new byte[]{0, 0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] bytex = new byte[128];
        byte[] bytey = new byte[128];
        byte[] bytez = new byte[128];
        int[] lengthx = new int[1];
        int[] lengthz = new int[1];
        int StartE = 0;
        boolean EndE = false;
        int ArrayNum = 9;
        Vector Para = new Vector(1);
        boolean bResult = false;
        if (command == null) {
            this.Message.setText(L.t("sensor.Get_SDR_Record_failed"));
            return bResult;
        }
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        StartE = 0;
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        if (this.ReserveSDR(command, ReserveID)) {
            int i = StartE;
            do {
                bResult = false;
                Object[] objs = new Object[]{"" + i};
                this.Message.setText(L.t("sensor.Getting_SDR_Record_colon") + i);
                Offset[0] = 0;
                if (this.GetSDRRecord(command, ReserveID, RecordID, NextRecordID, Offset, bytex, lengthx, (byte)8)) {
                    int totallen;
                    SensorRecord sensorR = new SensorRecord();
                    this.Message.setText(L.f("sensor.Get_SDR_Record__succeeded", objs));
                    if (bytex[3] == 1) {
                        int Value;
                        int BExp;
                        int RExp;
                        int B;
                        for (totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            byte byteToRead = 0;
                            byteToRead = totallen > 8 ? (byte)8 : (byte)((byte)totallen);
                            if (this.GetSDRRecord(command, ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz, byteToRead)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText(L.f("sensor.Get_SDR_Record__failed", objs));
                            Logger.writeLog("Get SDR Record: " + i + " failed");
                            break;
                        }
                        sensorR.SensorNumber = bytex[7] & 0xFF;
                        sensorR.SensorType = this.ByteToInt(bytex, 12, 1);
                        try {
                            System.arraycopy(bytex, 18, sensorR.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask, 0, 2);
                        }
                        catch (IndexOutOfBoundsException byteToRead) {
                            // empty catch block
                        }
                        this.GetSensor(command, sensorR.SensorNumber, bytey);
                        int X = this.ByteToInt(bytey, 0, 1);
                        if (sensorR.SensorType == 5 || sensorR.SensorType == 8 || sensorR.SensorType == 192) {
                            sensorR.Reading = bytey[2];
                            if (sensorR.SensorType == 192 && (bytey[1] & 0x20) > 0) {
                                sensorR.Reading = (byte)7;
                            }
                        } else {
                            sensorR.Reading = bytey[0];
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        int nameLength = lengthx[0] - 48;
                        strout.write(bytex, 48, nameLength);
                        sensorR.SensorName = strout.toString();
                        sensorR.Maximum = bytex[37];
                        sensorR.Minimum = bytex[40];
                        int Linear = bytex[23] & 0x7F;
                        int M = (bytex[25] & 0xC0) * 4 + (bytex[24] & 0xFF);
                        if (M >= 512) {
                            M = -(512 - (M & 0x1FF));
                        }
                        if ((B = (bytex[27] & 0xC0) * 4 + (bytex[26] & 0xFF)) >= 512) {
                            B = -(512 - (B & 0x1FF));
                        }
                        if ((RExp = (bytex[29] & 0xF0) >> 4) >= 8) {
                            RExp = -(8 - (RExp & 7));
                        }
                        if ((BExp = bytex[29] & 0xF) >= 8) {
                            BExp = -(8 - (BExp & 7));
                        }
                        if (sensorR.SensorType == 4) {
                            double rawx;
                            if (Linear == 7) {
                                rawx = ((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.valueString = new String(Value + "");
                                rawx = ((double)(M * this.ByteToInt(bytex, 37, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.MaxString = new String(Value + "");
                                rawx = ((double)(M * this.ByteToInt(bytex, 40, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.MinString = new String(Value + "");
                            } else if (Linear == 8) {
                                rawx = ((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(rawx * rawx);
                                sensorR.valueString = new String(Value + "");
                                rawx = ((double)(M * this.ByteToInt(bytex, 37, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(rawx * rawx);
                                sensorR.MaxString = new String(Value + "");
                                rawx = ((double)(M * this.ByteToInt(bytex, 40, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(rawx * rawx);
                                sensorR.MinString = new String(Value + "");
                            } else {
                                Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.valueString = new String(Value + "");
                                Value = (int)(((double)(M * this.ByteToInt(bytex, 37, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.MaxString = new String(Value + "");
                                Value = (int)(((double)(M * this.ByteToInt(bytex, 40, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.MinString = new String(Value + "");
                            }
                        } else {
                            Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            if (sensorR.SensorType == 1 && Value > 12700) {
                                Value -= 25600;
                            }
                            sensorR.valueString = new String((double)Value / 100.0 + "");
                            Value = (int)(((double)(M * this.ByteToInt(bytex, 37, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.MaxString = new String((double)Value / 100.0 + "");
                            Value = (int)(((double)(M * this.ByteToInt(bytex, 40, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.MinString = new String((double)Value / 100.0 + "");
                        }
                        sensorR.Linearization = Linear;
                        sensorR.M = M;
                        sensorR.B = B;
                        sensorR.RExp = RExp;
                        sensorR.BExp = BExp;
                        this.sRecords.addElement(sensorR);
                    } else if (bytex[3] == 2) {
                        for (totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            byte byteToRead = 0;
                            byteToRead = totallen > 8 ? (byte)8 : (byte)((byte)totallen);
                            if (this.GetSDRRecord(command, ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz, byteToRead)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText(L.f("sensor.Get_SDR_Record__failed", objs));
                            Logger.writeLog("Get SDR Record: " + i + " failed");
                            break;
                        }
                        sensorR.SensorNumber = bytex[7] & 0xFF;
                        sensorR.SensorType = this.ByteToInt(bytex, 12, 1);
                        this.GetSensor(command, sensorR.SensorNumber, bytey);
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        int nameLength = lengthx[0] - 32;
                        strout.write(bytex, 32, nameLength);
                        sensorR.SensorName = strout.toString();
                        this.sRecords.addElement(sensorR);
                    }
                    sensorR.eventReadingTypeCode = bytex[13];
                    System.arraycopy(NextRecordID, 0, RecordID, 0, 2);
                    bResult = true;
                    continue;
                }
                this.Message.setText(L.f("sensor.Get_SDR_Record__failed", objs));
            } while (bResult && this.ByteToInt(RecordID, 0, 2) != 65535 && ++i < this.TotalEntries);
        }
        if (this.ByteToInt(RecordID, 0, 2) == 65535) {
            this.Message.setText(L.t("sensor.Get_SDR_Record_successful"));
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            return bResult;
        }
        this.Message.setText(L.t("sensor.Get_SDR_Record_failed"));
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return bResult;
    }

    private void initComponents() {
        this.PSUPanel = new JPSUPanel();
        this.PSUFrame = new JInternalFrame();
        this.jDesktopPane1 = new JDesktopPane();
        this.FANFrame = new JInternalFrame();
        this.FANGroup = new JPanel();
        this.VOLFrame = new JInternalFrame();
        this.VOLGroup = new JPanel();
        this.SENSORFrame = new JInternalFrame();
        this.SENSORGroup = new JPanel();
        this.TEMPFrame = new JInternalFrame();
        this.TEMPGroup = new JPanel();
        this.PowerConFrame = new JInternalFrame();
        this.PowerConGroup = new JPanel();
        this.DiscreteFrame = new JInternalFrame();
        this.DiscreteGroup = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jRefreshLabel = new JLabel();
        this.jAutoTimer = new JComboBox();
        this.jTimerLabel = new JLabel();
        this.jManuRefresh = new JButton();
        this.jSaveLayout = new JButton();
        this.jHideItem = new JCheckBox();
        this.jHistoryItem = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jDesktopPane1.setBorder(new EtchedBorder());
        this.FANFrame.setMaximizable(true);
        this.FANFrame.setTitle(L.t("sensor.Fans"));
        this.FANFrame.setIconifiable(true);
        this.FANFrame.setForeground(Color.black);
        this.FANFrame.setResizable(true);
        this.FANFrame.setVisible(true);
        this.FANFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.FANFrameFocusGained(evt);
            }
        });
        JScrollPane scrollPane_fan = new JScrollPane(this.FANGroup);
        scrollPane_fan.setPreferredSize(new Dimension(200, 190));
        this.FANGroup.setPreferredSize(new Dimension(200, 190));
        this.FANFrame.getContentPane().add((Component)scrollPane_fan, "Center");
        this.jDesktopPane1.add((Component)this.FANFrame, JLayeredPane.DEFAULT_LAYER);
        this.FANFrame.setBounds(0, 0, 200, 190);
        this.VOLFrame.setMaximizable(true);
        this.VOLFrame.setTitle(L.t("sensor.Voltages"));
        this.VOLFrame.setIconifiable(true);
        this.VOLFrame.setForeground(Color.black);
        this.VOLFrame.setResizable(true);
        this.VOLFrame.setVisible(true);
        this.VOLFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.VOLFrameFocusGained(evt);
            }
        });
        JScrollPane scroll_vol = new JScrollPane(this.VOLGroup);
        scroll_vol.setPreferredSize(new Dimension(250, 240));
        this.VOLGroup.setPreferredSize(new Dimension(250, 240));
        this.VOLFrame.getContentPane().add((Component)scroll_vol, "Center");
        this.jDesktopPane1.add((Component)this.VOLFrame, JLayeredPane.DEFAULT_LAYER);
        this.VOLFrame.setBounds(210, 0, 400, 190);
        this.SENSORFrame.setMaximizable(true);
        this.SENSORFrame.setTitle(L.t("sensor.Sensors"));
        this.SENSORFrame.setIconifiable(true);
        this.SENSORFrame.setResizable(true);
        this.SENSORFrame.setVisible(true);
        this.SENSORFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.SENSORFrameFocusGained(evt);
            }
        });
        this.SENSORFrame.getContentPane().add((Component)this.SENSORGroup, "Center");
        this.jDesktopPane1.add((Component)this.SENSORFrame, JLayeredPane.DEFAULT_LAYER);
        this.SENSORFrame.setBounds(370, 250, 200, 130);
        this.SENSORFrame.setPreferredSize(new Dimension(200, 130));
        this.TEMPFrame.setMaximizable(true);
        this.TEMPFrame.setTitle(L.t("sensor.Temperatures"));
        this.TEMPFrame.setIconifiable(true);
        this.TEMPFrame.setResizable(true);
        this.TEMPFrame.setVisible(true);
        this.TEMPFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.TEMPFrameFocusGained(evt);
            }
        });
        JScrollPane scrollPane_temp = new JScrollPane(this.TEMPGroup);
        scrollPane_temp.setPreferredSize(new Dimension(600, 110));
        this.TEMPGroup.setPreferredSize(new Dimension(600, 110));
        this.TEMPFrame.getContentPane().add((Component)scrollPane_temp, "Center");
        this.jDesktopPane1.add((Component)this.TEMPFrame, JLayeredPane.DEFAULT_LAYER);
        this.TEMPFrame.setBounds(0, 190, 260, 210);
        this.PowerConFrame.setMaximizable(true);
        this.PowerConFrame.setTitle("Other Units-based Sensors");
        this.PowerConFrame.setIconifiable(true);
        this.PowerConFrame.setResizable(true);
        this.PowerConFrame.setVisible(true);
        this.PowerConFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.OtherFrameFocusGained(evt);
            }
        });
        this.PowerConFrame.getContentPane().add((Component)this.PowerConGroup, "Center");
        this.jDesktopPane1.add((Component)this.PowerConFrame, JLayeredPane.DEFAULT_LAYER);
        this.PowerConFrame.setBounds(370, 370, 200, 100);
        this.PowerConFrame.setPreferredSize(new Dimension(200, 100));
        this.DiscreteFrame.setMaximizable(true);
        this.DiscreteFrame.setTitle("Discrete Sensors");
        this.DiscreteFrame.setIconifiable(true);
        this.DiscreteFrame.setResizable(true);
        this.DiscreteFrame.setVisible(true);
        this.DiscreteFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.DiscreteFrameFocusGained(evt);
            }
        });
        JScrollPane scrollPane_discrete = new JScrollPane(this.DiscreteGroup);
        this.DiscreteFrame.getContentPane().add((Component)scrollPane_discrete, "Center");
        this.jDesktopPane1.add((Component)this.DiscreteFrame, JLayeredPane.DEFAULT_LAYER);
        this.DiscreteFrame.setBounds(300, 300, 300, 100);
        this.DiscreteFrame.setPreferredSize(new Dimension(220, 110));
        this.add((Component)this.jDesktopPane1, "Center");
        this.jPanel8.setEnabled(false);
        this.jPanel1.setBorder(new EtchedBorder());
        this.jRefreshLabel.setText(L.t("sensor.Refresh_every"));
        this.jRefreshLabel.setForeground(Color.black);
        this.jRefreshLabel.setEnabled(false);
        this.jPanel1.add(this.jRefreshLabel);
        this.jAutoTimer.setPreferredSize(new Dimension(50, 26));
        this.jAutoTimer.setEnabled(false);
        this.jAutoTimer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Sensors20.this.jAutoTimerItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jAutoTimer);
        this.jTimerLabel.setText(L.t("sensor.seconds"));
        this.jTimerLabel.setForeground(Color.black);
        this.jTimerLabel.setEnabled(false);
        this.jPanel1.add(this.jTimerLabel);
        this.jManuRefresh.setText(L.t("sensor.Refresh_Now"));
        this.jManuRefresh.setEnabled(false);
        this.jManuRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sensors20.this.jManuRefreshActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jManuRefresh);
        this.jPanel8.add(this.jPanel1);
        this.jSaveLayout.setText(L.t("sensor.Save_Layout"));
        this.jSaveLayout.setEnabled(false);
        this.jSaveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sensors20.this.jSaveLayoutActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jSaveLayout);
        this.jHideItem.setSelected(true);
        this.jHideItem.setText(L.t("sensor.Hide_inactive_item"));
        this.jHideItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Sensors20.this.jHideItemItemStateChanged(evt);
            }
        });
        this.jHistoryItem.setSelected(false);
        this.jHistoryItem.setText(L.t("sensor.Show_History"));
        this.jHistoryItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Sensors20.this.jHistoryItemItemStateChanged(evt);
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(2, 1));
        jPanel9.add(this.jHideItem);
        jPanel9.add(this.jHistoryItem);
        this.jPanel8.add(jPanel9);
        this.add((Component)this.jPanel8, "South");
        this.PSUFrame.getContentPane().add((Component)this.PSUPanel, "Center");
        this.PSUFrame.setBounds(0, 280, 300, 362);
        this.PSUFrame.setMaximizable(true);
        this.PSUFrame.setTitle("PSU");
        this.PSUFrame.setIconifiable(true);
        this.PSUFrame.setForeground(Color.black);
        this.PSUFrame.setResizable(true);
        this.jDesktopPane1.add((Component)this.PSUFrame, JLayeredPane.DEFAULT_LAYER);
    }

    private void SENSORFrameFocusGained(FocusEvent evt) {
        this.SENSORFrame.moveToFront();
    }

    private void TEMPFrameFocusGained(FocusEvent evt) {
        this.TEMPFrame.moveToFront();
    }

    private void VOLFrameFocusGained(FocusEvent evt) {
        this.VOLFrame.moveToFront();
    }

    private void FANFrameFocusGained(FocusEvent evt) {
        this.FANFrame.moveToFront();
    }

    private void OtherFrameFocusGained(FocusEvent evt) {
        this.PowerConFrame.moveToFront();
    }

    private void DiscreteFrameFocusGained(FocusEvent evt) {
        this.DiscreteFrame.moveToFront();
    }

    private void jSaveLayoutActionPerformed(ActionEvent evt) {
        String totalstr = this.getLayoutPosition();
        this.Devicefile.SaveLayoutToFile(IPMIView20.propertyFolder + "IPMIView", this.hostname, totalstr);
        this.Message.setText(L.t("sensor.Layout_Configuration_saved"));
    }

    private String getLayoutPosition() {
        String xstr;
        Rectangle FANp = this.FANFrame.getNormalBounds();
        String ystr = this.FANFrame.isMaximum() ? "2" : (this.FANFrame.isIcon() ? "1" : "0");
        String totalstr = xstr = FANp.x + "," + FANp.y + "," + FANp.height + "," + FANp.width + "," + ystr;
        Rectangle VOLp = this.VOLFrame.getNormalBounds();
        ystr = this.VOLFrame.isMaximum() ? "2" : (this.VOLFrame.isIcon() ? "1" : "0");
        xstr = VOLp.x + "," + VOLp.y + "," + VOLp.height + "," + VOLp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle TEMPp = this.TEMPFrame.getNormalBounds();
        ystr = this.TEMPFrame.isMaximum() ? "2" : (this.TEMPFrame.isIcon() ? "1" : "0");
        xstr = TEMPp.x + "," + TEMPp.y + "," + TEMPp.height + "," + TEMPp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle SNRp = this.SENSORFrame.getNormalBounds();
        ystr = this.SENSORFrame.isMaximum() ? "2" : (this.SENSORFrame.isIcon() ? "1" : "0");
        xstr = SNRp.x + "," + SNRp.y + "," + SNRp.height + "," + SNRp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle PSUp = this.PSUFrame.getNormalBounds();
        ystr = this.PSUFrame.isMaximum() ? "2" : (this.PSUFrame.isIcon() ? "1" : "0");
        xstr = PSUp.x + "," + PSUp.y + "," + PSUp.height + "," + PSUp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle Discretep = this.DiscreteFrame.getNormalBounds();
        ystr = this.DiscreteFrame.isMaximum() ? "2" : (this.DiscreteFrame.isIcon() ? "1" : "0");
        xstr = Discretep.x + "," + Discretep.y + "," + Discretep.height + "," + Discretep.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        return totalstr;
    }

    private void jHideItemItemStateChanged(ItemEvent evt) {
        if (this.jHideItem.isSelected()) {
            int i;
            for (i = 0; i < this.TempPanelSize; ++i) {
                if (this.TempPanel[i] == null) continue;
                if (this.TempPanel[i].tempMeter.m_ShowString.compareTo("0.0") == 0 || "N/A".equals(this.TempPanel[i].tempMeter.m_ShowString)) {
                    this.TempPanel[i].setVisible(false);
                    continue;
                }
                this.TempPanel[i].setVisible(true);
            }
            for (i = 0; i < this.textTempPanelSize && this.textTempPanel[i] != null; ++i) {
                if (this.textTempPanel[i].reading != 7) continue;
                this.textTempPanel[i].setVisible(false);
            }
            for (i = 0; i < this.FanPanelSize; ++i) {
                if (this.FanPanel[i] == null) continue;
                if (this.FanPanel[i].fanMeter.m_ShowString.compareTo("N/A") == 0) {
                    this.FanPanel[i].setVisible(false);
                    continue;
                }
                this.FanPanel[i].setVisible(true);
            }
            for (i = 0; i < this.VolPanelSize; ++i) {
                if (this.VolPanel[i] == null) continue;
                if (this.VolPanel[i].volMeter.m_ShowString.compareTo("N/A") == 0) {
                    this.VolPanel[i].setVisible(false);
                    continue;
                }
                this.VolPanel[i].setVisible(true);
            }
        } else {
            int i;
            for (i = 0; i < this.TempPanelSize; ++i) {
                if (this.TempPanel[i] == null || this.TempPanel[i].isVisible()) continue;
                this.TempPanel[i].setVisible(true);
            }
            for (i = 0; i < this.textTempPanelSize; ++i) {
                if (this.textTempPanel[i] == null || this.textTempPanel[i].isVisible()) continue;
                this.textTempPanel[i].setVisible(true);
            }
            for (i = 0; i < this.FanPanelSize; ++i) {
                if (this.FanPanel[i] == null || this.FanPanel[i].isVisible()) continue;
                this.FanPanel[i].setVisible(true);
            }
            for (i = 0; i < this.VolPanelSize; ++i) {
                if (this.VolPanel[i] == null || this.VolPanel[i].isVisible()) continue;
                this.VolPanel[i].setVisible(true);
            }
        }
    }

    private void jHistoryItemItemStateChanged(ItemEvent evt) {
        if (this.jHistoryItem.isSelected()) {
            int i;
            for (i = 0; i < this.FanPanelSize; ++i) {
                if (this.FanPanel[i] == null) continue;
                this.FanPanel[i].showHistory();
                this.FanPanel[i].invalidate();
            }
            for (i = 0; i < this.VolPanelSize; ++i) {
                if (this.VolPanel[i] == null) continue;
                this.VolPanel[i].showHistory();
                this.VolPanel[i].invalidate();
            }
            for (i = 0; i < this.TempPanelSize; ++i) {
                if (this.TempPanel[i] == null) continue;
                this.TempPanel[i].showHistory();
                this.TempPanel[i].invalidate();
            }
            Point p = this.FANFrame.getLocation();
            this.FANFrame.setLocation(p.x + 1, p.y);
            p = this.VOLFrame.getLocation();
            this.VOLFrame.setLocation(p.x + 1, p.y);
            p = this.TEMPFrame.getLocation();
            this.TEMPFrame.setLocation(p.x + 1, p.y);
        } else {
            int i;
            for (i = 0; i < this.FanPanelSize; ++i) {
                if (this.FanPanel[i] == null) continue;
                this.FanPanel[i].showMeter();
                this.FanPanel[i].invalidate();
            }
            for (i = 0; i < this.VolPanelSize; ++i) {
                if (this.VolPanel[i] == null) continue;
                this.VolPanel[i].showMeter();
                this.VolPanel[i].invalidate();
            }
            for (i = 0; i < this.TempPanelSize; ++i) {
                if (this.TempPanel[i] == null) continue;
                this.TempPanel[i].showMeter();
                this.TempPanel[i].invalidate();
            }
            Point p = this.FANFrame.getLocation();
            this.FANFrame.setLocation(p.x - 1, p.y);
            p = this.VOLFrame.getLocation();
            this.VOLFrame.setLocation(p.x - 1, p.y);
            p = this.TEMPFrame.getLocation();
            this.TEMPFrame.setLocation(p.x - 1, p.y);
        }
        this.validate();
        this.invalidate();
    }

    public void jAutoTimerItemStateChanged(ItemEvent evt) {
        if (this.refreshFlag) {
            String x = (String)this.jAutoTimer.getSelectedItem();
            int xx = Integer.parseInt(x);
            TimerTask t = new TimerTask(){

                @Override
                public void run() {
                    Thread th = new Thread(){

                        @Override
                        public void run() {
                            Sensors20.this.RefreshSensors();
                        }
                    };
                    th.start();
                }
            };
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule(t, xx * 1000, (long)(xx * 1000));
        }
    }

    private void jManuRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            @Override
            public void run() {
                Cursor csrTemp = new Cursor(3);
                Sensors20.this.setCursor(csrTemp);
                Sensors20.this.RefreshSensors();
                csrTemp = new Cursor(0);
                Sensors20.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public void removeTableData(DefaultTableModel model) {
        int rowCount = model.getRowCount();
        if (rowCount == 0) {
            return;
        }
        for (int i = rowCount - 1; i >= 0; --i) {
            model.removeRow(i);
        }
    }

    public void setTableData(DefaultTableModel model, String status, String sensorName, String value) {
        Object[] data = new String[]{status, sensorName, value};
        model.addRow(data);
        model.fireTableDataChanged();
    }

    private synchronized boolean getPriorDone() {
        return this.priorDone;
    }

    private synchronized void setPriorDone(boolean isDone) {
        this.priorDone = isDone;
    }

    private int getSensorReadingFromSensorNumber(IPMISDRCommand command, int sensorNumber) {
        int value = 0;
        if (command != null) {
            value = command.getSensorReading((byte)sensorNumber);
        }
        return value;
    }

    private int getDiscreteReading(IPMISDRCommand command, int sensorNumber) {
        int discreteReading = 0;
        if (command != null) {
            discreteReading = command.getDiscreteOffset((byte)sensorNumber);
        }
        return discreteReading;
    }

    private IPMIInterfaceConfig getIPMIConfig() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.Session.SIP);
        config.setUserName(this.Session.userID);
        config.setPassword(this.Session.getPasswordStr());
        config.setPrivilege(this.Session.MaxLevel[0]);
        config.setSmcRAKP(this.Session.isSMCRAKP);
        return config;
    }

    @Override
    public void toolbarAction(int actionType) {
        if (actionType == 5) {
            this.setRefreshFlag(true);
        } else if (actionType == 6) {
            this.setRefreshFlag(false);
        }
    }

    public static void main(String[] argv) {
        System.out.println("\u00a4\u00a4\u00a4\u00e5\u00b4\u00fa\u00b8\u00d5 abc test");
    }

    class SensorRecord {
        int SensorNumber;
        int SensorType;
        byte Reading;
        byte Maximum;
        byte Minimum;
        String valueString;
        String MaxString;
        String MinString;
        String SensorName;
        byte UpperLimit;
        byte LowerLimit;
        int Linearization;
        int M;
        int B;
        int RExp;
        int BExp;
        byte eventReadingTypeCode;
        byte[] discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask = new byte[]{63, 63};

        SensorRecord() {
        }
    }
}

