/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.ComboTabListener;
import IPMIView20.DropShadowPanel;
import IPMIView20.IPMIView20;
import IPMIView20.SensorsReadingControl;
import IPMIView20.SensorsReadingInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SensorsReadingView
extends JPanel
implements SensorsReadingInterface,
ComboTabListener {
    private static final long serialVersionUID = 1L;
    private JPanel contentPanel = new JPanel();
    private JPanel springPanel = new JPanel();
    private SensorsPanel tempSensorPanel = new SensorsPanel(1);
    private SensorsPanel volSensorPanel = new SensorsPanel(1);
    private SensorsPanel fanSensorPanel = new SensorsPanel(1);
    private SensorsPanel batSensorPanel = new SensorsPanel(0);
    private SensorsPanel psuSensorPanel = new SensorsPanel(0);
    private SensorsPanel physicalSecuritySensorPanel = new SensorsPanel(0);
    private SensorsPanel others1SensorPanel = new SensorsPanel(1);
    private SensorsPanel others2SensorPanel = new SensorsPanel(0);
    private ComboTabListener comboTabListener = null;
    private SensorsReadingControl contorller = null;

    public SensorsReadingView(ComboTabListener listener) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.darkGray);
        this.contorller = new SensorsReadingControl(this);
        this.comboTabListener = listener;
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.setBackground(Color.WHITE);
        this.contentPanel.add(this.tempSensorPanel);
        this.contentPanel.add(this.volSensorPanel);
        this.contentPanel.add(this.fanSensorPanel);
        this.contentPanel.add(this.batSensorPanel);
        this.contentPanel.add(this.psuSensorPanel);
        this.contentPanel.add(this.physicalSecuritySensorPanel);
        this.contentPanel.add(this.others1SensorPanel);
        this.contentPanel.add(this.others2SensorPanel);
        this.tempSensorPanel.setType("Temperature");
        this.volSensorPanel.setType("Voltage");
        this.fanSensorPanel.setType("FAN");
        this.batSensorPanel.setType("Battery");
        this.psuSensorPanel.setType("PSU");
        this.physicalSecuritySensorPanel.setType("Physical Security");
        this.others1SensorPanel.setType("Others 1");
        this.others2SensorPanel.setType("Others 2");
        this.others1SensorPanel.setVisible(false);
        this.others2SensorPanel.setVisible(false);
        this.springPanel.setLayout(new BoxLayout(this.springPanel, 1));
        this.springPanel.add(Box.createVerticalGlue());
        this.add((Component)this.contentPanel, "North");
        this.add((Component)this.springPanel, "Center");
    }

    public void init(CSession session) {
        this.contorller.setControlSession(session);
    }

    public void refresh() {
        this.comboTabListener.toolbarStatus(1, new int[0]);
        this.comboTabListener.toolbarStatus(2, new int[0]);
        new Thread(() -> this.contorller.getData()).start();
    }

    @Override
    public void toolbarAction(int actionType) {
        if (actionType == 4 || actionType == 5) {
            this.refresh();
        }
    }

    @Override
    public void updateStatus(int status) {
        if (status == 0) {
            SwingUtilities.invokeLater(() -> {
                int tempIdx = 0;
                int volIdx = 0;
                int fanIdx = 0;
                int betIdx = 0;
                int psuIdx = 0;
                int phyIdx = 0;
                int others1Idx = 0;
                int others2Idx = 0;
                for (SensorsReadingControl.ReadingData readings : this.contorller.tempReadings) {
                    this.tempSensorPanel.load(tempIdx++, readings, true);
                }
                for (SensorsReadingControl.ReadingData readings : this.contorller.volReadings) {
                    this.volSensorPanel.load(volIdx++, readings, true);
                }
                for (SensorsReadingControl.ReadingData readings : this.contorller.fanReadings) {
                    this.fanSensorPanel.load(fanIdx++, readings, true);
                }
                for (SensorsReadingControl.ReadingData readings : this.contorller.batReadings) {
                    this.batSensorPanel.load(betIdx++, readings, true);
                }
                for (SensorsReadingControl.ReadingData readings : this.contorller.psuReadings) {
                    this.psuSensorPanel.load(psuIdx++, readings, true);
                }
                for (SensorsReadingControl.ReadingData readings : this.contorller.physicalSecurityReadings) {
                    this.physicalSecuritySensorPanel.load(phyIdx++, readings, true);
                }
                if (this.contorller.others1Readings.size() > 0) {
                    this.others1SensorPanel.setVisible(true);
                    for (SensorsReadingControl.ReadingData readings : this.contorller.others1Readings) {
                        this.others1SensorPanel.load(others1Idx++, readings, true);
                    }
                } else {
                    this.others1SensorPanel.setVisible(false);
                }
                if (this.contorller.others2Readings.size() > 0) {
                    this.others2SensorPanel.setVisible(true);
                    for (SensorsReadingControl.ReadingData readings : this.contorller.others2Readings) {
                        this.others2SensorPanel.load(others2Idx++, readings, true);
                    }
                } else {
                    this.others2SensorPanel.setVisible(false);
                }
                this.comboTabListener.toolbarStatus(0, new int[0]);
            });
        }
    }

    private class SensorsPanel
    extends DropShadowPanel {
        private static final long serialVersionUID = 1L;
        private final int DISPLAY_MODE_HIDDEN = 0;
        private final int DISPLAY_MODE_WORK = 1;
        private final int DISPLAY_MODE_ALL = 2;
        private static final String ICON_COLLAPSE = "/images/advanced.png";
        private static final String ICON_EXT_ADD = "/images/btn_Add.png";
        private static final String ICON_EXT_MINUS = "/images/btn_minus.png";
        private Icon collapseIcon = new ImageIcon(this.getClass().getResource("/images/advanced.png"));
        private Icon addIcon = new ImageIcon(this.getClass().getResource("/images/btn_Add.png"));
        private Icon minusIcon = new ImageIcon(this.getClass().getResource("/images/btn_minus.png"));
        private JLabel collapseLabel = new JLabel();
        private JLabel sensorTypeLabel = new JLabel();
        private JLabel displayStateLabel = new JLabel("All display");
        private JLabel toggleLabel = new JLabel();
        private JPanel headerPanel = new JPanel();
        private ReadingComponent titlePanel = null;
        private List<ReadingComponent> readingsList = new ArrayList<ReadingComponent>();
        private int displayMode = 1;
        private int panelType;

        public SensorsPanel(int type) {
            this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
            this.headerPanel.add(this.collapseLabel);
            this.headerPanel.add(Box.createHorizontalStrut(10));
            this.headerPanel.add(this.sensorTypeLabel);
            this.headerPanel.add(Box.createHorizontalGlue());
            this.headerPanel.add(this.displayStateLabel);
            this.headerPanel.add(Box.createHorizontalStrut(15));
            this.headerPanel.add(this.toggleLabel);
            this.headerPanel.add(Box.createHorizontalStrut(5));
            this.headerPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
            this.headerPanel.setBackground(Color.BLACK);
            this.headerPanel.setToolTipText("Toggle to switch hidden, active only and display all sensors mode");
            this.sensorTypeLabel.setForeground(Color.WHITE);
            this.sensorTypeLabel.setFont(new Font(IPMIView20.IPMI_DEFAULT_FONT, 1, 12));
            this.panelType = type;
            this.titlePanel = new ReadingComponent(type, 0);
            this.displayStateLabel.setVisible(false);
            this.displayStateLabel.setForeground(Color.WHITE);
            this.collapseLabel.setIcon(this.collapseIcon);
            this.toggleLabel.setIcon(this.minusIcon);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.headerPanel);
            this.add(Box.createRigidArea(new Dimension(10, 2)));
            this.add(this.titlePanel);
            this.headerPanel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SensorsPanel.this.displayMode = SensorsPanel.this.displayMode - 1;
                    if (SensorsPanel.this.displayMode < 0) {
                        SensorsPanel.this.displayMode = 2;
                    }
                    if (SensorsPanel.this.displayMode == 0) {
                        SensorsPanel.this.titlePanel.setVisible(false);
                        for (ReadingComponent comp : SensorsPanel.this.readingsList) {
                            comp.setVisible(false);
                        }
                        SensorsPanel.this.toggleLabel.setIcon(SensorsPanel.this.addIcon);
                    } else {
                        SensorsPanel.this.titlePanel.setVisible(true);
                        SensorsPanel.this.displayStateLabel.setVisible(SensorsPanel.this.displayMode == 2);
                        Iterator iterator = SensorsPanel.this.readingsList.iterator();
                        while (iterator.hasNext()) {
                            ReadingComponent comp;
                            comp.setVisible((comp = (ReadingComponent)iterator.next()).sensorStatusType == 0 || SensorsPanel.this.displayMode == 2);
                        }
                        SensorsPanel.this.toggleLabel.setIcon(SensorsPanel.this.minusIcon);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SensorsPanel.this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SensorsPanel.this.setCursor(new Cursor(0));
                }
            });
        }

        public void setType(String type) {
            this.sensorTypeLabel.setText(type);
        }

        public void load(int index, SensorsReadingControl.ReadingData readings, boolean hideInActive) {
            while (this.readingsList.size() <= index) {
                ReadingComponent comp = new ReadingComponent(this.panelType, index % 2 == 0 ? 1 : 2);
                this.readingsList.add(comp);
                this.add(comp);
            }
            this.readingsList.get(index).reload(readings, this.panelType, hideInActive);
            this.displayMode = 1;
            this.displayStateLabel.setVisible(false);
            this.titlePanel.setVisible(true);
        }
    }

    private class ReadingComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final String ICON_READING_OK = "/images/sensor_reading_success.png";
        private static final String ICON_READING_FAIL = "/images/sensor_reading_fail.png";
        private static final String ICON_READING_NONE = "/images/sensor_reading_none.png";
        protected Icon readingOkIcon = new ImageIcon(this.getClass().getResource("/images/sensor_reading_success.png"));
        protected Icon readingFailIcon = new ImageIcon(this.getClass().getResource("/images/sensor_reading_fail.png"));
        protected Icon readingNoneIcon = new ImageIcon(this.getClass().getResource("/images/sensor_reading_none.png"));
        private JLabel sensorStatus = new JLabel();
        private JLabel sensorName = new JLabel("Sensor");
        private JLabel sensorReading = new JLabel("Reading");
        private JLabel lowLimit = new JLabel("Low Limit");
        private JLabel highLimit = new JLabel("High Limit");
        private JLabel description = new JLabel("Description");
        private int sensorStatusType;

        public ReadingComponent(int type, int style) {
            this.setLayout(new BoxLayout(this, 0));
            switch (style) {
                case 0: {
                    this.sensorStatus.setText("Status");
                    this.sensorStatus.setForeground(Color.WHITE);
                    this.sensorName.setForeground(Color.WHITE);
                    this.sensorReading.setForeground(Color.WHITE);
                    this.lowLimit.setForeground(Color.WHITE);
                    this.highLimit.setForeground(Color.WHITE);
                    this.description.setForeground(Color.WHITE);
                    this.setBackground(new Color(124, 124, 124));
                    break;
                }
                case 1: {
                    this.setBackground(new Color(225, 225, 225));
                    break;
                }
                case 2: {
                    this.setBackground(new Color(237, 237, 237));
                }
            }
            this.sensorStatus.setMinimumSize(new Dimension(80, 20));
            this.sensorStatus.setPreferredSize(new Dimension(80, 20));
            this.sensorName.setMinimumSize(new Dimension(120, 20));
            this.sensorName.setPreferredSize(new Dimension(120, 20));
            this.sensorReading.setMinimumSize(new Dimension(80, 20));
            this.sensorReading.setPreferredSize(new Dimension(80, 20));
            this.lowLimit.setMinimumSize(new Dimension(80, 20));
            this.lowLimit.setPreferredSize(new Dimension(80, 20));
            this.highLimit.setMinimumSize(new Dimension(80, 20));
            this.highLimit.setPreferredSize(new Dimension(80, 20));
            this.description.setMinimumSize(new Dimension(240, 20));
            this.description.setPreferredSize(new Dimension(240, 20));
            this.add(Box.createHorizontalStrut(10));
            this.add(this.sensorStatus);
            this.add(Box.createHorizontalGlue());
            this.add(this.sensorName);
            this.add(Box.createHorizontalGlue());
            if (type == 1) {
                this.add(this.sensorReading);
                this.add(Box.createHorizontalGlue());
                this.add(this.lowLimit);
                this.add(Box.createHorizontalGlue());
                this.add(this.highLimit);
            } else {
                this.add(this.description);
                this.add(Box.createHorizontalGlue());
            }
        }

        public void reload(SensorsReadingControl.ReadingData data, int type, boolean hideInActive) {
            if (data.sensorStatus == 0) {
                this.sensorStatus.setIcon(this.readingOkIcon);
                this.sensorStatusType = 0;
            } else if (data.sensorStatus == 1) {
                this.sensorStatus.setIcon(this.readingFailIcon);
                this.sensorStatusType = 1;
            } else {
                this.sensorStatus.setIcon(this.readingNoneIcon);
                this.sensorStatusType = 2;
            }
            this.sensorName.setText(data.sensorName);
            if (type == 0) {
                this.description.setText(data.description != null ? data.description : data.sensorReading);
            } else {
                this.sensorReading.setText(data.sensorReading);
                this.lowLimit.setText(data.lowLimit);
                this.highLimit.setText(data.highLimit);
            }
            if (hideInActive) {
                this.setVisible(data.sensorStatus == 0);
            }
        }
    }
}

