/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ByteUtility;
import IPMIView20.CSession;
import IPMIView20.IPMIView20;
import IPMIView20.Logger;
import IPMIView20.RMCPPlus;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class UDPSocket {
    DatagramSocket socket;
    InetAddress saddress = null;
    InetAddress tempaddress = null;
    DatagramPacket s_packet;
    DatagramPacket r_packet;
    byte[] recvBuf = new byte[256];
    int InSeqNum = 0;
    boolean bClosed = false;
    boolean ignoreIOException = true;
    CSession session;
    int noResponseCount = 0;
    int NO_RESPONSE_COUNT_LIMIT = 5;
    int receiveByteLength = 0;
    private boolean retry = true;
    private boolean timeoutCounter = true;
    private boolean responseCount = true;
    private int retryTime = 5;
    int timeout = 30;
    byte[] latestResponseSeq = new byte[4];
    public RMCPPlus rmcpPlus;

    public UDPSocket(int timeout, int retryTime) {
        this.timeout = timeout;
        this.retryTime = retryTime;
        try {
            this.socket = new DatagramSocket();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void initSession(CSession session) {
        this.session = session;
    }

    private void printSeqNum(byte[] seq) {
        for (int i = 0; i < seq.length; ++i) {
            System.out.print(seq[i] + ",");
        }
        System.out.println("");
    }

    public synchronized boolean SendPacket(String SIP, int port, byte[] InboundSeqNum, byte[] Payload2, int datalength, boolean wantRetry) {
        boolean gotback = false;
        int loop = 1;
        int SIPint = 0;
        try {
            if (IPMIView20.getInstance() == null) {
                return false;
            }
            this.saddress = IPMIView20.getInstance().isProxyEnabled ? InetAddress.getByName(IPMIView20.getInstance().proxyIP) : InetAddress.getByName(SIP);
            SIPint = this.saddress.hashCode();
            if (SIPint == 0) {
                return false;
            }
        }
        catch (UnknownHostException ue) {
            return false;
        }
        try {
            this.tempaddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            this.tempaddress = null;
            Logger.writeLog("tempaddress = InetAddress.getLocalHost() report UnknowHostException");
        }
        int slength = datalength;
        int rlength = 256;
        this.s_packet = IPMIView20.getInstance().isProxyEnabled ? new DatagramPacket(Payload2, slength, this.saddress, IPMIView20.getInstance().proxyPort) : new DatagramPacket(Payload2, slength, this.saddress, port);
        this.r_packet = new DatagramPacket(this.recvBuf, rlength, this.tempaddress, port);
        while (true) {
            if (this.bClosed) {
                return false;
            }
            try {
                this.socket.send(this.s_packet);
            }
            catch (SecurityException e) {
                return false;
            }
            catch (IOException ie) {
                return false;
            }
            if (this.timeoutCounter && wantRetry) {
                IPMIView20.getInstance().timeoutCounter.start();
            }
            try {
                if (!wantRetry) {
                    this.socket.setSoTimeout(5000);
                } else {
                    this.socket.setSoTimeout(this.timeout * 1000);
                }
            }
            catch (SecurityException e) {
                if (IPMIView20.getInstance().DEBUG) {
                    Logger.writeLog(SIP + " Timeout for sent command.\n");
                }
                e.printStackTrace();
                return false;
            }
            catch (IOException ie) {
                return false;
            }
            gotback = false;
            try {
                this.socket.receive(this.r_packet);
                gotback = true;
                this.noResponseCount = 0;
                this.receiveByteLength = this.r_packet.getLength();
                if (this.timeoutCounter && wantRetry) {
                    IPMIView20.getInstance().timeoutCounter.stop();
                }
                if (this.session == null || !this.session.isPeppercon) break;
                byte[] seq = new byte[4];
                System.arraycopy(this.recvBuf, 10, seq, 0, 4);
                if ((seq[0] != 0 || seq[1] != 0 || seq[2] != 0 || seq[3] != 0) && seq[0] == this.latestResponseSeq[0] && seq[1] == this.latestResponseSeq[1] && seq[2] == this.latestResponseSeq[2] && seq[3] == this.latestResponseSeq[3]) {
                    System.out.println("[dup PK]");
                    throw new IOException();
                }
                this.latestResponseSeq = seq;
            }
            catch (SecurityException e) {
                if (IPMIView20.getInstance().DEBUG) {
                    Logger.writeLog(SIP + " Receive Security violation.\n");
                }
                if (this.timeoutCounter && wantRetry) {
                    IPMIView20.getInstance().timeoutCounter.stop();
                }
                return false;
            }
            catch (IOException ie) {
                if (!wantRetry) break;
                if (this.timeoutCounter && wantRetry) {
                    IPMIView20.getInstance().timeoutCounter.stop();
                }
                ++this.noResponseCount;
                if (IPMIView20.getInstance().DEBUG) {
                    Logger.writeLog("[UDPSocket] No Response from :" + ByteUtility.bytesToHex(InboundSeqNum));
                }
                if (IPMIView20.getInstance().DEBUG) {
                    Logger.writeLog("NoResponseCount =" + this.noResponseCount);
                }
                if (this.retry) {
                    for (int i = 0; i < this.retryTime; ++i) {
                        if (this.session.isPeppercon) {
                            byte[] newPayload = new byte[256];
                            RMCPPlus rmcpplus = new RMCPPlus();
                            rmcpplus.Session = this.session;
                            this.session.IncreaseSessionSeq();
                            System.arraycopy(this.session.SessionSeq, 0, this.session.originalEncryptedpayLoadWithoutAuthcode, 10, 4);
                            System.arraycopy(this.session.originalEncryptedpayLoadWithoutAuthcode, 0, newPayload, 0, this.session.originalEncryptedpayLoadWithoutAuthcode.length);
                            int newDatalength = rmcpplus.refinalSignAuthCode(newPayload, this.session.originalEncryptedpayLoadWithoutAuthcode);
                            Payload2 = newPayload;
                            datalength = newDatalength;
                        }
                        if (!this.SendPacketForRetry(SIP, port, InboundSeqNum, Payload2, datalength)) continue;
                        if (IPMIView20.getInstance().DEBUG) {
                            Logger.writeLog("resend successful !!");
                        }
                        return true;
                    }
                    IPMIView20.getInstance().Message.setText("retry " + this.retryTime + " times. No response after retry. Give up this command.");
                }
                if (!this.responseCount) continue;
                if (IPMIView20.getInstance().jTabbedPane == null || IPMIView20.getInstance().jTabbedPane.getTabCount() == 0 || this.session == null) {
                    return false;
                }
                int tabbedSelectIndexString = IPMIView20.getInstance().jTabbedPane.indexOfTab(this.session.hostName);
                if (tabbedSelectIndexString == -1) continue;
                IPMIView20.getInstance().jTabbedPane.setSelectedIndex(tabbedSelectIndexString);
                IPMIView20.getInstance().closeActivatelySessionFromNoResponse(this.session.hostName);
                if (--loop > 0) continue;
            }
            break;
        }
        if (gotback) {
            if (this.timeoutCounter && wantRetry) {
                IPMIView20.getInstance().timeoutCounter.stop();
            }
            return true;
        }
        if (this.timeoutCounter && wantRetry) {
            IPMIView20.getInstance().timeoutCounter.stop();
        }
        return false;
    }

    public boolean SendPacketForRetry(String SIP, int port, byte[] InboundSeqNum, byte[] Payload2, int datalength) {
        if (IPMIView20.getInstance().DEBUG) {
            Logger.writeLog("No response, retry send packet ...");
        }
        if (IPMIView20.getInstance().DEBUG) {
            Logger.writeLog("Resend Content =" + ByteUtility.bytesToHex(Payload2));
        }
        boolean loop = true;
        int SIPint = 0;
        try {
            this.saddress = IPMIView20.getInstance().isProxyEnabled ? InetAddress.getByName(IPMIView20.getInstance().proxyIP) : InetAddress.getByName(SIP);
            SIPint = this.saddress.hashCode();
            this.tempaddress = InetAddress.getLocalHost();
            if (SIPint == 0) {
                return false;
            }
        }
        catch (UnknownHostException ue) {
            return false;
        }
        int slength = datalength;
        int rlength = 256;
        this.s_packet = IPMIView20.getInstance().isProxyEnabled ? new DatagramPacket(Payload2, slength, this.saddress, IPMIView20.getInstance().proxyPort) : new DatagramPacket(Payload2, slength, this.saddress, port);
        this.r_packet = new DatagramPacket(this.recvBuf, rlength, this.tempaddress, port);
        if (this.bClosed) {
            return false;
        }
        try {
            this.socket.send(this.s_packet);
        }
        catch (SecurityException e) {
            return false;
        }
        catch (IOException ie) {
            return false;
        }
        if (this.timeoutCounter) {
            IPMIView20.getInstance().timeoutCounter.start();
        }
        try {
            this.socket.setSoTimeout(this.timeout * 1000);
        }
        catch (SecurityException e) {
            if (IPMIView20.getInstance().DEBUG) {
                Logger.writeLog(SIP + " Timeout for sent command.\n");
            }
            e.printStackTrace();
            return false;
        }
        catch (IOException ie) {
            return false;
        }
        try {
            this.socket.receive(this.r_packet);
            this.noResponseCount = 0;
            if (this.timeoutCounter) {
                IPMIView20.getInstance().timeoutCounter.stop();
            }
        }
        catch (SecurityException e) {
            if (IPMIView20.getInstance().DEBUG) {
                Logger.writeLog(SIP + " Receive Security violation.\n");
            }
            if (this.timeoutCounter) {
                IPMIView20.getInstance().timeoutCounter.stop();
            }
            return false;
        }
        catch (IOException ie) {
            if (this.timeoutCounter) {
                IPMIView20.getInstance().timeoutCounter.stop();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        if (this.timeoutCounter) {
            IPMIView20.getInstance().timeoutCounter.stop();
        }
        return true;
    }

    public synchronized boolean SendPacketNoWait(String SIP, int port, byte[] InboundSeqNum, byte[] Payload2, int datalength) {
        boolean gotback = false;
        int loop = 1;
        int SIPint = 0;
        try {
            this.saddress = IPMIView20.getInstance().isProxyEnabled ? InetAddress.getByName(IPMIView20.getInstance().proxyIP) : InetAddress.getByName(SIP);
            SIPint = this.saddress.hashCode();
            this.tempaddress = InetAddress.getLocalHost();
            if (SIPint == 0) {
                return false;
            }
        }
        catch (UnknownHostException ue) {
            return false;
        }
        int slength = datalength;
        int rlength = 256;
        this.s_packet = IPMIView20.getInstance().isProxyEnabled ? new DatagramPacket(Payload2, slength, this.saddress, IPMIView20.getInstance().proxyPort) : new DatagramPacket(Payload2, slength, this.saddress, port);
        do {
            if (this.bClosed) {
                return false;
            }
            try {
                this.socket.send(this.s_packet);
            }
            catch (SecurityException e) {
                return false;
            }
            catch (IOException ie) {
                return false;
            }
        } while (--loop > 0);
        return true;
    }

    public synchronized byte[] sendData(String ip, int port, byte[] data) {
        int retry = 3;
        byte[] buffer = new byte[2048];
        InetAddress remoteAddress = null;
        InetAddress localAddress = null;
        try {
            remoteAddress = InetAddress.getByName(ip);
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex3) {
            return null;
        }
        DatagramPacket sendPacket = new DatagramPacket(data, data.length, remoteAddress, port);
        DatagramPacket receivePacket = new DatagramPacket(buffer, 256, localAddress, port);
        do {
            try {
                this.socket.send(sendPacket);
            }
            catch (IOException ex) {
                return null;
            }
            try {
                this.socket.setSoTimeout(this.timeout * 1000);
            }
            catch (SocketException ex2) {
                return null;
            }
            try {
                this.socket.receive(receivePacket);
            }
            catch (SocketTimeoutException ste) {
                continue;
            }
            catch (IOException ex1) {
                return null;
            }
            byte[] result = new byte[receivePacket.getLength()];
            System.arraycopy(buffer, 0, result, 0, receivePacket.getLength());
            return result;
        } while (--retry > 0);
        return null;
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public boolean isIgnoreIOException() {
        return this.ignoreIOException;
    }

    public void setIgnoreIOException(boolean ignoreIOException) {
        this.ignoreIOException = ignoreIOException;
    }

    public static void main(String[] args) {
        System.out.println("asdfasdfasdf" + null);
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isTimeoutCounter() {
        return this.timeoutCounter;
    }

    public void setTimeoutCounter(boolean timeoutCounter) {
        this.timeoutCounter = timeoutCounter;
    }

    public boolean isResponseCount() {
        return this.responseCount;
    }

    public void setResponseCount(boolean responseCount) {
        this.responseCount = responseCount;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public void closeSocket() {
        this.socket.close();
    }
}

