/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.Logger;
import IPMIView20.UOLDebug;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UOLUDPSocket {
    DatagramSocket socket;
    DatagramPacket packet;
    InetAddress address;
    boolean isInitialize = true;

    public UOLUDPSocket(String ip) {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException ex) {
            Logger.writeLog("Initialize socket error ");
            this.isInitialize = false;
        }
        try {
            this.address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException ue) {
            Logger.writeLog("UnknowHostException error ");
            this.isInitialize = false;
        }
    }

    private String byteToString(byte b) {
        int i = b & 0xFF;
        String strByte = Integer.toHexString(i);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public String toByteString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            sb.append(this.byteToString(byteArray[i]) + " ");
        }
        return sb.toString();
    }

    public synchronized boolean sendPacket(byte[] data) {
        this.packet = new DatagramPacket(data, data.length, this.address, 664);
        try {
            this.socket.send(this.packet);
            if (UOLDebug.debugLevel >= 1) {
                Logger.writeLog("-->> :" + this.toByteString(data));
            }
        }
        catch (IOException ex) {
            Logger.writeLog("Can't send packet to destination");
            return false;
        }
        return true;
    }
}

