/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.L;
import IPMIView20.UsersAdvancedSettingsInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.AccountLockoutSettingHelper;
import java.util.HashMap;

public class UsersAdvancedSettingsControl {
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    private UsersAdvancedSettingsInterface advancedSettingsListener;
    private RedfishHttpUtils utils;
    private Integer thresholdEnum;
    private Integer durationEnum;
    private Integer counterEnum;

    public UsersAdvancedSettingsControl(IPMIInterfaceConfig config, UsersAdvancedSettingsInterface listener) {
        this.ipmiInterfaceConfig = config;
        this.advancedSettingsListener = listener;
        this.utils = new RedfishHttpUtils();
        this.thresholdEnum = new Integer(0);
        this.durationEnum = new Integer(0);
        this.counterEnum = new Integer(0);
    }

    public int getThresholdEnum() {
        return this.thresholdEnum;
    }

    public int getDurationEnum() {
        return this.durationEnum;
    }

    public int getCounterEnum() {
        return this.counterEnum;
    }

    public void setThresholdEnum(int thresholdEnum) {
        this.thresholdEnum = thresholdEnum;
    }

    public void setDurationEnum(int durationEnum) {
        this.durationEnum = durationEnum;
    }

    public void setCounterEnum(int counterEnum) {
        this.counterEnum = counterEnum;
    }

    public boolean isEnabledLockoutControl() {
        return this.thresholdEnum != 0 && this.counterEnum != 0;
    }

    public boolean isValidCounterReset() {
        return this.counterEnum <= this.durationEnum;
    }

    public void loadProfile(boolean updateMsg) {
        this.advancedSettingsListener.updateState(2, true, new String[0]);
        if (updateMsg) {
            this.advancedSettingsListener.updateState(3, false, L.t("user.Loading_Advanced_Settings"));
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + "/redfish/v1/AccountService/";
        try {
            int httpStatusCode = this.utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
            if (200 <= httpStatusCode && httpStatusCode <= 210) {
                HashMap<String, String> entryMap = this.utils.getEntry();
                String thresholdStr = entryMap.get("AccountLockoutThreshold");
                String durationStr = entryMap.get("AccountLockoutDuration");
                String counterStr = entryMap.get("AccountLockoutCounterResetAfter");
                this.thresholdEnum = Integer.valueOf(thresholdStr);
                this.durationEnum = AccountLockoutSettingHelper.getCounterInEnum(Integer.valueOf(durationStr));
                this.counterEnum = AccountLockoutSettingHelper.getCounterInEnum(Integer.valueOf(counterStr));
                if (updateMsg) {
                    this.advancedSettingsListener.updateState(3, false, L.t("user.Loading_Advanced_Settings_done"));
                }
            } else if (401 == httpStatusCode || 404 == httpStatusCode) {
                this.advancedSettingsListener.updateState(5, false, new String[0]);
            } else {
                this.advancedSettingsListener.updateState(3, false, L.t("user.Loading_Advanced_Settings_failed"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.advancedSettingsListener.updateState(3, false, L.t("user.Loading_Advanced_Settings_failed"));
        }
        this.advancedSettingsListener.updateState(0, false, new String[0]);
    }

    public void saveProfile() {
        this.advancedSettingsListener.updateState(2, true, new String[0]);
        this.advancedSettingsListener.updateState(3, true, L.t("user.Saving_Advanced_Settings"));
        new Thread(() -> {
            String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + "/redfish/v1/AccountService/";
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("AccountLockoutThreshold", this.thresholdEnum);
                hashMap.put("AccountLockoutDuration", Integer.valueOf(AccountLockoutSettingHelper.getCounterInSeconds(this.durationEnum)));
                hashMap.put("AccountLockoutCounterResetAfter", Integer.valueOf(AccountLockoutSettingHelper.getCounterInSeconds(this.counterEnum)));
                String body = this.utils.getPatchBody(this.ipmiInterfaceConfig, url);
                body = this.utils.updateEntryValue(body, hashMap);
                int httpStatusCode = this.utils.sendRedfishPatch(this.ipmiInterfaceConfig, url, body);
                if (200 <= httpStatusCode && httpStatusCode <= 210) {
                    this.advancedSettingsListener.updateState(3, true, L.t("user.Saving_Advanced_Settings_done"));
                } else {
                    this.advancedSettingsListener.updateState(3, true, L.t("user.Saving_Advanced_Settings_failed"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.advancedSettingsListener.updateState(3, true, L.t("user.Saving_Advanced_Settings_failed"));
            }
            this.advancedSettingsListener.updateState(1, true, new String[0]);
        }).start();
    }
}

