/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.batch;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import java.util.ArrayList;

public class FindIPMIDeviceThread
extends Thread {
    IPMIInterfaceConfig config = new IPMIInterfaceConfig();
    ISessionController sessionController = null;
    byte[] guid = null;
    boolean isDone = false;

    @Override
    public void run() {
        this.isDone = false;
        MessageCenter.getInstance().deleteObservers();
        this.guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        this.isDone = true;
    }

    public static void main(String[] args) {
        String ip = "192.168.10.";
        System.out.println("Discoveing ...");
        ArrayList<FindIPMIDeviceThread> ipmidevices = new ArrayList<FindIPMIDeviceThread>();
        for (int i = 1; i < 254; ++i) {
            FindIPMIDeviceThread f = new FindIPMIDeviceThread();
            ipmidevices.add(f);
            f.config.setIp(ip + i);
            f.start();
        }
        System.out.println("Checking ...");
        boolean finish = false;
        while (!finish) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException f) {
                // empty catch block
            }
            for (int i = 0; i < ipmidevices.size(); ++i) {
                finish = true;
                if (((FindIPMIDeviceThread)ipmidevices.get((int)i)).isDone) continue;
                finish = false;
            }
        }
        for (int i = 0; i < ipmidevices.size(); ++i) {
            FindIPMIDeviceThread f = (FindIPMIDeviceThread)ipmidevices.get(i);
            byte[] guid = f.guid;
            if (guid == null) continue;
            String type = "none";
            if (guid != null) {
                type = IPMIMessagingCommand.isCMMGUID(guid) ? "CMM" : (IPMIMessagingCommand.isPepperconGUID(guid) ? "SIM" : (IPMIMessagingCommand.isPepperconGUID(guid) ? "SIM None KVM" : "Other IPMI"));
            }
            System.out.println(f.config.getIp() + " ....... " + type);
        }
    }
}

