/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class Label10GSwitch
extends LabelBladeComponent {
    ImageIcon label10GigabitSwitchUp = new ImageIcon(this.getClass().getResource("/images/label10gSwitch-up.jpg"));
    ImageIcon label10GigabitSwitchDown = new ImageIcon(this.getClass().getResource("/images/label10gSwitch-up.jpg"));
    BladeSystemEntity bladeSystemEntity = null;

    public Label10GSwitch() {
        this.setIcon(this.label10GigabitSwitchUp);
        this.setSize(21, 144);
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.setModuleName("10G Switch");
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[Label10GSwitch] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Label10GSwitch.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        TenGSwitchEntity tenGSwitchEntity = this.bladeSystemEntity.getTenGSwitches()[this.number - 1];
        if (tenGSwitchEntity.getPresent() != 0 && tenGSwitchEntity.is10GSwitch()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        }
        if (this.number == 1) {
            this.setIcon(this.label10GigabitSwitchUp);
        } else {
            this.setIcon(this.label10GigabitSwitchDown);
        }
        if (tenGSwitchEntity.isPowerOnCheckedByVoltage()) {
            this.setPowerStatus(0);
        } else {
            this.setPowerStatus(1);
        }
        if (tenGSwitchEntity.isPowerOnCheckedByVoltage() && tenGSwitchEntity.isError()) {
            this.setAlertVisible(true);
        } else {
            this.setAlertVisible(false);
        }
    }
}

