/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBlade;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class LabelBladeSystemFrontView
extends JPanel
implements Observer {
    public static final int BLADE_10 = 10;
    public static final int BLADE_14 = 14;
    public static final int BLADE_20 = 20;
    public LabelBlade[] labelBlades;
    ImageIcon iconBladeSystemFrontView10b = new ImageIcon(this.getClass().getResource("/images/labelBladeSystemFrontView.png"));
    ImageIcon iconBladeSystemFrontView14b = new ImageIcon(this.getClass().getResource("/images/labelBladeSystemFrontView14b.png"));
    ImageIcon iconBladeSystemFrontView20b = new ImageIcon(this.getClass().getResource("/images/labelBladeSystemFrontView20b.png"));
    int pixWidth_10b = 22;
    int pixWidth_14b = 16;
    int pixWidth_20b = 22;
    int bladeSize;
    int pixWidthRef;
    ImageIcon iconBladeSystemFrontViewRef = null;

    public LabelBladeSystemFrontView(int bladeSize) {
        try {
            this.resetBladeSize(bladeSize);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LabelBladeSystemFrontView() {
        this(10);
    }

    public void resetBladeSize(int bladeSize) {
        if (this.labelBlades != null) {
            for (int i = 0; i < this.labelBlades.length; ++i) {
                if (this.labelBlades[i] == null) continue;
                this.labelBlades[i].labelBladeGroup.removeLabelBladeComponent(this.labelBlades[i]);
                this.labelBlades[i] = null;
            }
        }
        this.bladeSize = bladeSize;
        this.labelBlades = new LabelBlade[bladeSize];
        switch (bladeSize) {
            case 10: {
                this.iconBladeSystemFrontViewRef = this.iconBladeSystemFrontView10b;
                this.pixWidthRef = this.pixWidth_10b;
                break;
            }
            case 14: {
                this.iconBladeSystemFrontViewRef = this.iconBladeSystemFrontView14b;
                this.pixWidthRef = this.pixWidth_14b;
                break;
            }
            case 20: {
                this.iconBladeSystemFrontViewRef = this.iconBladeSystemFrontView20b;
                this.pixWidthRef = this.pixWidth_20b;
                break;
            }
            default: {
                this.iconBladeSystemFrontViewRef = this.iconBladeSystemFrontView10b;
                this.pixWidthRef = this.pixWidth_10b;
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clearReference() {
        this.removeAll();
        for (int i = 0; i < this.labelBlades.length; ++i) {
            this.labelBlades[i] = null;
        }
        this.labelBlades = null;
    }

    private void jbInit() throws Exception {
        this.removeAll();
        this.setLayout(null);
        if (this.bladeSize == 10 || this.bladeSize == 14) {
            for (int i = 0; i < this.bladeSize; ++i) {
                this.labelBlades[i] = new LabelBlade();
                this.labelBlades[i].setNumber(i + 1);
                this.labelBlades[i].setBounds(new Rectangle(1 + this.pixWidthRef * i, 1, this.labelBlades[i].getWidth(), this.labelBlades[i].getHeight()));
                this.add(this.labelBlades[i]);
            }
        } else if (this.bladeSize == 20) {
            for (int i = 0; i < this.bladeSize; ++i) {
                this.labelBlades[i] = new LabelBlade();
                this.labelBlades[i].setNumber(i + 1);
                int x = 1 + this.pixWidthRef * i;
                int y = 1;
                if (i >= 10) {
                    y = this.labelBlades[i].getHeight() / 2 + 1;
                    x = 1 + this.pixWidthRef * (i - 10);
                }
                this.labelBlades[i].setBounds(new Rectangle(x, y, this.labelBlades[i].getWidth(), this.labelBlades[i].getHeight()));
                this.add(this.labelBlades[i]);
            }
        }
        this.setPreferredSize(new Dimension(this.iconBladeSystemFrontViewRef.getIconWidth(), this.iconBladeSystemFrontViewRef.getIconHeight()));
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.iconBladeSystemFrontViewRef.getImage(), 0, 0, null);
        this.setOpaque(false);
        super.paintComponent(g);
    }

    public void setAllModuleNumberVisible(boolean visible) {
        for (int i = 0; i < this.labelBlades.length; ++i) {
            this.labelBlades[i].setNumberVisible(visible);
        }
    }

    public void setAllModulePictureVisible(boolean visible) {
        for (int i = 0; i < this.labelBlades.length; ++i) {
            this.labelBlades[i].setShowPicture(visible);
        }
    }

    public void setAllModuleShowStatus(boolean visible) {
        for (int i = 0; i < this.labelBlades.length; ++i) {
            this.labelBlades[i].setShowStatus(visible);
        }
    }

    public void addMouseAdaptorForAllModule(MouseAdapter m) {
        for (int i = 0; i < this.labelBlades.length; ++i) {
            this.labelBlades[i].addMouseListener(m);
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelBladeSystegmFrontView] [Notify]");
        }
        for (int i = 0; i < this.labelBlades.length; ++i) {
            this.labelBlades[i].update(o, obj);
        }
    }

    public LabelBlade[] getLabelBlades() {
        return this.labelBlades;
    }
}

