/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.JVolPanel;
import IPMIView20.blade.Label10GPassThru;
import IPMIView20.blade.Single10gPassThruPanel_jMenuItem1_actionAdapter;
import IPMIView20.blade.SingleModuleAbstractPanel;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.TenGPassThruEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class Single10gPassThruPanel
extends SingleModuleAbstractPanel {
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static int VOLTAGE_V33_FULL_SCALE = 5;
    public static int VOLTAGE_V12_FULL_SCALE = 2;
    boolean initSensors = false;
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    JTempPanel temp1v25 = new JTempPanel();
    JTempPanel temp3v3 = new JTempPanel();
    JVolPanel vram3v3Voltage = new JVolPanel();
    JVolPanel vcore1v2Voltage = new JVolPanel();
    JPanel jRightPanel = new JPanel();
    JPanel jCenterPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    JPanel jLeftPanel = new JPanel();
    TitledBorder titledBorder3 = new TitledBorder("");
    JPanel jStatusPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1 = BorderFactory.createEmptyBorder();
    Border border2 = new TitledBorder(this.border1, "Status");
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    GridLayout gridLayout7 = new GridLayout();
    JLabel jTemp3v3StringLabel = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jTemp3v3Label = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jVram3v3StringLabel = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jVram3v3Label = new JLabel();
    JLabel jCvore1v25StringLabel = new JLabel();
    JLabel jLabel11 = new JLabel();
    JLabel jVcore1v25Label = new JLabel();
    JLabel jTemp1v25StringLabel = new JLabel();
    JLabel jTemp1v25Label = new JLabel();
    JLabel jLabel15 = new JLabel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JLabel notPresent = new JLabel("Module not present");
    BladeSystemEntity bladeSystemEntity = null;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jVoltagePanel = new JPanel();
    JPanel jTempPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jMenuItem1 = new JMenuItem();

    public Single10gPassThruPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void myInit() {
        this.temp1v25.tempMeter.setPreferredSize(new Dimension(120, 35));
        this.temp3v3.tempMeter.setPreferredSize(new Dimension(120, 35));
        this.vram3v3Voltage.volMeter.setPreferredSize(new Dimension(117, 69));
        this.vcore1v2Voltage.volMeter.setPreferredSize(new Dimension(117, 69));
        this.jTempPanel.add(this.temp3v3);
        this.jTempPanel.add(this.temp1v25);
        this.jVoltagePanel.add(this.vram3v3Voltage);
        this.jVoltagePanel.add(this.vcore1v2Voltage);
        this.temp1v25.init("Temp. VR1.25V", (byte)0, (byte)0, "", "");
        this.temp3v3.init("Temp. VR3.3V", (byte)0, (byte)0, "", "");
        this.vram3v3Voltage.init("3.3V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.vcore1v2Voltage.init("1.2V", (byte)0, (byte)0, (byte)0, "", "", "");
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[Single10gPassThruPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Single10gPassThruPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        TenGPassThruEntity tenGPassThruEntity = this.bladeSystemEntity.getTenGPassThrus()[this.moduleIndex - 1];
        boolean present = tenGPassThruEntity.getPresent() != 0 && tenGPassThruEntity.getType() == 1;
        byte tempLimit = 80;
        if (!present) {
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        this.jPowerStatusLabel.setText("On");
        this.jPowerStatusLabel.setIcon(this.powerOnIcon);
        if (tenGPassThruEntity.getTemp_1v25() < 80) {
            this.jTemp1v25Label.setIcon(this.okGreenIcon);
            this.jTemp1v25Label.setForeground(Color.GREEN);
            this.jTemp1v25Label.setText("Normal");
        } else {
            this.jTemp1v25Label.setIcon(this.xRedIcon);
            this.jTemp1v25Label.setForeground(Color.RED);
            this.jTemp1v25Label.setText("Error");
        }
        if (tenGPassThruEntity.getTemp_3v3() < 80) {
            this.jTemp3v3Label.setIcon(this.okGreenIcon);
            this.jTemp3v3Label.setForeground(Color.GREEN);
            this.jTemp3v3Label.setText("Normal");
        } else {
            this.jTemp3v3Label.setIcon(this.xRedIcon);
            this.jTemp3v3Label.setForeground(Color.RED);
            this.jTemp3v3Label.setText("Error");
        }
        double v33 = tenGPassThruEntity.getVram_3v3Formula();
        double v33LowLimit = 2.9699999999999998;
        double v33HighLimit = 3.63;
        byte v33Ratio = (byte)(v33 * 256.0 / (double)VOLTAGE_V33_FULL_SCALE);
        byte v33LowLimitRatio = (byte)(v33LowLimit * 256.0 / (double)VOLTAGE_V33_FULL_SCALE);
        byte v33HighLimitRatio = (byte)(v33HighLimit * 256.0 / (double)VOLTAGE_V33_FULL_SCALE);
        String v33String = this.doubleToString(v33);
        String v33LowLimitString = this.doubleToString(v33LowLimit);
        String v33HighLimitString = this.doubleToString(v33HighLimit);
        double v12 = tenGPassThruEntity.getVcore_1v2Formula();
        double v12LowLimit = 1.08;
        double v12HighLimit = 1.32;
        byte v12Ratio = (byte)(v12 * 256.0 / (double)VOLTAGE_V12_FULL_SCALE);
        byte v12LowLimitRatio = (byte)(v12LowLimit * 256.0 / (double)VOLTAGE_V12_FULL_SCALE);
        byte v12HighLimitRatio = (byte)(v12HighLimit * 256.0 / (double)VOLTAGE_V12_FULL_SCALE);
        String v12String = this.doubleToString(v12);
        String v12LowLimitString = this.doubleToString(v12LowLimit);
        String v12HighLimitString = this.doubleToString(v12HighLimit);
        if (!this.initSensors) {
            this.temp1v25.init("Temp. VR1.25V", tenGPassThruEntity.getTemp_1v25(), tempLimit, "" + tenGPassThruEntity.getTemp_1v25(), "" + tempLimit);
            this.temp3v3.init("Temp. VR3.3V", tenGPassThruEntity.getTemp_3v3(), tempLimit, "" + tenGPassThruEntity.getTemp_3v3(), "" + tempLimit);
            this.vram3v3Voltage.init("3.3V", v33Ratio, v33HighLimitRatio, v33LowLimitRatio, v33String, v33HighLimitString, v33LowLimitString);
            this.vcore1v2Voltage.init("1.2V", v12Ratio, v12HighLimitRatio, v12LowLimitRatio, v12String, v12HighLimitString, v12LowLimitString);
            this.initSensors = true;
        }
        if (v33 < v33LowLimit || v33 > v33HighLimit) {
            this.jVram3v3Label.setIcon(this.xRedIcon);
            this.jVram3v3Label.setForeground(Color.RED);
            this.jVram3v3Label.setText("Abnormal");
        } else {
            this.jVram3v3Label.setIcon(this.okGreenIcon);
            this.jVram3v3Label.setForeground(Color.GREEN);
            this.jVram3v3Label.setText("Normal");
        }
        if (v12 < v12LowLimit || v12 > v12HighLimit) {
            this.jVcore1v25Label.setIcon(this.xRedIcon);
            this.jVcore1v25Label.setForeground(Color.RED);
            this.jVcore1v25Label.setText("Abnormal");
        } else {
            this.jVcore1v25Label.setIcon(this.okGreenIcon);
            this.jVcore1v25Label.setForeground(Color.GREEN);
            this.jVcore1v25Label.setText("Normal");
        }
        if (present) {
            this.temp1v25.updateValue(tenGPassThruEntity.getTemp_1v25(), "" + tenGPassThruEntity.getTemp_1v25());
            this.temp3v3.updateValue(tenGPassThruEntity.getTemp_3v3(), "" + tenGPassThruEntity.getTemp_3v3());
            this.vram3v3Voltage.updateValue(v33Ratio, v33String);
            this.vcore1v2Voltage.updateValue(v12Ratio, v12String);
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder3 = new TitledBorder("Status");
        this.titledBorder1 = new TitledBorder("Voltage and Temperature");
        this.jRightPanel.setBorder(this.titledBorder1);
        this.jRightPanel.setLayout(this.gridLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jLeftPanel.setLayout(this.borderLayout1);
        this.jCenterPanel.setBorder(null);
        this.jLeftPanel.setBorder(null);
        this.jStatusPanel.setBorder(this.titledBorder3);
        this.jStatusPanel.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(8);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.jPanel3.setLayout(this.gridLayout5);
        this.jPanel2.setLayout(this.gridLayout6);
        this.jPanel1.setLayout(this.gridLayout7);
        this.gridLayout3.setColumns(3);
        this.gridLayout3.setRows(0);
        this.gridLayout4.setColumns(3);
        this.gridLayout4.setRows(0);
        this.gridLayout6.setColumns(3);
        this.gridLayout6.setRows(0);
        this.gridLayout7.setColumns(3);
        this.gridLayout7.setRows(0);
        this.jTemp3v3StringLabel.setForeground(Color.blue);
        this.jTemp3v3StringLabel.setText("Temp. VR3.3V:");
        this.gridLayout5.setColumns(3);
        this.gridLayout5.setRows(0);
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setText("Power Status:");
        this.jVram3v3StringLabel.setForeground(Color.blue);
        this.jVram3v3StringLabel.setText("3.3V:");
        this.jCvore1v25StringLabel.setForeground(Color.blue);
        this.jCvore1v25StringLabel.setText("1.2V:");
        this.jTemp1v25StringLabel.setForeground(Color.blue);
        this.jTemp1v25StringLabel.setText("Temp. VR1.25V:");
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.jMenuItem1.setText("Focus Here");
        this.jMenuItem1.addActionListener(new Single10gPassThruPanel_jMenuItem1_actionAdapter(this));
        this.add((Component)this.jCenterPanel, "Center");
        this.jLeftPanel.add((Component)this.jStatusPanel, "Center");
        this.jStatusPanel.add(this.jPanel4);
        this.jPanel4.add(this.jPowerStatusStringLabel);
        this.jPanel4.add(this.jPowerStatusLabel);
        this.jPanel4.add(this.jLabel5);
        this.jStatusPanel.add(this.jPanel3);
        this.jPanel3.add(this.jVram3v3StringLabel);
        this.jPanel3.add(this.jVram3v3Label);
        this.jPanel3.add(this.jLabel8);
        this.jStatusPanel.add(this.jPanel2);
        this.jPanel2.add(this.jCvore1v25StringLabel);
        this.jPanel2.add(this.jVcore1v25Label);
        this.jPanel2.add(this.jLabel11);
        this.jStatusPanel.add(this.jPanel1);
        this.jPanel1.add(this.jTemp1v25StringLabel);
        this.jPanel1.add(this.jTemp1v25Label);
        this.jStatusPanel.add(this.jPanel5);
        this.jPanel5.add(this.jTemp3v3StringLabel);
        this.jPanel5.add(this.jTemp3v3Label);
        this.jPanel5.add(this.jLabel2);
        this.jPanel1.add(this.jLabel15);
        this.jStatusPanel.add(this.jPanel7);
        this.jStatusPanel.add(this.jPanel6);
        this.jCenterPanel.add((Component)this.jRightPanel, "Center");
        this.jRightPanel.add(this.jTempPanel);
        this.jRightPanel.add(this.jVoltagePanel);
        this.jCenterPanel.add((Component)this.jLeftPanel, "West");
        this.jPopupMenuForLabel.add(this.jMenuItem1);
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }

    public String doubleToString4(double value) {
        int temp = (int)(value * 10000.0);
        double d = (double)temp / 10000.0;
        return "" + d;
    }

    public void setEnableControls(boolean isEnable) {
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jMenuItem1_actionPerformed(ActionEvent e) {
        Label10GPassThru c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.label10GPassThru[this.moduleIndex - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Rear");
        c.labelBladeGroup.setIndicatorUnique(true);
        c.setIndicatorVisible(true);
        String label = c.getModuleName() + " " + c.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c.getModuleName() + c.getNumber());
    }
}

