/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.CMMSessionPanel;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.AbstractMBSensorTableUIHelper;
import IPMIView20.blade.LabelBlade;
import IPMIView20.blade.MBSensorTableUIHelperFactory;
import IPMIView20.blade.SIMBLLANSettingDialogPanel;
import IPMIView20.blade.SingleBladePanel_jBladeNameUpdateButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jButton1_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jCursorHereMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jErrorLEDCheckBox_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jGracefulPowerDownButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jGracefulShutdownMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPopupWindowMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerDownMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerOnMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jRefreshSIMBLIPButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jRequestKVMButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jRequestKVMMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jResetButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jResetMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jSetSIMBLIPButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jTabbedPane1_changeAdapter;
import IPMIView20.blade.SingleBladePanel_jUIDCheckBoxMenuItem1_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jUIDCheckBox_actionAdapter;
import IPMIView20.blade.SingleModuleAbstractPanel;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;

public class SingleBladePanel
extends SingleModuleAbstractPanel {
    SIMBLLANSettingDialogPanel simblLANSettingDialogPanel = new SIMBLLANSettingDialogPanel();
    TableSorter ts;
    TableSorter configurationTs;
    AbstractMBSensorTableUIHelper mbSensorTableUIHelper;
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okBlueIcon = new ImageIcon(this.getClass().getResource("/images/ok_blue.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon refresh16Icon = new ImageIcon(this.getClass().getResource("/images/Refresh16.gif"));
    Icon Preferences16Icon = new ImageIcon(this.getClass().getResource("/images/Preferences16.gif"));
    Icon edit16Icon = new ImageIcon(this.getClass().getResource("/images/Edit16.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    JPanel jRightPanel = new JPanel();
    JPanel jLeftPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jLeftDownPanel = new JPanel();
    JPanel jLeftUpPanel = new JPanel();
    TitledBorder titledBorder2 = new TitledBorder("");
    GridLayout gridLayout3 = new GridLayout();
    JPanel jManagementPanel = new JPanel();
    JLabel jManagementLabel = new JLabel();
    JLabel jManagementStringLabel = new JLabel();
    JLabel jErrorLEDLabel = new JLabel();
    JLabel jErrorLEDStringLabel = new JLabel();
    JButton jRequestKVMButton = new JButton();
    JLabel jLabel6 = new JLabel();
    JLabel jUIDStringLabel = new JLabel();
    JLabel jKVMLabel = new JLabel();
    JLabel jUIDLabel = new JLabel();
    JLabel jKVMStringLabel = new JLabel();
    JLabel jBoardLabel = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel();
    JCheckBox jUIDCheckBox = new JCheckBox();
    JPanel jPowerControlPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    TitledBorder titledBorder3 = new TitledBorder("");
    JButton jResetButton = new JButton();
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    TitledBorder titledBorder4 = new TitledBorder("");
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jLanSettingPanel = new JPanel();
    JCheckBox jErrorLEDCheckBox = new JCheckBox();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    JLabel jWattLabel = new JLabel();
    JLabel jWattStringLabel = new JLabel();
    TitledBorder titledBorder5 = new TitledBorder("");
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable = null;
    TitledBorder titledBorder6 = new TitledBorder("");
    JToolBar jToolBar1 = new JToolBar();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel7 = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    JLabel jLabel2 = new JLabel();
    JTextField jIPTextField = new JTextField();
    JButton jGracefulPowerDownButton = new JButton();
    BorderLayout borderLayout8 = new BorderLayout();
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jPowerOnMenuItem = new JMenuItem();
    JMenuItem jGracefulShutdownMenuItem = new JMenuItem();
    JMenuItem jPowerDownMenuItem = new JMenuItem();
    JMenuItem jResetMenuItem = new JMenuItem();
    JMenuItem jRequestKVMMenuItem = new JMenuItem();
    JCheckBoxMenuItem jUIDCheckBoxMenuItem1 = new JCheckBoxMenuItem();
    JMenuItem jPopupWindowMenuItem = new JMenuItem();
    JMenuItem jCursorHereMenuItem = new JMenuItem();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout9 = new BorderLayout();
    JLabel jBladeNameLabel = new JLabel();
    JLabel jBladeNameStringLabel = new JLabel();
    JButton jBladeNameUpdateButton = new JButton();
    JLabel notPresent = new JLabel(L.t("cmm.single.blade.Module_not_present"));
    JToolBar jManagementSIMBLToolBar = new JToolBar();
    JButton jSetSIMBLIPButton = new JButton();
    JButton jRefreshSIMBLIPButton = new JButton();
    TitledBorder titledBorder7 = new TitledBorder("");
    boolean isGetSIMBL_IP = false;
    AbstractMBSensorEntity sensor;
    BladeSystemEntity bladeSystemEntity = null;
    String tempIP;
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout10 = new BorderLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTable jConfigurationTable = new JTable();
    JToolBar jToolBar2 = new JToolBar();
    JButton jButton1 = new JButton();
    TitledBorder titledBorder8 = new TitledBorder("");
    boolean isLoadBladeHWInfo = false;
    String tempBladeName;

    public SingleBladePanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() {
        this.jErrorLEDCheckBox.setVisible(false);
        this.showHeader();
        this.showConfigurationHeader();
        this.setIPMBFunctionEnable(false);
    }

    @Override
    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jResetButton.setEnabled(false);
        this.jGracefulPowerDownButton.setEnabled(false);
        this.jUIDCheckBox.setEnabled(false);
        this.jManagementPanel.setVisible(false);
        this.jPowerOnMenuItem.setEnabled(false);
        this.jPowerDownMenuItem.setEnabled(false);
        this.jResetMenuItem.setEnabled(false);
        this.jGracefulShutdownMenuItem.setEnabled(false);
        this.jUIDCheckBoxMenuItem1.setEnabled(false);
    }

    @Override
    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jGracefulPowerDownButton.setEnabled(true);
        this.jUIDCheckBox.setEnabled(true);
        this.jManagementPanel.setVisible(true);
    }

    @Override
    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jGracefulPowerDownButton.setEnabled(true);
        this.jUIDCheckBox.setEnabled(true);
        this.jManagementPanel.setVisible(true);
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setEnableControls(boolean isEnable) {
        this.jRequestKVMButton.setEnabled(isEnable);
        this.jResetButton.setEnabled(isEnable);
        this.jPowerOffButton.setEnabled(isEnable);
        this.jPowerOnButton.setEnabled(isEnable);
        this.jGracefulPowerDownButton.setEnabled(isEnable);
        this.jUIDCheckBox.setEnabled(isEnable);
    }

    private void jbInit() throws Exception {
        this.titledBorder8 = new TitledBorder(L.t("cmm.single.blade.Motherboard_Configuration"));
        this.jTable = new JTable(){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        this.titledBorder6 = new TitledBorder(L.t("cmm.single.blade.IPMI_LAN"));
        this.titledBorder5 = new TitledBorder(L.t("cmm.single.blade.Sensors"));
        this.titledBorder4 = new TitledBorder(L.t("cmm.single.blade.Management_Module"));
        this.titledBorder3 = new TitledBorder(L.t("cmm.single.blade.Power_Control"));
        this.titledBorder2 = new TitledBorder(L.t("cmm.single.blade.Status"));
        this.titledBorder1 = new TitledBorder(L.t("cmm.single.blade.Right"));
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setLayout(this.borderLayout3);
        this.jRightPanel.setLayout(this.borderLayout4);
        this.jLeftPanel.setLayout(this.borderLayout8);
        this.jLeftUpPanel.setBorder(this.titledBorder2);
        this.jLeftUpPanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(3);
        this.gridLayout3.setRows(0);
        this.jManagementStringLabel.setForeground(Color.blue);
        this.jManagementStringLabel.setText(L.t("cmm.single.blade.BMC"));
        this.jErrorLEDStringLabel.setForeground(Color.blue);
        this.jErrorLEDStringLabel.setText(L.t("cmm.single.blade.System_Fault"));
        this.jRequestKVMButton.setPreferredSize(new Dimension(70, 23));
        this.jRequestKVMButton.setHorizontalTextPosition(10);
        this.jRequestKVMButton.setText(L.t("cmm.single.blade.Request"));
        this.jRequestKVMButton.addActionListener(new SingleBladePanel_jRequestKVMButton_actionAdapter(this));
        this.jUIDStringLabel.setForeground(Color.blue);
        this.jUIDStringLabel.setText(L.t("cmm.single.blade.UID"));
        this.jUIDLabel.setIcon(null);
        this.jKVMStringLabel.setForeground(Color.blue);
        this.jKVMStringLabel.setText(L.t("cmm.single.blade.KVM"));
        this.jPowerStatusLabel.setToolTipText("");
        this.jPowerStatusLabel.setIcon(null);
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setText(L.t("cmm.single.blade.Power_Status"));
        this.jUIDCheckBox.setText(L.t("cmm.single.blade.Enable"));
        this.jUIDCheckBox.addActionListener(new SingleBladePanel_jUIDCheckBox_actionAdapter(this));
        this.jLeftDownPanel.setLayout(this.borderLayout2);
        this.jResetButton.setFont(new Font("Dialog", 1, 12));
        this.jResetButton.setForeground(Color.red);
        this.jResetButton.setPreferredSize(new Dimension(140, 25));
        this.jResetButton.setText(L.t("cmm.single.blade.Reset"));
        this.jResetButton.addActionListener(new SingleBladePanel_jResetButton_actionAdapter(this));
        this.jPowerOffButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.setPreferredSize(new Dimension(140, 25));
        this.jPowerOffButton.setText(L.t("cmm.single.blade.Power_Down"));
        this.jPowerOffButton.addActionListener(new SingleBladePanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setPreferredSize(new Dimension(140, 25));
        this.jPowerOnButton.setText(L.t("cmm.single.blade.Power_On"));
        this.jPowerOnButton.addActionListener(new SingleBladePanel_jPowerOnButton_actionAdapter(this));
        this.jPowerControlPanel.setLayout(this.gridLayout2);
        this.jPowerControlPanel.setBorder(this.titledBorder3);
        this.jErrorLEDCheckBox.setForeground(Color.orange);
        this.jErrorLEDCheckBox.setText("Err LED[Test]");
        this.jErrorLEDCheckBox.addActionListener(new SingleBladePanel_jErrorLEDCheckBox_actionAdapter(this));
        this.jRightPanel.setBorder(null);
        this.jWattStringLabel.setForeground(Color.blue);
        this.jWattStringLabel.setText(L.t("cmm.single.blade.Watt"));
        this.jPanel1.setLayout(this.borderLayout7);
        this.jPanel1.setBorder(this.titledBorder5);
        this.jLanSettingPanel.setBorder(this.titledBorder6);
        this.jLanSettingPanel.setLayout(this.gridLayout1);
        this.jToolBar1.setFloatable(false);
        this.jPanel7.setLayout(this.gridLayout5);
        this.gridLayout5.setColumns(2);
        this.jLabel2.setForeground(Color.blue);
        this.jLabel2.setText(L.t("cmm.single.blade.IPMI_IP"));
        this.setPreferredSize(new Dimension(680, 300));
        this.jGracefulPowerDownButton.setFont(new Font("Dialog", 1, 12));
        this.jGracefulPowerDownButton.setForeground(Color.red);
        this.jGracefulPowerDownButton.setPreferredSize(new Dimension(140, 25));
        this.jGracefulPowerDownButton.setText(L.t("cmm.single.blade.Graceful_Shutdown"));
        this.jGracefulPowerDownButton.addActionListener(new SingleBladePanel_jGracefulPowerDownButton_actionAdapter(this));
        this.jPowerOnMenuItem.setText(L.t("cmm.single.blade.Power_On"));
        this.jPowerOnMenuItem.addActionListener(new SingleBladePanel_jPowerOnMenuItem_actionAdapter(this));
        this.jGracefulShutdownMenuItem.setText(L.t("cmm.single.blade.Graceful_Shutdown"));
        this.jGracefulShutdownMenuItem.addActionListener(new SingleBladePanel_jGracefulShutdownMenuItem_actionAdapter(this));
        this.jPowerDownMenuItem.setText(L.t("cmm.single.blade.Power_Down"));
        this.jPowerDownMenuItem.addActionListener(new SingleBladePanel_jPowerDownMenuItem_actionAdapter(this));
        this.jResetMenuItem.setText(L.t("cmm.single.blade.Reset"));
        this.jResetMenuItem.addActionListener(new SingleBladePanel_jResetMenuItem_actionAdapter(this));
        this.jRequestKVMMenuItem.setText(L.t("cmm.single.blade.Request_KVM"));
        this.jRequestKVMMenuItem.addActionListener(new SingleBladePanel_jRequestKVMMenuItem_actionAdapter(this));
        this.jUIDCheckBoxMenuItem1.setText(L.t("cmm.single.blade.UID"));
        this.jUIDCheckBoxMenuItem1.addActionListener(new SingleBladePanel_jUIDCheckBoxMenuItem1_actionAdapter(this));
        this.jPopupWindowMenuItem.setText(L.t("cmm.single.blade.Popup_Management_Window"));
        this.jPopupWindowMenuItem.addActionListener(new SingleBladePanel_jPopupWindowMenuItem_actionAdapter(this));
        this.jCursorHereMenuItem.setText(L.t("cmm.single.blade.Focus_Here"));
        this.jCursorHereMenuItem.addActionListener(new SingleBladePanel_jCursorHereMenuItem_actionAdapter(this));
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.jPanel3.setLayout(this.flowLayout1);
        this.jPanel2.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.flowLayout1.setAlignment(0);
        this.jSetSIMBLIPButton.setToolTipText(L.t("cmm.single.blade.BMC_IP_VLAN_Setting"));
        this.jSetSIMBLIPButton.setIcon(this.edit16Icon);
        this.jSetSIMBLIPButton.setMargin(new Insets(0, 0, 0, 0));
        this.jSetSIMBLIPButton.setText(L.t("cmm.single.blade.Set") + "...");
        this.jSetSIMBLIPButton.addActionListener(new SingleBladePanel_jSetSIMBLIPButton_actionAdapter(this));
        this.jRefreshSIMBLIPButton.setToolTipText(L.t("cmm.single.blade.Refresh"));
        this.jRefreshSIMBLIPButton.setIcon(this.refresh16Icon);
        this.jRefreshSIMBLIPButton.setMargin(new Insets(0, 0, 0, 0));
        this.jRefreshSIMBLIPButton.addActionListener(new SingleBladePanel_jRefreshSIMBLIPButton_actionAdapter(this));
        this.jManagementSIMBLToolBar.setFloatable(false);
        this.jManagementPanel.setLayout(this.borderLayout9);
        this.jPanel4.setLayout(this.borderLayout10);
        this.jButton1.setIcon(this.refresh16Icon);
        this.jButton1.setText(L.t("cmm.single.blade.Refresh"));
        this.jButton1.addActionListener(new SingleBladePanel_jButton1_actionAdapter(this));
        this.jToolBar2.setFloatable(false);
        this.jPanel4.setBorder(this.titledBorder8);
        this.jTabbedPane1.addChangeListener(new SingleBladePanel_jTabbedPane1_changeAdapter(this));
        this.jBladeNameUpdateButton.addActionListener(new SingleBladePanel_jBladeNameUpdateButton_actionAdapter(this));
        this.add((Component)this.jCenterPanel, "Center");
        this.jLeftUpPanel.add(this.jPowerStatusStringLabel);
        this.jLeftUpPanel.add(this.jPowerStatusLabel);
        this.jLeftUpPanel.add(this.jBoardLabel);
        this.jLeftUpPanel.add(this.jKVMStringLabel);
        this.jLeftUpPanel.add(this.jKVMLabel);
        JPanel p = new JPanel();
        p.setLayout(this.borderLayout6);
        this.jLeftUpPanel.add(p);
        this.jLeftUpPanel.add(this.jUIDStringLabel);
        this.jLeftUpPanel.add(this.jUIDLabel);
        this.jLeftUpPanel.add(this.jUIDCheckBox);
        this.jLeftUpPanel.add(this.jErrorLEDStringLabel);
        this.jLeftUpPanel.add(this.jErrorLEDLabel);
        this.jLeftUpPanel.add(this.jLabel6);
        this.jLeftUpPanel.add(this.jManagementStringLabel);
        this.jLeftUpPanel.add(this.jManagementLabel);
        this.jLeftUpPanel.add(this.jManagementPanel);
        this.jManagementSIMBLToolBar.add(this.jSetSIMBLIPButton);
        this.jManagementSIMBLToolBar.addSeparator();
        this.jManagementSIMBLToolBar.add(this.jRefreshSIMBLIPButton);
        this.jPowerControlPanel.add(this.jPanel3);
        this.jPanel3.add(this.jPowerOnButton);
        this.jPanel3.add(this.jResetButton);
        this.jPowerControlPanel.add(this.jPanel2);
        this.jPanel2.add(this.jGracefulPowerDownButton);
        this.jPanel2.add(this.jPowerOffButton);
        this.jLanSettingPanel.add(this.jPanel7);
        this.jPanel7.add(this.jLabel2);
        this.jPanel7.add(this.jIPTextField);
        p.add((Component)this.jRequestKVMButton, "Center");
        this.jLeftUpPanel.add(this.jWattStringLabel);
        this.jLeftUpPanel.add(this.jWattLabel);
        this.jLeftUpPanel.add(this.jErrorLEDCheckBox);
        this.jBladeNameStringLabel.setText("Name:");
        this.jBladeNameUpdateButton.setText("Update");
        this.jBladeNameStringLabel.setForeground(Color.blue);
        this.jLeftUpPanel.add(this.jBladeNameStringLabel);
        this.jLeftUpPanel.add(this.jBladeNameLabel);
        this.jLeftUpPanel.add(this.jBladeNameUpdateButton);
        this.jCenterPanel.add((Component)this.jRightPanel, "Center");
        this.jCenterPanel.add((Component)this.jLeftPanel, "West");
        this.jPopupMenuForLabel.add(this.jPowerOnMenuItem);
        this.jPopupMenuForLabel.add(this.jGracefulShutdownMenuItem);
        this.jPopupMenuForLabel.add(this.jPowerDownMenuItem);
        this.jPopupMenuForLabel.add(this.jResetMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jRequestKVMMenuItem);
        this.jPopupMenuForLabel.add(this.jUIDCheckBoxMenuItem1);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jPopupWindowMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jCursorHereMenuItem);
        this.jLeftDownPanel.add((Component)this.jPowerControlPanel, "Center");
        this.jLeftPanel.add((Component)this.jLeftUpPanel, "North");
        this.jLeftPanel.add((Component)this.jLeftDownPanel, "Center");
        this.jManagementPanel.add((Component)this.jManagementSIMBLToolBar, "Center");
        this.jPanel1.add((Component)this.jToolBar1, "South");
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jPanel4.add((Component)this.jToolBar2, "North");
        this.jToolBar2.add(this.jButton1);
        this.jScrollPane2.getViewport().add(this.jConfigurationTable);
        this.jTabbedPane1.add((Component)this.jPanel1, L.t("cmm.single.blade.Sensors"));
        this.jTabbedPane1.add((Component)this.jPanel4, L.t("cmm.single.blade.Configuration"));
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jRightPanel.add((Component)this.jTabbedPane1, "Center");
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SingleBladePanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SingleBladePanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        boolean isPowerOff = false;
        BladeEntity blade = this.bladeSystemEntity.getBlades()[this.moduleIndex - 1];
        this.sensor = this.bladeSystemEntity.getMbSensors()[this.moduleIndex - 1];
        if (blade.getPresent() == 0) {
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        boolean powerSupply = true;
        if (blade.isV12vEnable() && blade.isV3_3v() && powerSupply) {
            this.jPowerStatusLabel.setIcon(this.powerOnIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.single.blade.On"));
        } else if (!blade.isV12vEnable() && !blade.isV3_3v()) {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.single.blade.Off"));
            isPowerOff = true;
        } else if (blade.isV12vEnable() && !blade.isV3_3v() && powerSupply) {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.single.blade.Off"));
            isPowerOff = true;
        } else if (!powerSupply) {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.single.blade.Off"));
            isPowerOff = true;
        }
        if (blade.getKvmEnable() > 0) {
            this.jKVMLabel.setIcon(this.okBlueIcon);
            this.jKVMLabel.setText(L.t("cmm.single.blade.Selected"));
        } else {
            this.jKVMLabel.setIcon(null);
            this.jKVMLabel.setText(L.t("cmm.single.blade.Non-Selected"));
        }
        if (blade.getUidEnable() > 0) {
            this.jUIDLabel.setIcon(this.uidLEDOnIcon);
            this.jUIDLabel.setText(L.t("cmm.single.blade.On"));
            this.jUIDCheckBox.setSelected(true);
            this.jUIDCheckBoxMenuItem1.setSelected(true);
        } else {
            this.jUIDLabel.setIcon(this.uidLEDOffIcon);
            this.jUIDLabel.setText(L.t("cmm.single.blade.Off"));
            this.jUIDCheckBox.setSelected(false);
            this.jUIDCheckBoxMenuItem1.setSelected(false);
        }
        if (blade.isError1LED()) {
            this.jErrorLEDLabel.setIcon(this.xRedIcon);
            this.jErrorLEDLabel.setForeground(Color.RED);
            this.jErrorLEDLabel.setText(L.t("cmm.single.blade.Error"));
        } else {
            this.jErrorLEDLabel.setIcon(this.okGreenIcon);
            this.jErrorLEDLabel.setForeground(Color.GREEN);
            this.jErrorLEDLabel.setText(L.t("cmm.single.blade.Normal"));
        }
        if (blade.isSimCardDetectPin()) {
            if (this.bladeSystemEntity.isIsSupportIPMB() && this.bladeSystemEntity.getIsMaster()) {
                this.helpShowSIMBL_IP_ViaIPMB();
            } else {
                this.helpShowSIMBLInstalledWithoutIPMBSupport();
            }
        } else {
            this.jManagementLabel.setForeground(Color.BLACK);
            this.jManagementLabel.setText(L.t("cmm.single.blade.Not_Installed"));
            this.jSetSIMBLIPButton.setEnabled(false);
            this.jRefreshSIMBLIPButton.setEnabled(false);
        }
        this.jWattLabel.setText("" + blade.getWattByFormula());
        if (this.mbSensorTableUIHelper == null || !MBSensorTableUIHelperFactory.checkUIHelperType(blade.getMBModel(), this.mbSensorTableUIHelper)) {
            this.mbSensorTableUIHelper = MBSensorTableUIHelperFactory.createMBSensorTableUIHelper(blade.getMBModel(), this.jTable, this.ts);
            this.mbSensorTableUIHelper.removeAllRaw();
        }
        if (isPowerOff) {
            this.mbSensorTableUIHelper.removeAllRaw();
        } else if ((this.sensor.getFlag() & 1) == 1) {
            this.mbSensorTableUIHelper.updateTable(this.sensor);
        }
        String mbName = blade.getMBModelName();
        if (mbName != null) {
            this.titledBorder5 = new TitledBorder(mbName + " " + L.t("cmm.single.blade.Sensors"));
            this.jPanel1.setBorder(this.titledBorder5);
        } else {
            this.titledBorder5 = new TitledBorder(L.t("cmm.single.blade.Sensors"));
            this.jPanel1.setBorder(this.titledBorder5);
        }
        String bladeName = blade.getMiscEntity().isIsAvailable() ? blade.getMiscEntity().getBladeName() : "";
        this.jBladeNameLabel.setText(bladeName);
    }

    @Override
    public void preset(CMMSessionPanel cmmSessionPanel, JLabel xMessage) {
        super.preset(cmmSessionPanel, xMessage);
        this.simblLANSettingDialogPanel.setIPMIInterfaceConfig(cmmSessionPanel.ipmiInterfaceConfig);
        this.simblLANSettingDialogPanel.setBladeIndex(this.moduleIndex);
    }

    private void helpShowSIMBLInstalledWithoutIPMBSupport() {
        this.jManagementLabel.setForeground(Color.BLUE);
        this.jSetSIMBLIPButton.setEnabled(false);
        this.jRefreshSIMBLIPButton.setEnabled(false);
        this.jManagementLabel.setText(L.t("cmm.single.blade.Installed"));
    }

    private void helpShowSIMBL_IP_ViaIPMB() {
        this.jManagementLabel.setForeground(Color.BLUE);
        this.jSetSIMBLIPButton.setEnabled(true);
        this.jRefreshSIMBLIPButton.setEnabled(true);
        if (!this.isGetSIMBL_IP) {
            this.jManagementLabel.setText(L.t("cmm.single.blade.Refresh") + " ...");
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SingleBladePanel.this.getSIMBLIPViaIPMB();
                }
            };
            thread.start();
            this.isGetSIMBL_IP = true;
        }
    }

    private void setIPMBFunctionEnable(boolean isEnable) {
        this.jIPTextField.setEnabled(isEnable);
    }

    public void jRequestKVMButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SingleBladePanel.this.requestKVM();
            }
        };
        thread.start();
    }

    private void requestKVM() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.requestKVM((byte)this.moduleIndex);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Request_KVM_failed"));
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jUIDCheckBox_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SingleBladePanel.this.setUID();
            }
        };
        thread.start();
    }

    private void setUID() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = this.jUIDCheckBox.isSelected() ? ipmiCMMOEMCommand.setBladeUID((byte)this.moduleIndex, (byte)1) : ipmiCMMOEMCommand.setBladeUID((byte)this.moduleIndex, (byte)0);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Set_UID_failed"));
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), L.t("cmm.single.blade.Are_you_sure_power_on"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.powerOn();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            int b = 99;
            try {
                b = ipmiCMMOEMCommand.enableP12V((byte)this.moduleIndex, (byte)1);
                if (b != 0) {
                    if (b == 1) {
                        JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Not_enough_Power"));
                    } else if (b == 99) {
                        JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Power_on_failed"));
                    }
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), L.t("cmm.single.blade.Are_you_sure_power_off"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.powerOff();
            }
        };
        thread.start();
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            int b = 99;
            try {
                b = ipmiCMMOEMCommand.enableP12V((byte)this.moduleIndex, (byte)0);
                if (b != 0 && b == 99) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Power_off_failed"));
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jResetButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), L.t("cmm.single.blade.Are_you_sure_reset"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.reset();
            }
        };
        thread.start();
    }

    private void reset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.resetBlade((byte)this.moduleIndex);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Reset_failed"));
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jErrorLEDCheckBox_actionPerformed(ActionEvent e) {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = this.jErrorLEDCheckBox.isSelected() ? ipmiCMMOEMCommand.testBladeErrorLED((byte)this.moduleIndex, (byte)1) : ipmiCMMOEMCommand.testBladeErrorLED((byte)this.moduleIndex, (byte)0);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Set_Error_LED_failed"));
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public Object clone() {
        SingleBladePanel singleBladePanel = new SingleBladePanel();
        singleBladePanel.moduleIndex = this.moduleIndex;
        return singleBladePanel;
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(25);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(" ");
        headerList.add(L.t("cmm.single.blade.Sensor") + "    ");
        headerList.add(L.t("cmm.single.blade.Reading") + "    ");
        headerList.add(L.t("cmm.single.blade.Low_Limit"));
        headerList.add(L.t("cmm.single.blade.High_Limit"));
        return headerList;
    }

    public void jGracefulPowerDownButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), L.t("cmm.single.blade.Are_you_sure_g_shutdown"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.gracefulShutdown();
            }
        };
        thread.start();
    }

    private void gracefulShutdown() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                boolean b = ipmiCMMOEMCommand.gracefulPowerDownBlade((byte)this.moduleIndex);
                if (b) {
                    this.xMessage.setText(L.t("cmm.single.blade.Graceful_shutdown_sent"));
                } else {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Graceful_shutdown_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jPowerOnMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOnButton_actionPerformed(null);
    }

    public void jGracefulShutdownMenuItem_actionPerformed(ActionEvent e) {
        this.jGracefulPowerDownButton_actionPerformed(null);
    }

    public void jPowerDownMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOffButton_actionPerformed(null);
    }

    public void jResetMenuItem_actionPerformed(ActionEvent e) {
        this.jResetButton_actionPerformed(null);
    }

    public void jRequestKVMMenuItem_actionPerformed(ActionEvent e) {
        this.jRequestKVMButton_actionPerformed(null);
    }

    public void jUIDCheckBoxMenuItem1_actionPerformed(ActionEvent e) {
        if (this.jUIDCheckBoxMenuItem1.isSelected()) {
            this.jUIDCheckBox.setSelected(true);
        } else {
            this.jUIDCheckBox.setSelected(false);
        }
        this.jUIDCheckBox_actionPerformed(null);
    }

    public void jPopupWindowMenuItem_actionPerformed(ActionEvent e) {
        this.cmmSessionPanel.cmmBladeSystemPanel.helpTakeSinglePanelOut(this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemFront.labelBlades[this.moduleIndex - 1]);
    }

    public void jCursorHereMenuItem_actionPerformed(ActionEvent e) {
        LabelBlade c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemFront.labelBlades[this.moduleIndex - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Front");
        c.labelBladeGroup.setIndicatorUnique(true);
        c.setIndicatorVisible(true);
        String label = c.getModuleName() + " " + c.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c.getModuleName() + c.getNumber());
    }

    public void getSIMBLIPViaIPMB() {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiLanCommand);
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)this.moduleIndex);
        if (sessionController != null) {
            String ip = null;
            try {
                ip = ipmiLanCommand.getIP();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (ip != null) {
                this.jManagementLabel.setText(ip);
            } else {
                this.jManagementLabel.setText(L.t("cmm.single.blade.Installed"));
            }
            sessionController.closeSession();
        }
    }

    public void jRefreshSIMBLIPButton_actionPerformed(ActionEvent e) {
        this.jManagementLabel.setText(L.t("cmm.single.blade.Refresh") + " ...");
        Thread thread = new Thread(){

            @Override
            public void run() {
                SingleBladePanel.this.getSIMBLIPViaIPMB();
            }
        };
        thread.start();
    }

    public void jSetSIMBLIPButton_actionPerformed(ActionEvent e) {
        this.showSIMBLLANSSettingDialog();
    }

    public void showSIMBLIPConfigDialog() {
        int result;
        Object[] message = new Object[1];
        JPanel p = new JPanel();
        JLabel l = new JLabel(L.t("cmm.single.blade.BMC_IP"));
        JTextField t = new JTextField(18);
        if (IPMILanCommand.isIPAddress(this.jManagementLabel.getText())) {
            t.setText(this.jManagementLabel.getText());
        }
        p.add(l);
        p.add(t);
        t.requestFocus();
        message[0] = p;
        boolean flag = true;
        while (flag && (result = JOptionPane.showOptionDialog(this.findParentFrame(), message, L.t("cmm.single.blade.Management_IP"), 2, 1, null, null, null)) == 0) {
            boolean b1 = IPMILanCommand.isIPAddress(t.getText());
            if (!b1) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.IP_format_error"));
                t.setText(this.jManagementLabel.getText());
                continue;
            }
            if (t.getText().equals(this.jManagementLabel.getText())) break;
            this.tempIP = t.getText();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SingleBladePanel.this.helpUpdateSIMBLIP(SingleBladePanel.this.tempIP);
                }
            };
            thread.start();
            flag = false;
        }
    }

    private void helpUpdateSIMBLIP(String ip) throws HeadlessException {
        this.jManagementLabel.setText(L.t("cmm.single.blade.Updating") + " ...");
        boolean b2 = this.setSIMBLIPViaIPMB(ip);
        if (b2) {
            this.jManagementLabel.setText(L.t("cmm.single.blade.OK"));
        } else {
            this.jManagementLabel.setText(L.t("cmm.single.blade.Failed"));
        }
        this.jRefreshSIMBLIPButton_actionPerformed(null);
    }

    public boolean setSIMBLIPViaIPMB(String ip) {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiLanCommand);
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)this.moduleIndex);
        boolean b = false;
        if (sessionController != null) {
            b = ipmiLanCommand.setIP(ip);
            sessionController.closeSession();
        }
        return b;
    }

    public void showSIMBLLANSSettingDialog() {
        int result;
        this.setCursor(new Cursor(3));
        if (!this.simblLANSettingDialogPanel.loadData()) {
            this.setCursor(new Cursor(0));
            return;
        }
        this.setCursor(new Cursor(0));
        Object[] message = new Object[]{this.simblLANSettingDialogPanel};
        while ((result = JOptionPane.showOptionDialog(this.findParentFrame(), message, L.t("cmm.single.blade.BMC_IP_VLAN_Setting"), 2, -1, null, null, null)) == 0) {
            if (!this.simblLANSettingDialogPanel.validateUserInput()) continue;
            if (this.simblLANSettingDialogPanel.setData()) break;
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.blade.Set_data_failed"));
        }
    }

    public void showConfigurationHeader() {
        ArrayList headerList = this.getConfigurationHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.configurationTs = new TableSorter(dtm);
        this.jConfigurationTable.setModel(this.configurationTs);
        this.jConfigurationTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.jConfigurationTable.getColumnModel().getColumn(1).setPreferredWidth(200);
    }

    public ArrayList getConfigurationHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("cmm.single.blade.Field") + "    ");
        headerList.add(L.t("cmm.single.blade.Value") + "    ");
        return headerList;
    }

    public void loadBladeHWInfo() {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                IPMICMMOEMCommand.BladeHWInfo bladeHWInfo = ipmiCMMOEMCommand.getBladeHWInfo((byte)this.moduleIndex);
                if (bladeHWInfo != null) {
                    this.helpUpdateBladeHWInfo(bladeHWInfo);
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    private void helpUpdateBladeHWInfo(IPMICMMOEMCommand.BladeHWInfo bladeHWInfo) {
        this.addRaw(L.t("cmm.single.blade.CPUs"), bladeHWInfo.getNumberOfCPUInstalled());
        this.addRaw(L.t("cmm.single.blade.CPU_Type"), bladeHWInfo.getCPUID());
        this.addRaw(L.t("cmm.single.blade.CPU_Speed"), bladeHWInfo.getCPUSpeeed());
        this.addRaw(L.t("cmm.single.blade.DIMMs"), bladeHWInfo.getNumberOfDIMMsInstalled());
        this.addRaw(L.t("cmm.single.blade.Memory_Size"), bladeHWInfo.getMemorySize());
        this.addRaw(L.t("cmm.single.blade.Memory_Speed"), bladeHWInfo.getMemorySpeed());
        int lanTotal = bladeHWInfo.getNumberOfOnboardLanValue();
        String m3 = bladeHWInfo.getMAC3();
        String m4 = bladeHWInfo.getMAC4();
        String m5 = bladeHWInfo.getMAC5();
        if (bladeHWInfo.getNumberOfOnboardLanValue() > 1) {
            if (!m3.contains("not presented")) {
                ++lanTotal;
            }
            if (!m4.contains("not presented")) {
                ++lanTotal;
            }
            if (m3.equalsIgnoreCase(bladeHWInfo.getMAC(1))) {
                --lanTotal;
                m3 = "not presented";
            }
            this.addRaw(L.t("cmm.single.blade.LANs"), Integer.toString(lanTotal));
            for (int i = 0; i < bladeHWInfo.getNumberOfOnboardLanValue(); ++i) {
                this.addRaw(L.t("cmm.single.blade.LAN") + " " + (i + 1) + " " + L.t("cmm.single.blade.MAC"), bladeHWInfo.getMAC(i));
            }
            if (!m3.contains("not presented")) {
                this.addRaw(L.t("cmm.single.blade.LAN") + " " + 3 + " " + L.t("cmm.single.blade.MAC"), m3);
            }
            if (!m4.contains("not presented")) {
                this.addRaw(L.t("cmm.single.blade.LAN") + " " + 4 + " " + L.t("cmm.single.blade.MAC"), m4);
            }
        } else if (bladeHWInfo.getNumberOfOnboardLanValue() == 1) {
            if (!m3.contains("not presented")) {
                ++lanTotal;
            }
            if (!m4.contains("not presented")) {
                ++lanTotal;
            }
            if (!m5.contains("not presented")) {
                ++lanTotal;
            }
            this.addRaw(L.t("cmm.single.blade.LANs"), Integer.toString(lanTotal));
            this.addRaw(L.t("cmm.single.blade.LAN") + " " + 1 + " " + L.t("cmm.single.blade.MAC"), bladeHWInfo.getMAC(0));
            if (!m3.contains("not presented")) {
                this.addRaw(L.t("cmm.single.blade.LAN") + " " + 2 + " " + L.t("cmm.single.blade.MAC"), m3);
            }
            if (!m4.contains("not presented")) {
                this.addRaw(L.t("cmm.single.blade.LAN") + " " + 3 + " " + L.t("cmm.single.blade.MAC"), m4);
            }
            if (!m5.contains("not presented")) {
                this.addRaw(L.t("cmm.single.blade.LAN") + " " + 4 + " " + L.t("cmm.single.blade.MAC"), m5);
            }
        }
    }

    public void addRaw(String name, String value) {
        int rowIndex = this.findRow(name);
        if (rowIndex != -1) {
            ((DefaultTableModel)this.configurationTs.getTableModel()).setValueAt(value, rowIndex, 1);
        } else {
            ArrayList<String> raw = new ArrayList<String>();
            raw.add(name);
            raw.add(value);
            ((DefaultTableModel)this.configurationTs.getTableModel()).addRow(raw.toArray());
        }
    }

    private int findRow(String name) {
        int count = ((DefaultTableModel)this.configurationTs.getTableModel()).getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!((DefaultTableModel)this.configurationTs.getTableModel()).getValueAt(i, 0).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void jButton1_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SingleBladePanel.this.loadBladeHWInfo();
            }
        };
        thread.start();
    }

    public void jTabbedPane1_stateChanged(ChangeEvent e) {
        if (this.jTabbedPane1.getSelectedIndex() == 1 && !this.isLoadBladeHWInfo) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SingleBladePanel.this.loadBladeHWInfo();
                    SingleBladePanel.this.isLoadBladeHWInfo = true;
                }
            };
            thread.start();
        }
    }

    public void jBladeNameUpdateButton_actionPerformed(ActionEvent e) {
        this.tempBladeName = JOptionPane.showInputDialog(this.findParentFrame(), "Name", this.jBladeNameLabel.getText());
        if (this.tempBladeName == null) {
            return;
        }
        if (this.tempBladeName.length() > 20) {
            JOptionPane.showMessageDialog(this.findParentFrame(), "20 characters limited");
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                SingleBladePanel.this.helpUpdateBladeName();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpUpdateBladeName() {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                if (this.tempBladeName == null || this.tempBladeName.length() == 0) {
                    this.tempBladeName = "";
                }
                ipmiCMMOEMCommand.setBladeName((byte)this.moduleIndex, this.tempBladeName);
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
            finally {
                sessionController.closeSession();
            }
        }
    }
}

