/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.JFanPanel;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.SummaryAbstractPanel;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class SummaryPowerPanel
extends SummaryAbstractPanel {
    public static int FAN_FULL_SPEED_RPM = 15000;
    public static int TEMPERATURE_FULL_SCALE = 100;
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    boolean initPower1Sensors = false;
    boolean initPower2Sensors = false;
    boolean initPower3Sensors = false;
    boolean initPower4Sensors = false;
    JLabel p1PowerStatusLabel = new JLabel("");
    JLabel p2PowerStatusLabel = new JLabel("");
    JLabel p3PowerStatusLabel = new JLabel("");
    JLabel p4PowerStatusLabel = new JLabel("");
    JFanPanel p1Fan1Panel = new JFanPanel();
    JFanPanel p1Fan2Panel = new JFanPanel();
    JFanPanel p1Fan3Panel = new JFanPanel();
    JFanPanel p1Fan4Panel = new JFanPanel();
    JTempPanel p1TempPanel = new JTempPanel();
    JFanPanel p2Fan1Panel = new JFanPanel();
    JFanPanel p2Fan2Panel = new JFanPanel();
    JFanPanel p2Fan3Panel = new JFanPanel();
    JFanPanel p2Fan4Panel = new JFanPanel();
    JTempPanel p2TempPanel = new JTempPanel();
    JFanPanel p3Fan1Panel = new JFanPanel();
    JFanPanel p3Fan2Panel = new JFanPanel();
    JFanPanel p3Fan3Panel = new JFanPanel();
    JFanPanel p3Fan4Panel = new JFanPanel();
    JTempPanel p3TempPanel = new JTempPanel();
    JFanPanel p4Fan1Panel = new JFanPanel();
    JFanPanel p4Fan2Panel = new JFanPanel();
    JFanPanel p4Fan3Panel = new JFanPanel();
    JFanPanel p4Fan4Panel = new JFanPanel();
    JTempPanel p4TempPanel = new JTempPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPowerFanPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPowerSupplyTemperaturePanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    TitledBorder titledBorder3 = new TitledBorder("");
    TitledBorder titledBorder4 = new TitledBorder("");
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jP4Panel = new JPanel();
    JPanel jP3Panel = new JPanel();
    JPanel jP2Panel = new JPanel();
    JPanel jP1Panel = new JPanel();

    public SummaryPowerPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.p1Fan1Panel.init("P1 Fan1", (byte)0, (byte)0, "", "");
        this.p1Fan2Panel.init("P1 Fan2", (byte)0, (byte)0, "", "");
        this.p1Fan3Panel.init("P1 Fan3", (byte)0, (byte)0, "", "");
        this.p1Fan4Panel.init("P1 Fan4", (byte)0, (byte)0, "", "");
        this.p1TempPanel.init("P1 Temperature", (byte)0, (byte)0, "", "");
        this.p2Fan1Panel.init("P2 Fan1", (byte)0, (byte)0, "", "");
        this.p2Fan2Panel.init("P2 Fan2", (byte)0, (byte)0, "", "");
        this.p2Fan3Panel.init("P2 Fan3", (byte)0, (byte)0, "", "");
        this.p2Fan4Panel.init("P2 Fan4", (byte)0, (byte)0, "", "");
        this.p2TempPanel.init("P2 Temperature", (byte)0, (byte)0, "", "");
        this.p3Fan1Panel.init("P3 Fan1", (byte)0, (byte)0, "", "");
        this.p3Fan2Panel.init("P3 Fan2", (byte)0, (byte)0, "", "");
        this.p3Fan3Panel.init("P3 Fan3", (byte)0, (byte)0, "", "");
        this.p3Fan4Panel.init("P3 Fan4", (byte)0, (byte)0, "", "");
        this.p3TempPanel.init("P3 Temperature", (byte)0, (byte)0, "", "");
        this.p4Fan1Panel.init("P4 Fan1", (byte)0, (byte)0, "", "");
        this.p4Fan2Panel.init("P4 Fan2", (byte)0, (byte)0, "", "");
        this.p4Fan3Panel.init("P4 Fan3", (byte)0, (byte)0, "", "");
        this.p4Fan4Panel.init("P4 Fan4", (byte)0, (byte)0, "", "");
        this.p4TempPanel.init("P4 Temperature", (byte)0, (byte)0, "", "");
        Dimension tempDimension = new Dimension(110, 28);
        Dimension fanDimension = new Dimension(72, 72);
        this.p1Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p1Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p1Fan3Panel.fanMeter.setPreferredSize(fanDimension);
        this.p1Fan4Panel.fanMeter.setPreferredSize(fanDimension);
        this.p1TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.p2Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p2Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p2Fan3Panel.fanMeter.setPreferredSize(fanDimension);
        this.p2Fan4Panel.fanMeter.setPreferredSize(fanDimension);
        this.p2TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.p3Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p3Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p3Fan3Panel.fanMeter.setPreferredSize(fanDimension);
        this.p3Fan4Panel.fanMeter.setPreferredSize(fanDimension);
        this.p3TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.p4Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p4Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p4Fan3Panel.fanMeter.setPreferredSize(fanDimension);
        this.p4Fan4Panel.fanMeter.setPreferredSize(fanDimension);
        this.p4TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.jP1Panel.add(this.p1Fan1Panel);
        this.jP1Panel.add(this.p1Fan2Panel);
        this.jP1Panel.add(this.p1Fan3Panel);
        this.jP1Panel.add(this.p1Fan4Panel);
        this.jP2Panel.add(this.p2Fan1Panel);
        this.jP2Panel.add(this.p2Fan2Panel);
        this.jP2Panel.add(this.p2Fan3Panel);
        this.jP2Panel.add(this.p2Fan4Panel);
        this.jP3Panel.add(this.p3Fan1Panel);
        this.jP3Panel.add(this.p3Fan2Panel);
        this.jP3Panel.add(this.p3Fan3Panel);
        this.jP3Panel.add(this.p3Fan4Panel);
        this.jP4Panel.add(this.p4Fan1Panel);
        this.jP4Panel.add(this.p4Fan2Panel);
        this.jP4Panel.add(this.p4Fan3Panel);
        this.jP4Panel.add(this.p4Fan4Panel);
        this.jPowerSupplyTemperaturePanel.add(this.p1TempPanel);
        this.jPowerSupplyTemperaturePanel.add(this.p2TempPanel);
        this.jPowerSupplyTemperaturePanel.add(this.p3TempPanel);
        this.jPowerSupplyTemperaturePanel.add(this.p4TempPanel);
    }

    private void jbInit() throws Exception {
        this.titledBorder4 = new TitledBorder("Power Supply 4");
        this.titledBorder3 = new TitledBorder("Power Supply 3");
        this.titledBorder2 = new TitledBorder("Temperature");
        this.titledBorder1 = new TitledBorder("Power Supply Fans");
        this.setLayout(this.borderLayout1);
        this.jPowerFanPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(2);
        this.jPowerSupplyTemperaturePanel.setBorder(this.titledBorder2);
        this.jPowerSupplyTemperaturePanel.setLayout(this.flowLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.flowLayout1.setHgap(10);
        this.flowLayout1.setVgap(0);
        this.jPowerFanPanel.setBorder(null);
        this.add((Component)this.jCenterPanel, "Center");
        this.jPowerFanPanel.add(this.jP3Panel);
        this.jPowerFanPanel.add(this.jP1Panel);
        this.jPowerFanPanel.add(this.jP4Panel);
        this.jPowerFanPanel.add(this.jP2Panel);
        this.jCenterPanel.add((Component)this.jPowerFanPanel, "Center");
        this.jCenterPanel.add((Component)this.jScrollPane1, "South");
        this.jCenterPanel.add((Component)this.jPowerSupplyTemperaturePanel, "North");
    }

    @Override
    public void update(Observable o, Object obj) {
        byte tempLimit;
        byte temp;
        byte fan4LimitRatio;
        byte fan4Ratio;
        byte fan3LimitRatio;
        byte fan3Ratio;
        byte fan2LimitRatio;
        byte fan2Ratio;
        byte fan1LimitRatio;
        byte fan1Ratio;
        int fan4RPMLimit;
        int fan4RPM;
        int fan3RPMLimit;
        int fan3RPM;
        int fan2RPMLimit;
        int fan2RPM;
        int fan1RPMLimit;
        int fan1RPM;
        BladeSystemEntity bladeSystemEntity;
        PowerSupplyEntity powerSupply;
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SummaryPowerPanel] [Notify]");
        }
        if ((powerSupply = (bladeSystemEntity = (BladeSystemEntity)o).getPowerSupplies()[0]).getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p1PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p1PowerStatusLabel.setText("Off");
                    break;
                }
                case 1: {
                    this.p1PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p1PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p1PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p1PowerStatusLabel.setText("Failure");
                    break;
                }
                default: {
                    this.p1PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p1PowerStatusLabel.setText("Off");
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower1Sensors) {
                this.p1Fan1Panel.init("P1 Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p1Fan2Panel.init("P1 Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p1Fan3Panel.init("P1 Fan 3", fan3Ratio, fan3LimitRatio, "" + fan3RPM, "" + fan3RPMLimit);
                this.p1Fan4Panel.init("P1 Fan 4", fan4Ratio, fan4LimitRatio, "" + fan4RPM, "" + fan4RPMLimit);
                this.p1TempPanel.init("P1 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower1Sensors = true;
            }
            this.p1Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
            this.p1Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            this.p1Fan3Panel.updateValue(fan3Ratio, "" + fan3RPM);
            this.p1Fan4Panel.updateValue(fan4Ratio, "" + fan4RPM);
            this.p1TempPanel.updateValue(temp, "" + temp);
            this.p1Fan3Panel.setVisible(powerSupply.getNumOfFans() >= 3);
            this.p1Fan4Panel.setVisible(powerSupply.getNumOfFans() >= 4);
        }
        if ((powerSupply = bladeSystemEntity.getPowerSupplies()[1]).getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p2PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p2PowerStatusLabel.setText("Off");
                    break;
                }
                case 1: {
                    this.p2PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p2PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p2PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p2PowerStatusLabel.setText("Failure");
                    break;
                }
                default: {
                    this.p2PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p2PowerStatusLabel.setText("Off");
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower2Sensors) {
                this.p2Fan1Panel.init("P2 Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p2Fan2Panel.init("P2 Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p2Fan3Panel.init("P2 Fan 3", fan3Ratio, fan3LimitRatio, "" + fan3RPM, "" + fan3RPMLimit);
                this.p2Fan4Panel.init("P2 Fan 4", fan4Ratio, fan4LimitRatio, "" + fan4RPM, "" + fan4RPMLimit);
                this.p2TempPanel.init("P2 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower2Sensors = true;
            }
            this.p2Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
            this.p2Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            this.p2Fan3Panel.updateValue(fan3Ratio, "" + fan3RPM);
            this.p2Fan4Panel.updateValue(fan4Ratio, "" + fan4RPM);
            this.p2TempPanel.updateValue(temp, "" + temp);
            this.p2Fan3Panel.setVisible(powerSupply.getNumOfFans() >= 3);
            this.p2Fan4Panel.setVisible(powerSupply.getNumOfFans() >= 4);
        }
        if ((powerSupply = bladeSystemEntity.getPowerSupplies()[2]).getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p3PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p3PowerStatusLabel.setText("Off");
                    break;
                }
                case 1: {
                    this.p3PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p3PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p3PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p3PowerStatusLabel.setText("Failure");
                    break;
                }
                default: {
                    this.p3PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p3PowerStatusLabel.setText("Off");
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower3Sensors) {
                this.p3Fan1Panel.init("P3 Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p3Fan2Panel.init("P3 Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p3Fan3Panel.init("P3 Fan 3", fan3Ratio, fan3LimitRatio, "" + fan3RPM, "" + fan3RPMLimit);
                this.p3Fan4Panel.init("P3 Fan 4", fan4Ratio, fan4LimitRatio, "" + fan4RPM, "" + fan4RPMLimit);
                this.p3TempPanel.init("P3 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower3Sensors = true;
            }
            this.p3Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
            this.p3Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            this.p3Fan3Panel.updateValue(fan3Ratio, "" + fan3RPM);
            this.p3Fan4Panel.updateValue(fan4Ratio, "" + fan4RPM);
            this.p3TempPanel.updateValue(temp, "" + temp);
            this.p3Fan3Panel.setVisible(powerSupply.getNumOfFans() >= 3);
            this.p3Fan4Panel.setVisible(powerSupply.getNumOfFans() >= 4);
        }
        if ((powerSupply = bladeSystemEntity.getPowerSupplies()[3]).getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p4PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p4PowerStatusLabel.setText("Off");
                    break;
                }
                case 1: {
                    this.p4PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p4PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p4PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p4PowerStatusLabel.setText("Failure");
                    break;
                }
                default: {
                    this.p4PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p4PowerStatusLabel.setText("Off");
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower4Sensors) {
                this.p4Fan1Panel.init("P4 Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p4Fan2Panel.init("P4 Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p4Fan3Panel.init("P4 Fan 3", fan3Ratio, fan3LimitRatio, "" + fan3RPM, "" + fan3RPMLimit);
                this.p4Fan4Panel.init("P4 Fan 4", fan4Ratio, fan4LimitRatio, "" + fan4RPM, "" + fan4RPMLimit);
                this.p4TempPanel.init("P4 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower4Sensors = true;
            }
            this.p4Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
            this.p4Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            this.p4Fan3Panel.updateValue(fan3Ratio, "" + fan3RPM);
            this.p4Fan4Panel.updateValue(fan4Ratio, "" + fan4RPM);
            this.p4TempPanel.updateValue(temp, "" + temp);
            this.p4Fan3Panel.setVisible(powerSupply.getNumOfFans() >= 3);
            this.p4Fan4Panel.setVisible(powerSupply.getNumOfFans() >= 4);
        }
    }
}

