/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.BrowserControl;
import IPMIView20.CMMDebug;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.JVolPanel;
import IPMIView20.blade.SummaryAbstractPanel;
import IPMIView20.blade.SummarySwitchPanel_jg1WebManagementButton_actionAdapter;
import IPMIView20.blade.SummarySwitchPanel_jg2WebManagementButton_actionAdapter;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SummarySwitchPanel
extends SummaryAbstractPanel {
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static int VOLTAGE_2V5_FULL_SCALE = 3;
    public static int VOLTAGE_1V25_FULL_SCALE = 3;
    boolean initSwitch1Sensors = false;
    boolean initSwitch2Sensors = false;
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    JTempPanel g1SwitchTemperature = new JTempPanel();
    JTempPanel g1BoardTemperature = new JTempPanel();
    JVolPanel g1P2v5Voltage = new JVolPanel();
    JVolPanel g1P1v25Voltage = new JVolPanel();
    JTempPanel g2SwitchTemperature = new JTempPanel();
    JTempPanel g2BoardTemperature = new JTempPanel();
    JVolPanel g2P2v5Voltage = new JVolPanel();
    JVolPanel g2P1v25Voltage = new JVolPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jSensorPanel = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jTemperaturePanel = new JPanel();
    JPanel jVoltagePanel = new JPanel();
    JPanel jInfoPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    GridLayout gridLayout2 = new GridLayout();
    TitledBorder titledBorder3 = new TitledBorder("");
    GridLayout gridLayout3 = new GridLayout();
    TitledBorder titledBorder4 = new TitledBorder("");
    JPanel jSwitch2TempPanel = new JPanel();
    JPanel jSwitch1TempPanel = new JPanel();
    JPanel jSwitch1VolPanel = new JPanel();
    JPanel jSwitch2VolPanel = new JPanel();
    TitledBorder titledBorder5 = new TitledBorder("");
    TitledBorder titledBorder6 = new TitledBorder("");
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    GridLayout gridLayout4 = new GridLayout();
    FlowLayout flowLayout3 = new FlowLayout();
    FlowLayout flowLayout4 = new FlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jSwitch2InfoPanel = new JPanel();
    JPanel jSwitch1InfoPanel = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel9 = new JPanel();
    JPanel jPanel10 = new JPanel();
    JPanel jPanel11 = new JPanel();
    GridLayout gridLayout7 = new GridLayout();
    GridLayout gridLayout8 = new GridLayout();
    JLabel jg1PowerStatusStringLabel = new JLabel();
    JLabel jg1PowerStatusLabel = new JLabel();
    TitledBorder titledBorder7 = new TitledBorder("");
    TitledBorder titledBorder8 = new TitledBorder("");
    JLabel jg1ErrorLEDStringLabel = new JLabel();
    JLabel jg1ErrorLEDLabel = new JLabel();
    JLabel jg1InitializedLabel = new JLabel();
    JLabel jg2ErrorLEDLabel = new JLabel();
    JLabel jg1InitializedStringLabel = new JLabel();
    GridLayout gridLayout9 = new GridLayout();
    JButton jg1WebManagementButton = new JButton();
    GridLayout gridLayout10 = new GridLayout();
    GridLayout gridLayout11 = new GridLayout();
    GridLayout gridLayout12 = new GridLayout();
    JLabel jg2PowerStatusLabel = new JLabel();
    JLabel jg2PowerStatusStringLabel = new JLabel();
    JLabel jg2ErrorLEDStringLabel = new JLabel();
    JLabel jg2InitializedStringLabel = new JLabel();
    JLabel jg2InitializedLabel = new JLabel();
    JButton jg2WebManagementButton = new JButton();
    BladeSystemEntity bladeSystemEntity = null;

    public SummarySwitchPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.g1SwitchTemperature.tempMeter.setPreferredSize(new Dimension(144, 42));
        this.g1BoardTemperature.tempMeter.setPreferredSize(new Dimension(120, 35));
        this.g1P2v5Voltage.volMeter.setPreferredSize(new Dimension(117, 69));
        this.g1P1v25Voltage.volMeter.setPreferredSize(new Dimension(117, 69));
        this.g2SwitchTemperature.tempMeter.setPreferredSize(new Dimension(144, 42));
        this.g2BoardTemperature.tempMeter.setPreferredSize(new Dimension(120, 35));
        this.g2P2v5Voltage.volMeter.setPreferredSize(new Dimension(117, 69));
        this.g2P1v25Voltage.volMeter.setPreferredSize(new Dimension(117, 69));
        this.jSwitch1TempPanel.add(this.g1SwitchTemperature);
        this.jSwitch1TempPanel.add(this.g1BoardTemperature);
        this.jSwitch2TempPanel.add(this.g2SwitchTemperature);
        this.jSwitch2TempPanel.add(this.g2BoardTemperature);
        this.jSwitch1VolPanel.add(this.g1P1v25Voltage);
        this.jSwitch1VolPanel.add(this.g1P2v5Voltage);
        this.jSwitch2VolPanel.add(this.g2P1v25Voltage);
        this.jSwitch2VolPanel.add(this.g2P2v5Voltage);
        this.g1SwitchTemperature.init(L.t("cmm.summary.switch.Switch"), (byte)0, (byte)0, "", "");
        this.g1BoardTemperature.init(L.t("cmm.summary.switch.Board"), (byte)0, (byte)0, "", "");
        this.g1P2v5Voltage.init("2.5 V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.g1P1v25Voltage.init("1.25 V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.g2SwitchTemperature.init(L.t("cmm.summary.switch.Switch"), (byte)0, (byte)0, "", "");
        this.g2BoardTemperature.init(L.t("cmm.summary.switch.Board"), (byte)0, (byte)0, "", "");
        this.g2P2v5Voltage.init("2.5 V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.g2P1v25Voltage.init("1.25 V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.g1BoardTemperature.setVisible(false);
        this.g2BoardTemperature.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.titledBorder8 = new TitledBorder(L.t("cmm.summary.switch.Switch_2_Information"));
        this.titledBorder7 = new TitledBorder(L.t("cmm.summary.switch.Switch_1_Information"));
        this.titledBorder6 = new TitledBorder(L.t("cmm.summary.switch.Switch_2_Voltage"));
        this.titledBorder5 = new TitledBorder(L.t("cmm.summary.switch.Switch_1_Voltage"));
        this.titledBorder3 = new TitledBorder(L.t("cmm.summary.switch.Information"));
        this.titledBorder2 = new TitledBorder(L.t("cmm.summary.switch.Switch_2_Temperature"));
        this.titledBorder1 = new TitledBorder(L.t("cmm.summary.switch.Switch_1_Temperature"));
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jSensorPanel.setLayout(this.borderLayout3);
        this.jTemperaturePanel.setLayout(this.gridLayout3);
        this.jVoltagePanel.setLayout(this.gridLayout4);
        this.jPanel2.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.jInfoPanel.setLayout(this.gridLayout1);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(2);
        this.jVoltagePanel.setBorder(null);
        this.jSwitch1TempPanel.setLayout(this.flowLayout1);
        this.jSwitch2TempPanel.setLayout(this.flowLayout2);
        this.jSwitch1VolPanel.setLayout(this.flowLayout3);
        this.jSwitch2VolPanel.setLayout(this.flowLayout4);
        this.jSwitch1TempPanel.setBorder(this.titledBorder1);
        this.jTemperaturePanel.setBorder(null);
        this.jSwitch2TempPanel.setBorder(this.titledBorder2);
        this.jSwitch1VolPanel.setBorder(this.titledBorder5);
        this.jSwitch2VolPanel.setBorder(this.titledBorder6);
        this.gridLayout4.setColumns(1);
        this.gridLayout4.setRows(2);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.jSwitch1InfoPanel.setLayout(this.gridLayout5);
        this.jSwitch2InfoPanel.setLayout(this.gridLayout6);
        this.gridLayout5.setColumns(1);
        this.gridLayout5.setRows(4);
        this.gridLayout6.setColumns(1);
        this.gridLayout6.setRows(4);
        this.jPanel1.setLayout(this.gridLayout8);
        this.jPanel6.setLayout(this.gridLayout7);
        this.jg1PowerStatusStringLabel.setForeground(Color.blue);
        this.jg1PowerStatusStringLabel.setMinimumSize(new Dimension(60, 15));
        this.jg1PowerStatusStringLabel.setText(L.t("cmm.summary.switch.Power_Status"));
        this.jg1PowerStatusLabel.setPreferredSize(new Dimension(80, 15));
        this.jInfoPanel.setBorder(null);
        this.jSwitch1InfoPanel.setBorder(this.titledBorder7);
        this.jSwitch2InfoPanel.setBorder(this.titledBorder8);
        this.jg1ErrorLEDStringLabel.setForeground(Color.blue);
        this.jg1ErrorLEDStringLabel.setText(L.t("cmm.summary.switch.Error_LED"));
        this.jg1InitializedStringLabel.setForeground(Color.blue);
        this.jg1InitializedStringLabel.setText(L.t("cmm.summary.switch.Initialized"));
        this.jPanel5.setLayout(this.gridLayout9);
        this.jg1WebManagementButton.setEnabled(false);
        this.jg1WebManagementButton.setText(L.t("cmm.summary.switch.Web_Management"));
        this.jg1WebManagementButton.addActionListener(new SummarySwitchPanel_jg1WebManagementButton_actionAdapter(this));
        this.jPanel7.setLayout(this.gridLayout10);
        this.jPanel11.setLayout(this.gridLayout11);
        this.jPanel10.setLayout(this.gridLayout12);
        this.jg2PowerStatusStringLabel.setForeground(Color.blue);
        this.jg2PowerStatusStringLabel.setText(L.t("cmm.summary.switch.Power_Status"));
        this.jg2ErrorLEDStringLabel.setForeground(Color.blue);
        this.jg2ErrorLEDStringLabel.setText(L.t("cmm.summary.switch.Error_LED"));
        this.jg2InitializedStringLabel.setForeground(Color.blue);
        this.jg2InitializedStringLabel.setText(L.t("cmm.summary.switch.Initialized"));
        this.jg2WebManagementButton.setEnabled(false);
        this.jg2WebManagementButton.setText(L.t("cmm.summary.switch.Web_Management"));
        this.jg2WebManagementButton.addActionListener(new SummarySwitchPanel_jg2WebManagementButton_actionAdapter(this));
        this.jPanel2.add(this.jInfoPanel);
        this.jInfoPanel.add(this.jSwitch1InfoPanel);
        this.jSwitch1InfoPanel.add(this.jPanel1);
        this.jPanel1.add(this.jg1PowerStatusStringLabel);
        this.jPanel1.add(this.jg1PowerStatusLabel);
        this.jSwitch1InfoPanel.add(this.jPanel6);
        this.jPanel6.add(this.jg1ErrorLEDStringLabel);
        this.jPanel6.add(this.jg1ErrorLEDLabel);
        this.jSwitch1InfoPanel.add(this.jPanel5);
        this.jPanel5.add(this.jg1InitializedStringLabel);
        this.jPanel5.add(this.jg1InitializedLabel);
        this.jSwitch1InfoPanel.add(this.jPanel4);
        this.jPanel4.add(this.jg1WebManagementButton);
        this.jInfoPanel.add(this.jSwitch2InfoPanel);
        this.jSwitch2InfoPanel.add(this.jPanel7);
        this.jPanel7.add(this.jg2PowerStatusStringLabel);
        this.jPanel7.add(this.jg2PowerStatusLabel);
        this.jSwitch2InfoPanel.add(this.jPanel11);
        this.jPanel11.add(this.jg2ErrorLEDStringLabel);
        this.jPanel11.add(this.jg2ErrorLEDLabel);
        this.jSwitch2InfoPanel.add(this.jPanel10);
        this.jPanel10.add(this.jg2InitializedStringLabel);
        this.jPanel10.add(this.jg2InitializedLabel);
        this.jSwitch2InfoPanel.add(this.jPanel9);
        this.jPanel9.add(this.jg2WebManagementButton);
        this.jCenterPanel.add((Component)this.jSensorPanel, "Center");
        this.jTemperaturePanel.add(this.jSwitch1TempPanel);
        this.jTemperaturePanel.add(this.jSwitch2TempPanel);
        this.jVoltagePanel.add(this.jSwitch1VolPanel);
        this.jVoltagePanel.add(this.jSwitch2VolPanel);
        this.add((Component)this.jCenterPanel, "Center");
        this.jCenterPanel.add((Component)this.jPanel2, "East");
        this.jSensorPanel.add((Component)this.jVoltagePanel, "Center");
        this.jSensorPanel.add((Component)this.jTemperaturePanel, "West");
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SummarySwitchPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SummarySwitchPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        GigabitSwitchEntity gigabit1SwitchEntity = this.bladeSystemEntity.getGigabitSwitchs()[0];
        GigabitSwitchEntity gigabit2SwitchEntity = this.bladeSystemEntity.getGigabitSwitchs()[1];
        this.updateSwitch1(gigabit1SwitchEntity);
        this.updateSwitch2(gigabit2SwitchEntity);
    }

    private void updateSwitch1(GigabitSwitchEntity gigabit1SwitchEntity) {
        if (gigabit1SwitchEntity.getPresent() > 0) {
            this.jg1PowerStatusLabel.setVisible(true);
            if (gigabit1SwitchEntity.isPowerOn()) {
                this.jg1PowerStatusLabel.setIcon(this.powerOnIcon);
                this.jg1PowerStatusLabel.setText(L.t("cmm.summary.switch.On"));
                this.jg1ErrorLEDLabel.setVisible(true);
                this.jg1InitializedLabel.setVisible(true);
                if (gigabit1SwitchEntity.getFlag() == 0 || gigabit1SwitchEntity.getFlag() == 2) {
                    this.jg1WebManagementButton.setEnabled(true);
                }
            } else {
                this.jg1PowerStatusLabel.setIcon(this.powerOffIcon);
                this.jg1PowerStatusLabel.setText(L.t("cmm.summary.switch.Off"));
                this.jg1ErrorLEDLabel.setVisible(false);
                this.jg1InitializedLabel.setVisible(false);
                this.jg1WebManagementButton.setEnabled(false);
            }
            if (gigabit1SwitchEntity.getFlag() == 0 || gigabit1SwitchEntity.getFlag() == 2) {
                if (gigabit1SwitchEntity.isError()) {
                    this.jg1ErrorLEDLabel.setIcon(this.xRedIcon);
                    this.jg1ErrorLEDLabel.setForeground(Color.RED);
                    this.jg1ErrorLEDLabel.setText(L.t("cmm.summary.switch.Error"));
                } else {
                    this.jg1ErrorLEDLabel.setIcon(this.okGreenIcon);
                    this.jg1ErrorLEDLabel.setForeground(Color.GREEN);
                    this.jg1ErrorLEDLabel.setText(L.t("cmm.summary.switch.Normal"));
                }
            } else {
                this.jg1ErrorLEDLabel.setForeground(Color.BLACK);
                this.jg1ErrorLEDLabel.setText(L.t("cmm.summary.switch.N_A"));
                this.jg1WebManagementButton.setEnabled(false);
            }
            if (gigabit1SwitchEntity.getInitialized() > 0) {
                this.jg1InitializedLabel.setIcon(this.okGreenIcon);
                this.jg1InitializedLabel.setForeground(Color.GREEN);
                this.jg1InitializedLabel.setText(L.t("cmm.summary.switch.OK"));
            } else {
                this.jg1InitializedLabel.setIcon(this.xRedIcon);
                this.jg1InitializedLabel.setForeground(Color.RED);
                this.jg1InitializedLabel.setText(L.t("cmm.summary.switch.Error"));
            }
            byte switchTemp = gigabit1SwitchEntity.getSwitchTemperature();
            byte switchTempLimit = 80;
            byte boardTemp = gigabit1SwitchEntity.getBoardTemperature();
            byte boardTempLimit = 80;
            double p2v5 = gigabit1SwitchEntity.p2v5Formula();
            double p2v5LowLimit = 2.25;
            double p2v5HighLimit = 2.75;
            byte p2v5Ratio = (byte)(p2v5 * 256.0 / (double)VOLTAGE_2V5_FULL_SCALE);
            byte p2v5LowLimitRatio = (byte)(p2v5LowLimit * 256.0 / (double)VOLTAGE_2V5_FULL_SCALE);
            byte p2v5HighLimitRatio = (byte)(p2v5HighLimit * 256.0 / (double)VOLTAGE_2V5_FULL_SCALE);
            String p2v5String = this.doubleToString(p2v5);
            String p2v5LowLimitString = "" + p2v5LowLimit;
            String p2v5HighLimitString = "" + p2v5HighLimit;
            double p1v25 = gigabit1SwitchEntity.p1v25Formula();
            double p1v25LowLimit = 1.025;
            double p1v25HighLimit = 1.375;
            byte p1v25Ratio = (byte)(p1v25 * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
            byte p1v25LowLimitRatio = (byte)(p1v25LowLimit * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
            byte p1v25HighLimitRatio = (byte)(p1v25HighLimit * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
            String p1v25String = this.doubleToString4(p1v25);
            String p1v25LowLimitString = "" + p1v25LowLimit;
            String p1v25HighLimitString = "" + p1v25HighLimit;
            if (!this.initSwitch1Sensors) {
                this.g1SwitchTemperature.init(L.t("cmm.summary.switch.Switch") + " ", switchTemp, switchTempLimit, "" + switchTemp, "" + switchTempLimit);
                this.g1BoardTemperature.init(L.t("cmm.summary.switch.Board") + " ", boardTemp, boardTempLimit, "" + boardTemp, "" + boardTempLimit);
                this.g1P2v5Voltage.init("2.5 V", p2v5Ratio, p2v5HighLimitRatio, p2v5LowLimitRatio, p2v5String, p2v5HighLimitString, p2v5LowLimitString);
                this.g1P1v25Voltage.init("1.25 V", p1v25Ratio, p1v25HighLimitRatio, p1v25LowLimitRatio, p1v25String, p1v25HighLimitString, p1v25LowLimitString);
                this.initSwitch1Sensors = true;
            }
            if (gigabit1SwitchEntity.isPowerOn()) {
                this.g1SwitchTemperature.updateValue(switchTemp, "" + switchTemp);
                this.g1P2v5Voltage.updateValue(p2v5Ratio, p2v5String);
                this.g1P1v25Voltage.updateValue(p1v25Ratio, p1v25String);
            } else {
                this.g1SwitchTemperature.setNA();
                this.g1P2v5Voltage.setNA();
                this.g1P1v25Voltage.setNA();
            }
        } else {
            this.setSwitch1UIVisible(false);
        }
    }

    private void setSwitch1UIVisible(boolean isVisible) {
        if (!isVisible) {
            this.g1SwitchTemperature.setNA();
            this.g1BoardTemperature.setNA();
            this.g1P2v5Voltage.setNA();
            this.g1P1v25Voltage.setNA();
        }
        this.jg1PowerStatusLabel.setVisible(isVisible);
        this.jg1ErrorLEDLabel.setVisible(isVisible);
        this.jg1InitializedLabel.setVisible(isVisible);
        this.jg1WebManagementButton.setEnabled(isVisible);
    }

    private void updateSwitch2(GigabitSwitchEntity gigabit2SwitchEntity) {
        if (gigabit2SwitchEntity.getPresent() > 0) {
            this.jg2PowerStatusLabel.setVisible(true);
            if (gigabit2SwitchEntity.isPowerOn()) {
                this.jg2PowerStatusLabel.setIcon(this.powerOnIcon);
                this.jg2PowerStatusLabel.setText(L.t("cmm.summary.switch.On"));
                this.jg2ErrorLEDLabel.setVisible(true);
                this.jg2InitializedLabel.setVisible(true);
                if (gigabit2SwitchEntity.getFlag() == 0 || gigabit2SwitchEntity.getFlag() == 2) {
                    this.jg2WebManagementButton.setEnabled(true);
                }
            } else {
                this.jg2PowerStatusLabel.setIcon(this.powerOffIcon);
                this.jg2PowerStatusLabel.setText(L.t("cmm.summary.switch.Off"));
                this.jg2ErrorLEDLabel.setVisible(false);
                this.jg2InitializedLabel.setVisible(false);
                this.jg2WebManagementButton.setEnabled(false);
            }
            if (gigabit2SwitchEntity.getFlag() == 0 || gigabit2SwitchEntity.getFlag() == 2) {
                if (gigabit2SwitchEntity.isError()) {
                    this.jg2ErrorLEDLabel.setIcon(this.xRedIcon);
                    this.jg2ErrorLEDLabel.setForeground(Color.RED);
                    this.jg2ErrorLEDLabel.setText(L.t("cmm.summary.switch.Error"));
                } else {
                    this.jg2ErrorLEDLabel.setIcon(this.okGreenIcon);
                    this.jg2ErrorLEDLabel.setForeground(Color.GREEN);
                    this.jg2ErrorLEDLabel.setText(L.t("cmm.summary.switch.Normal"));
                }
            } else {
                this.jg2ErrorLEDLabel.setForeground(Color.BLACK);
                this.jg2ErrorLEDLabel.setText(L.t("cmm.summary.switch.N_A"));
            }
            if (gigabit2SwitchEntity.getInitialized() > 0) {
                this.jg2InitializedLabel.setIcon(this.okGreenIcon);
                this.jg2InitializedLabel.setForeground(Color.GREEN);
                this.jg2InitializedLabel.setText(L.t("cmm.summary.switch.OK"));
            } else {
                this.jg2InitializedLabel.setIcon(this.xRedIcon);
                this.jg2InitializedLabel.setForeground(Color.RED);
                this.jg2InitializedLabel.setText(L.t("cmm.summary.switch.Error"));
            }
            byte switchTemp = gigabit2SwitchEntity.getSwitchTemperature();
            byte switchTempLimit = 80;
            byte boardTemp = gigabit2SwitchEntity.getBoardTemperature();
            byte boardTempLimit = 80;
            double p2v5 = gigabit2SwitchEntity.p2v5Formula();
            double p2v5LowLimit = 2.25;
            double p2v5HighLimit = 2.75;
            byte p2v5Ratio = (byte)(p2v5 * 256.0 / (double)VOLTAGE_2V5_FULL_SCALE);
            byte p2v5LowLimitRatio = (byte)(p2v5LowLimit * 256.0 / (double)VOLTAGE_2V5_FULL_SCALE);
            byte p2v5HighLimitRatio = (byte)(p2v5HighLimit * 256.0 / (double)VOLTAGE_2V5_FULL_SCALE);
            String p2v5String = this.doubleToString(p2v5);
            String p2v5LowLimitString = "" + p2v5LowLimit;
            String p2v5HighLimitString = "" + p2v5HighLimit;
            double p1v25 = gigabit2SwitchEntity.p1v25Formula();
            double p1v25LowLimit = 1.025;
            double p1v25HighLimit = 1.375;
            byte p1v25Ratio = (byte)(p1v25 * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
            byte p1v25LowLimitRatio = (byte)(p1v25LowLimit * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
            byte p1v25HighLimitRatio = (byte)(p1v25HighLimit * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
            String p1v25String = this.doubleToString4(p1v25);
            String p1v25LowLimitString = "" + p1v25LowLimit;
            String p1v25HighLimitString = "" + p1v25HighLimit;
            if (!this.initSwitch2Sensors) {
                this.g2SwitchTemperature.init(L.t("cmm.summary.switch.Switch") + " ", switchTemp, switchTempLimit, "" + switchTemp, "" + switchTempLimit);
                this.g2BoardTemperature.init(L.t("cmm.summary.switch.Board") + " ", boardTemp, boardTempLimit, "" + boardTemp, "" + boardTempLimit);
                this.g2P2v5Voltage.init("2.5 V", p2v5Ratio, p2v5HighLimitRatio, p2v5LowLimitRatio, p2v5String, p2v5HighLimitString, p2v5LowLimitString);
                this.g2P1v25Voltage.init("1.25 V", p1v25Ratio, p1v25HighLimitRatio, p1v25LowLimitRatio, p1v25String, p1v25HighLimitString, p1v25LowLimitString);
                this.initSwitch2Sensors = true;
            }
            if (gigabit2SwitchEntity.isPowerOn()) {
                this.g2SwitchTemperature.updateValue(switchTemp, "" + switchTemp);
                this.g2P2v5Voltage.updateValue(p2v5Ratio, p2v5String);
                this.g2P1v25Voltage.updateValue(p1v25Ratio, p1v25String);
            } else {
                this.g2SwitchTemperature.setNA();
                this.g2P2v5Voltage.setNA();
                this.g2P1v25Voltage.setNA();
            }
        } else {
            this.setSwitch2UIVisible(false);
        }
    }

    private void setSwitch2UIVisible(boolean isVisible) {
        if (!isVisible) {
            this.g2SwitchTemperature.setNA();
            this.g2BoardTemperature.setNA();
            this.g2P2v5Voltage.setNA();
            this.g2P1v25Voltage.setNA();
        }
        this.jg2PowerStatusLabel.setVisible(isVisible);
        this.jg2ErrorLEDLabel.setVisible(isVisible);
        this.jg2InitializedLabel.setVisible(isVisible);
        this.jg2WebManagementButton.setEnabled(isVisible);
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }

    public String doubleToString4(double value) {
        int temp = (int)(value * 10000.0);
        double d = (double)temp / 10000.0;
        return "" + d;
    }

    public void jg1WebManagementButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String ip = SummarySwitchPanel.this.helpGetWSSIP((byte)1);
                    if (ip == null) {
                        return;
                    }
                    BrowserControl.displayURL("http://" + ip);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SummarySwitchPanel.this.findParentFrame(), ex.getMessage());
                }
            }
        };
        thread.start();
    }

    public void jg2WebManagementButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String ip = SummarySwitchPanel.this.helpGetWSSIP((byte)2);
                    if (ip == null) {
                        return;
                    }
                    BrowserControl.displayURL("http://" + ip);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SummarySwitchPanel.this.findParentFrame(), ex.getMessage());
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String helpGetWSSIP(byte moduleIndex) throws Exception {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                String ip;
                String string = ip = ipmiCMMOEMCommand.getGBIP(moduleIndex);
                return string;
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
                String string = null;
                return string;
            }
            finally {
                sessionController.closeSession();
            }
        }
        return null;
    }
}

