/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.L;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class CMMMasterPanel
extends JPanel {
    CMM2CMMInfo cmm2cmmInfo;
    JLabel title1 = new JLabel(L.t("cmm.nodeStatus.master.info"));
    JLabel title2 = new JLabel(L.t("cmm.nodeStatus.master.connecting_status"));
    JLabel title3 = new JLabel(L.t("cmm.nodeStatus.master.flash_firmware"));
    JLabel lbl_IP = new JLabel("IP: ");
    JLabel lbl_mask = new JLabel(L.t("cmm.nodeStatus.master.netmask"));
    JLabel lbl_gateway = new JLabel(L.t("cmm.nodeStatus.master.gateway"));
    JLabel lbl_mac = new JLabel("Mac: ");
    JLabel lbl_fwVersion = new JLabel("FW version: ");
    JLabel lbl_modelName = new JLabel("Model Name:");
    JLabel lbl_slot = new JLabel(L.t("cmm.nodeStatus.master.cmm_slot"));
    JLabel lbl_status = new JLabel(L.t("cmm.nodeStatus.master.status"));
    JLabel lbl_lanReady = new JLabel(L.t("cmm.nodeStatus.master.connected_with_slave_cmm"));
    JLabel lbl_syncData = new JLabel(L.t("cmm.nodeStatus.master.data_sync_with_slave_cmm"));
    JLabel lbl_masterMessage = new JLabel(L.t("cmm.nodeStatus.master.info_icon"));
    JLabel lbl_updateMessage1 = new JLabel(L.t("cmm.nodeStatus.master.instruction"));
    JLabel lbl_updateMessage2 = new JLabel(L.t("cmm.nodeStatus.master.step1"));
    JLabel lbl_updateMessage3 = new JLabel(L.t("cmm.nodeStatus.master.step2"));
    JLabel lbl_updateMessage4 = new JLabel(L.t("cmm.nodeStatus.master.step3"));
    JLabel str_IP = new JLabel();
    JLabel str_mask = new JLabel();
    JLabel str_gateway = new JLabel();
    JLabel str_mac = new JLabel();
    JLabel str_fwVersion = new JLabel();
    JLabel str_modelName = new JLabel();
    JLabel str_slot = new JLabel();
    JLabel str_status = new JLabel();
    JLabel str_lanReady = new JLabel();
    JLabel str_syncData = new JLabel();
    JLabel ic_status = new JLabel();
    JLabel ic_lanReady = new JLabel();
    JLabel ic_syncData = new JLabel();
    JLabel ic_tip = new JLabel();
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon tipIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_about.gif"));
    JSeparator js1 = new JSeparator();
    JSeparator js2 = new JSeparator();
    JSeparator js3 = new JSeparator();

    public CMMMasterPanel(CMM2CMMInfo cmminfo) {
        this.cmm2cmmInfo = cmminfo;
        this.setLayout((LayoutManager)new MigLayout("", "", "5[]5[]5"));
        this.title1.setForeground(Color.blue);
        this.title2.setForeground(Color.blue);
        this.title3.setForeground(Color.blue);
        this.ic_status.setIcon(this.okGreenIcon);
        this.str_status.setText(L.t("cmm.nodeStatus.master.normal"));
        JPanel p1 = new JPanel((LayoutManager)new MigLayout("", "[70!][]", ""));
        JPanel p2 = new JPanel((LayoutManager)new MigLayout("", "", ""));
        JPanel p3 = new JPanel((LayoutManager)new MigLayout("", "", ""));
        JPanel p4 = new JPanel((LayoutManager)new MigLayout("", "", ""));
        p1.add((Component)this.title1, "cell 0 0");
        p1.add((Component)this.js1, "cell 0 1, span 4, growx");
        p1.add((Component)this.lbl_IP, "cell 0 2");
        p1.add((Component)this.str_IP, "cell 1 2");
        p1.add((Component)this.lbl_mask, "cell 0 3");
        p1.add((Component)this.str_mask, "cell 1 3");
        p1.add((Component)this.lbl_gateway, "cell 0 4");
        p1.add((Component)this.str_gateway, "cell 1 4");
        p1.add((Component)this.lbl_mac, "cell 0 5");
        p1.add((Component)this.str_mac, "cell 1 5");
        p1.add((Component)this.lbl_modelName, "cell 0 6");
        p1.add((Component)this.str_modelName, "cell 1 6");
        p1.add((Component)this.lbl_fwVersion, "cell 0 7");
        p1.add((Component)this.str_fwVersion, "cell 1 7");
        p2.add((Component)this.title2, "cell 0 1");
        p2.add((Component)this.js2, "cell 0 2, spanx4, growx");
        p2.add((Component)this.lbl_slot, "cell 0 3");
        p2.add((Component)this.str_slot, "cell 2 3");
        p2.add((Component)this.lbl_status, "cell 0 4");
        p2.add((Component)this.ic_status, "cell 1 4");
        p2.add((Component)this.str_status, "cell 2 4");
        p2.add((Component)this.lbl_lanReady, "cell 0 5");
        p2.add((Component)this.ic_lanReady, "cell 1 5");
        p2.add((Component)this.str_lanReady, "cell 2 5");
        p2.add((Component)this.lbl_syncData, "cell 0 6");
        p2.add((Component)this.ic_syncData, "cell 1 6");
        p2.add((Component)this.str_syncData, "cell 2 6");
        this.lbl_masterMessage.setForeground(Color.blue);
        this.ic_tip.setIcon(this.tipIcon);
        p3.add(this.ic_tip);
        p3.add(this.lbl_masterMessage);
        p4.add((Component)this.title3, "cell 0 0");
        p4.add((Component)this.js3, "cell 0 1, span4, growx");
        p4.add((Component)this.lbl_updateMessage1, "cell 0 2");
        p4.add((Component)this.lbl_updateMessage2, "cell 0 3");
        p4.add((Component)this.lbl_updateMessage3, "cell 0 4");
        p4.add((Component)this.lbl_updateMessage4, "cell 0 5");
        this.add((Component)p1, "cell 0 0, top");
        this.add((Component)p4, "cell 1 0, top");
        this.add((Component)p2, "cell 0 2");
        this.add((Component)p3, "cell 1 2");
        this.update(this.cmm2cmmInfo);
    }

    public void preset(final IPMIInterfaceConfig config) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
                ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(config, ipmiLanCommand);
                if (sessionController != null && ipmiLanCommand != null) {
                    try {
                        String ip = ipmiLanCommand.getIP();
                        String gateway = ipmiLanCommand.getGatewayIP();
                        String subnetMask = ipmiLanCommand.getSubnetMask();
                        String mac = ipmiLanCommand.getMAC();
                        CMMMasterPanel.this.str_IP.setText(ip);
                        CMMMasterPanel.this.str_gateway.setText(gateway);
                        CMMMasterPanel.this.str_mask.setText(subnetMask);
                        CMMMasterPanel.this.str_mac.setText(mac);
                        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(ipmiLanCommand.getIPMIInterface());
                        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
                        if (deviceInfo.usingAuxiliaryFWVesion) {
                            CMMMasterPanel.this.str_fwVersion.setText(deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]));
                        } else {
                            CMMMasterPanel.this.str_fwVersion.setText(deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2));
                        }
                        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(ipmiLanCommand.getIPMIInterface());
                        FRUInfo fruInfo = ipmiFRUCommand.getFRUData((byte)1);
                        if (fruInfo != null) {
                            CMMMasterPanel.this.str_modelName.setText(new String(fruInfo.fru.product.productPartModelNumber));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (sessionController != null) {
                    sessionController.closeSession();
                }
            }
        });
    }

    public void refresh(CMM2CMMInfo cmm2cmminfo) {
        this.str_slot.setText(Integer.toString(cmm2cmminfo.cmmSlot + 1));
        if (cmm2cmminfo.isOtherCMMPresent()) {
            if (cmm2cmminfo.isLanReady()) {
                this.ic_lanReady.setIcon(this.okGreenIcon);
                this.str_lanReady.setText(L.t("cmm.nodeStatus.master.normal"));
            } else {
                this.ic_lanReady.setIcon(this.xRedIcon);
                this.str_lanReady.setText(L.t("cmm.nodeStatus.master.error"));
            }
            if (cmm2cmminfo.isDataSync()) {
                this.ic_syncData.setIcon(this.okGreenIcon);
                this.str_syncData.setText(L.t("cmm.nodeStatus.master.normal"));
            } else {
                this.ic_syncData.setIcon(this.xRedIcon);
                this.str_syncData.setText(L.t("cmm.nodeStatus.master.error"));
            }
        } else {
            this.ic_lanReady.setIcon(null);
            this.str_lanReady.setText(L.t("cmm.nodeStatus.master.no") + " Slave CMM");
            this.ic_syncData.setIcon(null);
            this.str_syncData.setText(L.t("cmm.nodeStatus.master.no") + " Slave CMM");
        }
    }

    public void update(CMM2CMMInfo cmmInfo) {
        this.cmm2cmmInfo = cmmInfo;
        SwingUtilities.invokeLater(new Runnable(){
            private CMM2CMMInfo c;
            {
                this.c = CMMMasterPanel.this.cmm2cmmInfo;
            }

            @Override
            public void run() {
                try {
                    CMMMasterPanel.this.refresh(this.c);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }
}

