/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import com.supermicro.ipmi.microblade.RedundantCMMInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class CMMRedundantPanel
extends JPanel {
    CMM2CMMInfo cmm2cmmInfo;
    RedundantCMMInfo redundantCMMInfo;
    JLabel title1 = new JLabel("Information");
    JLabel title2 = new JLabel("Connecting status");
    JLabel lbl_slot = new JLabel("CMM Slot: ");
    JLabel lbl_fwRevision = new JLabel("FW Revision: ");
    JLabel lbl_fwTime = new JLabel("FW build time: ");
    JLabel lbl_mac = new JLabel("Mac: ");
    JLabel lbl_status = new JLabel("Status: ");
    JLabel lbl_lanReady = new JLabel("Conntected with Master: ");
    JLabel lbl_syncData = new JLabel("Data Synchronized: ");
    JLabel lbl_slaveMessage = new JLabel("This is a back up CMM. You are now connecting to Master CMM");
    JLabel str_slot = new JLabel();
    JLabel str_fwRevision = new JLabel();
    JLabel str_fwTime = new JLabel();
    JLabel str_mac = new JLabel();
    JLabel str_status = new JLabel();
    JLabel str_lanReady = new JLabel();
    JLabel str_syncData = new JLabel();
    JLabel ic_status = new JLabel();
    JLabel ic_lanReady = new JLabel();
    JLabel ic_syncData = new JLabel();
    JLabel ic_tip = new JLabel();
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon tipIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_about.gif"));
    JSeparator js1 = new JSeparator();
    JSeparator js2 = new JSeparator();

    public CMMRedundantPanel(CMM2CMMInfo cmminfo, RedundantCMMInfo redCmmInfo) {
        this.cmm2cmmInfo = cmminfo;
        this.redundantCMMInfo = redCmmInfo;
        this.setLayout((LayoutManager)new MigLayout("", "", "[][30!][]"));
        this.title1.setForeground(Color.blue);
        this.title2.setForeground(Color.blue);
        JPanel p1 = new JPanel((LayoutManager)new MigLayout("", "[70!][]", ""));
        JPanel p2 = new JPanel((LayoutManager)new MigLayout("", "", ""));
        JPanel p3 = new JPanel((LayoutManager)new MigLayout("", "", ""));
        p1.add((Component)this.title1, "cell 0 0");
        p1.add((Component)this.js1, "cell 0 1, span 4, growx");
        p1.add((Component)this.lbl_fwRevision, "cell 0 2");
        p1.add((Component)this.str_fwRevision, "cell 1 2");
        p1.add((Component)this.lbl_fwTime, "cell 0 3");
        p1.add((Component)this.str_fwTime, "cell 1 3");
        p1.add((Component)this.lbl_mac, "cell 0 4");
        p1.add((Component)this.str_mac, "cell 1 4");
        p2.add((Component)this.title2, "cell 0 1");
        p2.add((Component)this.js2, "cell 0 2, spanx4, growx");
        p2.add((Component)this.lbl_slot, "cell 0 3");
        p2.add((Component)this.str_slot, "cell 2 3");
        p2.add((Component)this.lbl_status, "cell 0 4");
        p2.add((Component)this.ic_status, "cell 1 4");
        p2.add((Component)this.str_status, "cell 2 4");
        p2.add((Component)this.lbl_lanReady, "cell 0 5");
        p2.add((Component)this.ic_lanReady, "cell 1 5");
        p2.add((Component)this.str_lanReady, "cell 2 5");
        p2.add((Component)this.lbl_syncData, "cell 0 6");
        p2.add((Component)this.ic_syncData, "cell 1 6");
        p2.add((Component)this.str_syncData, "cell 2 6");
        this.lbl_slaveMessage.setForeground(Color.blue);
        this.ic_tip.setIcon(this.tipIcon);
        p3.add(this.ic_tip);
        p3.add(this.lbl_slaveMessage);
        this.add((Component)p1, "cell 0 0");
        this.add((Component)p2, "cell 0 1");
        this.add((Component)p3, "cell 1 1");
        this.refresh(this.cmm2cmmInfo, this.redundantCMMInfo);
    }

    public void refresh(CMM2CMMInfo cmm2cmminfo, RedundantCMMInfo redundantCmmInfo) {
        this.str_fwRevision.setText(redundantCmmInfo.getVersion());
        this.str_fwTime.setText(redundantCmmInfo.getFWbuildTime());
        this.str_mac.setText(redundantCmmInfo.getMac());
        int redundantSlot = cmm2cmminfo.cmmSlot == 0 ? 1 : 0;
        this.str_slot.setText(Integer.toString(redundantSlot));
        if (cmm2cmminfo.isOtherCMMAlive()) {
            this.ic_status.setIcon(this.okGreenIcon);
            this.str_status.setText("Normal");
        } else {
            this.ic_status.setIcon(this.xRedIcon);
            this.str_status.setText("Error");
        }
        if (cmm2cmminfo.isLanReady()) {
            this.ic_lanReady.setIcon(this.okGreenIcon);
            this.str_lanReady.setText("Normal");
        } else {
            this.ic_lanReady.setIcon(this.xRedIcon);
            this.str_lanReady.setText("Error");
        }
        if (cmm2cmminfo.isDataSync()) {
            this.ic_syncData.setIcon(this.okGreenIcon);
            this.str_syncData.setText("Normal");
        } else {
            this.ic_syncData.setIcon(this.xRedIcon);
            this.str_syncData.setText("Error");
        }
    }

    public void update(CMM2CMMInfo cmmInfo, RedundantCMMInfo redInfo) {
        this.cmm2cmmInfo = cmmInfo;
        this.redundantCMMInfo = redInfo;
        SwingUtilities.invokeLater(new Runnable(){
            private CMM2CMMInfo c;
            private RedundantCMMInfo r;
            {
                this.c = CMMRedundantPanel.this.cmm2cmmInfo;
                this.r = CMMRedundantPanel.this.redundantCMMInfo;
            }

            @Override
            public void run() {
                try {
                    CMMRedundantPanel.this.refresh(this.c, this.r);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }
}

