/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.L;
import IPMIView20.micro.NodeStatusPanel;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class GlobalSummaryPanel
extends JPanel {
    int totalNodes;
    int totalPS = 8;
    int totalSwitch = 4;
    int totalCMM = 2;
    IPMIInterfaceConfig ipmiInterfaceConfig;
    FRUInfo fruInfo;
    JLabel lbl_node = new JLabel(L.t("cmm.nodeStatus.summary.node"));
    JLabel lbl_power = new JLabel(L.t("cmm.nodeStatus.summary.power"));
    JLabel lbl_switch = new JLabel(L.t("cmm.nodeStatus.summary.switch"));
    JLabel lbl_cmm = new JLabel("CMM:");
    JLabel cont_node = new JLabel("");
    JLabel cont_power = new JLabel("");
    JLabel cont_switch = new JLabel("");
    JLabel cont_cmm = new JLabel("");
    JPanel summaryPanel;
    JPanel helpPanel;
    JPanel middlePlanePanel;
    ImageIcon alertIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentAlert.gif"));
    ImageIcon flashingIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentFlashing.gif"));
    ImageIcon uidIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentUID.gif"));
    ImageIcon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentPowerOn.gif"));
    ImageIcon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentPowerOff.gif"));
    ImageIcon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentPowerFailure.gif"));
    ImageIcon indexNumberIcon = new ImageIcon(this.getClass().getResource("/images/index_number.gif"));
    ImageIcon mouseOnIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeMouseOnExample.gif"));
    ImageIcon mouseFocusIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeFocus2Example.png"));
    JLabel lbl_1 = new JLabel();
    JLabel lbl_2 = new JLabel();
    JLabel lbl_3 = new JLabel();
    JLabel lbl_4 = new JLabel();
    JLabel lbl_5 = new JLabel();
    JLabel lbl_6 = new JLabel();
    JLabel lbl_7 = new JLabel();
    JLabel lbl_8 = new JLabel();
    JLabel lbl_9 = new JLabel();
    JLabel lbl_boardTitle = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.info"));
    JLabel lbl_board1 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.mfg_date_time"));
    JLabel lbl_board1String = new JLabel();
    JLabel lbl_board2 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.mfg_name"));
    JLabel lbl_board2String = new JLabel();
    JLabel lbl_board3 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.product_name"));
    JLabel lbl_board3String = new JLabel();
    JLabel lbl_board4 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.serial_name"));
    JLabel lbl_board4String = new JLabel();
    JLabel lbl_board5 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.part_number"));
    JLabel lbl_board5String = new JLabel();
    JLabel lbl_board6 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.board.language"));
    JLabel lbl_board6String = new JLabel();
    JLabel lbl_proTitle = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.info"));
    JLabel lbl_pro1 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.mfg_name"));
    JLabel lbl_pro1String = new JLabel();
    JLabel lbl_pro2 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.name"));
    JLabel lbl_pro2String = new JLabel();
    JLabel lbl_pro3 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.part_model_number"));
    JLabel lbl_pro3String = new JLabel();
    JLabel lbl_pro4 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.version"));
    JLabel lbl_pro4String = new JLabel();
    JLabel lbl_pro5 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.serial_number"));
    JLabel lbl_pro5String = new JLabel();
    JLabel lbl_pro6 = new JLabel(L.t("cmm.nodeStatus.middle_plane_info.product.asset_tag"));
    JLabel lbl_pro6String = new JLabel();

    public GlobalSummaryPanel(MicroBladeEntity m, IPMIInterfaceConfig ipmiInterfaceconfig) {
        this.setLayout((LayoutManager)new MigLayout("", "", ""));
        this.lbl_node.setForeground(Color.blue);
        this.lbl_power.setForeground(Color.blue);
        this.lbl_switch.setForeground(Color.blue);
        this.lbl_cmm.setForeground(Color.blue);
        this.totalNodes = NodeStatusPanel.numberOfNodes;
        this.totalPS = NodeStatusPanel.numberOfPS;
        this.totalSwitch = NodeStatusPanel.numberOfSwitch;
        this.totalCMM = NodeStatusPanel.numberOfCmm;
        if (m.MiddlePlaneType == 2) {
            this.totalNodes = 56;
            this.totalPS = 4;
            this.totalSwitch = 2;
            this.totalCMM = 1;
        } else if (m.MiddlePlaneType == 1) {
            this.totalNodes = 112;
            this.totalPS = 8;
            this.totalSwitch = 4;
            this.totalCMM = 2;
        } else if (m.MiddlePlaneType == 4) {
            this.totalNodes = 80;
            this.totalPS = 8;
            this.totalSwitch = 4;
            this.totalCMM = 1;
        }
        this.summaryPanel = this.getSummaryPanel();
        this.helpPanel = this.getHelpPanel();
        this.middlePlanePanel = this.getMiddlePlanePanel();
        this.add((Component)this.summaryPanel, "cell 0 0");
        this.add((Component)this.helpPanel, "cell 0 1");
        this.add((Component)this.middlePlanePanel, "cell 1 0, spany 2");
        this.ipmiInterfaceConfig = ipmiInterfaceconfig;
        Thread thread = new Thread(){

            @Override
            public void run() {
                GlobalSummaryPanel.this.getfruInfo(GlobalSummaryPanel.this.ipmiInterfaceConfig);
            }
        };
        thread.start();
    }

    public JPanel getSummaryPanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("", "", ""));
        TitledBorder b = new TitledBorder(L.t("cmm.nodeStatus.summary"));
        p.add((Component)this.lbl_node, "cell 0 1");
        p.add((Component)this.cont_node, "cell 1 1");
        p.add((Component)this.lbl_cmm, "cell 2 1");
        p.add((Component)this.cont_cmm, "cell 3 1");
        p.add((Component)this.lbl_power, "cell 0 2");
        p.add((Component)this.cont_power, "cell 1 2");
        p.add((Component)this.lbl_switch, "cell 2 2");
        p.add((Component)this.cont_switch, "cell 3 2");
        p.setBorder(b);
        return p;
    }

    public JPanel getHelpPanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("", "", "[]3[]"));
        TitledBorder b = new TitledBorder(L.t("cmm.nodeStatus.icon.expression"));
        this.lbl_1.setIcon(this.powerOnIcon);
        this.lbl_1.setText(L.t("cmm.nodeStatus.icon.power_on"));
        this.lbl_2.setIcon(this.powerOffIcon);
        this.lbl_2.setText(L.t("cmm.nodeStatus.icon.power_off"));
        this.lbl_3.setIcon(this.powerFailureIcon);
        this.lbl_3.setText(L.t("cmm.nodeStatus.icon.power_failure"));
        this.lbl_4.setIcon(this.uidIcon);
        this.lbl_4.setText("UID");
        this.lbl_5.setIcon(this.alertIcon);
        this.lbl_5.setText(L.t("cmm.nodeStatus.icon.alert"));
        this.lbl_6.setIcon(this.flashingIcon);
        this.lbl_6.setText(L.t("cmm.nodeStatus.icon.flashing"));
        this.lbl_7.setIcon(this.indexNumberIcon);
        this.lbl_7.setText(L.t("cmm.nodeStatus.icon.module_index"));
        this.lbl_8.setIcon(this.mouseOnIcon);
        this.lbl_8.setText(L.t("cmm.nodeStatus.icon.mouse_on_module"));
        this.lbl_9.setIcon(this.mouseFocusIcon);
        this.lbl_9.setText(L.t("cmm.nodeStatus.icon.focus_on_module"));
        p.add((Component)this.lbl_1, "cell 0 0");
        p.add((Component)this.lbl_2, "cell 0 1");
        p.add((Component)this.lbl_3, "cell 0 2");
        p.add((Component)this.lbl_4, "cell 0 3");
        p.add((Component)this.lbl_5, "cell 0 4");
        p.add((Component)this.lbl_6, "cell 0 5");
        p.add((Component)this.lbl_7, "cell 0 6");
        p.add((Component)this.lbl_8, "cell 0 7");
        p.add((Component)this.lbl_9, "cell 0 8");
        p.setBorder(b);
        return p;
    }

    public JPanel getMiddlePlanePanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("", "", "[]5[]"));
        TitledBorder b = new TitledBorder(L.t("cmm.nodeStatus.middle_plane_info"));
        this.lbl_boardTitle.setForeground(Color.blue);
        this.lbl_proTitle.setForeground(Color.blue);
        p.add((Component)this.lbl_boardTitle, "cell 0 0");
        p.add((Component)this.lbl_board6, "cell 0 1");
        p.add((Component)this.lbl_board6String, "cell 1 1");
        p.add((Component)this.lbl_board1, "cell 0 2");
        p.add((Component)this.lbl_board1String, "cell 1 2");
        p.add((Component)this.lbl_board2, "cell 0 3");
        p.add((Component)this.lbl_board2String, "cell 1 3");
        p.add((Component)this.lbl_board3, "cell 0 4");
        p.add((Component)this.lbl_board3String, "cell 1 4");
        p.add((Component)this.lbl_board4, "cell 0 5");
        p.add((Component)this.lbl_board4String, "cell 1 5");
        p.add((Component)this.lbl_board5, "cell 0 6");
        p.add((Component)this.lbl_board5String, "cell 1 6");
        p.add((Component)this.lbl_proTitle, "cell 0 7");
        p.add((Component)this.lbl_pro1, "cell 0 8");
        p.add((Component)this.lbl_pro1String, "cell 1 8");
        p.add((Component)this.lbl_pro2, "cell 0 9");
        p.add((Component)this.lbl_pro2String, "cell 1 9");
        p.add((Component)this.lbl_pro3, "cell 0 10");
        p.add((Component)this.lbl_pro3String, "cell 1 10");
        p.add((Component)this.lbl_pro4, "cell 0 11");
        p.add((Component)this.lbl_pro4String, "cell 1 11");
        p.add((Component)this.lbl_pro5, "cell 0 12");
        p.add((Component)this.lbl_pro5String, "cell 1 12");
        p.add((Component)this.lbl_pro6, "cell 0 13");
        p.add((Component)this.lbl_pro6String, "cell 1 13");
        p.setBorder(b);
        return p;
    }

    public void getfruInfo(IPMIInterfaceConfig ipmiInterfaceConfig) {
        ISessionController sessionController = null;
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        sessionController = SessionControllerFactory.createSessionController(ipmiInterfaceConfig, ipmiFRUCommand);
        if (sessionController != null) {
            this.fruInfo = ipmiFRUCommand.getFRUData((byte)2);
            if (this.fruInfo != null) {
                this.lbl_board1String.setText(new String(this.getMfgDateTime(this.fruInfo.fru.board.mfgDateTime)));
                this.lbl_board2String.setText(new String(this.fruInfo.fru.board.boardManufacturer).trim());
                this.lbl_board3String.setText(new String(this.fruInfo.fru.board.boardProductName).trim());
                this.lbl_board4String.setText(new String(this.fruInfo.fru.board.boardSerialNumber).trim());
                this.lbl_board5String.setText(new String(this.fruInfo.fru.board.boardPartNumber).trim());
                this.lbl_board6String.setText(this.fruInfo.fru.board.languageCode == 0 ? new String("English") : new String("unKnown"));
                this.lbl_pro1String.setText(new String(this.fruInfo.fru.product.productManufacturerName).trim());
                this.lbl_pro2String.setText(new String(this.fruInfo.fru.product.productName).trim());
                this.lbl_pro3String.setText(new String(this.fruInfo.fru.product.productPartModelNumber).trim());
                this.lbl_pro4String.setText(new String(this.fruInfo.fru.product.productVersion).trim());
                this.lbl_pro5String.setText(new String(this.fruInfo.fru.product.productSerialNumber).trim());
                this.lbl_pro6String.setText(new String(this.fruInfo.fru.product.assetTag).trim());
            }
        }
        if (sessionController != null) {
            sessionController.closeSession();
        }
    }

    private String getMfgDateTime(byte[] mfgDateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.set(1996, 0, 1, 0, 0, 0);
        long timeValue = ((long)(mfgDateTime[2] & 0xFF) << 16) + ((long)(mfgDateTime[1] & 0xFF) << 8) + (long)(mfgDateTime[0] & 0xFF);
        cal.setTimeInMillis(cal.getTimeInMillis() + (timeValue *= 60000L));
        return sdf.format(cal.getTime()) + " (" + ByteUtility.byteToHex(mfgDateTime[0]) + " " + ByteUtility.byteToHex(mfgDateTime[1]) + " " + ByteUtility.byteToHex(mfgDateTime[2]) + ")";
    }

    public void update(int curNodes, int curPower, int curSwitch, int curCMM) {
        this.cont_node.setText(curNodes + " / " + this.totalNodes + "  ");
        this.cont_power.setText(curPower + " / " + this.totalPS + "  ");
        this.cont_switch.setText(curSwitch + " / " + this.totalSwitch + "  ");
        this.cont_cmm.setText(curCMM + " / " + this.totalCMM + "  ");
    }
}

