/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.micro.LabelMicroBladeComponent;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelMicroCMM
extends LabelMicroBladeComponent {
    IPMIInterfaceConfig ipmiInterfaceConfig;
    ImageIcon labelCMM = new ImageIcon(this.getClass().getResource("/images/labelMicrobladeCMM.jpg"));
    ImageIcon connectedCMM = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentConnected.gif"));
    boolean connected = false;
    boolean isAlive = false;
    int connectedIconX;
    int connectedIconY;

    public LabelMicroCMM(IPMIInterfaceConfig config) {
        this.ipmiInterfaceConfig = config;
        this.setIcon(this.labelCMM);
        this.setSize(this.labelCMM.getIconWidth(), this.labelCMM.getIconHeight());
        this.uidVisible = false;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!LabelMicroCMM.this.isExist) {
                    return;
                }
                LabelMicroCMM.this.setCursor(new Cursor(12));
                LabelMicroCMM.this.setBorderVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabelMicroCMM.this.setCursor(new Cursor(0));
                LabelMicroCMM.this.setBorderVisible(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LabelMicroCMM.this.isExist) {
                    return;
                }
                LabelMicroCMM.this.setGroupUnSellect();
                LabelMicroCMM.this.isSelected = true;
                if (LabelMicroCMM.this.connected) {
                    LabelMicroCMM.this.nodestatusPanel.flipcards("Cm");
                } else {
                    LabelMicroCMM.this.nodestatusPanel.flipcards("Cr");
                }
                LabelMicroCMM.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.setPowerStatus(0);
        this.setPowerVisible(true);
        this.powerIconX = 15;
        this.powerIconY = 4;
        this.alertIconX = 39;
        this.alertIconY = 4;
        this.uidIconX = 27;
        this.uidIconY = 4;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color backupColor;
        super.paintComponent(g);
        this.setEnabled(this.isExist);
        this.showAlertVisisble = false;
        if (!this.isExist) {
            this.numberVisible = false;
            this.connected = false;
            this.powerVisible = false;
        }
        this.setOpaque(false);
        if (this.borderVisible) {
            backupColor = g.getColor();
            g.setColor(this.borderColor);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(backupColor);
        }
        if (this.powerVisible) {
            ImageIcon icon = null;
            icon = this.isAlive ? this.powerOnIcon : this.powerOffIcon;
            g.drawImage(icon.getImage(), this.powerIconX, this.powerIconY, icon.getIconWidth(), icon.getIconHeight(), null);
        }
        if (this.isSelected) {
            backupColor = g.getColor();
            g.setColor(Color.MAGENTA);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(backupColor);
        }
        if (this.uidVisible) {
            g.drawImage(this.uidIcon.getImage(), this.uidIconX, this.uidIconY, this.uidIcon.getIconWidth(), this.uidIcon.getIconHeight(), null);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public void setUIDLED(IPMIInterfaceConfig ipmiInterfaceConfig) throws Exception {
        ISessionController sessionController = null;
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(ipmiInterfaceConfig, ipmiOEMCommand);
        if (sessionController == null) {
            return;
        }
        if (ipmiOEMCommand.isUIDLit()) {
            this.setUidVisible(true);
        } else {
            this.setUidVisible(false);
        }
        if (sessionController != null) {
            sessionController.closeSession();
        }
    }

    public void update(Observable o) {
        this.microbladeEntity = (MicroBladeEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelMicroCMM.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        try {
            this.setUIDLED(this.ipmiInterfaceConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }
}

