/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.micro.LabelMicroBladeComponent;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelMicroPowerSupply
extends LabelMicroBladeComponent {
    ImageIcon labelPowerSupplyUp = new ImageIcon(this.getClass().getResource("/images/labelMicrobladePower(up).jpg"));
    ImageIcon labelPowerSupplyDown = new ImageIcon(this.getClass().getResource("/images/labelMicrobladePower(below).jpg"));

    public LabelMicroPowerSupply() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!LabelMicroPowerSupply.this.isExist) {
                    return;
                }
                LabelMicroPowerSupply.this.setCursor(new Cursor(12));
                LabelMicroPowerSupply.this.setBorderVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabelMicroPowerSupply.this.setCursor(new Cursor(0));
                LabelMicroPowerSupply.this.setBorderVisible(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LabelMicroPowerSupply.this.isExist) {
                    return;
                }
                LabelMicroPowerSupply.this.setGroupUnSellect();
                LabelMicroPowerSupply.this.isSelected = true;
                LabelMicroPowerSupply.this.nodestatusPanel.flipcards("P" + LabelMicroPowerSupply.this.number);
                LabelMicroPowerSupply.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public void setIcon(boolean upper) {
        this.setIcon(upper ? this.labelPowerSupplyUp : this.labelPowerSupplyDown);
    }

    @Override
    public void paintComponent(Graphics g) {
        Color backupColor;
        super.paintComponent(g);
        this.setEnabled(this.isExist);
        if (!this.isExist) {
            this.isSelected = false;
            this.numberVisible = false;
            this.showAlertVisisble = false;
            this.powerVisible = false;
        }
        this.setOpaque(false);
        if (this.showAlertVisisble) {
            if (this.alertIconX == 0 && this.alertIconY == 0) {
                this.alertIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2;
                this.alertIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2;
            }
            g.drawImage(this.alertIcon.getImage(), this.alertIconX, this.alertIconY, this.alertIcon.getIconWidth(), this.alertIcon.getIconHeight(), null);
        }
        if (this.numberVisible) {
            backupColor = g.getColor();
            g.setColor(Color.black);
            g.drawString("" + (this.number + 1), this.numberX + 1, this.numberY + 1);
            g.setColor(Color.white);
            g.drawString("" + (this.number + 1), this.numberX, this.numberY);
            g.setColor(backupColor);
        }
        if (this.borderVisible) {
            backupColor = g.getColor();
            g.setColor(this.borderColor);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(backupColor);
        }
        if (this.powerVisible) {
            if (this.powerIconX == 0 && this.powerIconY == 0) {
                this.powerIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2;
                this.powerIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2 + 15;
            }
            ImageIcon icon = null;
            switch (this.powerStatus) {
                case 1: {
                    icon = this.powerOnIcon;
                    break;
                }
                case 0: {
                    icon = this.powerOffIcon;
                    break;
                }
                case 2: {
                    icon = this.powerFailureIcon;
                }
            }
            if (icon != null) {
                g.drawImage(icon.getImage(), this.powerIconX, this.powerIconY, icon.getIconWidth(), icon.getIconHeight(), null);
            }
        }
        if (this.isSelected) {
            backupColor = g.getColor();
            g.setColor(Color.MAGENTA);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(backupColor);
        }
    }

    public void update(Observable o) {
        this.microbladeEntity = (MicroBladeEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelMicroPowerSupply.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        if (!this.isExist) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        PowerSupplyInfo pws = this.microbladeEntity.getPowerSupplyInfos()[this.number];
        this.setPowerStatus(pws.powerStatus);
        if (pws.error == 0) {
            this.setAlertVisible(false);
        } else {
            this.setAlertVisible(true);
        }
        this.repaint();
    }
}

