/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.L;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class NodeConfigureListPanel
extends JPanel {
    NodeSensorInfo nodesensorInfo;
    Object[][] data = new Object[25][2];
    JTable table;
    MyTableModel tableModel = new MyTableModel();

    public NodeConfigureListPanel(NodeSensorInfo nodesensorInfo) {
        this.table = new JTable(new MyTableModel()){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                c.setForeground(Color.black);
                return c;
            }
        };
        this.refreshTableData(nodesensorInfo);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(350, 250));
        this.add(scroll);
    }

    public void update(NodeSensorInfo ns) {
        this.nodesensorInfo = ns;
        SwingUtilities.invokeLater(new Runnable(){
            private NodeSensorInfo n;
            {
                this.n = NodeConfigureListPanel.this.nodesensorInfo;
            }

            @Override
            public void run() {
                try {
                    NodeConfigureListPanel.this.refreshTableData(this.n);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public void refreshTableData(NodeSensorInfo nodesensorInfo) {
        String[] lines = nodesensorInfo.toFormatedString().split("\\r?\\n");
        int countline = 0;
        for (int i = 0; i < 25; ++i) {
            String[] word = lines[i].split("\\s+\\|\\s+");
            if (word.length == 2) {
                for (int j = 0; j < 2; ++j) {
                    this.data[countline][j] = word[j];
                }
            } else if (word.length == 1) {
                this.data[countline][0] = word[0];
            }
            ++countline;
        }
        this.tableModel.refresh(this.data);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{L.t("cmm.nodeStatus.blade.item"), L.t("cmm.nodeStatus.blade.value")};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return NodeConfigureListPanel.this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return NodeConfigureListPanel.this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + NodeConfigureListPanel.this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }

        public void refresh(Object[][] objects) {
            this.fireTableChanged(null);
        }
    }
}

