/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.CMMSessionPanel;
import IPMIView20.L;
import IPMIView20.micro.NodeStatusPanel;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStaticInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class NodeControlPanel
extends JPanel
implements ActionListener {
    public static int POWER_OFF = 0;
    public static int POWER_ON = 1;
    public static int POWER_CYCLE = 2;
    public static int POWER_RESET = 3;
    public static int POWER_ACCYCLE = 24;
    public static int POWER_GRACEFUL = 5;
    NodeSensorInfo nodesensorInfo;
    IPMIInterfaceConfig config;
    JLabel lbl_title1 = new JLabel(L.t("cmm.nodeStatus.blade.status"));
    JLabel lbl_title2 = new JLabel(L.t("cmm.nodeStatus.blade.power_control"));
    JLabel lbl_modelName = new JLabel(L.t("cmm.nodeStatus.blade.modelName"));
    JLabel lbl_boardName = new JLabel(L.t("cmm.nodeStatus.blade.boardName"));
    JLabel lbl_powerStatus = new JLabel(L.t("cmm.nodeStatus.blade.power_status"));
    JLabel lbl_kvm = new JLabel("KVM:");
    JLabel lbl_uid = new JLabel(L.t("cmm.nodeStatus.blade.blade_uid"));
    JLabel lbl_system = new JLabel(L.t("cmm.nodeStatus.blade.system_fault"));
    JLabel lbl_bmc = new JLabel("BMC:");
    JLabel lbl_watt = new JLabel(L.t("cmm.nodeStatus.blade.watt"));
    JLabel lbl_name = new JLabel(L.t("cmm.nodeStatus.blade.server_name"));
    JLabel re_modelname = new JLabel();
    JLabel re_boardname = new JLabel();
    JLabel re_powerStatus = new JLabel();
    JLabel re_kvm = new JLabel();
    JLabel re_uid = new JLabel();
    JLabel re_system = new JLabel();
    JLabel re_bmc = new JLabel();
    JLabel re_watt = new JLabel();
    JLabel re_name = new JLabel();
    JLabel ic_power = new JLabel();
    JLabel ic_kvm = new JLabel();
    JLabel ic_uid = new JLabel();
    JLabel ic_error = new JLabel();
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon okBlueIcon = new ImageIcon(this.getClass().getResource("/images/ok_blue.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon flashingIcon = new ImageIcon(this.getClass().getResource("/images/flashing_blue.gif"));
    JButton btn_kvm = new JButton("Select");
    JButton btn_uid = new JButton(L.t("cmm.nodeStatus.blade.enable"));
    JButton btn_setting = new JButton(L.t("cmm.nodeStatus.blade.settings"));
    JButton btn_name = new JButton(L.t("cmm.nodeStatus.blade.update"));
    JButton btn_powerOn = new JButton(L.t("cmm.nodeStatus.blade.power_on"));
    JButton btn_reset = new JButton(L.t("cmm.nodeStatus.blade.power_reset"));
    JButton btn_grace = new JButton(L.t("cmm.nodeStatus.blade.graceful_shutdown"));
    JButton btn_powerOff = new JButton(L.t("cmm.nodeStatus.blade.power_off"));
    JButton btn_powerCycle = new JButton("Power Cycle");
    JButton btn_acCycle = new JButton("AC Cycle");
    JSeparator js1 = new JSeparator();
    JSeparator js2 = new JSeparator();
    JPanel powerControlPanel;
    ButtonGroup bg1 = new ButtonGroup();
    JRadioButton rb_dhcp = new JRadioButton("DHCP");
    JRadioButton rb_static = new JRadioButton(L.t("cmm.nodeStatus.blade.settings.static_ip"));
    JTextField tf_ip = new JTextField();
    JTextField tf_mask = new JTextField();
    JTextField tf_gateway = new JTextField();
    JTextField tf_vlan = new JTextField();
    JCheckBox ch_vlan = new JCheckBox("Enable VLAN Tagging");
    JTextField tf_name = new JTextField();
    public static final int POWER_OFF_STATUS = 0;
    public static final int POWER_ON_STATUS = 1;
    public static final int POWER_FAILURE_STATUS = 2;

    public NodeControlPanel(NodeSensorInfo nodesensorInfo, CMMSessionPanel cmmSessionPanel, int bladeIdx, int nodeIdx, boolean asyncUpdate) {
        this.setLayout((LayoutManager)new MigLayout("", "20[]20[]20[]", "5[]5[]6[]6[]7[]2[]2[]2[]2[]0"));
        this.config = cmmSessionPanel.ipmiInterfaceConfig;
        this.refreshStatus(nodesensorInfo);
        this.nodesensorInfo = nodesensorInfo;
        if (asyncUpdate) {
            this.asyncUpdateModelName(this.config, bladeIdx, nodeIdx);
        }
        this.lbl_title1.setForeground(Color.BLUE);
        this.add((Component)this.lbl_title1, "cell 0 0");
        this.add((Component)this.re_boardname, "cell 1 0");
        this.add((Component)this.js1, "cell 0 1, span 4 , growx");
        this.add((Component)this.lbl_modelName, "cell 0 2");
        this.add((Component)this.re_modelname, "cell 1 2");
        this.add((Component)this.lbl_boardName, "cell 0 3");
        this.add((Component)this.re_boardname, "cell 1 3");
        this.add((Component)this.lbl_powerStatus, "cell 0 4");
        this.add((Component)this.ic_power, "cell 1 4");
        this.add((Component)this.re_powerStatus, "cell 1 4");
        this.add((Component)this.lbl_uid, "cell 0 5");
        this.add((Component)this.ic_uid, "cell 1 5");
        this.add((Component)this.re_uid, "cell 1 5");
        this.add((Component)this.btn_uid, "cell 2 5, growx");
        this.add((Component)this.lbl_system, "cell 0 6");
        this.add((Component)this.ic_error, "cell 1 6");
        this.add((Component)this.re_system, "cell 1 6");
        this.add((Component)this.lbl_bmc, "cell 0 7");
        this.add((Component)this.re_bmc, "cell 1 7");
        this.add((Component)this.btn_setting, "cell 2 7, growx");
        this.add((Component)this.lbl_watt, "cell 0 8");
        this.add((Component)this.re_watt, "cell 1 8");
        this.add((Component)this.lbl_name, "cell 0 9");
        this.add((Component)this.re_name, "cell 1 9");
        this.add((Component)this.btn_name, "cell 2 9, growx");
        this.add((Component)this.getpowerControllPanel(), "cell 0 10, span 4");
        this.rb_dhcp.addActionListener(this);
        this.rb_static.addActionListener(this);
        this.btn_uid.addActionListener(this);
        this.btn_setting.addActionListener(this);
        this.btn_name.addActionListener(this);
        this.re_boardname.setText(this.getBoardName(ByteUtility.twoBytesToInt(nodesensorInfo.boardId)));
    }

    private JPanel getpowerControllPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout((LayoutManager)new MigLayout("", "", "2[]2[]2[]1[]1[]0"));
        this.btn_reset.setForeground(Color.red);
        this.btn_grace.setForeground(Color.red);
        this.btn_powerOff.setForeground(Color.red);
        this.btn_powerCycle.setForeground(Color.red);
        this.btn_acCycle.setForeground(Color.red);
        this.btn_powerOn.addActionListener(this);
        this.btn_reset.addActionListener(this);
        this.btn_grace.addActionListener(this);
        this.btn_powerOff.addActionListener(this);
        this.btn_powerCycle.addActionListener(this);
        this.btn_acCycle.addActionListener(this);
        this.lbl_title2.setForeground(Color.BLUE);
        p1.add((Component)this.lbl_title2, "cell 0 0");
        p1.add((Component)this.js2, "cell 0 1, span 4 , growx");
        p1.add((Component)this.btn_powerOn, "cell 0 2, growx");
        p1.add((Component)this.btn_reset, "cell 1 2, growx");
        p1.add((Component)this.btn_grace, "cell 0 3, growx");
        p1.add((Component)this.btn_powerOff, "cell 1 3, growx");
        p1.add((Component)this.btn_powerCycle, "cell 0 4, growx");
        p1.add((Component)this.btn_acCycle, "cell 1 4, growx");
        return p1;
    }

    private JPanel getLanPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JLabel lbl_ip = new JLabel("IP:");
        JLabel lbl_mask = new JLabel(L.t("cmm.nodeStatus.blade.settings.subnet_mask"));
        JLabel lbl_gateway = new JLabel(L.t("cmm.nodeStatus.blade.settings.gateway"));
        TitledBorder titledBorder1 = new TitledBorder(L.t("cmm.nodeStatus.blade.settings.ip_setting"));
        JPanel ipPanel = new JPanel((LayoutManager)new MigLayout("", "", ""));
        this.bg1.add(this.rb_dhcp);
        this.bg1.add(this.rb_static);
        ipPanel.setBorder(titledBorder1);
        ipPanel.add((Component)this.rb_dhcp, "cell 1 0");
        ipPanel.add((Component)this.rb_static, "cell 1 0");
        ipPanel.add((Component)lbl_ip, "cell 0 1");
        ipPanel.add((Component)this.tf_ip, "cell 1 1, growx");
        ipPanel.add((Component)lbl_mask, "cell 0 2");
        ipPanel.add((Component)this.tf_mask, "cell 1 2, growx");
        ipPanel.add((Component)lbl_gateway, "cell 0 3");
        ipPanel.add((Component)this.tf_gateway, "cell 1 3, growx");
        p.add((Component)ipPanel, "Center");
        this.tf_ip.setText(this.nodesensorInfo.getBMCIP());
        this.tf_mask.setText(this.nodesensorInfo.getBMCMask());
        this.tf_gateway.setText(this.nodesensorInfo.getBMCGateway());
        return p;
    }

    private void refreshStatus(NodeSensorInfo nodesensorInfo) {
        byte powerStatus = nodesensorInfo.getPowerStatus();
        boolean kvmSelect = false;
        if (powerStatus == 0) {
            this.ic_power.setIcon(this.powerOffIcon);
            this.re_powerStatus.setText(L.t("cmm.nodeStatus.blade.off"));
        } else if (powerStatus == 1) {
            this.ic_power.setIcon(this.powerOnIcon);
            this.re_powerStatus.setText(L.t("cmm.nodeStatus.blade.on"));
        } else if (powerStatus == 2) {
            this.ic_power.setIcon(this.powerOffIcon);
            this.re_powerStatus.setText(L.t("cmm.nodeStatus.blade.error"));
        }
        if (kvmSelect) {
            this.ic_kvm.setIcon(this.okBlueIcon);
            this.re_kvm.setText("Selected");
        } else {
            this.ic_kvm.setIcon(null);
            this.re_kvm.setText("Non-Selected");
        }
        if (nodesensorInfo.getUid() == 2) {
            this.ic_uid.setIcon(this.uidLEDOnIcon);
            this.re_uid.setText(L.t("cmm.nodeStatus.blade.on"));
            this.btn_uid.setText(L.t("cmm.nodeStatus.blade.disable"));
        } else {
            this.ic_uid.setIcon(this.uidLEDOffIcon);
            this.re_uid.setText(L.t("cmm.nodeStatus.blade.off"));
            this.btn_uid.setText(L.t("cmm.nodeStatus.blade.enable"));
        }
        if (nodesensorInfo.error() >> 1 == NodeStatusPanel.NODE_STATE_NORMAL) {
            this.ic_error.setIcon(this.okGreenIcon);
            this.re_system.setText(L.t("cmm.nodeStatus.blade.normal"));
        } else if (nodesensorInfo.error() >> 1 == NodeStatusPanel.NODE_STATE_ERROR) {
            this.ic_error.setIcon(this.xRedIcon);
            this.re_system.setText(L.t("cmm.nodeStatus.blade.error"));
        } else if (nodesensorInfo.error() >> 1 == NodeStatusPanel.NODE_STATE_FLASHING) {
            this.ic_error.setIcon(this.flashingIcon);
            this.re_system.setText(L.t("cmm.nodeStatus.blade.flashing"));
        }
        this.re_bmc.setText(nodesensorInfo.getBMCIP() == "" ? "Installed" : nodesensorInfo.getBMCIP());
        this.re_watt.setText(String.valueOf(nodesensorInfo.getCurPower()));
        this.re_name.setText(nodesensorInfo.getServerName().trim());
    }

    public void update(NodeSensorInfo ns) {
        this.nodesensorInfo = ns;
        SwingUtilities.invokeLater(new Runnable(){
            private NodeSensorInfo n;
            {
                this.n = NodeControlPanel.this.nodesensorInfo;
            }

            @Override
            public void run() {
                try {
                    NodeControlPanel.this.refreshStatus(this.n);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn_powerOn) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.nodeStatus.confirm_content") + " " + L.t("cmm.nodeStatus.blade.power_on") + "?", L.t("cmm.nodeStatus.confirm"), 0);
                    if (result == 0) {
                        NodeControlPanel.this.setPowerStatus(POWER_ON);
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_reset) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.nodeStatus.confirm_content") + " " + L.t("cmm.nodeStatus.blade.power_reset") + "?", L.t("cmm.nodeStatus.confirm"), 0);
                    if (result == 0) {
                        NodeControlPanel.this.setPowerStatus(POWER_RESET);
                    }
                    NodeControlPanel.this.setPowerStatus(POWER_RESET);
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_grace) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.nodeStatus.confirm_content") + " " + L.t("cmm.nodeStatus.blade.graceful_shutdown") + "?", L.t("cmm.nodeStatus.confirm"), 0);
                    if (result == 0) {
                        NodeControlPanel.this.setPowerStatus(POWER_GRACEFUL);
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_powerCycle) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.nodeStatus.confirm_content") + " Power Cycle?", L.t("cmm.nodeStatus.confirm"), 0);
                    if (result == 0) {
                        NodeControlPanel.this.setPowerStatus(POWER_CYCLE);
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_powerOff) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.nodeStatus.confirm_content") + " " + L.t("cmm.nodeStatus.blade.power_off") + "?", L.t("cmm.nodeStatus.confirm"), 0);
                    if (result == 0) {
                        NodeControlPanel.this.setPowerStatus(POWER_OFF);
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_acCycle) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.nodeStatus.confirm_content") + " AC Cycle?", L.t("cmm.nodeStatus.confirm"), 0);
                    if (result == 0) {
                        NodeControlPanel.this.setPowerStatus(POWER_ACCYCLE);
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.rb_dhcp) {
            this.tf_ip.setEnabled(false);
            this.tf_mask.setEnabled(false);
            this.tf_gateway.setEnabled(false);
        } else if (e.getSource() == this.rb_static) {
            this.tf_ip.setEnabled(true);
            this.tf_mask.setEnabled(true);
            this.tf_gateway.setEnabled(true);
        } else if (e.getSource() == this.btn_setting) {
            if (this.isDHCP()) {
                this.rb_dhcp.setSelected(true);
                this.tf_ip.setEnabled(false);
                this.tf_mask.setEnabled(false);
                this.tf_gateway.setEnabled(false);
            } else {
                this.rb_static.setSelected(true);
                this.tf_ip.setEnabled(true);
                this.tf_mask.setEnabled(true);
                this.tf_gateway.setEnabled(true);
            }
            this.tf_ip.setText(this.nodesensorInfo.getBMCIP());
            this.tf_mask.setText(this.nodesensorInfo.getBMCMask());
            this.tf_gateway.setText(this.nodesensorInfo.getBMCGateway());
            Object[] options = new Object[]{L.t("cmm.nodeStatus.blade.settings.update"), L.t("cmm.nodeStatus.blade.settings.cancel")};
            int n = JOptionPane.showOptionDialog(null, this.getLanPanel(), L.t("cmm.nodeStatus.blade.settings.title"), 1, -1, null, options, options[1]);
            if (n == 0) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        NodeControlPanel.this.setLanConfiguration();
                    }
                };
                thread.start();
            }
        } else if (e.getSource() == this.btn_name) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    NodeControlPanel.this.tf_name.setText(NodeControlPanel.this.nodesensorInfo.getServerName().trim());
                    Object[] options = new Object[]{L.t("cmm.nodeStatus.blade.settings.update"), L.t("cmm.nodeStatus.blade.settings.cancel")};
                    int n = JOptionPane.showOptionDialog(null, NodeControlPanel.this.tf_name, L.t("cmm.nodeStatus.blade.server_name"), 1, -1, null, options, options[1]);
                    if (n == 0) {
                        NodeControlPanel.this.setServerName(NodeControlPanel.this.tf_name.getText());
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_uid) {
            if (this.nodesensorInfo.getUid() == 2) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        NodeControlPanel.this.setUID(false);
                        NodeControlPanel.this.btn_uid.setText(L.t("cmm.nodeStatus.blade.enable"));
                    }
                };
                thread.start();
            } else {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        NodeControlPanel.this.setUID(true);
                        NodeControlPanel.this.btn_uid.setText(L.t("cmm.nodeStatus.blade.disable"));
                    }
                };
                thread.start();
            }
        }
    }

    private void powerOn() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        sessionController.closeSession();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.nodesensorInfo.getBMCIP());
        config.setUserName(this.nodesensorInfo.getDecryptedUsername());
        config.setPassword(this.nodesensorInfo.getDecryptedPassword());
        config.setPrivilege((byte)4);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
        if (sessionController == null) {
            return;
        }
        if (ipmiChassisCommand.powerUp()) {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.power_on") + " " + L.t("cmm.nodeStatus.successful"));
        } else {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.power_on") + " " + L.t("cmm.nodeStatus.failure"), L.t("cmm.nodeStatus.message"), 0);
        }
        sessionController.closeSession();
    }

    private void powerReset() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        sessionController.closeSession();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.nodesensorInfo.getBMCIP());
        config.setUserName(this.nodesensorInfo.getDecryptedUsername());
        config.setPassword(this.nodesensorInfo.getDecryptedPassword());
        config.setPrivilege((byte)4);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
        if (sessionController == null) {
            return;
        }
        if (ipmiChassisCommand.reset()) {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.power_reset") + " " + L.t("cmm.nodeStatus.successful"));
        } else {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.power_reset") + " " + L.t("cmm.nodeStatus.failure"), L.t("cmm.nodeStatus.message"), 0);
        }
        sessionController.closeSession();
    }

    private void graceShutDown() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        sessionController.closeSession();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.nodesensorInfo.getBMCIP());
        config.setUserName(this.nodesensorInfo.getDecryptedUsername());
        config.setPassword(this.nodesensorInfo.getDecryptedPassword());
        config.setPrivilege((byte)4);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
        if (sessionController == null) {
            return;
        }
        if (ipmiChassisCommand.softShutdown()) {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.graceful_shutdown") + " " + L.t("cmm.nodeStatus.successful"));
        } else {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.graceful_shutdown") + " " + L.t("cmm.nodeStatus.failure"), L.t("cmm.nodeStatus.message"), 0);
        }
        sessionController.closeSession();
    }

    private void powerDown() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        sessionController.closeSession();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.nodesensorInfo.getBMCIP());
        config.setUserName(this.nodesensorInfo.getDecryptedUsername());
        config.setPassword(this.nodesensorInfo.getDecryptedPassword());
        config.setPrivilege((byte)4);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
        if (sessionController == null) {
            return;
        }
        if (ipmiChassisCommand.powerDown()) {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.power_off") + " " + L.t("cmm.nodeStatus.successful"));
        } else {
            JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.power_off") + " " + L.t("cmm.nodeStatus.failure"), L.t("cmm.nodeStatus.message"), 0);
        }
        sessionController.closeSession();
    }

    private void powerCycle() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        sessionController.closeSession();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.nodesensorInfo.getBMCIP());
        config.setUserName(this.nodesensorInfo.getDecryptedUsername());
        config.setPassword(this.nodesensorInfo.getDecryptedPassword());
        config.setPrivilege((byte)4);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
        if (sessionController == null) {
            return;
        }
        if (ipmiChassisCommand.powerCycle()) {
            JOptionPane.showMessageDialog(null, "Power Cycle " + L.t("cmm.nodeStatus.successful"));
        } else {
            JOptionPane.showMessageDialog(null, "Power Cycle " + L.t("cmm.nodeStatus.failure"), L.t("cmm.nodeStatus.message"), 0);
        }
        sessionController.closeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPowerStatus(int option) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setNodeStatus(this.nodesensorInfo.getBladeIndex(), this.nodesensorInfo.getIndex(), option);
                JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.set_power_status_ok"));
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
            finally {
                sessionController.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUID(boolean setOn) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                boolean b = false;
                b = setOn ? ipmiMicroBladeOEMCommand.setNodeUIDLED(this.nodesensorInfo.getBladeIndex(), this.nodesensorInfo.getIndex(), (byte)1) : ipmiMicroBladeOEMCommand.setNodeUIDLED(this.nodesensorInfo.getBladeIndex(), this.nodesensorInfo.getIndex(), (byte)0);
                if (b) {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.set_uid_led_successfully"));
                } else {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.set_uid_led_fail"), L.t("cmm.nodeStatus.error"), 0);
                }
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
            finally {
                sessionController.closeSession();
            }
        }
    }

    private void setServerName(String name) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            boolean b = ipmiMicroBladeOEMCommand.setNodeName(this.nodesensorInfo.getBladeIndex(), this.nodesensorInfo.getIndex(), name);
            if (b) {
                JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.update_server_name_ok"));
            } else {
                JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.update_server_name_fail"), L.t("cmm.nodeStatus.error"), 0);
            }
            sessionController.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDHCP() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                String s = ipmiMicroBladeOEMCommand.getNodeLanDHCP(this.nodesensorInfo.getBladeIndex(), this.nodesensorInfo.getIndex());
                if (s.contains("DHCP")) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
            finally {
                sessionController.closeSession();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLanConfiguration() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                int bladeIndex = this.nodesensorInfo.getBladeIndex();
                int nodeIndex = this.nodesensorInfo.getIndex();
                boolean b1 = false;
                boolean b2 = false;
                boolean b3 = false;
                boolean b4 = false;
                if (this.rb_static.isSelected()) {
                    b1 = ipmiMicroBladeOEMCommand.setNodeLanDHCP(bladeIndex, nodeIndex, 1);
                } else if (this.rb_dhcp.isSelected()) {
                    b1 = ipmiMicroBladeOEMCommand.setNodeLanDHCP(bladeIndex, nodeIndex, 2);
                }
                b2 = ipmiMicroBladeOEMCommand.setNodeLanIP(bladeIndex, nodeIndex, this.tf_ip.getText());
                b3 = ipmiMicroBladeOEMCommand.setNodeLanSubnetMask(bladeIndex, nodeIndex, this.tf_mask.getText());
                b4 = ipmiMicroBladeOEMCommand.setNodeLanSubnetMask(bladeIndex, nodeIndex, this.tf_gateway.getText());
                if (b1 && b2 && b3 && b4) {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.update_lan_config_ok"));
                } else {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.blade.update_lan_config_fail"), L.t("cmm.nodeStatus.error"), 0);
                }
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
            finally {
                sessionController.closeSession();
            }
        }
    }

    private void asyncUpdateModelName(IPMIInterfaceConfig config, int bladeIdx, int nodeIdx) {
        Runnable runnable = () -> {
            final String modelName = this.getModelName(config, bladeIdx, nodeIdx);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NodeControlPanel.this.re_modelname.setText(modelName);
                }
            });
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getModelName(IPMIInterfaceConfig config, int bladeIdx, int nodeIdx) {
        String modelName = null;
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                NodeStaticInfo info = ipmiMicroBladeOEMCommand.getNodeStaticInfo((byte)bladeIdx, (byte)nodeIdx);
                modelName = info.getProductName();
            }
            catch (IPMIException iPMIException) {
            }
            finally {
                sessionController.closeSession();
            }
        }
        return modelName;
    }

    public String getBoardName(int boardID) {
        String name = "";
        switch (boardID) {
            case 2118: {
                name = "B1DRi";
                break;
            }
            case 1633: {
                name = "B1SA4-F";
                break;
            }
            case 2170: {
                name = "B1SD2";
                break;
            }
            case 2146: {
                name = "B1SL1-F";
                break;
            }
            case 2312: {
                name = "B2SS2";
                break;
            }
            case 2353: {
                name = "B2SS1";
                break;
            }
            case 2385: {
                name = "B2SS2-MTF";
                break;
            }
            case 2406: {
                name = "B11DPT";
                break;
            }
            case 2441: {
                name = "B10DRE";
                break;
            }
            case 2455: {
                name = "B11DPE";
                break;
            }
            case 2447: {
                name = "B11QPi";
                break;
            }
            case 6660: {
                name = "B10KNM";
                break;
            }
            case 6663: {
                name = "B11SPE";
                break;
            }
            case 6953: {
                name = "B2SC1";
                break;
            }
            case 6963: {
                name = "B11SRE";
                break;
            }
            case 6969: {
                name = "B11SCG-ZTF";
                break;
            }
            case 6973: {
                name = "B11SCG-CTF";
                break;
            }
            case 6984: {
                name = "B2SD2";
                break;
            }
            case 7025: {
                name = "B12DPT";
                break;
            }
            case 7042: 
            case 7213: {
                name = "B12SPE";
                break;
            }
            case 7055: {
                name = "BH12SSi";
                break;
            }
            case 7228: {
                name = "B12DPE";
                break;
            }
            case 7238: {
                name = "B3ST1";
                break;
            }
            case 7285: {
                name = "B13DET";
                break;
            }
            case 7312: {
                name = "B13DEE";
                break;
            }
            case 7297: {
                name = "B13SEE";
                break;
            }
            case 7456: {
                name = "B13SEG";
                break;
            }
            case 7318: {
                name = "B4SA1";
                break;
            }
            case 7459: {
                name = "B4SC1";
                break;
            }
            case 7528: {
                name = "B14SBE";
                break;
            }
            case 7536: {
                name = "B14DBT";
            }
        }
        return name;
    }

    public void setUserPrivilege() {
        this.btn_uid.setEnabled(false);
        this.btn_setting.setEnabled(false);
        this.btn_setting.setEnabled(false);
        this.btn_powerOn.setEnabled(false);
        this.btn_reset.setEnabled(false);
        this.btn_grace.setEnabled(false);
        this.btn_powerOff.setEnabled(false);
        this.btn_powerCycle.setEnabled(false);
    }

    public void setOperatorPrivilege() {
        this.btn_uid.setEnabled(true);
        this.btn_setting.setEnabled(true);
        this.btn_setting.setEnabled(true);
        this.btn_powerOn.setEnabled(true);
        this.btn_reset.setEnabled(true);
        this.btn_grace.setEnabled(true);
        this.btn_powerOff.setEnabled(true);
        this.btn_powerCycle.setEnabled(true);
    }

    public void setAdministratorPrivilege() {
        this.btn_uid.setEnabled(true);
        this.btn_setting.setEnabled(true);
        this.btn_setting.setEnabled(true);
        this.btn_powerOn.setEnabled(true);
        this.btn_reset.setEnabled(true);
        this.btn_grace.setEnabled(true);
        this.btn_powerOff.setEnabled(true);
        this.btn_powerCycle.setEnabled(true);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel p = new JPanel();
        frame.setContentPane(p);
        frame.setSize(800, 550);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

