/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.L;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class NodeSensorListPanel
extends JPanel {
    NodeSensorInfo nodesensorInfo;
    Object[][] data;
    int sensorSize = 12;
    JTable table;
    MyTableModel tableModel = new MyTableModel();
    ImageIcon alertIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    ImageIcon okIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));

    public NodeSensorListPanel(NodeSensorInfo nodesensorInfo) {
        this.sensorSize = nodesensorInfo.sBEntity.getSensorDisplayNumber();
        this.data = new Object[this.sensorSize][5];
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                c.setForeground(Color.black);
                if (column == 2) {
                    if (NodeSensorListPanel.this.data[row][0] == NodeSensorListPanel.this.okIcon) {
                        c.setForeground(Color.blue);
                    } else if (NodeSensorListPanel.this.data[row][0] == NodeSensorListPanel.this.alertIcon) {
                        c.setForeground(Color.red);
                    }
                }
                return c;
            }
        };
        this.refreshTableData(nodesensorInfo);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(350, 250));
        this.add(scroll);
    }

    public void update(NodeSensorInfo ns) {
        this.nodesensorInfo = ns;
        SwingUtilities.invokeLater(new Runnable(){
            private NodeSensorInfo n;
            {
                this.n = NodeSensorListPanel.this.nodesensorInfo;
            }

            @Override
            public void run() {
                try {
                    NodeSensorListPanel.this.refreshTableData(this.n);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public void refreshTableData(NodeSensorInfo nodesensorInfo) {
        String[] word;
        String[] lines = nodesensorInfo.sBEntity.toFormatedString().split("\\r?\\n");
        for (int i = 0; i < lines.length && (word = lines[i].split("\\s+\\|\\s+"))[0] != ""; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!word[1].contains("Watchdog")) {
                    word[j] = word[j].replace(" ", "");
                }
                this.data[i][j] = word[j];
            }
            this.data[i][0] = word[0].contains("Normal") || word[1].contains("Watchdog") && !word[2].contains("N/A") ? this.okIcon : (word[0].contains("Higher") || word[0].contains("Lower") ? this.alertIcon : "");
        }
        this.tableModel.refresh(this.data);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(70);
    }

    public static void main(String[] args) {
        String s = "12,3|34,5|3,3,3 ,uu";
        String[] line = s.split("\\|");
        System.out.println(s.length());
        for (int i = 0; i < s.length(); ++i) {
            System.out.println(i + " " + line[i]);
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"", L.t("cmm.nodeStatus.blade.sensor"), L.t("cmm.nodeStatus.blade.reading"), L.t("cmm.nodeStatus.blade.low_limit"), L.t("cmm.nodeStatus.blade.high_limit")};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return NodeSensorListPanel.this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return NodeSensorListPanel.this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + NodeSensorListPanel.this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }

        public void refresh(Object[][] objects) {
            this.fireTableChanged(null);
        }
    }
}

