/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.CMMSessionPanel;
import IPMIView20.CMMUIPanel;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.micro.CMMMasterPanel;
import IPMIView20.micro.CMMRedundantPanel;
import IPMIView20.micro.FanStatusPanel;
import IPMIView20.micro.GlobalSummaryPanel;
import IPMIView20.micro.LabelMicroBladeComponent;
import IPMIView20.micro.NodeConfigureListPanel;
import IPMIView20.micro.NodeControlPanel;
import IPMIView20.micro.NodeSelectPanel;
import IPMIView20.micro.NodeSensorListPanel;
import IPMIView20.micro.PowerSupplySelectPanel;
import IPMIView20.micro.PowerSupplyStatusPanel;
import IPMIView20.micro.SwitchConfigureListPanel;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.microblade.RedundantCMMInfo;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.microblade.SystemMiscInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class NodeStatusPanel
extends CMMUIPanel
implements ActionListener,
Observer {
    JPanel summaryPanel = new JPanel();
    JPanel individualPanel = new JPanel();
    NodeSelectPanel nodeselectPanel = null;
    PowerSupplySelectPanel powersupplyselectPanel = null;
    CardLayout cardlayout = new CardLayout();
    JPanel cards = null;
    public static int numberOfNodes = 112;
    public static int numberOfPS = 8;
    public static int numberOfSwitch = 4;
    public static int numberOfCmm = 2;
    public static int numberOfFan = 3;
    public static int BLADE_A_COUNT = 14;
    public static int BLADE_B_COUNT = 14;
    public static int NODE_COUNT = 4;
    public static int NODE_STATE_NORMAL = 0;
    public static int NODE_STATE_WARNING = 1;
    public static int NODE_STATE_ERROR = 2;
    public static int NODE_STATE_FLASHING = 3;
    JPanel[] nodeTitle = new JPanel[numberOfNodes];
    JPanel[] psTitle = new JPanel[numberOfPS];
    JPanel[] switchTitle = new JPanel[numberOfSwitch];
    JPanel[] cmmTitle = new JPanel[numberOfCmm];
    JPanel[] fanTitle = new JPanel[numberOfFan];
    JTabbedPane[] tabbedPane = new JTabbedPane[numberOfNodes];
    NodeSensorListPanel[] nodesensorlistPanel = new NodeSensorListPanel[numberOfNodes];
    NodeConfigureListPanel[] nodeconfigurelistPanel = new NodeConfigureListPanel[numberOfNodes];
    NodeControlPanel[] nodecontrolPanel = new NodeControlPanel[numberOfNodes];
    PowerSupplyStatusPanel[] powersupplystatusPanel = new PowerSupplyStatusPanel[numberOfPS];
    SwitchConfigureListPanel[] switchconfigurelistPanel = new SwitchConfigureListPanel[numberOfSwitch];
    FanStatusPanel[] fanStatusPanel = new FanStatusPanel[numberOfFan];
    CMMMasterPanel masterCmmPanel;
    CMMRedundantPanel slaveCmmPanel;
    JPanel[] cardPanel_node = new JPanel[numberOfNodes];
    JPanel[] cardPanel_PS = new JPanel[numberOfPS];
    JPanel[] cardPanel_Switch = new JPanel[numberOfSwitch];
    JPanel[] cardPanel_cmm = new JPanel[numberOfCmm];
    JPanel[] cardPanel_fan = new JPanel[numberOfFan];
    JLabel[] powerSupplyTitleLabel = new JLabel[numberOfPS];
    JLabel[] switchTitleLabel = new JLabel[numberOfSwitch];
    JLabel[] fanTitleLabel = new JLabel[numberOfFan];
    GlobalSummaryPanel cardPanel_first = null;
    JToolBar jTopToolBar = new JToolBar();
    JScrollPane scrollPane_first = new JScrollPane();
    JScrollPane[] scrollPane_node = new JScrollPane[numberOfNodes];
    JScrollPane[] scrollPane_PS = new JScrollPane[numberOfPS];
    JScrollPane[] scrollPane_Switch = new JScrollPane[numberOfSwitch];
    JScrollPane[] scrollPane_cmm = new JScrollPane[numberOfCmm];
    JScrollPane[] scrollPane_fan = new JScrollPane[numberOfFan];
    LinkedList<LabelMicroBladeComponent> componentGroup = new LinkedList();
    JScrollPane scroll_nodeSelect = new JScrollPane();
    JScrollPane scroll_powerSelect = new JScrollPane();
    CMMSessionPanel cmm;
    JButton btn_summary = new JButton();
    JButton btn_front = new JButton();
    ImageIcon serverSummaryIcon = new ImageIcon(this.getClass().getResource("/images/server2.png"));
    ImageIcon popoutIcon = new ImageIcon(this.getClass().getResource("/images/popout_btn.png"));
    private Font titleFont = null;
    int curNodes = 0;
    int curPower = 0;
    int curSwitch = 0;
    int curCMM = 0;
    int curFan = 0;

    public NodeStatusPanel() {
        this.setLayout(new BorderLayout());
        this.titleFont = new Font(IPMIView20.IPMI_DEFAULT_FONT, 1, 13);
    }

    public void preset(CMMSessionPanel cmmSessionPanel) {
        int i;
        this.cmm = cmmSessionPanel;
        this.nodeselectPanel = new NodeSelectPanel(cmmSessionPanel.microbladeEntity, this);
        this.powersupplyselectPanel = new PowerSupplySelectPanel(cmmSessionPanel.microbladeEntity, this, this.cmm.ipmiInterfaceConfig);
        this.cardPanel_first = new GlobalSummaryPanel(cmmSessionPanel.microbladeEntity, this.cmm.ipmiInterfaceConfig);
        this.btn_summary.setIcon(this.serverSummaryIcon);
        this.btn_summary.setToolTipText(L.t("cmm.nodeStatus.summary.show"));
        this.btn_summary.setText(L.t("cmm.nodeStatus.summary"));
        this.btn_summary.setMargin(new Insets(0, 0, 0, 10));
        this.btn_summary.addActionListener(this);
        this.btn_front.setMargin(new Insets(0, 0, 0, 0));
        this.btn_front.addActionListener(this);
        this.scrollPane_first.setViewportView(this.cardPanel_first);
        this.cards = new JPanel(this.cardlayout);
        this.cards.add((Component)this.scrollPane_first, "first");
        int sumIdx = 0;
        for (int bladeIdx = 0; bladeIdx < BLADE_A_COUNT + BLADE_B_COUNT; ++bladeIdx) {
            for (int nodeIdx = 0; nodeIdx < NODE_COUNT; ++nodeIdx) {
                sumIdx = bladeIdx * NODE_COUNT + nodeIdx;
                this.nodeTitle[sumIdx] = new JPanel();
                JLabel titleText = new JLabel(L.t("cmm.nodeStatus.blade") + (bladeIdx < BLADE_A_COUNT ? " A" : " B") + (bladeIdx < BLADE_A_COUNT ? bladeIdx + 1 : bladeIdx - BLADE_A_COUNT + 1) + " " + L.t("cmm.nodeStatus.node") + " " + (nodeIdx + 1));
                titleText.setForeground(Color.WHITE);
                titleText.setFont(this.titleFont);
                this.nodeTitle[sumIdx].setBackground(new Color(65, 105, 225));
                this.nodeTitle[sumIdx].add(titleText);
                NodeSensorInfo nodesensorInfo = cmmSessionPanel.microbladeEntity.getNodeSensorInfos()[sumIdx];
                NodeStatusInfo nodestatusInfo = cmmSessionPanel.microbladeEntity.getNodeStatusInfos()[sumIdx];
                BladeRemoteInfo bladeRemoteInfo = cmmSessionPanel.microbladeEntity.getBladeRemoteInfos()[sumIdx / 4];
                this.nodesensorlistPanel[sumIdx] = new NodeSensorListPanel(nodesensorInfo);
                this.nodeconfigurelistPanel[sumIdx] = new NodeConfigureListPanel(nodesensorInfo);
                if (bladeRemoteInfo.isPresent() && nodestatusInfo.initialized()) {
                    ++this.curNodes;
                }
                this.nodecontrolPanel[sumIdx] = new NodeControlPanel(nodesensorInfo, this.cmm, bladeIdx, nodeIdx, bladeRemoteInfo.isPresent() && nodestatusInfo.initialized());
                this.tabbedPane[sumIdx] = new JTabbedPane();
                this.tabbedPane[sumIdx].addTab(L.t("cmm.nodeStatus.blade.sensors"), this.nodesensorlistPanel[sumIdx]);
                this.tabbedPane[sumIdx].addTab(L.t("cmm.nodeStatus.blade.config"), this.nodeconfigurelistPanel[sumIdx]);
                this.cardPanel_node[sumIdx] = new JPanel(new BorderLayout());
                this.cardPanel_node[sumIdx].add((Component)this.nodeTitle[sumIdx], "North");
                this.cardPanel_node[sumIdx].add((Component)this.tabbedPane[sumIdx], "East");
                this.cardPanel_node[sumIdx].add((Component)this.nodecontrolPanel[sumIdx], "Center");
                this.scrollPane_node[sumIdx] = new JScrollPane();
                this.scrollPane_node[sumIdx].setViewportView(this.cardPanel_node[sumIdx]);
                this.cards.add((Component)this.scrollPane_node[sumIdx], "N" + sumIdx);
            }
        }
        for (i = 0; i < numberOfPS; ++i) {
            this.psTitle[i] = new JPanel();
            this.powerSupplyTitleLabel[i] = new JLabel(L.t("cmm.nodeStatus.power_supply"));
            this.psTitle[i].setBackground(new Color(65, 105, 225));
            this.powerSupplyTitleLabel[i].setForeground(Color.WHITE);
            this.psTitle[i].add(this.powerSupplyTitleLabel[i]);
            this.powerSupplyTitleLabel[i].setFont(this.titleFont);
            PowerSupplyInfo powersupplyInfo = cmmSessionPanel.microbladeEntity.getPowerSupplyInfos()[i];
            this.powersupplystatusPanel[i] = new PowerSupplyStatusPanel(cmmSessionPanel, i);
            if (powersupplyInfo.isPresent()) {
                ++this.curPower;
            }
            this.cardPanel_PS[i] = new JPanel(new BorderLayout());
            this.cardPanel_PS[i].add((Component)this.psTitle[i], "North");
            this.cardPanel_PS[i].add((Component)this.powersupplystatusPanel[i], "Center");
            this.scrollPane_PS[i] = new JScrollPane();
            this.scrollPane_PS[i].setViewportView(this.cardPanel_PS[i]);
            this.cards.add((Component)this.scrollPane_PS[i], "P" + i);
        }
        for (i = 0; i < numberOfFan; ++i) {
            this.fanTitle[i] = new JPanel();
            this.fanTitleLabel[i] = new JLabel(L.t("cmm.nodeStatus.fan") + " " + (i + 1));
            this.fanTitle[i].setBackground(new Color(65, 105, 225));
            this.fanTitleLabel[i].setForeground(Color.WHITE);
            this.fanTitle[i].add(this.fanTitleLabel[i]);
            this.fanTitleLabel[i].setFont(this.titleFont);
            PowerSupplyInfo fanInfo = cmmSessionPanel.microbladeEntity.getFanInfos()[i];
            this.fanStatusPanel[i] = new FanStatusPanel(fanInfo);
            this.cardPanel_fan[i] = new JPanel(new BorderLayout());
            this.cardPanel_fan[i].add((Component)this.fanTitle[i], "North");
            this.cardPanel_fan[i].add((Component)this.fanStatusPanel[i], "Center");
            this.scrollPane_fan[i] = new JScrollPane();
            this.scrollPane_fan[i].setViewportView(this.cardPanel_fan[i]);
            this.cards.add((Component)this.scrollPane_fan[i], "F" + i);
        }
        for (i = 0; i < numberOfSwitch; ++i) {
            this.switchTitle[i] = new JPanel();
            this.switchTitleLabel[i] = new JLabel(L.t("cmm.nodeStatus.switch") + " " + (i + 1));
            this.switchTitle[i].setBackground(new Color(65, 105, 225));
            this.switchTitleLabel[i].setForeground(Color.WHITE);
            this.switchTitle[i].add(this.switchTitleLabel[i]);
            this.switchTitleLabel[i].setFont(this.titleFont);
            SwitchInfo switchinfo = cmmSessionPanel.microbladeEntity.getSwitchInfos()[i];
            if (!switchinfo.isPresent()) continue;
            ++this.curSwitch;
            this.switchconfigurelistPanel[i] = new SwitchConfigureListPanel(switchinfo, cmmSessionPanel);
            this.cardPanel_Switch[i] = new JPanel(new BorderLayout());
            this.cardPanel_Switch[i].add((Component)this.switchTitle[i], "North");
            this.cardPanel_Switch[i].add((Component)this.switchconfigurelistPanel[i], "Center");
            this.scrollPane_Switch[i] = new JScrollPane();
            this.scrollPane_Switch[i].setViewportView(this.cardPanel_Switch[i]);
            this.cards.add((Component)this.scrollPane_Switch[i], "S" + i);
        }
        CMM2CMMInfo cmm2cmmInfo = this.cmm.microbladeEntity.getCMM2CMMInfo();
        RedundantCMMInfo redundantCmmInfo = this.cmm.microbladeEntity.getRedundantCMMInfo();
        this.masterCmmPanel = new CMMMasterPanel(cmm2cmmInfo);
        this.masterCmmPanel.preset(this.cmm.ipmiInterfaceConfig);
        this.slaveCmmPanel = new CMMRedundantPanel(cmm2cmmInfo, redundantCmmInfo);
        for (int i2 = 0; i2 < numberOfCmm; ++i2) {
            JLabel titleText;
            this.cmmTitle[i2] = new JPanel();
            if (!cmm2cmmInfo.isMaster()) continue;
            if (this.cmm.microbladeEntity.getCMM2CMMInfo().cmmSlot == i2) {
                titleText = new JLabel("Master CMM");
                this.cmmTitle[i2].setBackground(new Color(65, 105, 225));
                titleText.setForeground(Color.WHITE);
                this.cmmTitle[i2].add(titleText);
                titleText.setFont(this.titleFont);
                this.cardPanel_cmm[i2] = new JPanel(new BorderLayout());
                this.cardPanel_cmm[i2].add((Component)this.cmmTitle[i2], "North");
                this.cardPanel_cmm[i2].add((Component)this.masterCmmPanel, "Center");
                this.scrollPane_cmm[i2] = new JScrollPane();
                this.scrollPane_cmm[i2].setViewportView(this.cardPanel_cmm[i2]);
                this.cards.add((Component)this.scrollPane_cmm[i2], "Cm");
                continue;
            }
            titleText = new JLabel("Redundant CMM");
            this.cmmTitle[i2].setBackground(new Color(65, 105, 225));
            titleText.setForeground(Color.WHITE);
            this.cmmTitle[i2].add(titleText);
            titleText.setFont(this.titleFont);
            this.cardPanel_cmm[i2] = new JPanel(new BorderLayout());
            this.cardPanel_cmm[i2].add((Component)this.cmmTitle[i2], "North");
            this.cardPanel_cmm[i2].add((Component)this.slaveCmmPanel, "Center");
            this.scrollPane_cmm[i2] = new JScrollPane();
            this.scrollPane_cmm[i2].setViewportView(this.cardPanel_cmm[i2]);
            this.cards.add((Component)this.scrollPane_cmm[i2], "Cr");
        }
        this.curCMM = cmm2cmmInfo.isOtherCMMAlive() ? 2 : 1;
        this.cardPanel_first.update(this.curNodes, this.curPower, this.curSwitch, this.curCMM);
        TitledBorder titledBorder3 = new TitledBorder(L.t("cmm.nodeStatus.frontView"));
        TitledBorder titledBorder2 = new TitledBorder(L.t("cmm.nodeStatus.rearView"));
        this.nodeselectPanel.add((Component)this.btn_front, "cell 14 0, gapleft 5");
        this.scroll_nodeSelect.setViewportView(this.nodeselectPanel);
        this.scroll_nodeSelect.setPreferredSize(new Dimension(380, 206));
        this.scroll_nodeSelect.setBorder(titledBorder3);
        this.powersupplyselectPanel.setPreferredSize(new Dimension(280, 190));
        this.powersupplyselectPanel.setBorder(titledBorder2);
        this.btn_summary.setMargin(new Insets(0, 5, 0, 5));
        this.btn_front.setIcon(this.popoutIcon);
        this.btn_front.setPreferredSize(new Dimension(32, 32));
        this.jTopToolBar.add(this.btn_summary);
        this.jTopToolBar.setFloatable(false);
        this.summaryPanel.setMaximumSize(new Dimension(660, 215));
        this.summaryPanel.setLayout((LayoutManager)new MigLayout("", "0 [] 0", "0 [] 0"));
        this.summaryPanel.add((Component)this.jTopToolBar, "cell 0 0");
        this.summaryPanel.add((Component)this.scroll_nodeSelect, "cell 0 1");
        this.summaryPanel.add((Component)this.powersupplyselectPanel, "cell 1 1 1 1");
        this.add((Component)this.summaryPanel, "North");
        this.individualPanel.setLayout(new BorderLayout());
        this.individualPanel.add((Component)this.cards, "Center");
        this.add((Component)this.individualPanel, "Center");
    }

    @Override
    public void setUserPrivilege() {
        int i;
        for (i = 0; i < this.nodecontrolPanel.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = this.cmm.microbladeEntity.getBladeRemoteInfos()[i / 4];
            if (!bladeRemoteInfo.isPresent() || !this.cmm.microbladeEntity.getNodeStatusInfos()[i].initialized()) continue;
            this.nodecontrolPanel[i].setUserPrivilege();
        }
        for (i = 0; i < this.powersupplystatusPanel.length; ++i) {
            PowerSupplyInfo powersupplyInfo = this.cmm.microbladeEntity.getPowerSupplyInfos()[i];
            if (!powersupplyInfo.isPresent()) continue;
            this.powersupplystatusPanel[i].setUserPrivilege();
        }
        for (i = 0; i < this.switchconfigurelistPanel.length; ++i) {
            SwitchInfo switchInfo = this.cmm.microbladeEntity.getSwitchInfos()[i];
            if (!switchInfo.isPresent()) continue;
            this.switchconfigurelistPanel[i].setUserPrivilege();
        }
    }

    @Override
    public void setOperatorPrivilege() {
        int i;
        for (i = 0; i < this.nodecontrolPanel.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = this.cmm.microbladeEntity.getBladeRemoteInfos()[i / 4];
            if (!bladeRemoteInfo.isPresent() || !this.cmm.microbladeEntity.getNodeStatusInfos()[i].initialized()) continue;
            this.nodecontrolPanel[i].setOperatorPrivilege();
        }
        for (i = 0; i < this.powersupplystatusPanel.length; ++i) {
            PowerSupplyInfo powersupplyInfo = this.cmm.microbladeEntity.getPowerSupplyInfos()[i];
            if (!powersupplyInfo.isPresent()) continue;
            this.powersupplystatusPanel[i].setOperatorPrivilege();
        }
        for (i = 0; i < this.switchconfigurelistPanel.length; ++i) {
            SwitchInfo switchInfo = this.cmm.microbladeEntity.getSwitchInfos()[i];
            if (!switchInfo.isPresent()) continue;
            this.switchconfigurelistPanel[i].setOperatorPrivilege();
        }
    }

    @Override
    public void setAdministratorPrivilege() {
        int i;
        for (i = 0; i < this.nodecontrolPanel.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = this.cmm.microbladeEntity.getBladeRemoteInfos()[i / 4];
            if (!bladeRemoteInfo.isPresent() || !this.cmm.microbladeEntity.getNodeStatusInfos()[i].initialized()) continue;
            this.nodecontrolPanel[i].setAdministratorPrivilege();
        }
        for (i = 0; i < this.powersupplystatusPanel.length; ++i) {
            PowerSupplyInfo powersupplyInfo = this.cmm.microbladeEntity.getPowerSupplyInfos()[i];
            if (!powersupplyInfo.isPresent()) continue;
            this.powersupplystatusPanel[i].setAdministratorPrivilege();
        }
        for (i = 0; i < this.switchconfigurelistPanel.length; ++i) {
            SwitchInfo switchInfo = this.cmm.microbladeEntity.getSwitchInfos()[i];
            if (!switchInfo.isPresent()) continue;
            this.switchconfigurelistPanel[i].setAdministratorPrivilege();
        }
    }

    public void flipcards(String tag) {
        this.cardlayout.show(this.cards, tag);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NodeSelectPanel popup_nodeSelectPanel = new NodeSelectPanel(this.cmm.microbladeEntity, this);
        if (e.getSource() == this.btn_front) {
            Object[] options = new Object[]{L.t("cmm.nodeStatus.ok")};
            JOptionPane.showOptionDialog(null, popup_nodeSelectPanel, L.t("cmm.nodeStatus.frontView"), 0, -1, null, options, options[0]);
        }
        if (e.getSource() == this.btn_summary) {
            this.cardlayout.first(this.cards);
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        int i;
        this.curNodes = 0;
        this.curPower = 0;
        this.curSwitch = 0;
        this.curCMM = 0;
        this.curFan = 0;
        this.nodeselectPanel.update(o, obj);
        this.powersupplyselectPanel.update(o, obj);
        MicroBladeEntity microbladeEntity = this.cmm.microbladeEntity;
        SystemMiscInfo systemmiscinfo = microbladeEntity.getSystemMiscInfo();
        for (i = 0; i < numberOfNodes; ++i) {
            NodeSensorInfo nodesensorInfo = microbladeEntity.getNodeSensorInfos()[i];
            BladeRemoteInfo bladeRemoteInfo = microbladeEntity.getBladeRemoteInfos()[i / 4];
            this.nodecontrolPanel[i].update(nodesensorInfo);
            this.nodesensorlistPanel[i].update(nodesensorInfo);
            this.nodeconfigurelistPanel[i].update(nodesensorInfo);
            if (!bladeRemoteInfo.isPresent() || !microbladeEntity.getNodeStatusInfos()[i].initialized()) continue;
            ++this.curNodes;
        }
        for (i = 0; i < numberOfPS; ++i) {
            PowerSupplyInfo powersupplyInfo = microbladeEntity.getPowerSupplyInfos()[i];
            this.powerSupplyTitleLabel[i].setText(L.t("cmm.nodeStatus.power_supply") + " " + PowerSupplyInfo.getIndex(powersupplyInfo.getIndex()));
            this.powersupplystatusPanel[i].update(powersupplyInfo, systemmiscinfo);
            if (!powersupplyInfo.isPresent()) continue;
            ++this.curPower;
        }
        for (i = 0; i < numberOfSwitch; ++i) {
            SwitchInfo switchInfo = microbladeEntity.getSwitchInfos()[i];
            if (!switchInfo.isPresent()) continue;
            ++this.curSwitch;
            this.switchTitleLabel[i].setText(L.t("cmm.nodeStatus.switch") + " " + SwitchInfo.getIndex(switchInfo.getIndex()));
            this.switchconfigurelistPanel[i].update(switchInfo);
        }
        for (i = 0; i < numberOfFan; ++i) {
            PowerSupplyInfo fanInfo = microbladeEntity.getFanInfos()[i];
            if (!fanInfo.isPresent()) continue;
            this.fanTitleLabel[i].setText(L.t("cmm.nodeStatus.fan") + " " + PowerSupplyInfo.getFanIndex(fanInfo.getIndex()));
            this.fanStatusPanel[i].update(fanInfo);
            ++this.curFan;
        }
        CMM2CMMInfo cmmInfo = microbladeEntity.getCMM2CMMInfo();
        RedundantCMMInfo reCmmInfo = microbladeEntity.getRedundantCMMInfo();
        this.masterCmmPanel.update(cmmInfo);
        this.slaveCmmPanel.update(cmmInfo, reCmmInfo);
        this.curCMM = cmmInfo.isOtherCMMAlive() ? 2 : 1;
        this.cardPanel_first.update(this.curNodes, this.curPower, this.curSwitch, this.curCMM);
    }
}

