/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.micro.LabelMicroBladeFan;
import IPMIView20.micro.LabelMicroBladeSwitch;
import IPMIView20.micro.LabelMicroCMM;
import IPMIView20.micro.LabelMicroPowerSupply;
import IPMIView20.micro.NodeStatusPanel;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.microblade.SwitchInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PowerSupplySelectPanel
extends JPanel
implements Observer {
    IPMIInterfaceConfig ipmiInterfaceConfig;
    LabelMicroCMM[] cmmLabels;
    LabelMicroBladeSwitch[] swtLabels;
    LabelMicroPowerSupply[] pspLabels;
    LabelMicroBladeFan[] fanLabels;
    private int cmmCount = 0;
    private int swtCount = 0;
    private int pspCount = 0;
    private int fanCount = 0;
    MicroBladeEntity microbladeEntity = null;

    public PowerSupplySelectPanel(MicroBladeEntity entity, NodeStatusPanel nodestatusPanel, IPMIInterfaceConfig ipmiInterfaceconfig) {
        this.microbladeEntity = entity;
        this.ipmiInterfaceConfig = ipmiInterfaceconfig;
        this.setLayout((LayoutManager)new MigLayout("insets 0 15 0 15", "[] 0 []", "[] 0 []"));
        this.setupCMMLabel(entity, nodestatusPanel);
        this.setupPowerSupplyLabel(entity, nodestatusPanel);
        this.setupSwitchLabel(entity, nodestatusPanel);
        this.setupFanLabel(entity, nodestatusPanel);
    }

    @Override
    public void update(Observable o, Object obj) {
        int i;
        for (i = 0; i < this.pspCount; ++i) {
            PowerSupplyInfo powersupplyinfo = this.microbladeEntity.getPowerSupplyInfos()[i];
            this.pspLabels[i].setExist(powersupplyinfo.isPresent());
            this.pspLabels[i].update(this.microbladeEntity);
        }
        for (i = 0; i < this.swtCount; ++i) {
            SwitchInfo switchinfo = this.microbladeEntity.getSwitchInfos()[i];
            this.swtLabels[i].setExist(switchinfo.isPresent());
            this.swtLabels[i].update(this.microbladeEntity);
        }
        for (i = 0; i < this.cmmCount; ++i) {
            if (!this.cmmLabels[i].isConnected()) continue;
            this.cmmLabels[i].update(this.microbladeEntity);
        }
    }

    private void setupCMMLabel(MicroBladeEntity entity, NodeStatusPanel panel) {
        this.cmmCount = entity.supportedCMMSize;
        this.cmmLabels = new LabelMicroCMM[this.cmmCount];
        for (int idx = 0; idx < this.cmmCount; ++idx) {
            this.cmmLabels[idx] = new LabelMicroCMM(this.ipmiInterfaceConfig);
            this.cmmLabels[idx].setNumber(idx);
            this.cmmLabels[idx].setExist(true);
            this.cmmLabels[idx].setComponentGroup(panel.componentGroup);
            this.cmmLabels[idx].setNodestatusPanel(panel);
            panel.componentGroup.add(this.cmmLabels[idx]);
        }
        CMM2CMMInfo cmm2cmm = this.microbladeEntity.getCMM2CMMInfo();
        if (cmm2cmm.isMaster()) {
            if (cmm2cmm.cmmSlot == 0) {
                this.cmmLabels[0].setConnected(true);
                this.cmmLabels[0].setAlive(true);
                if (cmm2cmm.isOtherCMMPresent()) {
                    if (cmm2cmm.isOtherCMMAlive()) {
                        this.cmmLabels[1].setAlive(true);
                    } else {
                        this.cmmLabels[1].setAlive(false);
                    }
                } else if (this.cmmCount > 1) {
                    this.cmmLabels[1].setExist(false);
                }
            } else if (cmm2cmm.cmmSlot == 1 && this.cmmCount > 1) {
                this.cmmLabels[1].setConnected(true);
                this.cmmLabels[1].setAlive(true);
                if (cmm2cmm.isOtherCMMPresent()) {
                    if (cmm2cmm.isOtherCMMAlive()) {
                        this.cmmLabels[0].setAlive(true);
                    } else {
                        this.cmmLabels[0].setAlive(false);
                    }
                } else {
                    this.cmmLabels[0].setExist(false);
                }
            }
        }
        switch (entity.MiddlePlaneType) {
            case 1: {
                this.add((Component)this.cmmLabels[0], "cell 3 1, align right");
                break;
            }
            case 2: {
                this.add((Component)this.cmmLabels[0], "cell 0 0, align left");
                break;
            }
            case 3: {
                this.add((Component)this.cmmLabels[0], "cell 1 1 2 1, align left, gapleft 31");
                break;
            }
            case 4: {
                this.add((Component)this.cmmLabels[0], "cell 1 3 2 1, align left, gapleft 31");
                break;
            }
            case 5: {
                this.add((Component)this.cmmLabels[0], "cell 2 1 2 1, align right, gapright 31");
                this.add((Component)this.cmmLabels[1], "cell 0 2 2 1, align left, gapleft 31");
                break;
            }
            case 6: {
                this.add((Component)this.cmmLabels[0], "cell 1 1 2 1, align left, gapleft 31");
                this.add((Component)this.cmmLabels[1], "cell 1 2 2 1, align left, gapleft 31");
                break;
            }
        }
    }

    private void setupPowerSupplyLabel(MicroBladeEntity entity, NodeStatusPanel panel) {
        this.pspCount = entity.supportedPowerSupplySize;
        int halfCount = this.pspCount > 4 ? this.pspCount / 2 : 0;
        String labelLayout = null;
        this.pspLabels = new LabelMicroPowerSupply[this.pspCount];
        for (int idx = 0; idx < this.pspCount; ++idx) {
            this.pspLabels[idx] = new LabelMicroPowerSupply();
            this.pspLabels[idx].setComponentGroup(panel.componentGroup);
            this.pspLabels[idx].setNodestatusPanel(panel);
            this.pspLabels[idx].setNumber(idx);
            this.pspLabels[idx].setPowerStatus(entity.getPowerSupplyInfos()[idx].powerStatus);
            this.pspLabels[idx].setExist(entity.getPowerSupplyInfos()[idx].isPresent());
            this.pspLabels[idx].setAlertVisible(entity.getPowerSupplyInfos()[idx].error != 0);
            this.pspLabels[idx].setIcon(idx < halfCount);
            panel.componentGroup.add(this.pspLabels[idx]);
            switch (entity.MiddlePlaneType) {
                case 5: {
                    labelLayout = "cell " + (idx < halfCount ? halfCount - idx - 1 : idx - halfCount) + (idx < halfCount ? " 0" : " 3");
                    break;
                }
                case 4: {
                    labelLayout = "cell " + (halfCount != 0 ? idx % halfCount : 0) + (idx < halfCount ? " 0" : " 4");
                    break;
                }
                case 2: {
                    labelLayout = "cell " + idx + " 1";
                    break;
                }
                default: {
                    labelLayout = "cell " + (halfCount != 0 ? idx % halfCount : 0) + (idx < halfCount ? " 0" : " 3");
                }
            }
            super.add((Component)this.pspLabels[idx], labelLayout);
        }
    }

    private void setupSwitchLabel(MicroBladeEntity entity, NodeStatusPanel panel) {
        this.swtCount = entity.supportedGigabitSwitchSize;
        this.swtLabels = new LabelMicroBladeSwitch[this.swtCount];
        block8: for (int idx = 0; idx < this.swtCount; ++idx) {
            SwitchInfo switchinfo = this.microbladeEntity.getSwitchInfos()[idx];
            this.swtLabels[idx] = new LabelMicroBladeSwitch();
            this.swtLabels[idx].setComponentGroup(panel.componentGroup);
            this.swtLabels[idx].setNodestatusPanel(panel);
            this.swtLabels[idx].setNumber(idx);
            this.swtLabels[idx].setPowerStatus(switchinfo.getPowerStatus());
            this.swtLabels[idx].setExist(switchinfo.isPresent());
            this.swtLabels[idx].setUidVisible(switchinfo.getUid());
            this.swtLabels[idx].setAlertVisible(switchinfo.error != 0);
            panel.componentGroup.add(this.swtLabels[idx]);
            switch (entity.MiddlePlaneType) {
                case 1: {
                    this.swtLabels[idx].setIcon(switchinfo, idx < 2, true);
                    if (idx == 0) {
                        this.add((Component)this.swtLabels[idx], "cell 0 1 2 1, align left");
                        continue block8;
                    }
                    if (idx == 1) {
                        this.add((Component)this.swtLabels[idx], "cell 1 1 2 1, align left, gapleft 30");
                        continue block8;
                    }
                    if (idx == 2) {
                        this.add((Component)this.swtLabels[idx], "cell 0 2 2 1, align left");
                        continue block8;
                    }
                    if (idx != 3) continue block8;
                    this.add((Component)this.swtLabels[idx], "cell 1 2 2 1, align left, gapleft 30");
                    continue block8;
                }
                case 2: {
                    this.swtLabels[idx].setIcon(switchinfo, false, true);
                    if (idx == 0) {
                        this.add((Component)this.swtLabels[idx], "cell 1 0 2 1, align left");
                        continue block8;
                    }
                    if (idx != 1) continue block8;
                    this.add((Component)this.swtLabels[idx], "cell 2 0 2 1, align right");
                    continue block8;
                }
                case 3: {
                    this.swtLabels[idx].setIcon(switchinfo, true, true);
                    if (idx == 0) {
                        this.add((Component)this.swtLabels[idx], "cell 0 1 2 1, align left");
                        continue block8;
                    }
                    if (idx != 1) continue block8;
                    this.add((Component)this.swtLabels[idx], "cell 2 1 2 1, align left, gapleft 30");
                    continue block8;
                }
                case 4: {
                    if (idx == 0) {
                        this.swtLabels[idx].setIcon(switchinfo, false, true);
                        this.add((Component)this.swtLabels[idx], "cell 0 3 2 1, align left");
                        continue block8;
                    }
                    if (idx == 1) {
                        this.swtLabels[idx].setIcon(switchinfo, false, true);
                        this.add((Component)this.swtLabels[idx], "cell 2 3 2 1, align right");
                        continue block8;
                    }
                    if (idx != 2) continue block8;
                    this.swtLabels[idx].setIcon(switchinfo, true, false);
                    this.add((Component)this.swtLabels[idx], "cell 0 1 4 1");
                    continue block8;
                }
                case 5: {
                    if (idx == 0) {
                        this.swtLabels[idx].setIcon(switchinfo, true, true);
                        this.add((Component)this.swtLabels[idx], "cell 0 1 2 1, align right");
                        continue block8;
                    }
                    if (idx != 1) continue block8;
                    this.swtLabels[idx].setIcon(switchinfo, false, true);
                    this.add((Component)this.swtLabels[idx], "cell 2 2 2 1, align left");
                    continue block8;
                }
                case 6: {
                    this.swtLabels[idx].setIcon(switchinfo, idx < 2, true);
                    if (idx == 0) {
                        this.add((Component)this.swtLabels[idx], "cell 0 1 2 1, align left");
                        continue block8;
                    }
                    if (idx == 1) {
                        this.add((Component)this.swtLabels[idx], "cell 2 1 2 1, align left, gapleft 30");
                        continue block8;
                    }
                    if (idx == 2) {
                        this.add((Component)this.swtLabels[idx], "cell 0 2 2 1, align left");
                        continue block8;
                    }
                    if (idx != 3) continue block8;
                    this.add((Component)this.swtLabels[idx], "cell 2 2 2 1, align left, gapleft 30");
                    continue block8;
                }
            }
        }
    }

    private void setupFanLabel(MicroBladeEntity entity, NodeStatusPanel panel) {
        this.fanCount = entity.supportedFanSize;
        this.fanLabels = new LabelMicroBladeFan[this.fanCount];
        for (int idx = 0; idx < this.fanCount; ++idx) {
            this.fanLabels[idx] = new LabelMicroBladeFan();
            this.fanLabels[idx].setComponentGroup(panel.componentGroup);
            this.fanLabels[idx].setNodestatusPanel(panel);
            this.fanLabels[idx].setNumber(idx);
            this.fanLabels[idx].setPowerStatus(this.microbladeEntity.getFanInfos()[idx].powerStatus);
            this.fanLabels[idx].setExist(this.microbladeEntity.getFanInfos()[idx].isPresent());
            panel.componentGroup.add(this.fanLabels[idx]);
            if (entity.MiddlePlaneType != 4) continue;
            if (idx == 0) {
                this.add((Component)this.fanLabels[idx], "cell 0 2, span 2, align left");
                continue;
            }
            if (idx == 1) {
                this.add((Component)this.fanLabels[idx], "cell 1 2, span 2, gapleft 20");
                continue;
            }
            if (idx != 2) continue;
            this.add((Component)this.fanLabels[idx], "cell 2 2, span 2, align right");
        }
    }
}

