/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.CMMSessionPanel;
import IPMIView20.L;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.SwitchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class SwitchConfigureListPanel
extends JPanel
implements ActionListener {
    ImageIcon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    ImageIcon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    ImageIcon okBlueIcon = new ImageIcon(this.getClass().getResource("/images/ok_blue.gif"));
    ImageIcon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    ImageIcon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    ImageIcon emptyIcon = new ImageIcon(this.getClass().getResource("/images/empty.gif"));
    SwitchInfo switchinfo;
    IPMIInterfaceConfig config;
    Object[][] data = new Object[15][3];
    JTable table;
    MyTableModel tableModel = new MyTableModel();
    JPanel managePanel;
    JLabel lbl_title1 = new JLabel(L.t("cmm.nodeStatus.switch.switch_management_configuration"));
    JSeparator js1 = new JSeparator();
    JLabel lbl_username = new JLabel(L.t("cmm.nodeStatus.switch.username_password"));
    JLabel lbl_ipMode = new JLabel(L.t("cmm.nodeStatus.switch.ip_mode"));
    JLabel lbl_wss = new JLabel("WSS IP");
    JLabel lbl_netmask = new JLabel(L.t("cmm.nodeStatus.switch.netmask"));
    JLabel lbl_gateway = new JLabel(L.t("cmm.nodeStatus.switch.gateway"));
    JLabel lbl_date = new JLabel("Datetime");
    JButton btn_setting = new JButton(L.t("cmm.nodeStatus.switch.setting"));
    JButton btn_restore = new JButton(L.t("cmm.nodeStatus.switch.restore"));
    JButton btn_update = new JButton(L.t("cmm.nodeStatus.switch.update"));
    ButtonGroup bg = new ButtonGroup();
    JRadioButton rb_dhcp = new JRadioButton("DHCP");
    JRadioButton rb_static = new JRadioButton(L.t("cmm.nodeStatus.switch.static_ip"));
    JTextField tf_wss = new JTextField();
    JTextField tf_netmask = new JTextField();
    JTextField tf_gateway = new JTextField();
    JTextField tf_date = new JTextField();
    JPanel powerControlPanel;
    JLabel lbl_title2 = new JLabel(L.t("cmm.nodeStatus.switch.power_control"));
    JSeparator js2 = new JSeparator();
    JButton btn_powerOn = new JButton("Power On");
    JButton btn_reset = new JButton(L.t("cmm.nodeStatus.switch.reset"));
    JButton btn_graceful = new JButton("Graceful Reboot");
    JButton btn_powerOff = new JButton("Power Off");
    JLabel lbl_title3 = new JLabel("UID");
    JSeparator js3 = new JSeparator();
    JButton btn_uidOn = new JButton(L.t("cmm.nodeStatus.switch.uid_on"));
    JButton btn_uidOff = new JButton(L.t("cmm.nodeStatus.switch.uid_off"));
    JLabel lbl_user_string = new JLabel();
    JPasswordField tf_pass = new JPasswordField();
    JPasswordField tf_confirm = new JPasswordField();

    public SwitchConfigureListPanel(SwitchInfo switchinfo, CMMSessionPanel cmmSessionPanel) {
        this.setLayout((LayoutManager)new MigLayout("", "[][0:40:60][]", ""));
        this.config = cmmSessionPanel.ipmiInterfaceConfig;
        this.switchinfo = switchinfo;
        this.btn_uidOn.setMargin(new Insets(2, 0, 2, 0));
        this.btn_uidOff.setMargin(new Insets(2, 0, 2, 0));
        this.btn_powerOn.addActionListener(this);
        this.btn_powerOff.addActionListener(this);
        this.btn_reset.addActionListener(this);
        this.btn_uidOn.addActionListener(this);
        this.btn_uidOff.addActionListener(this);
        this.btn_setting.addActionListener(this);
        this.btn_restore.addActionListener(this);
        this.btn_update.addActionListener(this);
        this.rb_dhcp.addActionListener(this);
        this.rb_static.addActionListener(this);
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                c.setForeground(Color.black);
                return c;
            }
        };
        this.refreshTableData(switchinfo);
        this.refreshManagementData(switchinfo);
        this.powerControlPanel = this.getpowerControllPanel();
        this.managePanel = this.getManagePanel();
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(280, 170));
        this.add((Component)scroll, "cell 0 0");
        this.add((Component)this.managePanel, "cell 2 0, span y 3, alignx right, aligny top");
        this.add((Component)this.powerControlPanel, "cell 0 1");
    }

    public void refreshManagementData(SwitchInfo Switchinfo) {
        if (Switchinfo.getIPSRC() == 1) {
            this.rb_static.setSelected(true);
            this.tf_wss.setEnabled(true);
            this.tf_netmask.setEnabled(true);
            this.tf_gateway.setEnabled(true);
        } else if (Switchinfo.getIPSRC() == 2) {
            this.rb_dhcp.setSelected(true);
            this.tf_wss.setEnabled(false);
            this.tf_netmask.setEnabled(false);
            this.tf_gateway.setEnabled(false);
        }
        this.tf_wss.setText(this.switchinfo.getIPAddr());
        this.tf_netmask.setText(this.switchinfo.getNetMask());
        this.tf_gateway.setText(this.switchinfo.getGateway());
        this.tf_date.setText(this.switchinfo.getDateTime());
    }

    public void refreshTableData(SwitchInfo Switchinfo) {
        String[] word;
        String[] lines = Switchinfo.toFormatedString().split("\\r?\\n");
        int countline = 0;
        for (int i = 0; i < 15 && !(word = lines[i].split("\\s+\\|\\s+"))[0].isEmpty(); ++i) {
            this.data[countline][0] = word[0];
            if (word.length > 1) {
                this.data[countline][2] = word[1];
            }
            ++countline;
        }
        this.data[0][1] = this.emptyIcon;
        if (this.data[5][2].toString().contains("Enabled")) {
            this.data[5][1] = this.uidLEDOnIcon;
        } else if (this.data[5][2].toString().contains("Disabled")) {
            this.data[5][1] = this.uidLEDOffIcon;
        }
        if (this.data[6][2].toString().contains("Normal")) {
            this.data[6][1] = this.okGreenIcon;
        } else if (this.data[6][2].toString().contains("error")) {
            this.data[6][1] = this.xRedIcon;
        }
        this.tableModel.refresh(this.data);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.setRowHeight(5, 20);
    }

    public JPanel getpowerControllPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout((LayoutManager)new MigLayout("", "", ""));
        this.lbl_title2.setForeground(Color.BLUE);
        this.lbl_title3.setForeground(Color.BLUE);
        this.btn_powerOff.setForeground(Color.red);
        this.btn_reset.setForeground(Color.red);
        this.btn_graceful.setForeground(Color.red);
        p1.add((Component)this.lbl_title2, "cell 0 0");
        p1.add((Component)this.js2, "cell 0 1, span 2 , growx");
        p1.add((Component)this.btn_reset, "cell 0 2, growx");
        p1.add((Component)this.lbl_title3, "cell 3 0");
        p1.add((Component)this.js3, "cell 3 1, span 2 , growx");
        p1.add((Component)this.btn_uidOn, "cell 3 2, growx");
        p1.add((Component)this.btn_uidOff, "cell 3 3, growx");
        return p1;
    }

    public JPanel getManagePanel() {
        JPanel p1 = new JPanel((LayoutManager)new MigLayout("", "", ""));
        this.bg.add(this.rb_dhcp);
        this.bg.add(this.rb_static);
        p1.add((Component)this.lbl_title1, "cell 0 0, span 4");
        this.lbl_title1.setForeground(Color.BLUE);
        p1.add((Component)this.js1, "cell 0 1, span 4, growx");
        p1.add((Component)this.lbl_username, "cell 0 2");
        p1.add((Component)this.btn_setting, "cell 2 2, alignx right");
        p1.add((Component)this.lbl_ipMode, "cell 0 3");
        p1.add((Component)this.rb_dhcp, "cell 2 3, split 2");
        p1.add((Component)this.rb_static, "cell 2 3");
        p1.add((Component)this.lbl_wss, "cell 0 4");
        p1.add((Component)this.tf_wss, "cell 1 4, span 2, growx");
        p1.add((Component)this.lbl_netmask, "cell 0 5");
        p1.add((Component)this.tf_netmask, "cell 1 5, span 2, growx");
        p1.add((Component)this.lbl_gateway, "cell 0 6");
        p1.add((Component)this.tf_gateway, "cell 1 6, span 2, growx");
        p1.add((Component)this.btn_restore, "cell 1 8,span 2, split 2, growx");
        p1.add((Component)this.btn_update, "cell 1 8, growx");
        return p1;
    }

    public JPanel getUsernamePanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("", "[][100!]", ""));
        JLabel lbl_user = new JLabel(L.t("cmm.nodeStatus.switch.username_password.username"));
        JLabel lbl_pass = new JLabel(L.t("cmm.nodeStatus.switch.username_password.password"));
        JLabel lbl_confirm = new JLabel(L.t("cmm.nodeStatus.switch.username_password.password_confirm"));
        p.add((Component)lbl_user, "cell 0 0");
        p.add((Component)this.lbl_user_string, "cell 1 0, growx");
        p.add((Component)lbl_pass, "cell 0 1");
        p.add((Component)this.tf_pass, "cell 1 1, growx");
        p.add((Component)lbl_confirm, "cell 0 2");
        p.add((Component)this.tf_confirm, "cell 1 2, growx");
        return p;
    }

    public void update(SwitchInfo swi) {
        this.switchinfo = swi;
        SwingUtilities.invokeLater(new Runnable(){
            private SwitchInfo switchInfo;
            {
                this.switchInfo = SwitchConfigureListPanel.this.switchinfo;
            }

            @Override
            public void run() {
                try {
                    SwitchConfigureListPanel.this.refreshTableData(this.switchInfo);
                    SwitchConfigureListPanel.this.refreshManagementData(this.switchInfo);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rb_dhcp) {
            this.tf_wss.setEnabled(false);
            this.tf_netmask.setEnabled(false);
            this.tf_gateway.setEnabled(false);
        } else if (e.getSource() == this.rb_static) {
            this.tf_wss.setEnabled(true);
            this.tf_netmask.setEnabled(true);
            this.tf_gateway.setEnabled(true);
        } else if (e.getSource() == this.btn_restore) {
            this.tf_wss.setText(this.switchinfo.getIPAddr());
            this.tf_netmask.setText(this.switchinfo.getNetMask());
            this.tf_gateway.setText(this.switchinfo.getGateway());
            this.tf_date.setText(this.switchinfo.getDateTime());
        } else if (e.getSource() == this.btn_update) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
                    ISessionController sessionController = SessionControllerFactory.createSessionController(SwitchConfigureListPanel.this.config, ipmiMicroBladeOEMCommand);
                    if (sessionController != null) {
                        boolean b1 = true;
                        if (SwitchConfigureListPanel.this.rb_dhcp.isSelected()) {
                            try {
                                b1 = ipmiMicroBladeOEMCommand.setSwitchDHCPStatus(SwitchConfigureListPanel.this.switchinfo.getIndex() + 1, 2);
                            }
                            catch (IPMIException ex) {
                                JOptionPane.showMessageDialog(null, "Update LAN configuration fail.", "Error", 0);
                            }
                            sessionController.closeSession();
                            return;
                        }
                        try {
                            b1 = ipmiMicroBladeOEMCommand.setSwitchDHCPStatus(SwitchConfigureListPanel.this.switchinfo.getIndex() + 1, 1);
                        }
                        catch (IPMIException ex) {
                            b1 = false;
                        }
                        boolean b2 = true;
                        try {
                            b2 = ipmiMicroBladeOEMCommand.setSwitchIP(SwitchConfigureListPanel.this.switchinfo.getIndex() + 1, SwitchConfigureListPanel.this.tf_wss.getText());
                        }
                        catch (IPMIException e1) {
                            b2 = false;
                        }
                        boolean b3 = true;
                        try {
                            b3 = ipmiMicroBladeOEMCommand.setSwitchMask(SwitchConfigureListPanel.this.switchinfo.getIndex() + 1, SwitchConfigureListPanel.this.tf_netmask.getText());
                        }
                        catch (IPMIException e1) {
                            b3 = false;
                        }
                        boolean b4 = true;
                        try {
                            b4 = ipmiMicroBladeOEMCommand.setSwitchGateway(SwitchConfigureListPanel.this.switchinfo.getIndex() + 1, SwitchConfigureListPanel.this.tf_gateway.getText());
                        }
                        catch (IPMIException e1) {
                            b4 = false;
                        }
                        sessionController.closeSession();
                        if (b1 && b2 && b3 && b4) {
                            JOptionPane.showMessageDialog(null, "Update LAN configuration Successfully.");
                        } else {
                            JOptionPane.showMessageDialog(null, "Update LAN configuration fail.", "Error", 0);
                        }
                    }
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_setting) {
            this.lbl_user_string.setText(this.switchinfo.getUserName());
            Object[] options = new Object[]{L.t("cmm.nodeStatus.switch.update"), L.t("cmm.nodeStatus.switch.username_password.cancel")};
            int n = JOptionPane.showOptionDialog(null, this.getUsernamePanel(), L.t("cmm.nodeStatus.switch.username_password.username_setting"), 1, -1, null, options, options[1]);
            if (n == 0) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand;
                        ISessionController sessionController;
                        String password = String.valueOf(SwitchConfigureListPanel.this.tf_pass.getPassword());
                        if (password != null && password.equals(String.valueOf(SwitchConfigureListPanel.this.tf_confirm.getPassword())) && (sessionController = SessionControllerFactory.createSessionController(SwitchConfigureListPanel.this.config, ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null))) != null) {
                            boolean b1 = ipmiMicroBladeOEMCommand.setSwitchPassword(SwitchConfigureListPanel.this.switchinfo.getIndex() + 1, password);
                            sessionController.closeSession();
                            if (b1) {
                                JOptionPane.showMessageDialog(null, "Update Successfully.");
                            } else {
                                JOptionPane.showMessageDialog(null, "Update fail.", "Error", 0);
                            }
                        }
                    }
                };
                thread.start();
            }
        } else if (e.getSource() == this.btn_powerOn) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SwitchConfigureListPanel.this.powerOn();
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_powerOff) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SwitchConfigureListPanel.this.powerOff();
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_reset) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SwitchConfigureListPanel.this.powerReset();
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_uidOn) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SwitchConfigureListPanel.this.uidOn();
                }
            };
            thread.start();
        } else if (e.getSource() == this.btn_uidOff) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SwitchConfigureListPanel.this.uidOff();
                }
            };
            thread.start();
        }
    }

    private void powerOn() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setSwitchPowerStatus(this.switchinfo.getIndex() + 1, (byte)1);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, L.t("cmm.single.power.Power_on_failed"));
            }
        }
    }

    private void powerOff() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setSwitchPowerStatus(this.switchinfo.getIndex() + 1, (byte)0);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, L.t("cmm.single.power.Power_off_failed"));
            }
        }
    }

    private void powerReset() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setSwitchPowerReset(this.switchinfo.getIndex() + 1);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    private void uidOn() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                boolean b = ipmiMicroBladeOEMCommand.setSwitchUID(this.switchinfo.getIndex() + 1, 1);
                sessionController.closeSession();
                if (b) {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.set_uid_led_successfully"));
                } else {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.set_uid_led_fail"), "Error", 0);
                }
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    private void uidOff() {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                boolean b = ipmiMicroBladeOEMCommand.setSwitchUID(this.switchinfo.getIndex() + 1, 0);
                sessionController.closeSession();
                if (b) {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.set_uid_led_successfully"));
                } else {
                    JOptionPane.showMessageDialog(null, L.t("cmm.nodeStatus.set_uid_led_fail"), "Error", 0);
                }
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    public void setUserPrivilege() {
        this.btn_setting.setEnabled(false);
        this.btn_update.setEnabled(false);
        this.rb_dhcp.setEnabled(false);
        this.rb_static.setEnabled(false);
        this.btn_powerOn.setEnabled(false);
        this.btn_reset.setEnabled(false);
        this.btn_powerOff.setEnabled(false);
        this.btn_uidOn.setEnabled(false);
        this.btn_uidOff.setEnabled(false);
    }

    public void setOperatorPrivilege() {
        this.btn_setting.setEnabled(true);
        this.btn_update.setEnabled(true);
        this.rb_dhcp.setEnabled(true);
        this.rb_static.setEnabled(true);
        this.btn_powerOn.setEnabled(true);
        this.btn_reset.setEnabled(true);
        this.btn_powerOff.setEnabled(true);
        this.btn_uidOn.setEnabled(true);
        this.btn_uidOff.setEnabled(true);
    }

    public void setAdministratorPrivilege() {
        this.btn_setting.setEnabled(true);
        this.btn_update.setEnabled(true);
        this.rb_dhcp.setEnabled(true);
        this.rb_static.setEnabled(true);
        this.btn_powerOn.setEnabled(true);
        this.btn_reset.setEnabled(true);
        this.btn_powerOff.setEnabled(true);
        this.btn_uidOn.setEnabled(true);
        this.btn_uidOff.setEnabled(true);
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{L.t("cmm.nodeStatus.switch.item"), "", L.t("cmm.nodeStatus.switch.value")};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return SwitchConfigureListPanel.this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return SwitchConfigureListPanel.this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + SwitchConfigureListPanel.this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }

        public void refresh(Object[][] objects) {
            this.fireTableChanged(null);
        }
    }
}

