/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.L;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import com.supermicro.ipmi.trap.traps.VariableBindings;
import java.io.UnsupportedEncodingException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TrapTreeV3 {
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(L.t("trap.tree.SNMP_Trap"));

    public TrapTreeV3() {
        this.treeModel = new DefaultTreeModel(this.rootNode);
    }

    public void loadTrapTree(SNMPv3Trap trapV3) {
        DefaultMutableTreeNode headerNode = new DefaultMutableTreeNode(L.t("trap.tree.SNMP_Header"));
        this.treeModel.insertNodeInto(headerNode, this.rootNode, this.rootNode.getChildCount());
        String msgLength = L.t("trap.tree.Message_Length") + ": " + trapV3.getWholeMsgLength();
        DefaultMutableTreeNode msgLengthNode = new DefaultMutableTreeNode(msgLength);
        this.treeModel.insertNodeInto(msgLengthNode, headerNode, headerNode.getChildCount());
        String msgVersion = L.t("trap.tree.Message_Version") + ": v" + trapV3.getMsgVersion();
        DefaultMutableTreeNode msgVerNode = new DefaultMutableTreeNode(msgVersion);
        this.treeModel.insertNodeInto(msgVerNode, headerNode, headerNode.getChildCount());
        String authoritativeEngineID = L.t("trap.tree.Authoritative_Engine_ID") + ": " + ByteUtility.bytesToHex(trapV3.getMsgAuthoritativeEngineID());
        DefaultMutableTreeNode engineIDNode = new DefaultMutableTreeNode(authoritativeEngineID);
        this.treeModel.insertNodeInto(engineIDNode, headerNode, headerNode.getChildCount());
        String authoritativeEngineBoots = L.t("trap.tree.Authoritative_Engine_Boots") + ": " + trapV3.getMsgAuthoritativeEngineBoots();
        DefaultMutableTreeNode engineBootsNode = new DefaultMutableTreeNode(authoritativeEngineBoots);
        this.treeModel.insertNodeInto(engineBootsNode, headerNode, headerNode.getChildCount());
        String authoritativeEngineTime = L.t("trap.tree.Authoritative_Engine_Time") + ": " + trapV3.getMsgAuthoritativeEngineTime();
        DefaultMutableTreeNode engineTimeNode = new DefaultMutableTreeNode(authoritativeEngineTime);
        this.treeModel.insertNodeInto(engineTimeNode, headerNode, headerNode.getChildCount());
        String authenticationParameters = L.t("trap.tree.Authentication_Parameters") + ": " + ByteUtility.bytesToHex(trapV3.getMsgAuthenticationParameters());
        DefaultMutableTreeNode authenticationParameterNode = new DefaultMutableTreeNode(authenticationParameters);
        this.treeModel.insertNodeInto(authenticationParameterNode, headerNode, headerNode.getChildCount());
        String privacyParameters = L.t("trap.tree.Privacy_Parameters") + ": " + ByteUtility.bytesToHex(trapV3.getMsgPrivacyParameters());
        DefaultMutableTreeNode privacyParametersNode = new DefaultMutableTreeNode(privacyParameters);
        this.treeModel.insertNodeInto(privacyParametersNode, headerNode, headerNode.getChildCount());
        String userName = null;
        try {
            userName = new String(trapV3.getMsgUserName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String userNameField = L.t("trap.tree.User_Name") + ": " + userName;
        DefaultMutableTreeNode userNameNode = new DefaultMutableTreeNode(userNameField);
        this.treeModel.insertNodeInto(userNameNode, headerNode, headerNode.getChildCount());
        DefaultMutableTreeNode decryptedScopedPDUNode = new DefaultMutableTreeNode(L.t("trap.tree.Decrypted_ScopedPDU") + ": ");
        this.treeModel.insertNodeInto(decryptedScopedPDUNode, this.rootNode, this.rootNode.getChildCount());
        DefaultMutableTreeNode pduHeaderNode = new DefaultMutableTreeNode(L.t("trap.tree.PDU_Header") + ": ");
        this.treeModel.insertNodeInto(pduHeaderNode, decryptedScopedPDUNode, decryptedScopedPDUNode.getChildCount());
        String contextEngineID = L.t("trap.tree.Context_Engine_ID") + ": " + trapV3.getContextEngineID();
        DefaultMutableTreeNode contextEngineIDNode = new DefaultMutableTreeNode(contextEngineID);
        this.treeModel.insertNodeInto(contextEngineIDNode, pduHeaderNode, pduHeaderNode.getChildCount());
        String contextName = L.t("trap.tree.Context_Name") + ": " + trapV3.getContextName();
        DefaultMutableTreeNode contextNameNode = new DefaultMutableTreeNode(contextName);
        this.treeModel.insertNodeInto(contextNameNode, pduHeaderNode, pduHeaderNode.getChildCount());
        DefaultMutableTreeNode pduBodyNode = new DefaultMutableTreeNode(L.t("trap.tree.PDU_Body") + ": ");
        this.treeModel.insertNodeInto(pduBodyNode, decryptedScopedPDUNode, decryptedScopedPDUNode.getChildCount());
        String varBindeingLength = L.t("trap.tree.Total_Length_of_Variable_Binding") + ": " + trapV3.getVariableBindingsLength();
        DefaultMutableTreeNode varBindeingLengthNode = new DefaultMutableTreeNode(varBindeingLength);
        this.treeModel.insertNodeInto(varBindeingLengthNode, pduBodyNode, pduBodyNode.getChildCount());
        for (int index = 0; index < trapV3.getVariableBindingsList().size(); ++index) {
            DefaultMutableTreeNode bindNode = new DefaultMutableTreeNode(L.t("trap.tree.Bind") + ": ");
            this.treeModel.insertNodeInto(bindNode, pduBodyNode, pduBodyNode.getChildCount());
            VariableBindings varBindings = trapV3.getVariableBindingsList().get(index);
            DefaultMutableTreeNode lengthNode = new DefaultMutableTreeNode(L.t("trap.tree.length") + ": " + varBindings.getVarBindLength());
            this.treeModel.insertNodeInto(lengthNode, bindNode, bindNode.getChildCount());
            DefaultMutableTreeNode oidNode = new DefaultMutableTreeNode("OID: " + varBindings.getVarBindOID());
            this.treeModel.insertNodeInto(oidNode, bindNode, bindNode.getChildCount());
            DefaultMutableTreeNode valNode = new DefaultMutableTreeNode(L.t("trap.tree.Value") + ": " + varBindings.getVarBindValue());
            this.treeModel.insertNodeInto(valNode, bindNode, bindNode.getChildCount());
        }
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }
}

