/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap.table;

import IPMIView20.trap.table.SNMPUserTableControlInterface;
import IPMIView20.trap.table.UserTableModel;
import IPMIView20.trap.table.UserTableModelInterface;
import com.supermicro.ipmi.trap.usm.AuthProtocol;
import com.supermicro.ipmi.trap.usm.PrivProtocol;
import com.supermicro.ipmi.trap.usm.UserTable;
import com.supermicro.ipmi.trap.usm.UserTableUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;

public class SNMPUserTableControl
implements UserTableModelInterface {
    private String currentFilePath = null;
    private UserTable defaultUser = null;
    private UserTableModel tableModel = new UserTableModel(this);
    private JFileChooser fileChooser = null;
    private List<AuthProtocol> listAuthProtocol = new ArrayList<AuthProtocol>();
    private List<PrivProtocol> listPrivProtocol = new ArrayList<PrivProtocol>();
    private FutureTask<JFileChooser> futureFileChooser;
    private SNMPUserTableControlInterface listener;

    public SNMPUserTableControl(SNMPUserTableControlInterface listener) {
        this.listAuthProtocol.add(new AuthProtocol("MD5"));
        this.listAuthProtocol.add(new AuthProtocol("SHA-1"));
        this.listPrivProtocol.add(new PrivProtocol("DES"));
        this.listPrivProtocol.add(new PrivProtocol("AES128"));
        this.defaultUser = new UserTable("", this.listAuthProtocol.get(0), "", this.listPrivProtocol.get(0), "");
        this.futureFileChooser = new FutureTask<JFileChooser>(JFileChooser::new);
        this.listener = listener;
        this.init();
    }

    public List<UserTable> readPropertyFile() {
        return UserTableUtils.readPropertyFile(this.getFilePath());
    }

    public void writePropertyFile(TableModel tableModel) {
        UserTableUtils.writePropertyFile(tableModel, this.getFilePath());
    }

    public int openFileBrower() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = this.futureFileChooser.get();
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setCurrentDirectory(new File(UserTableUtils.DEFAULT_FILE_PATH));
                this.fileChooser.resetChoosableFileFilters();
                this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("(*.properties)", "properties"));
                this.fileChooser.setFileFilter(this.fileChooser.getChoosableFileFilters()[1]);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (this.fileChooser != null) {
            int option = this.fileChooser.showOpenDialog(null);
            if (option == 0) {
                String fileFormat = "";
                String fileDesc = this.fileChooser.getFileFilter().getDescription();
                this.currentFilePath = this.fileChooser.getSelectedFile().getAbsolutePath();
                if (fileDesc.contains("properties")) {
                    fileFormat = ".properties";
                }
                if (!this.currentFilePath.contains(fileFormat)) {
                    this.currentFilePath = this.currentFilePath + fileFormat;
                }
            }
            return option;
        }
        return 1;
    }

    public UserTable getDefaultUser() {
        return this.defaultUser;
    }

    public void addUserTable(List<UserTable> userTable) {
        this.tableModel.addUserTable(userTable);
    }

    public void addDefaultUserTable() {
        this.tableModel.addUserTable(this.defaultUser);
    }

    public void updateUserTable() {
        this.tableModel.updateUserTable(this.readPropertyFile());
    }

    public void deleteUserTable(int index) {
        this.tableModel.deleteUserTable(index);
    }

    public UserTableModel getUserTableModel() {
        return this.tableModel;
    }

    public String getFilePath() {
        return this.currentFilePath != null && !this.currentFilePath.isEmpty() ? this.currentFilePath : UserTableUtils.DEFAULT_FILE_PATH;
    }

    public List<UserTable> getUserTableList() {
        return this.tableModel.getUserTableList();
    }

    public List<AuthProtocol> getAuthProtocolList() {
        return this.listAuthProtocol;
    }

    public List<PrivProtocol> getPrivProtocolList() {
        return this.listPrivProtocol;
    }

    private void init() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(this.futureFileChooser);
    }

    @Override
    public void notifyErrorInput() {
        this.listener.notifyError();
    }
}

