/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap.table;

import IPMIView20.L;
import IPMIView20.trap.table.AuthProtocolCellEditor;
import IPMIView20.trap.table.HeaderRenderer;
import IPMIView20.trap.table.PrivProtocolCellEditor;
import IPMIView20.trap.table.SNMPUserTableControl;
import IPMIView20.trap.table.SNMPUserTableControlInterface;
import com.supermicro.ipmi.trap.usm.AuthProtocol;
import com.supermicro.ipmi.trap.usm.PrivProtocol;
import com.supermicro.ipmi.trap.usm.UserTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SNMPUserTableView
extends JPanel
implements SNMPUserTableControlInterface {
    private String[] columnToolTips = new String[]{null, "The username", "Algorithm to be used for authentication", "The password used for authentication packets for this entry", "Algorithm to be used for privacy", "The password used for encrypting packets for this entry"};
    private SNMPUserTableControl controller;
    private JTable userTable = new JTable(){

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
            JLabel label = (JLabel)super.prepareRenderer(renderer, row, col);
            label.setHorizontalAlignment(0);
            return label;
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent e) {
                    super.getToolTipText(e);
                    Point p = e.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return SNMPUserTableView.this.columnToolTips[realIndex];
                }
            };
        }
    };
    private JButton addBtn;
    private JButton deleteBtn;
    private JButton saveBtn;
    private JLabel fileUrlLabel;
    private JPanel bottomPanel;

    public SNMPUserTableView() {
        this.controller = new SNMPUserTableControl(this);
        this.setComponentsLayout();
        this.setComponentsListenser();
        this.setUserTableProperties();
    }

    private void setUserTableProperties() {
        this.controller.updateUserTable();
        this.userTable.setModel(this.controller.getUserTableModel());
        this.userTable.setDefaultEditor(AuthProtocol.class, new AuthProtocolCellEditor(this.controller.getAuthProtocolList()));
        this.userTable.setDefaultEditor(PrivProtocol.class, new PrivProtocolCellEditor(this.controller.getPrivProtocolList()));
        this.userTable.getTableHeader().setDefaultRenderer(new HeaderRenderer(this.userTable));
    }

    private void setComponentsLayout() {
        this.addBtn = new JButton("+");
        this.deleteBtn = new JButton("-");
        this.saveBtn = new JButton("Save");
        this.fileUrlLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.fileUrlLabel.setText(this.controller.getFilePath());
        this.fileUrlLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.fileUrlLabel.setForeground(Color.BLUE.darker());
        Font font = this.fileUrlLabel.getFont();
        int style = font.getStyle();
        font = font.deriveFont(style ^= 2);
        this.fileUrlLabel.setFont(font);
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        JScrollPane scrollpane = new JScrollPane(this.userTable);
        scrollpane.setPreferredSize(new Dimension(640, 278));
        this.setLayout(new BorderLayout());
        this.add((Component)scrollpane, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.add(this.addBtn);
        this.bottomPanel.add(this.deleteBtn);
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.add(this.fileUrlLabel);
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        this.userTable.setRowHeight(25);
    }

    private void setComponentsListenser() {
        this.fileUrlLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SNMPUserTableView.this.controller.openFileBrower() == 0) {
                    SNMPUserTableView.this.load();
                }
                SNMPUserTableView.this.fileUrlLabel.setText(SNMPUserTableView.this.controller.getFilePath());
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addBtn.addActionListener(e -> {
            TableCellEditor cellEditor = this.userTable.getCellEditor();
            if (null != cellEditor) {
                cellEditor.stopCellEditing();
            }
            this.controller.addDefaultUserTable();
        });
        this.deleteBtn.addActionListener(e -> {
            TableCellEditor cellEditor = this.userTable.getCellEditor();
            if (null != cellEditor) {
                cellEditor.stopCellEditing();
            }
            int selectedIndex = this.userTable.getSelectedRow();
            this.controller.deleteUserTable(selectedIndex);
            this.userTable.clearSelection();
        });
        this.saveBtn.addActionListener(e -> {
            TableCellEditor cellEditor = this.userTable.getCellEditor();
            if (null != cellEditor) {
                cellEditor.stopCellEditing();
            }
            this.controller.writePropertyFile(this.userTable.getModel());
        });
    }

    public List<UserTable> getUserTableList() {
        return this.controller.getUserTableList();
    }

    public void load() {
        this.controller.updateUserTable();
        this.userTable.setModel(this.controller.getUserTableModel());
        this.userTable.invalidate();
        this.userTable.repaint();
    }

    public void save() {
        TableCellEditor cellEditor = this.userTable.getCellEditor();
        if (null != cellEditor) {
            cellEditor.stopCellEditing();
        }
        this.controller.writePropertyFile(this.userTable.getModel());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SNMPUserTableView userTableView = new SNMPUserTableView();
                Object[] options2 = new String[]{"OK", "Cancel"};
                int result2 = JOptionPane.showOptionDialog(null, userTableView, L.t("toolbar.Traps"), -1, -1, null, options2, null);
                System.out.println(result2);
                if (result2 == 0) {
                    userTableView.save();
                }
            }
        });
    }

    @Override
    public void notifyError() {
        Object[] options = new Object[]{"OK"};
        JOptionPane.showOptionDialog(this, L.t("main.Not_Support_html_syntax"), "Message", -1, 1, null, options, options[0]);
    }
}

