/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap.table;

import IPMIView20.trap.table.UserTableModelInterface;
import com.supermicro.ipmi.trap.usm.AuthProtocol;
import com.supermicro.ipmi.trap.usm.PrivProtocol;
import com.supermicro.ipmi.trap.usm.UserTable;
import com.supermicro.ipmi.trap.usm.UserTableUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class UserTableModel
extends AbstractTableModel {
    private List<UserTable> userTableList = new ArrayList<UserTable>();
    private UserTableModelInterface listener;

    public UserTableModel(UserTableModelInterface listener) {
        this.listener = listener;
    }

    public void addUserTable(List<UserTable> userTable) {
        this.userTableList.addAll(userTable);
    }

    public void addUserTable(UserTable userTable) {
        UserTable newUserTable = new UserTable();
        newUserTable.setName(userTable.getName());
        newUserTable.setAuthProtocol(userTable.getAuthProtocol());
        newUserTable.setAuthPassword(userTable.getAuthPassword());
        newUserTable.setPrivProtocol(userTable.getPrivProtocol());
        newUserTable.setPrivPassword(userTable.getPrivPassword());
        this.userTableList.add(newUserTable);
        super.fireTableRowsInserted(this.userTableList.size() - 1, this.userTableList.size() - 1);
    }

    public List<UserTable> getUserTableList() {
        return this.userTableList;
    }

    public void updateUserTable(List<UserTable> userTable) {
        this.userTableList.clear();
        this.userTableList.addAll(userTable);
    }

    public void deleteUserTable(int index) {
        if (0 <= index && index < this.userTableList.size()) {
            this.userTableList.remove(index);
            super.fireTableRowsDeleted(index - 1, index - 1);
        }
    }

    private boolean hasHtmlSyntax(Object value) {
        return ((String)value).toLowerCase().contains("<html>");
    }

    @Override
    public int getColumnCount() {
        return UserTableUtils.FIELD_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return UserTableUtils.FIELD_NAMES[column];
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public int getRowCount() {
        return this.userTableList.size();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        UserTable userTable = this.userTableList.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                if (!this.hasHtmlSyntax(value)) {
                    userTable.setName((String)value);
                    break;
                }
                this.listener.notifyErrorInput();
                break;
            }
            case 2: {
                userTable.setAuthProtocol((AuthProtocol)value);
                break;
            }
            case 3: {
                if (!this.hasHtmlSyntax(value)) {
                    userTable.setAuthPassword((String)value);
                    break;
                }
                this.listener.notifyErrorInput();
                break;
            }
            case 4: {
                userTable.setPrivProtocol((PrivProtocol)value);
                break;
            }
            case 5: {
                if (!this.hasHtmlSyntax(value)) {
                    userTable.setPrivPassword((String)value);
                    break;
                }
                this.listener.notifyErrorInput();
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnValue = null;
        UserTable userTable = this.userTableList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                returnValue = rowIndex + 1;
                break;
            }
            case 1: {
                returnValue = userTable.getName();
                break;
            }
            case 2: {
                returnValue = userTable.getAuthProtocol();
                break;
            }
            case 3: {
                returnValue = userTable.getAuthPassword();
                break;
            }
            case 4: {
                returnValue = userTable.getPrivProtocol();
                break;
            }
            case 5: {
                returnValue = userTable.getPrivPassword();
            }
        }
        return returnValue;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }
}

